// generated by gx_tube_transfer.py
// tube: SVEL34
// plate current function: pentode
// mu: 11.5
// kx: 1.35
// kg1: 608.9
// kg2: 4500
// kp: 41.2
// kvb: 30.1
// Uin_min: -25
// Uin_max: 25
// Vp: 250
// Rp: 2000

table1d_imp<2001> tubetable_SVEL34[2] __rt_data = {
	{ // Ri = 68k
	-25,25,40,2001, {
	228.353637405,228.284683484,228.215587963,228.146350822,228.076972042,
	228.007451603,227.937789487,227.867985677,227.798040155,227.727952903,
	227.657723906,227.587353149,227.516840615,227.44618629,227.375390161,
	227.304452213,227.233372434,227.16215081,227.090787331,227.019281985,
	226.94763476,226.875845647,226.803914636,226.731841716,226.659626881,
	226.58727012,226.514771427,226.442130793,226.369348213,226.296423681,
	226.223357189,226.150148734,226.07679831,226.003305914,225.929671541,
	225.855895188,225.781976853,225.707916533,225.633714226,225.559369932,
	225.484883649,225.410255378,225.335485118,225.26057287,225.185518635,
	225.110322415,225.034984212,224.959504028,224.883881867,224.808117733,
	224.732211628,224.656163558,224.579973527,224.503641541,224.427167606,
	224.350551727,224.273793913,224.196894169,224.119852503,224.042668924,
	223.965343441,223.887876061,223.810266795,223.732515652,223.654622643,
	223.576587778,223.498411068,223.420092526,223.341632163,223.263029992,
	223.184286025,223.105400275,223.026372758,222.947203486,222.867892474,
	222.788439737,222.708845291,222.629109152,222.549231335,222.469211857,
	222.389050735,222.308747987,222.228303631,222.147717684,222.066990165,
	221.986121094,221.90511049,221.823958372,221.742664761,221.661229677,
	221.579653141,221.497935175,221.416075801,221.33407504,221.251932915,
	221.169649449,221.087224665,221.004658586,220.921951237,220.839102642,
	220.756112826,220.672981814,220.589709631,220.506296303,220.422741856,
	220.339046317,220.255209712,220.171232069,220.087113415,220.002853779,
	219.918453188,219.833911671,219.749229258,219.664405976,219.579441857,
	219.49433693,219.409091225,219.323704773,219.238177605,219.152509751,
	219.066701245,218.980752118,218.894662401,218.808432129,218.722061332,
	218.635550046,218.548898303,218.462106137,218.375173583,218.288100674,
	218.200887447,218.113533935,218.026040174,217.938406201,217.85063205,
	217.762717759,217.674663364,217.586468901,217.498134409,217.409659925,
	217.321045486,217.23229113,217.143396897,217.054362824,216.965188951,
	216.875875317,216.786421961,216.696828923,216.607096243,216.517223962,
	216.427212121,216.337060759,216.246769919,216.156339642,216.065769969,
	215.975060943,215.884212606,215.793225,215.702098168,215.610832153,
	215.519426999,215.427882749,215.336199446,215.244377136,215.152415861,
	215.060315668,214.9680766,214.875698703,214.783182022,214.690526602,
	214.59773249,214.504799731,214.411728372,214.318518459,214.225170039,
	214.13168316,214.038057867,213.944294209,213.850392234,213.756351989,
	213.662173523,213.567856883,213.473402119,213.378809279,213.284078413,
	213.189209569,213.094202798,212.999058148,212.90377567,212.808355415,
	212.712797431,212.617101771,212.521268484,212.425297622,212.329189236,
	212.232943377,212.136560097,212.040039448,211.943381481,211.84658625,
	211.749653806,211.652584203,211.555377492,211.458033727,211.360552961,
	211.262935248,211.165180641,211.067289195,210.969260962,210.871095997,
	210.772794355,210.67435609,210.575781257,210.47706991,210.378222106,
	210.279237898,210.180117344,210.080860497,209.981467415,209.881938153,
	209.782272767,209.682471314,209.58253385,209.482460432,209.382251116,
	209.281905961,209.181425022,209.080808359,208.980056027,208.879168084,
	208.77814459,208.676985601,208.575691176,208.474261373,208.372696251,
	208.270995868,208.169160283,208.067189556,207.965083746,207.862842911,
	207.760467111,207.657956407,207.555310857,207.452530521,207.349615461,
	207.246565735,207.143381404,207.04006253,206.936609172,206.833021391,
	206.729299249,206.625442806,206.521452124,206.417327264,206.313068287,
	206.208675256,206.104148232,205.999487277,205.894692453,205.789763823,
	205.684701448,205.579505392,205.474175717,205.368712485,205.263115761,
	205.157385605,205.051522083,204.945525257,204.83939519,204.733131947,
	204.62673559,204.520206184,204.413543793,204.30674848,204.199820311,
	204.092759348,203.985565657,203.878239302,203.770780349,203.663188861,
	203.555464903,203.447608542,203.339619841,203.231498866,203.123245683,
	203.014860358,202.906342955,202.79769354,202.68891218,202.579998941,
	202.470953888,202.361777088,202.252468607,202.143028512,202.033456868,
	201.923753744,201.813919205,201.703953319,201.593856153,201.483627773,
	201.373268247,201.262777642,201.152156026,201.041403466,200.930520031,
	200.819505787,200.708360802,200.597085146,200.485678885,200.374142088,
	200.262474823,200.150677158,200.038749163,199.926690906,199.814502455,
	199.702183879,199.589735248,199.47715663,199.364448094,199.25160971,
	199.138641547,199.025543674,198.912316161,198.798959078,198.685472494,
	198.57185648,198.458111104,198.344236438,198.23023255,198.116099513,
	198.001837395,197.887446267,197.7729262,197.658277265,197.543499531,
	197.428593071,197.313557954,197.198394253,197.083102037,196.967681378,
	196.852132348,196.736455018,196.620649459,196.504715744,196.388653943,
	196.272464128,196.156146371,196.039700745,195.923127322,195.806426173,
	195.68959737,195.572640987,195.455557095,195.338345768,195.221007077,
	195.103541095,194.985947896,194.868227553,194.750380137,194.632405723,
	194.514304383,194.396076191,194.277721221,194.159239545,194.040631238,
	193.921896372,193.803035022,193.684047262,193.564933166,193.445692807,
	193.32632626,193.206833599,193.087214899,192.967470233,192.847599677,
	192.727603305,192.607481191,192.487233411,192.36686004,192.246361152,
	192.125736822,192.004987127,191.88411214,191.763111938,191.641986596,
	191.52073619,191.399360795,191.277860487,191.156235342,191.034485436,
	190.912610845,190.790611645,190.668487913,190.546239725,190.423867157,
	190.301370286,190.178749188,190.056003942,189.933134622,189.810141307,
	189.687024073,189.563782998,189.440418159,189.316929633,189.193317498,
	189.069581831,188.945722711,188.821740214,188.69763442,188.573405405,
	188.449053248,188.324578028,188.199979822,188.075258709,187.950414768,
	187.825448077,187.700358715,187.575146761,187.449812294,187.324355393,
	187.198776138,187.073074607,186.94725088,186.821305036,186.695237156,
	186.56904732,186.442735606,186.316302095,186.189746867,186.063070002,
	185.936271582,185.809351685,185.682310393,185.555147787,185.427863947,
	185.300458954,185.17293289,185.045285836,184.917517872,184.789629081,
	184.661619543,184.533489341,184.405238557,184.276867272,184.148375569,
	184.019763529,183.891031235,183.76217877,183.633206216,183.504113655,
	183.374901171,183.245568847,183.116116766,182.986545011,182.856853665,
	182.727042812,182.597112535,182.467062919,182.336894047,182.206606004,
	182.076198874,181.94567274,181.815027688,181.684263802,181.553381167,
	181.422379868,181.29125999,181.160021619,181.028664839,180.897189736,
	180.765596396,180.633884905,180.502055349,180.370107814,180.238042385,
	180.105859151,179.973558197,179.84113961,179.708603476,179.575949884,
	179.443178921,179.310290673,179.177285229,179.044162676,178.910923101,
	178.777566595,178.644093243,178.510503136,178.376796361,178.242973007,
	178.109033164,177.97497692,177.840804365,177.706515588,177.572110679,
	177.437589728,177.302952825,177.168200059,177.033331522,176.898347304,
	176.763247496,176.628032189,176.492701473,176.357255441,176.221694184,
	176.086017794,175.950226362,175.81431998,175.678298742,175.54216274,
	175.405912065,175.269546813,175.133067074,174.996472944,174.859764515,
	174.722941881,174.586005136,174.448954375,174.311789692,174.174511182,
	174.037118939,173.899613058,173.761993636,173.624260766,173.486414547,
	173.348455072,173.210382438,173.072196743,172.933898082,172.795486553,
	172.656962252,172.518325278,172.379575727,172.240713698,172.101739288,
	171.962652597,171.823453723,171.684142764,171.544719821,171.405184991,
	171.265538375,171.125780073,170.985910185,170.845928812,170.705836053,
	170.565632011,170.425316785,170.284890479,170.144353192,170.003705029,
	169.86294609,169.722076479,169.581096298,169.440005651,169.29880464,
	169.15749337,169.016071945,168.874540469,168.732899047,168.591147783,
	168.449286783,168.307316152,168.165235996,168.023046422,167.880747535,
	167.738339442,167.595822251,167.453196068,167.310461002,167.167617161,
	167.024664652,166.881603584,166.738434067,166.595156209,166.451770121,
	166.308275912,166.164673693,166.020963573,165.877145665,165.73322008,
	165.589186928,165.445046323,165.300798376,165.156443201,165.01198091,
	164.867411617,164.722735436,164.577952481,164.433062866,164.288066706,
	164.142964117,163.997755214,163.852440114,163.707018932,163.561491786,
	163.415858793,163.270120071,163.124275737,162.978325909,162.832270707,
	162.686110251,162.539844658,162.39347405,162.246998547,162.100418269,
	161.953733339,161.806943877,161.660050005,161.513051847,161.365949526,
	161.218743163,161.071432884,160.924018813,160.776501075,160.628879793,
	160.481155095,160.333327107,160.185395954,160.037361763,159.889224663,
	159.740984781,159.592642246,159.444197185,159.295649729,159.147000008,
	158.998248152,158.84939429,158.700438556,158.55138108,158.402221995,
	158.252961433,158.103599528,157.954136414,157.804572224,157.654907095,
	157.50514116,157.355274555,157.205307418,157.055239885,156.905072093,
	156.754804181,156.604436287,156.453968549,156.303401109,156.152734104,
	156.001967678,155.85110197,155.700137122,155.549073278,155.397910579,
	155.24664917,155.095289194,154.943830797,154.792274123,154.640619319,
	154.488866531,154.337015906,154.185067592,154.033021737,153.88087849,
	153.728638,153.576300418,153.423865895,153.271334582,153.118706631,
	152.965982194,152.813161426,152.660244479,152.50723151,152.354122672,
	152.200918122,152.047618017,151.894222514,151.74073177,151.587145945,
	151.433465198,151.279689688,151.125819578,150.971855027,150.817796198,
	150.663643254,150.509396358,150.355055676,150.20062137,150.046093609,
	149.891472557,149.736758382,149.581951251,149.427051335,149.272058801,
	149.11697382,148.961796564,148.806527203,148.65116591,148.495712859,
	148.340168223,148.184532177,148.028804897,147.872986559,147.717077341,
	147.56107742,147.404986975,147.248806187,147.092535234,146.936174299,
	146.779723564,146.623183211,146.466553425,146.309834389,146.153026291,
	145.996129315,145.83914365,145.682069482,145.524907002,145.367656399,
	145.210317864,145.052891589,144.895377765,144.737776587,144.580088249,
	144.422312946,144.264450874,144.106502231,143.948467214,143.790346022,
	143.632138856,143.473845917,143.315467405,143.157003525,142.998454479,
	142.839820473,142.681101713,142.522298404,142.363410755,142.204438974,
	142.045383272,141.886243859,141.727020946,141.567714747,141.408325476,
	141.248853346,141.089298575,140.929661378,140.769941975,140.610140584,
	140.450257425,140.290292719,140.13024669,139.970119559,139.809911552,
	139.649622894,139.489253812,139.328804534,139.168275289,139.007666306,
	138.846977816,138.686210053,138.52536325,138.364437641,138.203433462,
	138.04235095,137.881190343,137.71995188,137.558635802,137.397242351,
	137.235771769,137.074224301,136.912600192,136.750899689,136.589123038,
	136.42727049,136.265342294,136.103338703,135.941259968,135.779106344,
	135.616878086,135.45457545,135.292198695,135.12974808,134.967223865,
	134.804626311,134.641955683,134.479212244,134.31639626,134.153507999,
	133.990547728,133.827515717,133.664412238,133.501237563,133.337991965,
	133.174675721,133.011289106,132.847832399,132.68430588,132.520709828,
	132.357044527,132.19331026,132.029507312,131.865635969,131.70169652,
	131.537689255,131.373614463,131.209472439,131.045263474,130.880987866,
	130.71664591,130.552237905,130.387764151,130.22322495,130.058620604,
	129.893951417,129.729217696,129.564419749,129.399557884,129.234632413,
	129.069643646,128.904591899,128.739477487,128.574300726,128.409061935,
	128.243761435,128.078399547,127.912976596,127.747492905,127.581948801,
	127.416344614,127.250680674,127.084957311,126.919174859,126.753333654,
	126.587434032,126.421476332,126.255460894,126.08938806,125.923258173,
	125.75707158,125.590828626,125.424529661,125.258175035,125.091765101,
	124.925300213,124.758780727,124.592207001,124.425579393,124.258898266,
	124.092163983,123.925376908,123.758537408,123.591645852,123.42470261,
	123.257708055,123.09066256,122.923566502,122.756420259,122.589224209,
	122.421978736,122.254684223,122.087341054,121.919949618,121.752510304,
	121.585023502,121.417489607,121.249909012,121.082282116,120.914609318,
	120.746891017,120.579127618,120.411319525,120.243467145,120.075570887,
	119.907631162,119.739648383,119.571622965,119.403555325,119.235445883,
	119.067295058,118.899103274,118.730870957,118.562598533,118.394286433,
	118.225935087,118.057544929,117.889116395,117.720649922,117.55214595,
	117.383604922,117.21502728,117.046413472,116.877763946,116.709079153,
	116.540359544,116.371605575,116.202817703,116.033996387,115.865142088,
	115.696255271,115.527336401,115.358385945,115.189404375,115.020392163,
	114.851349784,114.682277715,114.513176435,114.344046426,114.174888173,
	114.005702162,113.836488882,113.667248824,113.497982483,113.328690356,
	113.159372941,112.99003074,112.82066426,112.651274007,112.481860493,
	112.312424233,112.142965744,111.973485549,111.803984174,111.634462149,
	111.464920012,111.295358302,111.125777569,110.956178368,110.786561263,
	110.616926827,110.447275644,110.277608313,110.107925448,109.938227679,
	109.76851566,109.598790069,109.429051617,109.259301051,109.08953916,
	108.919766789,108.749984846,108.580194316,108.410396277,108.240591919,
	108.07078257,107.900969721,107.73115506,107.56134052,107.391528323,
	107.221721043,107.051921686,106.882133773,106.712361451,106.54260963,
	106.372884137,106.203191913,106.033541244,105.863942041,105.69440618,
	105.524947909,105.355584328,105.186335979,105.01722753,104.848288601,
	104.679554728,104.511068502,104.342880887,104.175052738,104.007656533,
	103.840778305,103.674519758,103.509000536,103.344360532,103.180762151,
	103.018392312,102.857463961,102.698216787,102.540916781,102.385854273,
	102.233340103,102.083699713,101.937265119,101.794365024,101.65531362,
	101.520398935,101.389871775,101.263936346,101.142743456,101.026386897,
	100.914903167,100.808274264,100.70643297,100.60926984,100.516641094,
	100.428376663,100.344287849,100.264174186,100.187829309,100.115045755,
	100.045618735,99.9793489559,99.9160446486,99.8555229114,99.7976105224,
	99.7421443318,99.6889713392,99.6379485418,99.5889426207,99.5418295196,
	99.4964939578,99.4528289064,99.4107350525,99.3701202654,99.3308990777,
	99.2929921878,99.2563259888,99.2208321253,99.1864470811,99.1531117958,
	99.1207713105,99.0893744419,99.0588734821,99.0292239234,99.000384206,
	98.9723154869,98.944981429,98.918348007,98.8923833311,98.8670574846,
	98.8423423763,98.8182116048,98.7946403341,98.7716051799,98.7490841055,
	98.7270563262,98.7055022208,98.6844032515,98.6637418894,98.6435015463,
	98.6236665118,98.6042218948,98.5851535708,98.566448132,98.5480928416,
	98.5300755918,98.5123848647,98.4950096958,98.4779396408,98.461164744,
	98.4446755098,98.4284628754,98.4125181862,98.396833172,98.3813999255,
	98.3662108822,98.3512588012,98.3365367479,98.3220380771,98.3077564178,
	98.2936856587,98.2798199348,98.2661536145,98.2526812877,98.2393977549,
	98.2262980164,98.2133772626,98.2006308648,98.1880543662,98.1756434739,
	98.1633940512,98.1513021102,98.1393638047,98.1275754241,98.1159333871,
	98.1044342357,98.09307463,98.0818513428,98.0707612549,98.05980135,
	98.0489687111,98.0382605153,98.0276740306,98.0172066119,98.0068556973,
	97.996618805,97.9864935296,97.9764775396,97.9665685739,97.9567644396,
	97.9470630089,97.9374622168,97.9279600586,97.9185545878,97.9092439136,
	97.900026199,97.8908996591,97.8818625585,97.8729132102,97.8640499734,
	97.855271252,97.8465754932,97.8379611855,97.8294268578,97.8209710777,
	97.8125924502,97.8042896165,97.7960612528,97.7879060688,97.7798228072,
	97.7718102421,97.7638671781,97.7559924494,97.7481849187,97.7404434766,
	97.7327670402,97.7251545529,97.7176049829,97.7101173229,97.7026905893,
	97.6953238213,97.6880160802,97.680766449,97.6735740315,97.6664379517,
	97.6593573533,97.6523313991,97.6453592705,97.6384401666,97.6315733044,
	97.6247579174,97.617993256,97.6112785864,97.6046131905,97.5979963651,
	97.5914274221,97.5849056875,97.5784305011,97.5720012167,97.5656172007,
	97.5592778329,97.5529825053,97.546730622,97.5405215991,97.5343548642,
	97.5282298562,97.5221460249,97.5161028307,97.5100997446,97.5041362473,
	97.49821183,97.4923259931,97.4864782464,97.4806681092,97.4748951093,
	97.4691587836,97.4634586773,97.4577943439,97.4521653451,97.4465712504,
	97.4410116372,97.4354860903,97.4299942018,97.4245355713,97.419109805,
	97.4137165164,97.4083553253,97.4030258584,97.3977277486,97.392460635,
	97.3872241632,97.3820179843,97.3768417556,97.37169514,97.366577806,
	97.3614894275,97.3564296838,97.3513982597,97.3463948446,97.3414191335,
	97.3364708259,97.3315496262,97.3266552436,97.3217873919,97.3169457892,
	97.3121301584,97.3073402264,97.3025757244,97.2978363879,97.2931219564,
	97.2884321732,97.2837667858,97.2791255453,97.2745082066,97.2699145285,
	97.265344273,97.260797206,97.2562730966,97.2517717174,97.2472928445,
	97.2428362569,97.2384017371,97.2339890707,97.2295980463,97.2252284554,
	97.2208800928,97.216552756,97.2122462453,97.2079603639,97.2036949179,
	97.1994497157,97.1952245688,97.191019291,97.1868336988,97.1826676111,
	97.1785208494,97.1743932375,97.1702846016,97.1661947703,97.1621235745,
	97.1580708471,97.1540364237,97.1500201416,97.1460218404,97.142041362,
	97.13807855,97.1341332504,97.1302053108,97.1262945812,97.1224009132,
	97.1185241603,97.114664178,97.1108208237,97.1069939563,97.1031834367,
	97.0993891276,97.0956108932,97.0918485995,97.0881021141,97.0843713063,
	97.0806560471,97.0769562087,97.0732716653,97.0696022924,97.0659479669,
	97.0623085674,97.0586839738,97.0550740676,97.0514787315,97.0478978498,
	97.0443313079,97.0407789927,97.0372407926,97.0337165969,97.0302062965,
	97.0267097836,97.0232269512,97.0197576941,97.016301908,97.0128594897,
	97.0094303374,97.0060143503,97.0026114289,96.9992214745,96.9958443899,
	96.9924800787,96.9891284456,96.9857893965,96.9824628383,96.9791486788,
	96.9758468269,96.9725571924,96.9692796863,96.9660142203,96.9627607073,
	96.9595190609,96.9562891958,96.9530710275,96.9498644724,96.946669448,
	96.9434858724,96.9403136647,96.9371527447,96.9340030334,96.9308644521,
	96.9277369234,96.9246203704,96.9215147172,96.9184198884,96.9153358097,
	96.9122624073,96.9091996084,96.9061473406,96.9031055326,96.9000741135,
	96.8970530134,96.8940421629,96.8910414933,96.8880509367,96.8850704258,
	96.8820998939,96.8791392751,96.8761885041,96.8732475162,96.8703162474,
	96.8673946341,96.8644826136,96.8615801238,96.8586871029,96.85580349,
	96.8529292246,96.850064247,96.8472084977,96.8443619181,96.8415244501,
	96.8386960359,96.8358766186,96.8330661416,96.8302645489,96.8274717849,
	96.8246877947,96.8219125239,96.8191459185,96.816387925,96.8136384904,
	96.8108975623,96.8081650886,96.8054410177,96.8027252987,96.8000178809,
	96.7973187142,96.7946277488,96.7919449354,96.7892702254,96.7866035702,
	96.7839449219,96.781294233,96.7786514564,96.7760165454,96.7733894537,
	96.7707701353,96.768158545,96.7655546374,96.7629583681,96.7603696925,
	96.7577885669,96.7552149477,96.7526487916,96.750090056,96.7475386983,
	96.7449946765,96.7424579489,96.739928474,96.7374062109,96.734891119,
	96.7323831578,96.7298822873,96.727388468,96.7249016605,96.7224218257,
	96.7199489251,96.7174829201,96.7150237729,96.7125714456,96.7101259009,
	96.7076871015,96.7052550108,96.7028295921,96.7004108093,96.6979986264,
	96.6955930078,96.6931939181,96.6908013223,96.6884151856,96.6860354734,
	96.6836621515,96.681295186,96.6789345432,96.6765801896,96.674232092,
	96.6718902176,96.6695545337,96.667225008,96.6649016081,96.6625843024,
	96.6602730591,96.6579678468,96.6556686343,96.6533753909,96.6510880856,
	96.6488066883,96.6465311685,96.6442614963,96.641997642,96.639739576,
	96.6374872691,96.635240692,96.6329998161,96.6307646126,96.628535053,
	96.6263111092,96.6240927532,96.621879957,96.6196726933,96.6174709344,
	96.6152746533,96.6130838229,96.6108984165,96.6087184075,96.6065437694,
	96.604374476,96.6022105013,96.6000518195,96.5978984049,96.5957502321,
	96.5936072758,96.5914695109,96.5893369125,96.5872094558,96.5850871162,
	96.5829698695,96.5808576913,96.5787505577,96.5766484447,96.5745513286,
	96.572459186,96.5703719934,96.5682897277,96.5662123657,96.5641398846,
	96.5620722617,96.5600094744,96.5579515003,96.5558983171,96.5538499027,
	96.5518062352,96.5497672928,96.5477330538,96.5457034967,96.5436786001,
	96.5416583429,96.5396427039,96.5376316623,96.5356251973,96.5336232881,
	96.5316259143,96.5296330556,96.5276446917,96.5256608025,96.523681368,
	96.5217063684,96.519735784,96.5177695953,96.5158077827,96.513850327,
	96.5118972091,96.5099484097,96.5080039101,96.5060636914,96.5041277349,
	96.502196022,96.5002685343,96.4983452535,96.4964261613,96.4945112398,
	96.4926004708,96.4906938365,96.4887913193,96.4868929014,96.4849985654,
	96.4831082938,96.4812220693,96.4793398749,96.4774616933,96.4755875076,
	96.473717301,96.4718510566,96.469988758,96.4681303884,96.4662759315,
	96.4644253709,96.4625786904,96.4607358738,96.4588969051,96.4570617684,
	96.4552304478,96.4534029276,96.4515791922,96.4497592259,96.4479430134,
	96.4461305392,96.4443217882,96.4425167451,96.4407153948,96.4389177224,
	96.437123713,96.4353333518,96.4335466239,96.4317635149,96.4299840102,
	96.4282080953,96.4264357558,96.4246669775,96.4229017461,96.4211400476,
	96.4193818679,96.4176271931,96.4158760093,96.4141283027,96.4123840596,
	96.4106432664,96.4089059096,96.4071719757,96.4054414512,96.403714323,
	96.4019905778,96.4002702024,96.3985531838,96.3968395089,96.3951291649,
	96.3934221388,96.391718418,96.3900179896,96.3883208412,96.38662696,
	96.3849363337,96.3832489498,96.381564796,96.37988386,96.3782061295,
	96.3765315926,96.374860237,96.3731920509,96.3715270222,96.3698651391,
	96.3682063899,96.3665507627,96.3648982459,96.363248828,96.3616024973,
	96.3599592424,96.3583190519,96.3566819145,96.3550478188,96.3534167537,
	96.351788708,96.3501636705,96.3485416304,96.3469225764,96.3453064979,
	96.3436933839,96.3420832236,96.3404760062,96.3388717211,96.3372703577,
	96.3356719054,96.3340763537,96.3324836922,96.3308939104,96.329306998,
	96.3277229447,96.3261417403,96.3245633746,96.3229878376,96.321415119,
	96.319845209,96.3182780976,96.3167137748,96.3151522308,96.3135934558,
	96.31203744,96.3104841738,96.3089336474,96.3073858514,96.3058407761,
	96.3042984121,96.3027587499,96.30122178,96.2996874932,96.2981558802,
	96.2966269316,96.2951006384,96.2935769912,96.2920559811,96.2905375989,
	96.2890218356,96.2875086823,96.2859981301,96.28449017,96.2829847931,
	96.2814819909,96.2799817543,96.2784840749,96.2769889439,96.2754963527,
	96.2740062927,96.2725187554,96.2710337323,96.2695512151,96.2680711951,
	96.2665936643,96.2651186141,96.2636460363,96.2621759228,96.2607082652,
	96.2592430555,96.2577802855,96.2563199473,96.2548620326,96.2534065336,
	96.2519534423,96.2505027508,96.2490544512,96.2476085356,96.2461649964,
	96.2447238256,96.2432850157,96.2418485588,96.2404144474,96.2389826739,
	96.2375532306,96.2361261101,96.2347013049,96.2332788074,96.2318586103,
	96.2304407061,96.2290250875,96.2276117473,96.226200678,96.2247918725,
	96.2233853235,96.2219810238,96.2205789664,96.219179144,96.2177815496,
	96.2163861762,96.2149930168,96.2136020643,96.2122133118,96.2108267524,
	96.2094423792,96.2080601854,96.2066801642,96.2053023087,96.2039266122,
	96.202553068,96.2011816693,96.1998124096,96.1984452822,96.1970802805,
	96.195717398,96.194356628,96.1929979641,96.1916413998,96.1902869286,
	96.1889345442,96.1875842401,96.18623601,96.1848898476,96.1835457465,
	96.1822037005,96.1808637033,96.1795257487,96.1781898306,96.1768559427,
	96.1755240789,96.1741942332,96.1728663994,96.1715405715,96.1702167434,
	96.1688949093,96.167575063,96.1662571987,96.1649413104,96.1636273923,
	96.1623154385,96.1610054431,96.1596974004,96.1583913045,96.1570871497,
	96.1557849303,96.1544846405,96.1531862747,96.1518898272,96.1505952924,
	96.1493026646,96.1480119383,96.1467231079,96.1454361678,96.1441511127,
	96.1428679369,96.141586635,96.1403072016,96.1390296312,96.1377539185,
	96.1364800581,96.1352080447,96.1339378728,96.1326695372,96.1314030327,
	96.130138354,96.1288754958,96.127614453,96.1263552202,96.1250977925,
	96.1238421646,96.1225883314,96.1213362879,96.1200860288,96.1188375493,
	96.1175908441,96.1163459084,96.1151027372,96.1138613253,96.112621668,
	96.1113837603,96.1101475972,96.1089131739,96.1076804855,96.1064495272,
	96.1052202941,96.1039927814,96.1027669843,96.1015428981,96.100320518,
	96.0990998393,96.0978808573,96.0966635673,96.0954479645,96.0942340445,
	96.0930218024,96.0918112338,96.090602334,96.0893950985,96.0881895226,
	96.0869856019,96.0857833318,96.0845827079,96.0833837256,96.0821863805,
	96.0809906682,96.0797965841,96.078604124,96.0774132833,96.0762240578,
	96.0750364431,96.0738504348,96.0726660286,96.0714832203,96.0703020054,
	96.0691223798,96.0679443393,96.0667678794,96.0655929961,96.0644196852,
	96.0632479424,96.0620777636,96.0609091447,96.0597420814,96.0585765698,
	96.0574126056,96.0562501848,96.0550893033,96.053929957,96.052772142,
	96.0516158542,96.0504610897,96.0493078443,96.0481561141,96.0470058952,
	96.0458571836,96.0447099754,96.0435642667,96.0424200536,96.0412773322,
	96.0401360986,96.0389963489,96.0378580795,96.0367212863,96.0355859656,
	96.0344521136,96.0333197266,96.0321888007,96.0310593323,96.0299313175,
	96.0288047526,96.027679634,96.026555958,96.0254337208,96.0243129189,
	96.0231935485,96.022075606,96.0209590878,96.0198439903,96.0187303098,
	96.0176180429,96.0165071859,96.0153977353,96.0142896875,96.013183039,
	96.0120777864,96.010973926,96.0098714544,96.0087703681,96.0076706637,
	96.0065723376,96.0054753866,96.0043798071,96.0032855957,96.0021927491,
	96.0011012638,96.0000111365,95.9989223638,95.9978349423,95.9967488688,
	95.9956641399,95.9945807523,95.9934987026,95.9924179877,95.9913386041,
	95.9902605488,95.9891838183,95.9881084095,95.9870343191,95.985961544,
	95.9848900809,95.9838199266,95.9827510779,95.9816835317,95.9806172849,
	95.9795523342,95.9784886765,95.9774263088,95.9763652278,95.9753054305,
	95.9742469139,95.9731896747,95.97213371,95.9710790167,95.9700255918,
	95.9689734322,95.9679225348,95.9668728968,95.965824515,95.9647773865,
	95.9637315083,95.9626868774,95.9616434909,95.9606013458,95.9595604392,
	95.9585207682,95.9574823298,95.9564451211,95.9554091392,95.9543743813,
	95.9533408444,95.9523085257,95.9512774224,95.9502475315,95.9492188503,
	95.9481913759,95.9471651055,95.9461400363,95.9451161655,95.9440934903,
	95.9430720079,95.9420517156,95.9410326106,95.9400146902,95.9389979515,
	95.937982392,95.9369680088,95.9359547992,95.9349427606,95.9339318902,
	95.9329221854,95.9319136435,95.9309062618,95.9299000377,95.9288949685,
	95.9278910516,95.9268882843,95.9258866641,95.9248861883,95.9238868543,
	95.9228886595,95.9218916013,95.9208956773,95.9199008847,95.918907221,
	95.9179146838,95.9169232704,95.9159329783,95.914943805,95.9139557479,
	95.9129688046,95.9119829726,95.9109982493,95.9100146324,95.9090321192,
	95.9080507075,95.9070703946,95.9060911781,95.9051130556,95.9041360248,
	95.903160083,95.902185228,95.9012114573,95.9002387685,95.8992671593,
	95.8982966272,95.8973271698,95.8963587849,95.8953914699,95.8944252227,
	95.8934600408,95.8924959218,95.8915328636,95.8905708636,95.8896099197,
	95.8886500296,95.8876911908,95.8867334011,95.8857766583,95.8848209601,
	95.8838663041,95.8829126882,95.88196011,95.8810085674,95.880058058,
	95.8791085797,95.8781601302,95.8772127073,95.8762663088,95.8753209325,
	95.8743765762,95.8734332377,95.8724909147,95.8715496053,95.870609307,
	95.8696700179,95.8687317357,95.8677944583,95.8668581836,95.8659229094,
	95.8649886336,95.864055354,95.8631230686,95.8621917752,95.8612614718,
	95.8603321562,95.8594038264,95.8584764802,95.8575501157,95.8566247307,
	95.8557003231,95.854776891,95.8538544322,95.8529329448,95.8520124266,
	95.8510928757,95.8501742901,95.8492566676,95.8483400063,95.8474243043,
	95.8465095594,95.8455957697,95.8446829333,95.8437710481,95.8428601122,
	95.8419501236,95.8410410803,95.8401329804,95.8392258219,95.8383196029,
	95.8374143215,95.8365099756,95.8356065635,95.8347040832,95.8338025327,
	95.8329019102,95.8320022137,95.8311034414,95.8302055913,95.8293086616,
	95.8284126504,95.8275175559,95.8266233761,95.8257301092,95.8248377534,
	95.8239463067,95.8230557674,95.8221661336,95.8212774035,95.8203895753,
	95.819502647,95.818616617,95.8177314834,95.8168472443,95.8159638981,
	95.8150814428,95.8141998768,95.8133191981,95.8124394052,95.811560496,
	95.810682469
	}},
	{ // Ri = 250k
	-25,25,40,2001, {
	228.353637405,228.284683484,228.215587963,228.146350822,228.076972042,
	228.007451603,227.937789487,227.867985677,227.798040155,227.727952903,
	227.657723906,227.587353149,227.516840615,227.44618629,227.375390161,
	227.304452213,227.233372434,227.16215081,227.090787331,227.019281985,
	226.94763476,226.875845647,226.803914636,226.731841716,226.659626881,
	226.58727012,226.514771427,226.442130793,226.369348213,226.296423681,
	226.223357189,226.150148734,226.07679831,226.003305914,225.929671541,
	225.855895188,225.781976853,225.707916533,225.633714226,225.559369932,
	225.484883649,225.410255378,225.335485118,225.26057287,225.185518635,
	225.110322415,225.034984212,224.959504028,224.883881867,224.808117733,
	224.732211628,224.656163558,224.579973527,224.503641541,224.427167606,
	224.350551727,224.273793913,224.196894169,224.119852503,224.042668924,
	223.965343441,223.887876061,223.810266795,223.732515652,223.654622643,
	223.576587778,223.498411068,223.420092526,223.341632163,223.263029992,
	223.184286025,223.105400275,223.026372758,222.947203486,222.867892474,
	222.788439737,222.708845291,222.629109152,222.549231335,222.469211857,
	222.389050735,222.308747987,222.228303631,222.147717684,222.066990165,
	221.986121094,221.90511049,221.823958372,221.742664761,221.661229677,
	221.579653141,221.497935175,221.416075801,221.33407504,221.251932915,
	221.169649449,221.087224665,221.004658586,220.921951237,220.839102642,
	220.756112826,220.672981814,220.589709631,220.506296303,220.422741856,
	220.339046317,220.255209712,220.171232069,220.087113415,220.002853779,
	219.918453188,219.833911671,219.749229258,219.664405976,219.579441857,
	219.49433693,219.409091225,219.323704773,219.238177605,219.152509751,
	219.066701245,218.980752118,218.894662401,218.808432129,218.722061332,
	218.635550046,218.548898303,218.462106137,218.375173583,218.288100674,
	218.200887447,218.113533935,218.026040174,217.938406201,217.85063205,
	217.762717759,217.674663364,217.586468901,217.498134409,217.409659925,
	217.321045486,217.23229113,217.143396897,217.054362824,216.965188951,
	216.875875317,216.786421961,216.696828923,216.607096243,216.517223962,
	216.427212121,216.337060759,216.246769919,216.156339642,216.065769969,
	215.975060943,215.884212606,215.793225,215.702098168,215.610832153,
	215.519426999,215.427882749,215.336199446,215.244377136,215.152415861,
	215.060315668,214.9680766,214.875698703,214.783182022,214.690526602,
	214.59773249,214.504799731,214.411728372,214.318518459,214.225170039,
	214.13168316,214.038057867,213.944294209,213.850392234,213.756351989,
	213.662173523,213.567856883,213.473402119,213.378809279,213.284078413,
	213.189209569,213.094202798,212.999058148,212.90377567,212.808355415,
	212.712797431,212.617101771,212.521268484,212.425297622,212.329189236,
	212.232943377,212.136560097,212.040039448,211.943381481,211.84658625,
	211.749653806,211.652584203,211.555377492,211.458033727,211.360552961,
	211.262935248,211.165180641,211.067289195,210.969260962,210.871095997,
	210.772794355,210.67435609,210.575781257,210.47706991,210.378222106,
	210.279237898,210.180117344,210.080860497,209.981467415,209.881938153,
	209.782272767,209.682471314,209.58253385,209.482460432,209.382251116,
	209.281905961,209.181425022,209.080808359,208.980056027,208.879168084,
	208.77814459,208.676985601,208.575691176,208.474261373,208.372696251,
	208.270995868,208.169160283,208.067189556,207.965083746,207.862842911,
	207.760467111,207.657956407,207.555310857,207.452530521,207.349615461,
	207.246565735,207.143381404,207.04006253,206.936609172,206.833021391,
	206.729299249,206.625442806,206.521452124,206.417327264,206.313068287,
	206.208675256,206.104148232,205.999487277,205.894692453,205.789763823,
	205.684701448,205.579505392,205.474175717,205.368712485,205.263115761,
	205.157385605,205.051522083,204.945525257,204.83939519,204.733131947,
	204.62673559,204.520206184,204.413543793,204.30674848,204.199820311,
	204.092759348,203.985565657,203.878239302,203.770780349,203.663188861,
	203.555464903,203.447608542,203.339619841,203.231498866,203.123245683,
	203.014860358,202.906342955,202.79769354,202.68891218,202.579998941,
	202.470953888,202.361777088,202.252468607,202.143028512,202.033456868,
	201.923753744,201.813919205,201.703953319,201.593856153,201.483627773,
	201.373268247,201.262777642,201.152156026,201.041403466,200.930520031,
	200.819505787,200.708360802,200.597085146,200.485678885,200.374142088,
	200.262474823,200.150677158,200.038749163,199.926690906,199.814502455,
	199.702183879,199.589735248,199.47715663,199.364448094,199.25160971,
	199.138641547,199.025543674,198.912316161,198.798959078,198.685472494,
	198.57185648,198.458111104,198.344236438,198.23023255,198.116099513,
	198.001837395,197.887446267,197.7729262,197.658277265,197.543499531,
	197.428593071,197.313557954,197.198394253,197.083102037,196.967681378,
	196.852132348,196.736455018,196.620649459,196.504715744,196.388653943,
	196.272464128,196.156146371,196.039700745,195.923127322,195.806426173,
	195.68959737,195.572640987,195.455557095,195.338345768,195.221007077,
	195.103541095,194.985947896,194.868227553,194.750380137,194.632405723,
	194.514304383,194.396076191,194.277721221,194.159239545,194.040631238,
	193.921896372,193.803035022,193.684047262,193.564933166,193.445692807,
	193.32632626,193.206833599,193.087214899,192.967470233,192.847599677,
	192.727603305,192.607481191,192.487233411,192.36686004,192.246361152,
	192.125736822,192.004987127,191.88411214,191.763111938,191.641986596,
	191.52073619,191.399360795,191.277860487,191.156235342,191.034485436,
	190.912610845,190.790611645,190.668487913,190.546239725,190.423867157,
	190.301370286,190.178749188,190.056003942,189.933134622,189.810141307,
	189.687024073,189.563782998,189.440418159,189.316929633,189.193317498,
	189.069581831,188.945722711,188.821740214,188.69763442,188.573405405,
	188.449053248,188.324578028,188.199979822,188.075258709,187.950414768,
	187.825448077,187.700358715,187.575146761,187.449812294,187.324355393,
	187.198776138,187.073074607,186.94725088,186.821305036,186.695237156,
	186.56904732,186.442735606,186.316302095,186.189746867,186.063070002,
	185.936271582,185.809351685,185.682310393,185.555147787,185.427863947,
	185.300458954,185.17293289,185.045285836,184.917517872,184.789629081,
	184.661619543,184.533489341,184.405238557,184.276867272,184.148375569,
	184.019763529,183.891031235,183.76217877,183.633206216,183.504113655,
	183.374901171,183.245568847,183.116116766,182.986545011,182.856853665,
	182.727042812,182.597112535,182.467062919,182.336894047,182.206606004,
	182.076198874,181.94567274,181.815027688,181.684263802,181.553381167,
	181.422379868,181.29125999,181.160021619,181.028664839,180.897189736,
	180.765596396,180.633884905,180.502055349,180.370107814,180.238042385,
	180.105859151,179.973558197,179.84113961,179.708603476,179.575949884,
	179.443178921,179.310290673,179.177285229,179.044162676,178.910923101,
	178.777566595,178.644093243,178.510503136,178.376796361,178.242973007,
	178.109033164,177.97497692,177.840804365,177.706515588,177.572110679,
	177.437589728,177.302952825,177.168200059,177.033331522,176.898347304,
	176.763247496,176.628032189,176.492701473,176.357255441,176.221694184,
	176.086017794,175.950226362,175.81431998,175.678298742,175.54216274,
	175.405912065,175.269546813,175.133067074,174.996472944,174.859764515,
	174.722941881,174.586005136,174.448954375,174.311789692,174.174511182,
	174.037118939,173.899613058,173.761993636,173.624260766,173.486414547,
	173.348455072,173.210382438,173.072196743,172.933898082,172.795486553,
	172.656962252,172.518325278,172.379575727,172.240713698,172.101739288,
	171.962652597,171.823453723,171.684142764,171.544719821,171.405184991,
	171.265538375,171.125780073,170.985910185,170.845928812,170.705836053,
	170.565632011,170.425316785,170.284890479,170.144353192,170.003705029,
	169.86294609,169.722076479,169.581096298,169.440005651,169.29880464,
	169.15749337,169.016071945,168.874540469,168.732899047,168.591147783,
	168.449286783,168.307316152,168.165235996,168.023046422,167.880747535,
	167.738339442,167.595822251,167.453196068,167.310461002,167.167617161,
	167.024664652,166.881603584,166.738434067,166.595156209,166.451770121,
	166.308275912,166.164673693,166.020963573,165.877145665,165.73322008,
	165.589186928,165.445046323,165.300798376,165.156443201,165.01198091,
	164.867411617,164.722735436,164.577952481,164.433062866,164.288066706,
	164.142964117,163.997755214,163.852440114,163.707018932,163.561491786,
	163.415858793,163.270120071,163.124275737,162.978325909,162.832270707,
	162.686110251,162.539844658,162.39347405,162.246998547,162.100418269,
	161.953733339,161.806943877,161.660050005,161.513051847,161.365949526,
	161.218743163,161.071432884,160.924018813,160.776501075,160.628879793,
	160.481155095,160.333327107,160.185395954,160.037361763,159.889224663,
	159.740984781,159.592642246,159.444197185,159.295649729,159.147000008,
	158.998248152,158.84939429,158.700438556,158.55138108,158.402221995,
	158.252961433,158.103599528,157.954136414,157.804572224,157.654907095,
	157.50514116,157.355274555,157.205307418,157.055239885,156.905072093,
	156.754804181,156.604436287,156.453968549,156.303401109,156.152734104,
	156.001967678,155.85110197,155.700137122,155.549073278,155.397910579,
	155.24664917,155.095289194,154.943830797,154.792274123,154.640619319,
	154.488866531,154.337015906,154.185067592,154.033021737,153.88087849,
	153.728638,153.576300418,153.423865895,153.271334582,153.118706631,
	152.965982194,152.813161426,152.660244479,152.50723151,152.354122672,
	152.200918122,152.047618017,151.894222514,151.74073177,151.587145945,
	151.433465198,151.279689688,151.125819578,150.971855027,150.817796198,
	150.663643254,150.509396358,150.355055676,150.20062137,150.046093609,
	149.891472557,149.736758382,149.581951251,149.427051335,149.272058801,
	149.11697382,148.961796564,148.806527203,148.65116591,148.495712859,
	148.340168223,148.184532177,148.028804897,147.872986559,147.717077341,
	147.56107742,147.404986975,147.248806187,147.092535234,146.936174299,
	146.779723564,146.623183211,146.466553425,146.309834389,146.153026291,
	145.996129315,145.83914365,145.682069482,145.524907002,145.367656399,
	145.210317864,145.052891589,144.895377765,144.737776587,144.580088249,
	144.422312946,144.264450874,144.106502231,143.948467214,143.790346022,
	143.632138856,143.473845917,143.315467405,143.157003525,142.998454479,
	142.839820473,142.681101713,142.522298404,142.363410755,142.204438974,
	142.045383272,141.886243859,141.727020946,141.567714747,141.408325476,
	141.248853346,141.089298575,140.929661378,140.769941975,140.610140584,
	140.450257425,140.290292719,140.13024669,139.970119559,139.809911552,
	139.649622894,139.489253812,139.328804534,139.168275289,139.007666306,
	138.846977816,138.686210053,138.52536325,138.364437641,138.203433462,
	138.04235095,137.881190343,137.71995188,137.558635802,137.397242351,
	137.235771769,137.074224301,136.912600192,136.750899689,136.589123038,
	136.42727049,136.265342294,136.103338703,135.941259968,135.779106344,
	135.616878086,135.45457545,135.292198695,135.12974808,134.967223865,
	134.804626311,134.641955683,134.479212244,134.31639626,134.153507999,
	133.990547728,133.827515717,133.664412238,133.501237563,133.337991965,
	133.174675721,133.011289106,132.847832399,132.68430588,132.520709828,
	132.357044527,132.19331026,132.029507312,131.865635969,131.70169652,
	131.537689255,131.373614463,131.209472439,131.045263474,130.880987866,
	130.71664591,130.552237905,130.387764151,130.22322495,130.058620604,
	129.893951417,129.729217696,129.564419749,129.399557884,129.234632413,
	129.069643646,128.904591899,128.739477487,128.574300726,128.409061935,
	128.243761435,128.078399547,127.912976596,127.747492905,127.581948801,
	127.416344614,127.250680674,127.084957311,126.919174859,126.753333654,
	126.587434032,126.421476332,126.255460894,126.08938806,125.923258173,
	125.75707158,125.590828626,125.424529661,125.258175035,125.091765101,
	124.925300213,124.758780727,124.592207001,124.425579393,124.258898266,
	124.092163983,123.925376908,123.758537408,123.591645852,123.42470261,
	123.257708055,123.09066256,122.923566502,122.756420259,122.589224209,
	122.421978736,122.254684223,122.087341054,121.919949618,121.752510304,
	121.585023502,121.417489607,121.249909012,121.082282117,120.914609318,
	120.746891017,120.579127618,120.411319525,120.243467145,120.075570888,
	119.907631163,119.739648384,119.571622966,119.403555326,119.235445884,
	119.067295059,118.899103276,118.730870959,118.562598536,118.394286436,
	118.22593509,118.057544933,117.8891164,117.720649928,117.552145957,
	117.38360493,117.215027291,117.046413485,116.877763962,116.709079171,
	116.540359567,116.371605603,116.202817737,116.033996428,115.865142138,
	115.696255332,115.527336474,115.358386034,115.189404484,115.020392295,
	114.851349944,114.682277908,114.51317667,114.344046712,114.174888519,
	114.005702582,113.836489392,113.667249444,113.497983235,113.328691268,
	113.159374049,112.990032086,112.820665893,112.65127599,112.4818629,
	112.312427154,112.142969291,111.973489855,111.803989401,111.634468494,
	111.464927714,111.295367652,111.12578892,110.956192147,110.786577989,
	110.61694713,110.447300291,110.277638232,110.107961766,109.938271765,
	109.768569174,109.598855029,109.429130469,109.259396764,109.08965534,
	108.919907811,108.750156018,108.580402081,108.410648454,108.240897994,
	108.071154053,107.901420575,107.731702224,107.562004537,107.392334106,
	107.222698798,107.053108022,106.883573054,106.714107417,106.544727346,
	106.375452342,106.206305832,106.037315951,105.868516465,105.699947865,
	105.531658627,105.363706681,105.196161078,105.029103871,104.862632189,
	104.696860464,104.531922747,104.367975003,104.205197208,104.043795032,
	103.884000819,103.726073505,103.570297123,103.416977529,103.266437085,
	103.119007213,102.975018983,102.834792196,102.698623755,102.566776318,
	102.439468335,102.31686644,102.199080899,102.086164397,101.978114015,
	101.874875888,101.776351798,101.682406896,101.592877771,101.507580271,
	101.426316619,101.34888158,101.275067565,101.204668683,101.137483829,
	101.073318917,101.011988406,100.953316252,100.897136406,100.843292972,
	100.791640115,100.742041783,100.694371316,100.648510972,100.604351413,
	100.561791167,100.520736098,100.481098876,100.442798479,100.405759708,
	100.369912742,100.33519271,100.301539308,100.268896427,100.237211828,
	100.206436828,100.176526021,100.14743702,100.119130218,100.091568572,
	100.064717406,100.038544228,100.013018563,99.9881118057,99.9637970747,
	99.9400490909,99.9168440581,99.894159557,99.8719744466,99.8502687744,
	99.8290236938,99.8082213879,99.7878449996,99.7678785672,99.7483069651,
	99.7291158487,99.7102916043,99.6918213023,99.6736926537,99.6558939706,
	99.6384141286,99.6212425331,99.6043690871,99.5877841617,99.5714785685,
	99.5554435343,99.5396706771,99.5241519841,99.5088797907,99.4938467616,
	99.4790458728,99.4644703942,99.4501138746,99.4359701266,99.4220332128,
	99.4082974329,99.3947573117,99.3814075876,99.368243202,99.355259289,
	99.3424511665,99.3298143267,99.3173444282,99.305037288,99.2928888737,
	99.2808952971,99.2690528072,99.2573577842,99.2458067331,99.2343962788,
	99.2231231603,99.2119842261,99.200976429,99.1900968222,99.1793425543,
	99.1687108662,99.1581990865,99.1478046282,99.1375249852,99.127357729,
	99.1173005058,99.1073510331,99.0975070973,99.0877665507,99.0781273094,
	99.0685873502,99.0591447088,99.0497974775,99.0405438028,99.0313818838,
	99.0223099701,99.0133263596,99.0044293974,98.9956174737,98.9868890224,
	98.9782425192,98.9696764805,98.961189462,98.9527800572,98.9444468959,
	98.9361886436,98.9280039995,98.9198916962,98.9118504978,98.9038791996,
	98.8959766264,98.8881416322,98.8803730987,98.8726699348,98.8650310756,
	98.8574554816,98.8499421377,98.842490053,98.8350982594,98.8277658113,
	98.8204917848,98.8132752771,98.8061154059,98.7990113087,98.7919621421,
	98.7849670817,98.778025321,98.7711360711,98.7642985606,98.7575120342,
	98.7507757532,98.7440889945,98.7374510501,98.730861227,98.7243188468,
	98.7178232448,98.7113737703,98.7049697857,98.6986106664,98.6922958005,
	98.6860245882,98.6797964418,98.6736107851,98.6674670534,98.6613646928,
	98.6553031605,98.6492819238,98.6433004605,98.6373582582,98.6314548143,
	98.6255896357,98.6197622384,98.6139721476,98.608218897,98.6025020293,
	98.5968210951,98.5911756535,98.5855652715,98.5799895238,98.5744479927,
	98.568940268,98.5634659468,98.5580246331,98.552615938,98.5472394792,
	98.5418948811,98.5365817745,98.5312997965,98.5260485906,98.5208278059,
	98.5156370978,98.5104761271,98.5053445606,98.5002420704,98.4951683341,
	98.4901230343,98.4851058592,98.4801165017,98.4751546598,98.4702200364,
	98.465312339,98.4604312797,98.4555765755,98.4507479473,98.4459451208,
	98.4411678258,98.4364157963,98.4316887703,98.42698649,98.4223087013,
	98.4176551543,98.4130256024,98.4084198031,98.4038375174,98.3992785097,
	98.3947425482,98.3902294042,98.3857388525,98.3812706713,98.3768246417,
	98.3724005484,98.3679981788,98.3636173235,98.3592577762,98.3549193333,
	98.3506017943,98.3463049614,98.3420286395,98.3377726363,98.3335367623,
	98.3293208304,98.3251246562,98.3209480578,98.3167908557,98.3126528729,
	98.3085339348,98.3044338692,98.300352506,98.2962896777,98.2922452187,
	98.2882189658,98.2842107578,98.2802204358,98.2762478427,98.2722928237,
	98.2683552259,98.2644348984,98.2605316922,98.2566454601,98.252776057,
	98.2489233395,98.2450871661,98.2412673969,98.2374638939,98.2336765208,
	98.2299051431,98.2261496276,98.2224098432,98.2186856601,98.2149769503,
	98.211283587,98.2076054453,98.2039424018,98.2002943343,98.1966611223,
	98.1930426467,98.1894387897,98.1858494351,98.1822744679,98.1787137745,
	98.1751672426,98.1716347612,98.1681162208,98.164611513,98.1611205304,
	98.1576431674,98.1541793191,98.1507288821,98.1472917539,98.1438678335,
	98.1404570209,98.137059217,98.1336743241,98.1303022455,98.1269428856,
	98.1235961497,98.1202619444,98.1169401771,98.1136307564,98.1103335918,
	98.1070485937,98.1037756736,98.1005147439,98.0972657181,98.0940285103,
	98.0908030358,98.0875892108,98.0843869521,98.0811961778,98.0780168065,
	98.0748487578,98.0716919522,98.0685463109,98.065411756,98.0622882105,
	98.059175598,98.056073843,98.0529828708,98.0499026073,98.0468329794,
	98.0437739145,98.040725341,98.0376871877,98.0346593844,98.0316418614,
	98.0286345499,98.0256373816,98.022650289,98.0196732052,98.0167060639,
	98.0137487996,98.0108013475,98.007863643,98.0049356227,98.0020172235,
	97.9991083829,97.9962090391,97.9933191308,97.9904385974,97.9875673788,
	97.9847054155,97.9818526486,97.9790090196,97.9761744709,97.9733489449,
	97.9705323852,97.9677247353,97.9649259396,97.962135943,97.9593546907,
	97.9565821286,97.9538182031,97.9510628609,97.9483160494,97.9455777165,
	97.9428478102,97.9401262795,97.9374130735,97.9347081419,97.9320114348,
	97.9293229027,97.9266424966,97.9239701681,97.921305869,97.9186495515,
	97.9160011684,97.9133606729,97.9107280184,97.908103159,97.905486049,
	97.9028766432,97.9002748966,97.8976807649,97.895094204,97.8925151702,
	97.8899436201,97.8873795107,97.8848227996,97.8822734445,97.8797314035,
	97.8771966351,97.8746690982,97.8721487519,97.8696355558,97.8671294697,
	97.8646304538,97.8621384687,97.8596534753,97.8571754347,97.8547043084,
	97.8522400582,97.8497826464,97.8473320353,97.8448881877,97.8424510667,
	97.8400206356,97.8375968581,97.8351796981,97.8327691199,97.830365088,
	97.8279675672,97.8255765225,97.8231919195,97.8208137237,97.8184419011,
	97.8160764178,97.8137172403,97.8113643353,97.8090176699,97.8066772111,
	97.8043429267,97.8020147842,97.7996927518,97.7973767976,97.7950668901,
	97.7927629982,97.7904650907,97.7881731369,97.7858871063,97.7836069685,
	97.7813326935,97.7790642513,97.7768016125,97.7745447475,97.7722936272,
	97.7700482226,97.7678085051,97.765574446,97.763346017,97.7611231901,
	97.7589059373,97.756694231,97.7544880437,97.7522873481,97.7500921171,
	97.7479023238,97.7457179416,97.743538944,97.7413653046,97.7391969974,
	97.7370339964,97.734876276,97.7327238105,97.7305765747,97.7284345433,
	97.7262976914,97.7241659941,97.7220394268,97.7199179651,97.7178015846,
	97.7156902613,97.7135839711,97.7114826903,97.7093863954,97.7072950628,
	97.7052086692,97.7031271916,97.7010506071,97.6989788927,97.6969120259,
	97.6948499842,97.6927927452,97.6907402868,97.688692587,97.6866496239,
	97.6846113758,97.682577821,97.6805489383,97.6785247062,97.6765051038,
	97.6744901099,97.6724797037,97.6704738646,97.668472572,97.6664758054,
	97.6644835445,97.6624957692,97.6605124594,97.6585335953,97.6565591571,
	97.6545891252,97.6526234801,97.6506622024,97.6487052728,97.6467526724,
	97.6448043819,97.6428603827,97.640920656,97.638985183,97.6370539455,
	97.6351269248,97.6332041029,97.6312854615,97.6293709827,97.6274606485,
	97.6255544411,97.6236523428,97.6217543361,97.6198604035,97.6179705277,
	97.6160846915,97.6142028776,97.6123250692,97.6104512492,97.6085814009,
	97.6067155076,97.6048535526,97.6029955196,97.601141392,97.5992911537,
	97.5974447884,97.5956022801,97.5937636128,97.5919287705,97.5900977376,
	97.5882704982,97.5864470369,97.5846273381,97.5828113864,97.5809991665,
	97.5791906632,97.5773858614,97.575584746,97.5737873021,97.5719935148,
	97.5702033695,97.5684168513,97.5666339458,97.5648546384,97.5630789148,
	97.5613067605,97.5595381614,97.5577731033,97.5560115722,97.554253554,
	97.5524990348,97.5507480009,97.5490004385,97.5472563339,97.5455156736,
	97.543778444,97.5420446318,97.5403142235,97.538587206,97.536863566,
	97.5351432905,97.5334263663,97.5317127806,97.5300025204,97.528295573,
	97.5265919256,97.5248915655,97.5231944802,97.5215006571,97.5198100838,
	97.5181227478,97.516438637,97.5147577391,97.5130800418,97.5114055332,
	97.5097342011,97.5080660336,97.5064010188,97.5047391449,97.5030804001,
	97.5014247727,97.4997722511,97.4981228238,97.4964764791,97.4948332057,
	97.4931929922,97.4915558273,97.4899216998,97.4882905984,97.486662512,
	97.4850374296,97.4834153401,97.4817962326,97.4801800963,97.4785669202,
	97.4769566937,97.475349406,97.4737450464,97.4721436044,97.4705450695,
	97.4689494311,97.4673566789,97.4657668024,97.4641797914,97.4625956356,
	97.4610143248,97.4594358488,97.4578601976,97.4562873612,97.4547173294,
	97.4531500925,97.4515856404,97.4500239635,97.4484650519,97.4469088959,
	97.4453554858,97.443804812,97.4422568649,97.440711635,97.4391691128,
	97.4376292889,97.4360921539,97.4345576986,97.4330259135,97.4314967895,
	97.4299703175,97.4284464882,97.4269252926,97.4254067216,97.4238907662,
	97.4223774176,97.4208666667,97.4193585048,97.417852923,97.4163499125,
	97.4148494647,97.4133515707,97.4118562221,97.4103634103,97.4088731265,
	97.4073853625,97.4059001096,97.4044173595,97.4029371038,97.4014593341,
	97.3999840422,97.3985112199,97.3970408588,97.3955729508,97.3941074878,
	97.3926444618,97.3911838646,97.3897256882,97.3882699246,97.386816566,
	97.3853656045,97.3839170321,97.3824708411,97.3810270237,97.3795855721,
	97.3781464786,97.3767097356,97.3752753355,97.3738432706,97.3724135335,
	97.3709861165,97.3695610122,97.3681382131,97.3667177119,97.3652995012,
	97.3638835736,97.3624699218,97.3610585385,97.3596494166,97.3582425488,
	97.356837928,97.3554355469,97.3540353986,97.352637476,97.351241772,
	97.3498482796,97.3484569918,97.3470679018,97.3456810027,97.3442962874,
	97.3429137494,97.3415333816,97.3401551774,97.33877913,97.3374052327,
	97.3360334788,97.3346638617,97.3332963748,97.3319310114,97.3305677651,
	97.3292066293,97.3278475975,97.3264906632,97.32513582,97.3237830615,
	97.3224323813,97.3210837731,97.3197372306,97.3183927474,97.3170503173,
	97.3157099341,97.3143715916,97.3130352836,97.3117010039,97.3103687464,
	97.3090385051,97.3077102738,97.3063840465,97.3050598173,97.3037375801,
	97.302417329,97.301099058,97.2997827613,97.2984684329,97.297156067,
	97.2958456578,97.2945371995,97.2932306863,97.2919261125,97.2906234723,
	97.28932276,97.28802397,97.2867270967,97.2854321343,97.2841390773,
	97.2828479201,97.2815586572,97.2802712831,97.2789857921,97.277702179,
	97.2764204381,97.2751405642,97.2738625517,97.2725863953,97.2713120896,
	97.2700396294,97.2687690092,97.2675002238,97.2662332679,97.2649681363,
	97.2637048237,97.262443325,97.2611836349,97.2599257484,97.2586696603,
	97.2574153654,97.2561628587,97.2549121351,97.2536631895,97.252416017,
	97.2511706125,97.2499269711,97.2486850877,97.2474449575,97.2462065754,
	97.2449699367,97.2437350364,97.2425018697,97.2412704318,97.2400407177,
	97.2388127227,97.2375864421,97.2363618711,97.2351390048,97.2339178387,
	97.232698368,97.2314805881,97.2302644942,97.2290500817,97.227837346,
	97.2266262825,97.2254168866,97.2242091538,97.2230030795,97.2217986591,
	97.2205958882,97.2193947622,97.2181952767,97.2169974273,97.2158012094,
	97.2146066187,97.2134136508,97.2122223012,97.2110325657,97.2098444398,
	97.2086579193,97.2074729998,97.206289677,97.2051079466,97.2039278045,
	97.2027492462,97.2015722677,97.2003968646,97.1992230329,97.1980507682,
	97.1968800665,97.1957109237,97.1945433355,97.1933772979,97.1922128067,
	97.191049858,97.1898884475,97.1887285714,97.1875702255,97.1864134058,
	97.1852581084,97.1841043292,97.1829520643,97.1818013097,97.1806520615,
	97.1795043157,97.1783580685,97.177213316,97.1760700542,97.1749282794,
	97.1737879877,97.1726491752,97.1715118381,97.1703759726,97.169241575,
	97.1681086414,97.1669771681,97.1658471514,97.1647185875,97.1635914727,
	97.1624658033,97.1613415756,97.160218786,97.1590974307,97.1579775062,
	97.1568590088,97.1557419349,97.1546262808,97.1535120431,97.152399218,
	97.1512878021,97.1501777919,97.1490691836,97.1479619739,97.1468561593,
	97.1457517361,97.144648701,97.1435470505,97.1424467811,97.1413478894,
	97.1402503719,97.1391542252,97.138059446,97.1369660307,97.1358739761,
	97.1347832788,97.1336939353,97.1326059425,97.1315192968,97.1304339951,
	97.129350034,97.1282674102,97.1271861204,97.1261061614,97.1250275298,
	97.1239502226,97.1228742363,97.1217995678,97.1207262139,97.1196541714,
	97.118583437,97.1175140077,97.1164458803,97.1153790515,97.1143135182,
	97.1132492774,97.1121863259,97.1111246606,97.1100642784,97.1090051762,
	97.1079473509,97.1068907995,97.1058355189,97.1047815061,97.103728758,
	97.1026772716,97.101627044,97.100578072,97.0995303528,97.0984838834,
	97.0974386607,97.0963946818,97.0953519439,97.0943104438,97.0932701788,
	97.0922311459,97.0911933422,97.0901567648,97.0891214108,97.0880872774,
	97.0870543616,97.0860226607,97.0849921717,97.0839628919,97.0829348184,
	97.0819079485,97.0808822792,97.0798578079,97.0788345317,97.0778124478,
	97.0767915536,97.0757718461,97.0747533228,97.0737359808,97.0727198174,
	97.0717048299,97.0706910156,97.0696783718,97.0686668959,97.067656585,
	97.0666474366,97.065639448,97.0646326165,97.0636269395,97.0626224144,
	97.0616190385,97.0606168092,97.0596157239,97.0586157801,97.057616975,
	97.0566193062,97.0556227711,97.054627367,97.0536330915,97.0526399419,
	97.0516479159,97.0506570107,97.049667224,97.0486785531,97.0476909957,
	97.0467045491,97.0457192109,97.0447349787,97.0437518499,97.0427698221,
	97.0417888928,97.0408090596,97.0398303201,97.0388526718,97.0378761123,
	97.0369006391,97.03592625,97.0349529424,97.033980714,97.0330095624,
	97.0320394853,97.0310704802,97.0301025448,97.0291356768,97.0281698738,
	97.0272051335,97.0262414535,97.0252788315,97.0243172653,97.0233567525,
	97.0223972908,97.0214388779,97.0204815115,97.0195251895,97.0185699094,
	97.017615669,97.0166624662,97.0157102985,97.0147591639,97.0138090601,
	97.0128599847,97.0119119358,97.0109649109,97.0100189079,97.0090739247,
	97.008129959,97.0071870086,97.0062450714,97.0053041453,97.0043642279,
	97.0034253173,97.0024874112,97.0015505075,97.0006146041,96.9996796988,
	96.9987457895,96.9978128742,96.9968809507,96.9959500168,96.9950200706,
	96.99409111,96.9931631327,96.9922361369,96.9913101203,96.990385081,
	96.9894610169,96.9885379259,96.9876158061,96.9866946553,96.9857744715,
	96.9848552528,96.9839369971,96.9830197024,96.9821033667,96.981187988,
	96.9802735642,96.9793600936,96.9784475739,96.9775360034,96.9766253799,
	96.9757157016,96.9748069665,96.9738991726,96.9729923181,96.9720864009,
	96.9711814192,96.9702773709,96.9693742543,96.9684720674,96.9675708082,
	96.966670475,96.9657710657,96.9648725785,96.9639750116,96.9630783629,
	96.9621826308,96.9612878133,96.9603939085,96.9595009145,96.9586088297,
	96.957717652,96.9568273797,96.9559380109,96.9550495438,96.9541619767,
	96.9532753075,96.9523895347,96.9515046562,96.9506206705,96.9497375756,
	96.9488553698,96.9479740512,96.9470936182,96.9462140689,96.9453354016,
	96.9444576145,96.9435807059,96.942704674,96.941829517,96.9409552332,
	96.940081821
	}}
};
