/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model.items;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.model.items.Slot;
import org.lisaac.ldt.model.types.ITypeMono;
import org.lisaac.ldt.outline.OutlineItem;
import org.lisaac.ldt.outline.OutlineSlot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Section {
    protected Prototype prototype;
    protected String name;
    protected ITypeMono[] typeList;
    protected Section next;
    protected Position position;
    protected LinkedList<Slot> slots;

    public Section(Prototype prototype, String name, Position position) {
        this.name = name;
        this.prototype = prototype;
        this.position = position;
        this.next = null;
    }

    public Section(Prototype prototype, ITypeMono[] typeList, Position position) {
        this.typeList = typeList;
        this.prototype = prototype;
        this.position = position;
        this.next = null;
    }

    public String getName() {
        if (this.name == null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.typeList.length) {
                buffer.append(this.typeList[i].toString());
                if (i != this.typeList.length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
            return buffer.toString();
        }
        return this.name;
    }

    public ITypeMono[] getTypeList() {
        return this.typeList;
    }

    public Section getNext() {
        return this.next;
    }

    public void setNext(Section next) {
        this.next = next;
    }

    public Position getPosition() {
        return this.position;
    }

    public void addSlot(Slot slot) {
        if (this.slots == null) {
            this.slots = new LinkedList();
        }
        this.slots.add(slot);
    }

    public boolean isMapping() {
        if (this.name == null) {
            return false;
        }
        return this.name.equals("Mapping");
    }

    public boolean isPrivate() {
        if (this.name == null) {
            return true;
        }
        return this.name.equals("Private");
    }

    public boolean isPublic() {
        if (this.name != null) {
            return this.name.equals("Public");
        }
        return false;
    }

    public boolean isHeader() {
        if (this.name == null) {
            return false;
        }
        return this.name.equals("Header");
    }

    public boolean isInherit() {
        if (this.name == null) {
            return false;
        }
        return this.name.equals("Inherit");
    }

    public boolean isInsert() {
        if (this.name == null) {
            return false;
        }
        return this.name.equals("Insert");
    }

    public boolean isInheritOrInsert() {
        return this.isInherit() || this.isInsert();
    }

    public boolean isInterrupt() {
        if (this.name == null) {
            return false;
        }
        return this.name.equals("Interrupt");
    }

    public boolean isDirectory() {
        if (this.name == null) {
            return false;
        }
        return this.name.equals("Directory");
    }

    public boolean isExternal() {
        if (this.name == null) {
            return false;
        }
        return this.name.equals("External");
    }

    public boolean isPrivateStyle() {
        return !this.isPublic() && this.typeList == null;
    }

    public Prototype getPrototype() {
        return this.prototype;
    }

    public List<OutlineItem> getOutlineItems() {
        ArrayList<OutlineItem> items = new ArrayList<OutlineItem>();
        if (this.slots != null) {
            int i = 0;
            while (i < this.slots.size()) {
                items.add(new OutlineSlot(this.slots.get(i)));
                ++i;
            }
        }
        return items;
    }
}

