/* NVTV nvidia backend header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: back_nvidia.h,v 1.9 2002/11/14 17:09:29 dthierbach Exp $
 *
 * Contents:
 *
 * Header for nvidia backend
 */

#ifndef _BACK_NVIDIA_H
#define _BACK_NVIDIA_H

#include "backend.h"

extern BackCardRec bnv_func;
extern BackCardRec bxbox_func;

void bnv_openCard (CardPtr card);
void bnv_closeCard (void);
void bnv_setHeads (int main, int tv, int video);
void bnv_getHeads (int *main, int *tv, int *video, int *max);
void bnv_probeChips (void);
void bnv_setChip (ChipPtr chip, Bool init);
void bnv_setSettings (TVSettings *set);
void bnv_getSettings (TVSettings *set);
void bnv_setMode (TVRegs *r);
void bnv_getMode (TVRegs *r);
void bnv_setModeSettings (TVRegs *r, TVSettings *set);
void bnv_setTestImage (TVEncoderRegs *tv, TVSettings *set);
long bnv_getStatus (int index);
TVConnect bnv_getConnection (void);
Bool bnv_findBySize (TVSystem system, int xres, int yres, char *size, 
    TVMode *mode);
Bool bnv_findByOverscan (TVSystem system, int xres, int yres, 
    double hoc, double voc, TVMode *mode);

void bnv_initSharedView (int *view_x, int *view_y);
Bool bnv_getTwinView (int *view_x, int *view_y);
Bool bnv_adjustViewport (int flags, int *view_x, int *view_y); 
Bool bnv_serviceViewportCursor (int flags, int cursor_x, int cursor_y, 
  int *view_x, int *view_y);

void bnv_probeSystem (CardPtr card_list);

#endif /* _BACK_NVIDIA_H */
