/* NVTV tdfx_type -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * Extends the TDFXRec type from tdfx.h and introduces new types, and should
 * eventually be merged with the original XFree file.  
 * 
 */

#ifndef _TDFX_TYPE_H
#define _TDFX_TYPE_H

#include "xf86i2c.h"
#include "debug.h"
#include "tv_common.h"

typedef struct _TDFXRec *TDFXPtr;

#define MAXCHIPS 4

typedef struct _TDFXRec {
  unsigned char *MMIOBase[MAXCHIPS];
  unsigned char *FbBase;
  unsigned char *myFbBase;
  unsigned int PIOBase[MAXCHIPS];
  int IOBase; /* normally, this is in the vgaHWRec */
  /* ... */
  /* new members: */
  TVEncoderObj	      tvEncoder;
  I2CChainPtr         TvChain; /* chain of devices on all busses */
  I2CBusPtr           TvBus;
} TDFXRec;

#define TDFXPTR(p) ((TDFXPtr)((p)->driverPrivate))

#endif /* _TDFX_TYPE_H */
