% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkInt.R
\name{checkInt}
\alias{checkInt}
\alias{check_int}
\alias{assertInt}
\alias{assert_int}
\alias{testInt}
\alias{test_int}
\alias{expect_int}
\title{Check if an argument is a single integerish value}
\usage{
checkInt(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps), null.ok = FALSE)

check_int(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps), null.ok = FALSE)

assertInt(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps), null.ok = FALSE, coerce = FALSE,
  .var.name = vname(x), add = NULL)

assert_int(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps), null.ok = FALSE, coerce = FALSE,
  .var.name = vname(x), add = NULL)

testInt(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps), null.ok = FALSE)

test_int(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps), null.ok = FALSE)

expect_int(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps), null.ok = FALSE, info = NULL,
  label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than or equal to.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than or equal to.}

\item{tol}{[\code{double(1)}]\cr
Numerical tolerance used to check whether a double or complex can be converted.
Default is \code{sqrt(.Machine$double.eps)}.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{coerce}{[\code{logical(1)}]\cr
If \code{TRUE}, the input \code{x} is returned as integer after an successful assertion.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertInt}/\code{assert_int} return 
 \code{x} invisibly, whereas
 \code{checkInt}/\code{check_int} and 
 \code{testInt}/\code{test_int} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertInt}/\code{assert_int}
 throws an error message, 
 \code{testInt}/\code{test_int}
 returns \code{FALSE},
 and \code{checkInt} returns a string with the error message.
 The function \code{expect_int} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a single integerish value
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\note{
To perform an assertion and then convert to integer, use \code{\link{asInt}}.
\code{assertInt} will not convert numerics to integer.
}
\examples{
testInt(1)
testInt(-1, lower = 0)
}
\seealso{
Other scalars: \code{\link{checkCount}},
  \code{\link{checkFlag}}, \code{\link{checkNumber}},
  \code{\link{checkScalarNA}}, \code{\link{checkScalar}},
  \code{\link{checkString}}
}
\concept{scalars}
