% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_addrole.R
\name{collection_addrole}
\alias{collection_addrole}
\title{Add a role to a node}
\usage{
collection_addrole(conn, role = "overseer", node, raw = FALSE, ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{role}{(character) Required. The name of the role. The only supported role
as of now is overseer (set as default).}

\item{node}{(character) Required. The name of the node. It is possible to assign a
role even before that node is started.}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Assign a role to a given node in the cluster. The only supported role
as of 4.7 is 'overseer' . Use this API to dedicate a particular node as Overseer.
Invoke it multiple times to add more nodes. This is useful in large clusters where
an Overseer is likely to get overloaded . If available, one among the list of
nodes which are assigned the 'overseer' role would become the overseer. The
system would assign the role to any other node if none of the designated nodes
are up and running
}
\examples{
\dontrun{
(conn <- SolrClient$new())

# get list of nodes
nodes <- conn$collection_clusterstatus()$cluster$live_nodes
collection_addrole(conn, node = nodes[1])
}
}
