#include "rheolef.h"
#include "rheolef/mixed_solver.h"
using namespace rheolef;
using namespace std;
#include "cavity.h"
#include "pcg_solver.h"
int main(int argc, char**argv) {
  geo  omega (argv[1]);
  space Vh = cavity_space (omega, "P2");
  space Qh (omega, "P1");
  field uh = cavity_field (Vh, 1);
  field ph (Qh, 0.);
  form mp (Qh, Qh, "mass");
  form a  (Vh, Vh, "2D_D");
  form b (Vh, Qh, "div"); b = -b;
  int   max_iter = 5000;
  Float tol      = 1e-15;
  if (omega.dimension() < 3) {
    int status = pcg_abtb (a.uu, b.uu, uh.u, ph.u, -(a.ub*uh.b), -(b.ub*uh.b),
      ldlt(mp.uu), ldlt(a.uu), max_iter, tol, &cerr);
  } else {
    int status = pcg_abtb (a.uu, b.uu, uh.u, ph.u, -(a.ub*uh.b), -(b.ub*uh.b),
      pcg_solver(mp.uu), pcg_solver(a.uu), max_iter, tol, &cerr);
  }
  cout << catchmark("u")  << uh
       << catchmark("p")  << ph;
  return 0;
}
