// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * Enumeration of page fitting types.
 * @enum {string}
 */
export const FittingType = {
  NONE: 'none',
  FIT_TO_PAGE: 'fit-to-page',
  FIT_TO_WIDTH: 'fit-to-width',
  FIT_TO_HEIGHT: 'fit-to-height',
};

/**
 * Enumeration of two up view actions.
 * @enum {string}
 */
export const TwoUpViewAction = {
  TWO_UP_VIEW_ENABLE: 'two-up-view-enable',
  TWO_UP_VIEW_DISABLE: 'two-up-view-disable',
};
