/* goocanvas-3.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Goo", gir_namespace = "GooCanvas", gir_version = "3.0", lower_case_cprefix = "goo_")]
namespace Goo {
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_get_type ()")]
	public class Canvas : Gtk.Container, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Canvas ();
		public void convert_bounds_to_item_space (Goo.CanvasItem item, ref Goo.CanvasBounds bounds);
		public void convert_from_item_space (Goo.CanvasItem item, ref double x, ref double y);
		public void convert_from_pixels (ref double x, ref double y);
		public void convert_to_item_space (Goo.CanvasItem item, ref double x, ref double y);
		public void convert_to_pixels (ref double x, ref double y);
		[Version (since = "2.0.1")]
		public void convert_units_from_pixels (ref double x, ref double y);
		[Version (since = "2.0.1")]
		public void convert_units_to_pixels (ref double x, ref double y);
		public Cairo.Context create_cairo_context ();
		public virtual Goo.CanvasItem create_item (Goo.CanvasItemModel model);
		public static void create_path (GLib.Array<Goo.CanvasPathCommand?> commands, Cairo.Context cr);
		public void get_bounds (out double left, out double top, out double right, out double bottom);
		public double get_default_line_width ();
		public unowned Goo.CanvasItem get_item (Goo.CanvasItemModel model);
		public unowned Goo.CanvasItem get_item_at (double x, double y, bool is_pointer_event);
		public GLib.List<weak Goo.CanvasItem> get_items_at (double x, double y, bool is_pointer_event);
		public GLib.List<weak Goo.CanvasItem> get_items_in_area (Goo.CanvasBounds area, bool inside_area, bool allow_overlaps, bool include_containers);
		public unowned Goo.CanvasItem get_root_item ();
		public unowned Goo.CanvasItemModel get_root_item_model ();
		public double get_scale ();
		public unowned Goo.CanvasItem get_static_root_item ();
		public unowned Goo.CanvasItemModel get_static_root_item_model ();
		public void grab_focus (Goo.CanvasItem item);
		public Gdk.GrabStatus keyboard_grab (Goo.CanvasItem item, bool owner_events, uint32 time);
		public void keyboard_ungrab (Goo.CanvasItem item, uint32 time);
		public static GLib.Array<Goo.CanvasPathCommand?> parse_path_data (string path_data);
		public Gdk.GrabStatus pointer_grab (Goo.CanvasItem item, Gdk.EventMask event_mask, Gdk.Cursor cursor, uint32 time);
		public void pointer_ungrab (Goo.CanvasItem item, uint32 time);
		public void register_widget_item (Goo.CanvasWidget witem);
		public void render (Cairo.Context cr, Goo.CanvasBounds? bounds, double scale);
		public void request_item_redraw (Goo.CanvasBounds bounds, bool is_static);
		public void request_redraw (Goo.CanvasBounds bounds);
		public void request_update ();
		public void scroll_to (double left, double top);
		public void set_bounds (double left, double top, double right, double bottom);
		public void set_root_item (Goo.CanvasItem item);
		public void set_root_item_model (Goo.CanvasItemModel model);
		public void set_scale (double scale);
		public void set_static_root_item (Goo.CanvasItem item);
		public void set_static_root_item_model (Goo.CanvasItemModel model);
		public void unregister_item (Goo.CanvasItemModel model);
		public void unregister_widget_item (Goo.CanvasWidget witem);
		public void update ();
		[NoAccessorMethod]
		public Goo.CanvasAnchorType anchor { get; set; }
		[NoAccessorMethod]
		public bool automatic_bounds { get; set; }
		[NoAccessorMethod]
		public string background_color { set; }
		[NoAccessorMethod]
		[Version (since = "2.0.1")]
		public Gdk.RGBA background_color_gdk_rgba { set; }
		[NoAccessorMethod]
		public uint background_color_rgb { set; }
		[NoAccessorMethod]
		public bool bounds_from_origin { get; set; }
		[NoAccessorMethod]
		public double bounds_padding { get; set; }
		[NoAccessorMethod]
		public bool clear_background { get; set; }
		[NoAccessorMethod]
		public bool integer_layout { get; set; }
		[NoAccessorMethod]
		public bool redraw_when_scrolled { get; set; }
		[NoAccessorMethod]
		public double resolution_x { get; set; }
		[NoAccessorMethod]
		public double resolution_y { get; set; }
		public double scale { get; set; }
		[NoAccessorMethod]
		public double scale_x { get; set; }
		[NoAccessorMethod]
		public double scale_y { get; set; }
		[NoAccessorMethod]
		public Gtk.Unit units { get; set; }
		[NoAccessorMethod]
		public double x1 { get; set; }
		[NoAccessorMethod]
		public double x2 { get; set; }
		[NoAccessorMethod]
		public double y1 { get; set; }
		[NoAccessorMethod]
		public double y2 { get; set; }
		public virtual signal void item_created (Goo.CanvasItem item, Goo.CanvasItemModel model);
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_accessible_factory_get_type ()")]
	public class CanvasAccessibleFactory : Atk.ObjectFactory {
		[CCode (has_construct_function = false)]
		protected CanvasAccessibleFactory ();
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_ellipse_get_type ()")]
	public class CanvasEllipse : Goo.CanvasItemSimple, Goo.CanvasItem {
		public Goo.CanvasEllipseData? ellipse_data;
		[CCode (has_construct_function = false, type = "GooCanvasItem*")]
		public CanvasEllipse (Goo.CanvasItem? parent, double center_x, double center_y, double radius_x, double radius_y, ...);
		[NoAccessorMethod]
		public double center_x { get; set; }
		[NoAccessorMethod]
		public double center_y { get; set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public double radius_x { get; set; }
		[NoAccessorMethod]
		public double radius_y { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_ellipse_model_get_type ()")]
	public class CanvasEllipseModel : Goo.CanvasItemModelSimple, Goo.CanvasItemModel {
		public Goo.CanvasEllipseData ellipse_data;
		[CCode (has_construct_function = false, type = "GooCanvasItemModel*")]
		public CanvasEllipseModel (Goo.CanvasItemModel? parent, double center_x, double center_y, double radius_x, double radius_y, ...);
		[NoAccessorMethod]
		public double center_x { get; set; }
		[NoAccessorMethod]
		public double center_y { get; set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public double radius_x { get; set; }
		[NoAccessorMethod]
		public double radius_y { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_grid_get_type ()")]
	public class CanvasGrid : Goo.CanvasItemSimple, Goo.CanvasItem {
		public Goo.CanvasGridData? grid_data;
		[CCode (has_construct_function = false, type = "GooCanvasItem*")]
		public CanvasGrid (Goo.CanvasItem? parent, double x, double y, double width, double height, double x_step, double y_step, double x_offset, double y_offset, ...);
		[NoAccessorMethod]
		public string border_color { set; }
		[NoAccessorMethod]
		[Version (since = "2.0.1")]
		public Gdk.RGBA border_color_gdk_rgba { owned get; set; }
		[NoAccessorMethod]
		public uint border_color_rgba { get; set; }
		[NoAccessorMethod]
		public Cairo.Pattern? border_pattern { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Pixbuf border_pixbuf { set; }
		[NoAccessorMethod]
		public double border_width { get; set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public string horz_grid_line_color { set; }
		[NoAccessorMethod]
		[Version (since = "2.0.1")]
		public Gdk.RGBA horz_grid_line_color_gdk_rgba { owned get; set; }
		[NoAccessorMethod]
		public uint horz_grid_line_color_rgba { get; set; }
		[NoAccessorMethod]
		public Cairo.Pattern? horz_grid_line_pattern { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Pixbuf horz_grid_line_pixbuf { set; }
		[NoAccessorMethod]
		public double horz_grid_line_width { get; set; }
		[NoAccessorMethod]
		public bool show_horz_grid_lines { get; set; }
		[NoAccessorMethod]
		public bool show_vert_grid_lines { get; set; }
		[NoAccessorMethod]
		public string vert_grid_line_color { set; }
		[NoAccessorMethod]
		[Version (since = "2.0.1")]
		public Gdk.RGBA vert_grid_line_color_gdk_rgba { owned get; set; }
		[NoAccessorMethod]
		public uint vert_grid_line_color_rgba { get; set; }
		[NoAccessorMethod]
		public Cairo.Pattern? vert_grid_line_pattern { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Pixbuf vert_grid_line_pixbuf { set; }
		[NoAccessorMethod]
		public double vert_grid_line_width { get; set; }
		[NoAccessorMethod]
		public bool vert_grid_lines_on_top { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double x_offset { get; set; }
		[NoAccessorMethod]
		public double x_step { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
		[NoAccessorMethod]
		public double y_offset { get; set; }
		[NoAccessorMethod]
		public double y_step { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_grid_model_get_type ()")]
	public class CanvasGridModel : Goo.CanvasItemModelSimple, Goo.CanvasItemModel {
		public Goo.CanvasGridData grid_data;
		[CCode (has_construct_function = false, type = "GooCanvasItemModel*")]
		public CanvasGridModel (Goo.CanvasItemModel? parent, double x, double y, double width, double height, double x_step, double y_step, double x_offset, double y_offset, ...);
		[NoAccessorMethod]
		public string border_color { set; }
		[NoAccessorMethod]
		public Gdk.RGBA border_color_gdk_rgba { owned get; set; }
		[NoAccessorMethod]
		public uint border_color_rgba { get; set; }
		[NoAccessorMethod]
		public Cairo.Pattern? border_pattern { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Pixbuf border_pixbuf { set; }
		[NoAccessorMethod]
		public double border_width { get; set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public string horz_grid_line_color { set; }
		[NoAccessorMethod]
		public Gdk.RGBA horz_grid_line_color_gdk_rgba { owned get; set; }
		[NoAccessorMethod]
		public uint horz_grid_line_color_rgba { get; set; }
		[NoAccessorMethod]
		public Cairo.Pattern? horz_grid_line_pattern { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Pixbuf horz_grid_line_pixbuf { set; }
		[NoAccessorMethod]
		public double horz_grid_line_width { get; set; }
		[NoAccessorMethod]
		public bool show_horz_grid_lines { get; set; }
		[NoAccessorMethod]
		public bool show_vert_grid_lines { get; set; }
		[NoAccessorMethod]
		public string vert_grid_line_color { set; }
		[NoAccessorMethod]
		public Gdk.RGBA vert_grid_line_color_gdk_rgba { owned get; set; }
		[NoAccessorMethod]
		public uint vert_grid_line_color_rgba { get; set; }
		[NoAccessorMethod]
		public Cairo.Pattern? vert_grid_line_pattern { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Pixbuf vert_grid_line_pixbuf { set; }
		[NoAccessorMethod]
		public double vert_grid_line_width { get; set; }
		[NoAccessorMethod]
		public bool vert_grid_lines_on_top { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double x_offset { get; set; }
		[NoAccessorMethod]
		public double x_step { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
		[NoAccessorMethod]
		public double y_offset { get; set; }
		[NoAccessorMethod]
		public double y_step { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_group_get_type ()")]
	public class CanvasGroup : Goo.CanvasItemSimple, Goo.CanvasItem {
		public weak GLib.GenericArray<void*> items;
		[CCode (has_construct_function = false, type = "GooCanvasItem*")]
		public CanvasGroup (Goo.CanvasItem? parent, ...);
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_group_model_get_type ()")]
	public class CanvasGroupModel : Goo.CanvasItemModelSimple, Goo.CanvasItemModel {
		public weak GLib.GenericArray<void*> children;
		[CCode (has_construct_function = false, type = "GooCanvasItemModel*")]
		public CanvasGroupModel (Goo.CanvasItemModel? parent, ...);
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_image_get_type ()")]
	public class CanvasImage : Goo.CanvasItemSimple, Goo.CanvasItem {
		public Goo.CanvasImageData? image_data;
		[CCode (has_construct_function = false, type = "GooCanvasItem*")]
		public CanvasImage (Goo.CanvasItem? parent, Gdk.Pixbuf? pixbuf, double x, double y, ...);
		[NoAccessorMethod]
		public double alpha { get; set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public Cairo.Pattern? pattern { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Pixbuf pixbuf { set; }
		[NoAccessorMethod]
		public bool scale_to_fit { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_image_model_get_type ()")]
	public class CanvasImageModel : Goo.CanvasItemModelSimple, Goo.CanvasItemModel {
		public Goo.CanvasImageData image_data;
		[CCode (has_construct_function = false, type = "GooCanvasItemModel*")]
		public CanvasImageModel (Goo.CanvasItemModel? parent, Gdk.Pixbuf? pixbuf, double x, double y, ...);
		[NoAccessorMethod]
		public double alpha { get; set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public Cairo.Pattern? pattern { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Pixbuf pixbuf { set; }
		[NoAccessorMethod]
		public bool scale_to_fit { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_item_accessible_factory_get_type ()")]
	public class CanvasItemAccessibleFactory : Atk.ObjectFactory {
		[CCode (has_construct_function = false)]
		protected CanvasItemAccessibleFactory ();
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_item_model_simple_get_type ()")]
	public class CanvasItemModelSimple : GLib.Object, Goo.CanvasItemModel {
		public weak string description;
		public weak Goo.CanvasItemModel parent;
		public Goo.CanvasItemSimpleData simple_data;
		public weak string title;
		[CCode (has_construct_function = false)]
		protected CanvasItemModelSimple ();
		[NoAccessorMethod]
		public Goo.CairoAntialias antialias { get; set; }
		[NoAccessorMethod]
		public Goo.CairoFillRule clip_fill_rule { get; set; }
		[NoAccessorMethod]
		public string clip_path { set; }
		[NoAccessorMethod]
		public string fill_color { set; }
		[NoAccessorMethod]
		public Gdk.RGBA fill_color_gdk_rgba { owned get; set; }
		[NoAccessorMethod]
		public uint fill_color_rgba { get; set; }
		[NoAccessorMethod]
		public Cairo.Pattern? fill_pattern { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Pixbuf fill_pixbuf { set; }
		[NoAccessorMethod]
		public Goo.CairoFillRule fill_rule { get; set; }
		[NoAccessorMethod]
		public string font { owned get; set; }
		[NoAccessorMethod]
		public Pango.FontDescription font_desc { owned get; set; }
		[NoAccessorMethod]
		public Goo.CairoHintMetrics hint_metrics { get; set; }
		[NoAccessorMethod]
		public Goo.CairoLineCap line_cap { get; set; }
		[NoAccessorMethod]
		public Goo.CanvasLineDash line_dash { owned get; set; }
		[NoAccessorMethod]
		public Goo.CairoLineJoin line_join { get; set; }
		[NoAccessorMethod]
		public double line_join_miter_limit { get; set; }
		[NoAccessorMethod]
		public double line_width { get; set; }
		[NoAccessorMethod]
		public Goo.CairoOperator operator { get; set; }
		[NoAccessorMethod]
		public string stroke_color { set; }
		[NoAccessorMethod]
		public Gdk.RGBA stroke_color_gdk_rgba { owned get; set; }
		[NoAccessorMethod]
		public uint stroke_color_rgba { get; set; }
		[NoAccessorMethod]
		public Cairo.Pattern? stroke_pattern { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Pixbuf stroke_pixbuf { set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_item_simple_get_type ()")]
	public class CanvasItemSimple : GLib.Object, Goo.CanvasItem {
		public Goo.CanvasBounds bounds;
		public weak Goo.Canvas canvas;
		public weak Goo.CanvasItemModelSimple model;
		public uint need_entire_subtree_update;
		public uint need_update;
		public weak Goo.CanvasItem parent;
		public Goo.CanvasItemSimpleData? simple_data;
		[CCode (has_construct_function = false)]
		protected CanvasItemSimple ();
		public void changed (bool recompute_bounds);
		public bool check_in_path (double x, double y, Cairo.Context cr, Goo.CanvasPointerEvents pointer_events);
		public void check_style ();
		public double get_line_width ();
		public void get_path_bounds (Cairo.Context cr, out Goo.CanvasBounds bounds);
		public void paint_path (Cairo.Context cr);
		[NoWrapper]
		public virtual void simple_create_path (Cairo.Context cr);
		[NoWrapper]
		public virtual bool simple_is_item_at (double x, double y, Cairo.Context cr, bool is_pointer_event);
		[NoWrapper]
		public virtual void simple_paint (Cairo.Context cr, Goo.CanvasBounds bounds);
		[NoWrapper]
		public virtual void simple_update (Cairo.Context cr);
		public void user_bounds_to_device (Cairo.Context cr, Goo.CanvasBounds bounds);
		public void user_bounds_to_parent (Cairo.Context cr, Goo.CanvasBounds bounds);
		[NoAccessorMethod]
		public Goo.CairoAntialias antialias { get; set; }
		[NoAccessorMethod]
		public Goo.CairoFillRule clip_fill_rule { get; set; }
		[NoAccessorMethod]
		public string clip_path { set; }
		[NoAccessorMethod]
		public string fill_color { set; }
		[NoAccessorMethod]
		[Version (since = "2.0.1")]
		public Gdk.RGBA fill_color_gdk_rgba { owned get; set; }
		[NoAccessorMethod]
		public uint fill_color_rgba { get; set; }
		[NoAccessorMethod]
		public Cairo.Pattern? fill_pattern { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Pixbuf fill_pixbuf { set; }
		[NoAccessorMethod]
		public Goo.CairoFillRule fill_rule { get; set; }
		[NoAccessorMethod]
		public string font { owned get; set; }
		[NoAccessorMethod]
		public Pango.FontDescription font_desc { owned get; set; }
		[NoAccessorMethod]
		public Goo.CairoHintMetrics hint_metrics { get; set; }
		[NoAccessorMethod]
		public Goo.CairoLineCap line_cap { get; set; }
		[NoAccessorMethod]
		public Goo.CanvasLineDash line_dash { owned get; set; }
		[NoAccessorMethod]
		public Goo.CairoLineJoin line_join { get; set; }
		[NoAccessorMethod]
		public double line_join_miter_limit { get; set; }
		[NoAccessorMethod]
		public double line_width { get; set; }
		[NoAccessorMethod]
		public Goo.CairoOperator operator { get; set; }
		[NoAccessorMethod]
		public string stroke_color { set; }
		[NoAccessorMethod]
		[Version (since = "2.0.1")]
		public Gdk.RGBA stroke_color_gdk_rgba { owned get; set; }
		[NoAccessorMethod]
		public uint stroke_color_rgba { get; set; }
		[NoAccessorMethod]
		public Cairo.Pattern? stroke_pattern { owned get; set; }
		[NoAccessorMethod]
		public Gdk.Pixbuf stroke_pixbuf { set; }
	}
	[CCode (cheader_filename = "goocanvas.h", ref_function = "goo_canvas_line_dash_ref", type_id = "goo_canvas_line_dash_get_type ()", unref_function = "goo_canvas_line_dash_unref")]
	[Compact]
	public class CanvasLineDash {
		public double dash_offset;
		[CCode (array_length_cname = "num_dashes")]
		public double[] dashes;
		public int num_dashes;
		public int ref_count;
		[CCode (has_construct_function = false)]
		public CanvasLineDash (int num_dashes, ...);
		[CCode (cname = "goo_canvas_line_dash_newv", has_construct_function = false)]
		public CanvasLineDash.newv ([CCode (array_length_cname = "num_dashes", array_length_pos = 0.5)] owned double[] dashes);
		public Goo.CanvasLineDash @ref ();
		[Version (since = "2.0.2")]
		public void set_offset (double dash_offset);
		public void unref ();
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_path_get_type ()")]
	public class CanvasPath : Goo.CanvasItemSimple, Goo.CanvasItem {
		public Goo.CanvasPathData? path_data;
		[CCode (has_construct_function = false, type = "GooCanvasItem*")]
		public CanvasPath (Goo.CanvasItem? parent, string path_data, ...);
		[NoAccessorMethod]
		public string data { set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_path_model_get_type ()")]
	public class CanvasPathModel : Goo.CanvasItemModelSimple, Goo.CanvasItemModel {
		public Goo.CanvasPathData path_data;
		[CCode (has_construct_function = false, type = "GooCanvasItemModel*")]
		public CanvasPathModel (Goo.CanvasItemModel? parent, string path_data, ...);
		[NoAccessorMethod]
		public string data { set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", ref_function = "goo_canvas_points_ref", type_id = "goo_canvas_points_get_type ()", unref_function = "goo_canvas_points_unref")]
	[Compact]
	public class CanvasPoints {
		[CCode (array_length_cname = "num_points")]
		public double[] coords;
		public int num_points;
		public int ref_count;
		[CCode (has_construct_function = false)]
		public CanvasPoints (int num_points);
		[Version (since = "2.0.1")]
		public void get_point (int idx, out double x, out double y);
		public Goo.CanvasPoints @ref ();
		[Version (since = "2.0.1")]
		public void set_point (int idx, double x, double y);
		public void unref ();
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_polyline_get_type ()")]
	public class CanvasPolyline : Goo.CanvasItemSimple, Goo.CanvasItem {
		public Goo.CanvasPolylineData? polyline_data;
		[CCode (has_construct_function = false, type = "GooCanvasItem*")]
		public CanvasPolyline (Goo.CanvasItem? parent, bool close_path, int num_points, ...);
		[CCode (has_construct_function = false, type = "GooCanvasItem*")]
		public CanvasPolyline.line (Goo.CanvasItem? parent, double x1, double y1, double x2, double y2, ...);
		[NoAccessorMethod]
		public double arrow_length { get; set; }
		[NoAccessorMethod]
		public double arrow_tip_length { get; set; }
		[NoAccessorMethod]
		public double arrow_width { get; set; }
		[NoAccessorMethod]
		public bool close_path { get; set; }
		[NoAccessorMethod]
		public bool end_arrow { get; set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public Goo.CanvasPoints points { owned get; set; }
		[NoAccessorMethod]
		public bool start_arrow { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_polyline_model_get_type ()")]
	public class CanvasPolylineModel : Goo.CanvasItemModelSimple, Goo.CanvasItemModel {
		public Goo.CanvasPolylineData polyline_data;
		[CCode (has_construct_function = false, type = "GooCanvasItemModel*")]
		public CanvasPolylineModel (Goo.CanvasItemModel? parent, bool close_path, int num_points, ...);
		[CCode (has_construct_function = false, type = "GooCanvasItemModel*")]
		public CanvasPolylineModel.line (Goo.CanvasItemModel? parent, double x1, double y1, double x2, double y2, ...);
		[NoAccessorMethod]
		public double arrow_length { get; set; }
		[NoAccessorMethod]
		public double arrow_tip_length { get; set; }
		[NoAccessorMethod]
		public double arrow_width { get; set; }
		[NoAccessorMethod]
		public bool close_path { get; set; }
		[NoAccessorMethod]
		public bool end_arrow { get; set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public Goo.CanvasPoints points { owned get; set; }
		[NoAccessorMethod]
		public bool start_arrow { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_rect_get_type ()")]
	public class CanvasRect : Goo.CanvasItemSimple, Goo.CanvasItem {
		public Goo.CanvasRectData? rect_data;
		[CCode (has_construct_function = false, type = "GooCanvasItem*")]
		public CanvasRect (Goo.CanvasItem? parent, double x, double y, double width, double height, ...);
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public double radius_x { get; set; }
		[NoAccessorMethod]
		public double radius_y { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_rect_model_get_type ()")]
	public class CanvasRectModel : Goo.CanvasItemModelSimple, Goo.CanvasItemModel {
		public Goo.CanvasRectData rect_data;
		[CCode (has_construct_function = false, type = "GooCanvasItemModel*")]
		public CanvasRectModel (Goo.CanvasItemModel? parent, double x, double y, double width, double height, ...);
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public double radius_x { get; set; }
		[NoAccessorMethod]
		public double radius_y { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_style_get_type ()")]
	public class CanvasStyle : GLib.Object {
		public weak Goo.CanvasStyle parent;
		public weak GLib.Array<void*> properties;
		[CCode (has_construct_function = false)]
		public CanvasStyle ();
		public Goo.CanvasStyle copy ();
		public unowned Goo.CanvasStyle get_parent ();
		public GLib.Value? get_property (GLib.Quark property_id);
		public bool set_fill_options (Cairo.Context cr);
		public void set_parent (Goo.CanvasStyle parent);
		public void set_property (GLib.Quark property_id, GLib.Value value);
		public bool set_stroke_options (Cairo.Context cr);
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_table_get_type ()")]
	public class CanvasTable : Goo.CanvasGroup, Goo.CanvasItem {
		public Goo.CanvasTableData? table_data;
		[CCode (has_construct_function = false, type = "GooCanvasItem*")]
		public CanvasTable (Goo.CanvasItem? parent, ...);
		[NoAccessorMethod]
		public double column_spacing { get; set; }
		[NoAccessorMethod]
		public bool homogeneous_columns { get; set; }
		[NoAccessorMethod]
		public bool homogeneous_rows { get; set; }
		[NoAccessorMethod]
		public double horz_grid_line_width { get; set; }
		[NoAccessorMethod]
		public double row_spacing { get; set; }
		[NoAccessorMethod]
		public double vert_grid_line_width { get; set; }
		[NoAccessorMethod]
		public double x_border_spacing { get; set; }
		[NoAccessorMethod]
		public double y_border_spacing { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	[Compact]
	public class CanvasTableLayoutData {
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_table_model_get_type ()")]
	public class CanvasTableModel : Goo.CanvasGroupModel, Goo.CanvasItemModel {
		public Goo.CanvasTableData table_data;
		[CCode (has_construct_function = false, type = "GooCanvasItemModel*")]
		public CanvasTableModel (Goo.CanvasItemModel? parent, ...);
		[NoAccessorMethod]
		public double column_spacing { get; set; }
		[NoAccessorMethod]
		public bool homogeneous_columns { get; set; }
		[NoAccessorMethod]
		public bool homogeneous_rows { get; set; }
		[NoAccessorMethod]
		public double horz_grid_line_width { get; set; }
		[NoAccessorMethod]
		public double row_spacing { get; set; }
		[NoAccessorMethod]
		public double vert_grid_line_width { get; set; }
		[NoAccessorMethod]
		public double x_border_spacing { get; set; }
		[NoAccessorMethod]
		public double y_border_spacing { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_text_get_type ()")]
	public class CanvasText : Goo.CanvasItemSimple, Goo.CanvasItem {
		public double layout_width;
		public Goo.CanvasTextData? text_data;
		[CCode (has_construct_function = false, type = "GooCanvasItem*")]
		public CanvasText (Goo.CanvasItem? parent, string string, double x, double y, double width, Goo.CanvasAnchorType anchor, ...);
		public void get_natural_extents (out Pango.Rectangle ink_rect, out Pango.Rectangle logical_rect);
		[NoAccessorMethod]
		public Pango.Alignment alignment { get; set; }
		[NoAccessorMethod]
		public Goo.CanvasAnchorType anchor { get; set; }
		[NoAccessorMethod]
		public Pango.EllipsizeMode ellipsize { get; set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public string text { owned get; set; }
		[NoAccessorMethod]
		public bool use_markup { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public Pango.WrapMode wrap { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_text_model_get_type ()")]
	public class CanvasTextModel : Goo.CanvasItemModelSimple, Goo.CanvasItemModel {
		public Goo.CanvasTextData text_data;
		[CCode (has_construct_function = false, type = "GooCanvasItemModel*")]
		public CanvasTextModel (Goo.CanvasItemModel? parent, string string, double x, double y, double width, Goo.CanvasAnchorType anchor, ...);
		[NoAccessorMethod]
		public Pango.Alignment alignment { get; set; }
		[NoAccessorMethod]
		public Goo.CanvasAnchorType anchor { get; set; }
		[NoAccessorMethod]
		public Pango.EllipsizeMode ellipsize { get; set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public string text { owned get; set; }
		[NoAccessorMethod]
		public bool use_markup { get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public Pango.WrapMode wrap { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_widget_get_type ()")]
	public class CanvasWidget : Goo.CanvasItemSimple, Goo.CanvasItem {
		[CCode (has_construct_function = false, type = "GooCanvasItem*")]
		public CanvasWidget (Goo.CanvasItem? parent, Gtk.Widget widget, double x, double y, double width, double height, ...);
		[NoAccessorMethod]
		public Goo.CanvasAnchorType anchor { get; set; }
		[NoAccessorMethod]
		public double height { get; set; }
		[NoAccessorMethod]
		public Gtk.Widget widget { owned get; set; }
		[NoAccessorMethod]
		public double width { get; set; }
		[NoAccessorMethod]
		public double x { get; set; }
		[NoAccessorMethod]
		public double y { get; set; }
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_widget_accessible_factory_get_type ()")]
	public class CanvasWidgetAccessibleFactory : Atk.ObjectFactory {
		[CCode (has_construct_function = false)]
		protected CanvasWidgetAccessibleFactory ();
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_item_get_type ()")]
	public interface CanvasItem : GLib.Object {
		public abstract void add_child (Goo.CanvasItem child, int position);
		public abstract void allocate_area (Cairo.Context cr, Goo.CanvasBounds requested_area, Goo.CanvasBounds allocated_area, double x_offset, double y_offset);
		public void animate (double x, double y, double scale, double degrees, bool absolute, int duration, int step_time, Goo.CanvasAnimateType type);
		public static unowned GLib.ParamSpec class_find_child_property (GLib.ObjectClass iclass, string property_name);
		public static void class_install_child_property (GLib.ObjectClass iclass, uint property_id, GLib.ParamSpec pspec);
		[CCode (array_length_pos = 1.1, array_length_type = "guint")]
		public static (unowned GLib.ParamSpec)[] class_list_child_properties (GLib.ObjectClass iclass);
		public void ensure_updated ();
		public int find_child (Goo.CanvasItem child);
		public abstract void get_bounds (out Goo.CanvasBounds bounds);
		public abstract unowned Goo.Canvas get_canvas ();
		public abstract unowned Goo.CanvasItem get_child (int child_num);
		public void get_child_properties (Goo.CanvasItem child, ...);
		public void get_child_properties_valist (Goo.CanvasItem child, va_list var_args);
		[NoWrapper]
		public abstract void get_child_property (Goo.CanvasItem child, uint property_id, GLib.Value value, GLib.ParamSpec pspec);
		public abstract bool get_is_static ();
		public abstract unowned GLib.List<Goo.CanvasItem> get_items_at (double x, double y, Cairo.Context cr, bool is_pointer_event, bool parent_is_visible, GLib.List<Goo.CanvasItem> found_items);
		public abstract unowned Goo.CanvasItemModel get_model ();
		public abstract int get_n_children ();
		public abstract unowned Goo.CanvasItem get_parent ();
		public abstract bool get_requested_area (Cairo.Context cr, Goo.CanvasBounds requested_area);
		[Version (since = "2.0.1")]
		public abstract bool get_requested_area_for_width (Cairo.Context cr, double width, Goo.CanvasBounds requested_area);
		public abstract double get_requested_height (Cairo.Context cr, double width);
		public bool get_simple_transform (out double x, out double y, out double scale, out double rotation);
		public abstract unowned Goo.CanvasStyle get_style ();
		public abstract bool get_transform (out Cairo.Matrix transform);
		public abstract bool get_transform_for_child (Goo.CanvasItem child, out Cairo.Matrix transform);
		public bool is_container ();
		public abstract bool is_visible ();
		public void lower (Goo.CanvasItem? below);
		public abstract void move_child (int old_position, int new_position);
		public abstract void paint (Cairo.Context cr, Goo.CanvasBounds bounds, double scale);
		public void raise (Goo.CanvasItem? above);
		public void remove ();
		public abstract void remove_child (int child_num);
		public abstract void request_update ();
		public void rotate (double degrees, double cx, double cy);
		public void scale (double sx, double sy);
		public abstract void set_canvas (Goo.Canvas canvas);
		public void set_child_properties (Goo.CanvasItem child, ...);
		public void set_child_properties_valist (Goo.CanvasItem child, va_list var_args);
		[NoWrapper]
		public abstract void set_child_property (Goo.CanvasItem child, uint property_id, GLib.Value value, GLib.ParamSpec pspec);
		public abstract void set_is_static (bool is_static);
		public abstract void set_model (Goo.CanvasItemModel model);
		public abstract void set_parent (Goo.CanvasItem parent);
		public void set_simple_transform (double x, double y, double scale, double rotation);
		public abstract void set_style (Goo.CanvasStyle style);
		public abstract void set_transform (Cairo.Matrix? transform);
		public void skew_x (double degrees, double cx, double cy);
		public void skew_y (double degrees, double cx, double cy);
		public void stop_animation ();
		public void translate (double tx, double ty);
		public abstract void update (bool entire_tree, Cairo.Context cr, Goo.CanvasBounds bounds);
		[NoAccessorMethod]
		public abstract bool can_focus { get; set; }
		[NoAccessorMethod]
		public abstract string description { owned get; set; }
		public abstract Goo.CanvasItem parent { get; set; }
		[NoAccessorMethod]
		public abstract Goo.CanvasPointerEvents pointer_events { get; set; }
		[NoAccessorMethod]
		public abstract string title { owned get; set; }
		[NoAccessorMethod]
		public abstract string tooltip { owned get; set; }
		[NoAccessorMethod]
		public abstract Cairo.Matrix? transform { owned get; set; }
		[NoAccessorMethod]
		public abstract Goo.CanvasItemVisibility visibility { get; set; }
		[NoAccessorMethod]
		public abstract double visibility_threshold { get; set; }
		public virtual signal void animation_finished (bool stopped);
		public virtual signal bool button_press_event (Goo.CanvasItem target, Gdk.EventButton event);
		public virtual signal bool button_release_event (Goo.CanvasItem target, Gdk.EventButton event);
		public virtual signal void child_notify (GLib.ParamSpec pspec);
		public virtual signal bool enter_notify_event (Goo.CanvasItem target, Gdk.EventCrossing event);
		public virtual signal bool focus_in_event (Goo.CanvasItem target, Gdk.EventFocus event);
		public virtual signal bool focus_out_event (Goo.CanvasItem target, Gdk.EventFocus event);
		public virtual signal bool grab_broken_event (Goo.CanvasItem target, Gdk.EventGrabBroken event);
		public virtual signal bool key_press_event (Goo.CanvasItem target, Gdk.EventKey event);
		public virtual signal bool key_release_event (Goo.CanvasItem target, Gdk.EventKey event);
		public virtual signal bool leave_notify_event (Goo.CanvasItem target, Gdk.EventCrossing event);
		public virtual signal bool motion_notify_event (Goo.CanvasItem target, Gdk.EventMotion event);
		public virtual signal bool query_tooltip (double x, double y, bool keyboard_tooltip, Gtk.Tooltip tooltip);
		public virtual signal bool scroll_event (Goo.CanvasItem target, Gdk.EventScroll event);
	}
	[CCode (cheader_filename = "goocanvas.h", type_id = "goo_canvas_item_model_get_type ()")]
	public interface CanvasItemModel : GLib.Object {
		public abstract void add_child (Goo.CanvasItemModel child, int position);
		public void animate (double x, double y, double scale, double degrees, bool absolute, int duration, int step_time, Goo.CanvasAnimateType type);
		public static unowned GLib.ParamSpec class_find_child_property (GLib.ObjectClass mclass, string property_name);
		public static void class_install_child_property (GLib.ObjectClass mclass, uint property_id, GLib.ParamSpec pspec);
		[CCode (array_length_pos = 1.1, array_length_type = "guint")]
		public static (unowned GLib.ParamSpec)[] class_list_child_properties (GLib.ObjectClass mclass);
		[NoWrapper]
		public abstract unowned Goo.CanvasItem create_item (Goo.Canvas canvas);
		public int find_child (Goo.CanvasItemModel child);
		public abstract unowned Goo.CanvasItemModel get_child (int child_num);
		public void get_child_properties (Goo.CanvasItemModel child, ...);
		public void get_child_properties_valist (Goo.CanvasItemModel child, va_list var_args);
		[NoWrapper]
		public abstract void get_child_property (Goo.CanvasItemModel child, uint property_id, GLib.Value value, GLib.ParamSpec pspec);
		public abstract int get_n_children ();
		public abstract unowned Goo.CanvasItemModel get_parent ();
		public bool get_simple_transform (out double x, out double y, out double scale, out double rotation);
		public abstract unowned Goo.CanvasStyle get_style ();
		public abstract bool get_transform (out Cairo.Matrix transform);
		public bool is_container ();
		public void lower (Goo.CanvasItemModel? below);
		public abstract void move_child (int old_position, int new_position);
		public void raise (Goo.CanvasItemModel? above);
		public void remove ();
		public abstract void remove_child (int child_num);
		public void rotate (double degrees, double cx, double cy);
		public void scale (double sx, double sy);
		public void set_child_properties (Goo.CanvasItemModel child, ...);
		public void set_child_properties_valist (Goo.CanvasItemModel child, va_list var_args);
		[NoWrapper]
		public abstract void set_child_property (Goo.CanvasItemModel child, uint property_id, GLib.Value value, GLib.ParamSpec pspec);
		public abstract void set_parent (Goo.CanvasItemModel parent);
		public void set_simple_transform (double x, double y, double scale, double rotation);
		public abstract void set_style (Goo.CanvasStyle style);
		public abstract void set_transform (Cairo.Matrix? transform);
		public void skew_x (double degrees, double cx, double cy);
		public void skew_y (double degrees, double cx, double cy);
		public void stop_animation ();
		public void translate (double tx, double ty);
		[NoAccessorMethod]
		public abstract bool can_focus { get; set; }
		[NoAccessorMethod]
		public abstract string description { owned get; set; }
		public abstract Goo.CanvasItemModel parent { get; set; }
		[NoAccessorMethod]
		public abstract Goo.CanvasPointerEvents pointer_events { get; set; }
		[NoAccessorMethod]
		public abstract string title { owned get; set; }
		[NoAccessorMethod]
		public abstract string tooltip { owned get; set; }
		[NoAccessorMethod]
		public abstract Cairo.Matrix? transform { owned get; set; }
		[NoAccessorMethod]
		public abstract Goo.CanvasItemVisibility visibility { get; set; }
		[NoAccessorMethod]
		public abstract double visibility_threshold { get; set; }
		public virtual signal void animation_finished (bool stopped);
		public virtual signal void changed (bool recompute_bounds);
		public virtual signal void child_added (int child_num);
		public virtual signal void child_moved (int old_child_num, int new_child_num);
		public virtual signal void child_notify (GLib.ParamSpec pspec);
		public virtual signal void child_removed (int child_num);
	}
	[CCode (cheader_filename = "goocanvas.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "goo_canvas_bounds_get_type ()")]
	public struct CanvasBounds {
		public double x1;
		public double y1;
		public double x2;
		public double y2;
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	public struct CanvasEllipseData {
		public double center_x;
		public double center_y;
		public double radius_x;
		public double radius_y;
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	public struct CanvasGridData {
		public double x;
		public double y;
		public double width;
		public double height;
		public double x_step;
		public double y_step;
		public double x_offset;
		public double y_offset;
		public double horz_grid_line_width;
		public double vert_grid_line_width;
		public Cairo.Pattern? horz_grid_line_pattern;
		public Cairo.Pattern? vert_grid_line_pattern;
		public double border_width;
		public Cairo.Pattern? border_pattern;
		public uint show_horz_grid_lines;
		public uint show_vert_grid_lines;
		public uint vert_grid_lines_on_top;
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	public struct CanvasImageData {
		public Cairo.Pattern? pattern;
		public double x;
		public double y;
		public double width;
		public double height;
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	public struct CanvasItemSimpleData {
		public Goo.CanvasStyle style;
		public Cairo.Matrix? transform;
		public GLib.Array<Goo.CanvasPathCommand?> clip_path_commands;
		public string tooltip;
		public double visibility_threshold;
		public uint visibility;
		public uint pointer_events;
		public uint can_focus;
		public uint own_style;
		public uint clip_fill_rule;
		public uint is_static;
		public uint cache_setting;
		public uint has_tooltip;
	}
	[CCode (cheader_filename = "goocanvas.h")]
	public struct CanvasPathCommand {
		[CCode (cname = "simple.type")]
		public uint simple_type;
		[CCode (cname = "simple.relative")]
		public uint simple_relative;
		[CCode (cname = "simple.x")]
		public double simple_x;
		[CCode (cname = "simple.y")]
		public double simple_y;
		[CCode (cname = "curve.type")]
		public uint curve_type;
		[CCode (cname = "curve.relative")]
		public uint curve_relative;
		[CCode (cname = "curve.x")]
		public double curve_x;
		[CCode (cname = "curve.y")]
		public double curve_y;
		[CCode (cname = "curve.x1")]
		public double curve_x1;
		[CCode (cname = "curve.y1")]
		public double curve_y1;
		[CCode (cname = "curve.x2")]
		public double curve_x2;
		[CCode (cname = "curve.y2")]
		public double curve_y2;
		[CCode (cname = "arc.type")]
		public uint arc_type;
		[CCode (cname = "arc.relative")]
		public uint arc_relative;
		[CCode (cname = "arc.large_arc_flag")]
		public uint arc_large_arc_flag;
		[CCode (cname = "arc.sweep_flag")]
		public uint arc_sweep_flag;
		[CCode (cname = "arc.rx")]
		public double arc_rx;
		[CCode (cname = "arc.ry")]
		public double arc_ry;
		[CCode (cname = "arc.x_axis_rotation")]
		public double arc_x_axis_rotation;
		[CCode (cname = "arc.x")]
		public double arc_x;
		[CCode (cname = "arc.y")]
		public double arc_y;
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	public struct CanvasPathData {
		public GLib.Array<Goo.CanvasPathCommand?> path_commands;
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	public struct CanvasPolylineArrowData {
		public double arrow_width;
		public double arrow_length;
		public double arrow_tip_length;
		[CCode (array_length = false)]
		public double line_start[2];
		[CCode (array_length = false)]
		public double line_end[2];
		[CCode (array_length = false)]
		public double start_arrow_coords[10];
		[CCode (array_length = false)]
		public double end_arrow_coords[10];
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	public struct CanvasPolylineData {
		public double coords;
		public Goo.CanvasPolylineArrowData? arrow_data;
		public uint num_points;
		public uint close_path;
		public uint start_arrow;
		public uint end_arrow;
		public uint reconfigure_arrows;
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	public struct CanvasRectData {
		public double x;
		public double y;
		public double width;
		public double height;
		public double radius_x;
		public double radius_y;
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	public struct CanvasStyleProperty {
		public GLib.Quark id;
		public GLib.Value value;
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	public struct CanvasTableData {
		public double width;
		public double height;
		[CCode (array_length = false)]
		public Goo.CanvasTableDimension dimensions[2];
		public double border_width;
		public GLib.Array<void*> children;
		public Goo.CanvasTableLayoutData? layout_data;
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	public struct CanvasTableDimension {
		public int size;
		public double default_spacing;
		public double spacings;
		public uint homogeneous;
	}
	[CCode (cheader_filename = "goocanvas.h", has_type_id = false)]
	public struct CanvasTextData {
		public string text;
		public double x;
		public double y;
		public double width;
		public uint use_markup;
		public uint anchor;
		public uint alignment;
		public uint ellipsize;
		public uint wrap;
	}
	[CCode (cheader_filename = "goocanvas.h", cprefix = "CAIRO_ANTIALIAS_", type_id = "goo_cairo_antialias_get_type ()")]
	public enum CairoAntialias {
		DEFAULT,
		NONE,
		GRAY,
		SUBPIXEL
	}
	[CCode (cheader_filename = "goocanvas.h", cprefix = "CAIRO_FILL_RULE_", type_id = "goo_cairo_fill_rule_get_type ()")]
	public enum CairoFillRule {
		WINDING,
		EVEN_ODD
	}
	[CCode (cheader_filename = "goocanvas.h", cprefix = "CAIRO_HINT_METRICS_", type_id = "goo_cairo_hint_metrics_get_type ()")]
	public enum CairoHintMetrics {
		DEFAULT,
		OFF,
		ON
	}
	[CCode (cheader_filename = "goocanvas.h", cprefix = "CAIRO_LINE_CAP_", type_id = "goo_cairo_line_cap_get_type ()")]
	public enum CairoLineCap {
		BUTT,
		ROUND,
		SQUARE
	}
	[CCode (cheader_filename = "goocanvas.h", cprefix = "CAIRO_LINE_JOIN_", type_id = "goo_cairo_line_join_get_type ()")]
	public enum CairoLineJoin {
		MITER,
		ROUND,
		BEVEL
	}
	[CCode (cheader_filename = "goocanvas.h", cprefix = "CAIRO_OPERATOR_", type_id = "goo_cairo_operator_get_type ()")]
	public enum CairoOperator {
		CLEAR,
		SOURCE,
		OVER,
		IN,
		OUT,
		ATOP,
		DEST,
		DEST_OVER,
		DEST_IN,
		DEST_OUT,
		DEST_ATOP,
		XOR,
		ADD,
		SATURATE
	}
	[CCode (cheader_filename = "goocanvas.h", cprefix = "GOO_CANVAS_ANCHOR_", type_id = "goo_canvas_anchor_type_get_type ()")]
	public enum CanvasAnchorType {
		CENTER,
		NORTH,
		NORTH_WEST,
		NORTH_EAST,
		SOUTH,
		SOUTH_WEST,
		SOUTH_EAST,
		WEST,
		EAST,
		N,
		NW,
		NE,
		S,
		SW,
		SE,
		W,
		E
	}
	[CCode (cheader_filename = "goocanvas.h", cprefix = "GOO_CANVAS_ANIMATE_", type_id = "goo_canvas_animate_type_get_type ()")]
	public enum CanvasAnimateType {
		FREEZE,
		RESET,
		RESTART,
		BOUNCE
	}
	[CCode (cheader_filename = "goocanvas.h", cprefix = "GOO_CANVAS_ITEM_", type_id = "goo_canvas_item_visibility_get_type ()")]
	public enum CanvasItemVisibility {
		HIDDEN,
		INVISIBLE,
		VISIBLE,
		VISIBLE_ABOVE_THRESHOLD
	}
	[CCode (cheader_filename = "goocanvas.h", cprefix = "GOO_CANVAS_PATH_", type_id = "goo_canvas_path_command_type_get_type ()")]
	public enum CanvasPathCommandType {
		MOVE_TO,
		CLOSE_PATH,
		LINE_TO,
		HORIZONTAL_LINE_TO,
		VERTICAL_LINE_TO,
		CURVE_TO,
		SMOOTH_CURVE_TO,
		QUADRATIC_CURVE_TO,
		SMOOTH_QUADRATIC_CURVE_TO,
		ELLIPTICAL_ARC
	}
	[CCode (cheader_filename = "goocanvas.h", cprefix = "GOO_CANVAS_EVENTS_", type_id = "goo_canvas_pointer_events_get_type ()")]
	[Flags]
	public enum CanvasPointerEvents {
		VISIBLE_MASK,
		PAINTED_MASK,
		FILL_MASK,
		STROKE_MASK,
		NONE,
		VISIBLE_PAINTED,
		VISIBLE_FILL,
		VISIBLE_STROKE,
		VISIBLE,
		PAINTED,
		FILL,
		STROKE,
		ALL
	}
	[CCode (cheader_filename = "goocanvas.h", cname = "GOO_CANVAS_POLYLINE_NUM_ARROW_POINTS")]
	public const int NUM_ARROW_POINTS;
}
