/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.schema.PgSequencePrivilege;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PgSequence {
    private String cache;
    private String increment;
    private String maxValue;
    private String minValue;
    private String name;
    private String startWith;
    private boolean cycle;
    private String ownedBy;
    private String comment;
    private final List<PgSequencePrivilege> privileges = new ArrayList<PgSequencePrivilege>();
    private String dataType;

    public PgSequence(String string) {
        this.name = string;
    }

    public void setCache(String string) {
        this.cache = string;
    }

    public String getCache() {
        return this.cache;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getCreationSQL() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("CREATE SEQUENCE ");
        stringBuilder.append(PgDiffUtils.getCreateIfNotExists());
        stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
        if (this.dataType != null) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("\tAS ");
            stringBuilder.append(this.dataType);
        }
        if (this.startWith != null) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("\tSTART WITH ");
            stringBuilder.append(this.startWith);
        }
        if (this.increment != null) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("\tINCREMENT BY ");
            stringBuilder.append(this.increment);
        }
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("\t");
        if (this.maxValue == null) {
            stringBuilder.append("NO MAXVALUE");
        } else {
            stringBuilder.append("MAXVALUE ");
            stringBuilder.append(this.maxValue);
        }
        stringBuilder.append(System.getProperty("line.separator"));
        stringBuilder.append("\t");
        if (this.minValue == null) {
            stringBuilder.append("NO MINVALUE");
        } else {
            stringBuilder.append("MINVALUE ");
            stringBuilder.append(this.minValue);
        }
        if (this.cache != null) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("\tCACHE ");
            stringBuilder.append(this.cache);
        }
        if (this.cycle) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("\tCYCLE");
        }
        stringBuilder.append(';');
        if (this.comment != null && !this.comment.isEmpty()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("COMMENT ON SEQUENCE ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
            stringBuilder.append(" IS ");
            stringBuilder.append(this.comment);
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public String getOwnedBySQL() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("ALTER SEQUENCE ");
        stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
        if (this.ownedBy != null && !this.ownedBy.isEmpty()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("\tOWNED BY ");
            stringBuilder.append(this.ownedBy);
        }
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    public void setCycle(boolean bl) {
        this.cycle = bl;
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public String getDropSQL() {
        return "DROP SEQUENCE " + PgDiffUtils.getDropIfExists() + PgDiffUtils.getQuotedName(this.getName()) + ";";
    }

    public void setIncrement(String string) {
        this.increment = string;
    }

    public String getIncrement() {
        return this.increment;
    }

    public void setMaxValue(String string) {
        this.maxValue = string;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(String string) {
        this.minValue = string;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setStartWith(String string) {
        this.startWith = string;
    }

    public String getStartWith() {
        return this.startWith;
    }

    public String getOwnedBy() {
        return this.ownedBy;
    }

    public void setOwnedBy(String string) {
        this.ownedBy = string;
    }

    public List<PgSequencePrivilege> getPrivileges() {
        return Collections.unmodifiableList(this.privileges);
    }

    public PgSequencePrivilege getPrivilege(String string) {
        for (PgSequencePrivilege pgSequencePrivilege : this.privileges) {
            if (!pgSequencePrivilege.getRoleName().equals(string)) continue;
            return pgSequencePrivilege;
        }
        return null;
    }

    public void addPrivilege(PgSequencePrivilege pgSequencePrivilege) {
        this.privileges.add(pgSequencePrivilege);
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }
}

