/*/**
* \file adrv9025_arm_error_mapping.h
* \brief Contains ARM error tables
*
* \note This file was autogenerated. DO NOT MODIFY.
*
* ADRV9025 API Version: 6.4.0.14
*/

/**
* Copyright 2015 - 2022 Analog Devices Inc.
* Released under the ADRV9025 API license, for more information
* see the "LICENSE.pdf" file in this zip file.
*/

#ifndef _ADRV9025_ARM_ERROR_MAPPING_H_
#define _ADRV9025_ARM_ERROR_MAPPING_H_

#ifdef __cplusplus
extern "C" {
#endif

/* The firmware revision required for this API */
#define ADRV9025_ERROR_TABLE_EXPECTED_FW_MAJOR_REV 6u
#define ADRV9025_ERROR_TABLE_EXPECTED_FW_MINOR_REV 4u
#define ADRV9025_ERROR_TABLE_EXPECTED_FW_MAINT_REV 0u
#define ADRV9025_ERROR_TABLE_EXPECTED_FW_BUILD_NUM 6u

typedef struct adrv9025_arm_api_error
{
    const uint32_t errcode;
    const char* const errstr;
} adrv9025_arm_api_error_t;

const adrv9025_arm_api_error_t adrv9025_error_table_ArmBootStatus[] =
{
    { 0UL, "Used to put API in wait for ARM state" },
    { 1UL, "ARM booted with no failure" },
    { 2UL, "ARM Firmware checksum error" },
    { 3UL, "ARM data memory error" },
    { 4UL, "Stream image checksum error" },
    { 5UL, "Device profile checksum error" },
    { 6UL, "Bootup clkgen setup error" },
    { 7UL, "Bootup Jesd setup error" },
    { 8UL, "Power init setup error" },
    { 9UL, "Jtag build status ready indication" },
    { 10UL, "Bootup clock LOGEN error" },
    { 11UL, "Error initializing RxQEC hardware" },
    { 12UL, "Failed to create Health monitor timers" },
    { 13UL, "ADC RCAL error" },
    { 14UL, "Stream Run error" },
    { 15UL, "Bootup clkgen setup after RCAL error" },
    { 16UL, "LDO configured incorrectly" },
    { 17UL, "Invalid Efuse Channel Config Error" },
    { 18UL, "ARM-D booted with no failure" },
    { 19UL, "ARM-D Firmware checksum error" },
    { 20UL, "ARM-D did not boot, unknown reason" }
};

const adrv9025_arm_api_error_t adrv9025_error_table_CmdCtrlMboxCmdError[] =
{
    { 0UL, "No Error" },
    { 1UL, "Nested Mailbox command" },
    { 2UL, "Command not supported" },
    { 3UL, "Invalid state" },
    { 4UL, "Timed out waiting on busy bit" },
    { 5UL, "Timed out waiting on status bit" },
    { 6UL, "Reserved 3" },
    { 7UL, "Command error" }
};

const adrv9025_arm_api_error_t adrv9025_error_table_ErrorCode[] =
{
    { 0x0000UL, "No Error" },
    { 0x0001UL, "TXBBF:TX is disabled" },
    { 0x0002UL, "TXBBF:Calibration timed-out" },
    { 0x0003UL, "TXBBF:Calibration results are invalid" },
    { 0x0004UL, "TXBBF:PFIR Set/Read verification failed" },
    { 0x0005UL, "TXBBF:DAC Image capacitor estimate too high" },
    { 0x0006UL, "TXBBF:DAC Image capacitor estimate too low" },
    { 0x0007UL, "TXBBF:DAC Image capacitor estimate above maximum" },
    { 0x0008UL, "TXBBF:Control command not supported" },
    { 0x0009UL, "TXBBF:Invalid filter frequency." },
    { 0x0101UL, "ADCTuner:Calibration Timed-out" },
    { 0x0102UL, "ADCTuner:Invalid channel" },
    { 0x0103UL, "ADCTuner:Self-Test Error" },
    { 0x0104UL, "ADCTuner:Param Profile Select Error" },
    { 0x0201UL, "TIARx:CAL aborted" },
    { 0x0202UL, "TIARx:No solution for RX" },
    { 0x0203UL, "TIARx:RX Stream error" },
    { 0x0204UL, "TIARx:Cal tone error" },
    { 0x0205UL, "TIARx:Control command not supported" },
    { 0x0206UL, "TIARx:Flatness error for RX" },
    { 0x0207UL, "TIARx:Sig Present error for RX" },
    { 0x0208UL, "TIARx:ADC Cal Not run error for RX" },
    { 0x0301UL, "TIAORx:CAL aborted" },
    { 0x0302UL, "TIAORx:No solution for ORX" },
    { 0x0303UL, "TIAORx:ORX Stream error" },
    { 0x0304UL, "TIAORx:Cal tone error" },
    { 0x0305UL, "TIAORx:Control command not supported" },
    { 0x0306UL, "TIAORx:Flatness error for ORX" },
    { 0x0307UL, "TIAORx:Sig Present error for ORX" },
    { 0x0308UL, "TIAORx:ADC Cal Not run error for ORX" },
    { 0x0401UL, "TIALBRx:CAL aborted" },
    { 0x0402UL, "TIALBRx:No solution for LBRX" },
    { 0x0403UL, "TIALBRx:LBRX Stream error" },
    { 0x0404UL, "TIALBRx:Cal tone error" },
    { 0x0405UL, "TIALBRx:Control command not supported" },
    { 0x0406UL, "TIALBRx:Flatness error for LBRX" },
    { 0x0407UL, "TIALBRx:Sig Present error for LBRX" },
    { 0x0408UL, "TIALBRx:ADC Cal Not run error for LBRX" },
    { 0x0501UL, "DCOffsetRx:Calibration timed out" },
    { 0x0502UL, "DCOffsetRx:RXON HI stream errored out" },
    { 0x0503UL, "DCOffsetRx:RXON LOW stream errored out" },
    { 0x0504UL, "DCOffsetRx:Undefined API function called" },
    { 0x0601UL, "DCOffsetORx:Calibration timed out" },
    { 0x0602UL, "DCOffsetORx:ORXON HI stream errored out" },
    { 0x0603UL, "DCOffsetORx:ORXON LOW stream errored out" },
    { 0x0604UL, "DCOffsetORx:Undefined API function called" },
    { 0x0701UL, "DCOffsetLBRx:Calibration timed out" },
    { 0x0702UL, "DCOffsetLBRx:LBRXON HI stream errored out" },
    { 0x0703UL, "DCOffsetLBRx:LBRXON LOW stream errored out" },
    { 0x0801UL, "FlashCal:Calibration aborted" },
    { 0x0802UL, "FlashCal:Calibration timed-out" },
    { 0x0803UL, "FlashCal:No channel is selected" },
    { 0x0804UL, "FlashCal:Rx is disabled" },
    { 0x0805UL, "FlashCal:ORx is disabled" },
    { 0x0806UL, "FlashCal:Final cal result failed threshold test" },
    { 0x0807UL, "FlashCal:Restored data during warm boot is invalid" },
    { 0x0808UL, "FlashCal:Stream reported an error trying to enable Rx/ORx ADCs" },
    { 0x0901UL, "PathDelay:Did not detect a measurable pathdelay" },
    { 0x0902UL, "PathDelay:Measured TX power is too low" },
    { 0x0903UL, "PathDelay:Measured correlated power too low" },
    { 0x0904UL, "PathDelay:TXQEC pathdelay peak is not strong (bad PFIR?)" },
    { 0x0905UL, "PathDelay:No loopback is enabled for pathdelay" },
    { 0x0A01UL, "TxLOLIntInit:Pathdelay invalid" },
    { 0x0A02UL, "TxLOLIntInit:Data capture timed-out due to HW setup" },
    { 0x0A03UL, "TxLOLIntInit:Batch time too small" },
    { 0x0A04UL, "TxLOLIntInit:Offset LO not enabled" },
    { 0x0A05UL, "TxLOLIntInit:Data capture was aborted" },
    { 0x0A06UL, "TxLOLIntInit:Data capture timed-out" },
    { 0x0A07UL, "TxLOLIntInit:Data capture failed due to channel pause" },
    { 0x0A08UL, "TxLOLIntInit:No data was captured" },
    { 0x0B0AUL, "TxLOLIntInit:Wrong baseband is active" },
    { 0x0B01UL, "TxLOLExtInit:Initial Cal did not run first" },
    { 0x0B02UL, "TxLOLExtInit:Pathdelay invalid" },
    { 0x0B03UL, "TxLOLExtInit:Data capture error due to HW" },
    { 0x0B04UL, "TxLOLExtInit:Batch time too small" },
    { 0x0B05UL, "TxLOLExtInit:Data capture was aborted" },
    { 0x0B06UL, "TxLOLExtInit:Data capture timed-out" },
    { 0x0B07UL, "TxLOLExtInit:No data was captured" },
    { 0x0B08UL, "TxLOLExtInit:No Orx assigned to the TX channel" },
    { 0x0B09UL, "TxLOLExtInit:Orx assigned to the TX channel, is not configured" },
    { 0x0B0AUL, "TxLOLExtInit:Wrong baseband is active" },
    { 0x0C01UL, "TxQECInit:TX is disabled" },
    { 0x0C02UL, "TxQECInit:LBRX is disabled" },
    { 0x0C03UL, "TxQECInit:No pathdelay estimate present" },
    { 0x0C04UL, "TxQECInit:Offset LO not enabled" },
    { 0x0C05UL, "TxQECInit:Channel estimate never reached variance" },
    { 0x0C06UL, "TxQECInit:Channel estimate calculation error" },
    { 0x0C07UL, "TxQECInit:Correlation capture timed-out or was aborted" },
    { 0x0C08UL, "TxQECInit:Correlation capture timed-out or was aborted" },
    { 0x0C09UL, "TxQECInit:Correlation capture error" },
    { 0x0C0AUL, "TxQECInit:Tone measurement error" },
    { 0x0C0BUL, "TxQECInit:No signal present" },
    { 0x0C0CUL, "TxQECInit:Need estimate for coarse change transition point" },
    { 0x0C0DUL, "TxQECInit:Decrementing fine phase, coarse value railed" },
    { 0x0C0EUL, "TxQECInit:Incrementing fine phase, coarse value railed" },
    { 0x0C0FUL, "TxQECInit:Tone measurement saturated error" },
    { 0x0D01UL, "LBRxLODelay:TX is disabled" },
    { 0x0D02UL, "LBRxLODelay:LBRX is disabled" },
    { 0x0D03UL, "LBRxLODelay:PLL setup error" },
    { 0x0D04UL, "LBRxLODelay:Data Capture Error" },
    { 0x0D05UL, "LBRxLODelay:Coarse phase estimate Error" },
    { 0x0D06UL, "LBRxLODelay:Fine phase estimate Error" },
    { 0x0D07UL, "LBRxLODelay:Output phase error too large (self-test)" },
    { 0x0D08UL, "LBRxLODelay:Data Capture Abort Error" },
    { 0x0D09UL, "LBRxLODelay:Loop-back tone signal power too weak" },
    { 0x0E01UL, "LBRxTCAL:LBRX TCAL RxQec3 obs image power error" },
    { 0x0E02UL, "LBRxTCAL:LBRX TCAL RxQec3 obs insufficient power error" },
    { 0x0E03UL, "LBRxTCAL:LBRX TCAL RxQec3 obs numerical error" },
    { 0x0E04UL, "LBRxTCAL:LBRX TCAL RxQec3 obs no new data" },
    { 0x0E05UL, "LBRxTCAL:LBRX TCAL data capture error" },
    { 0x0E06UL, "LBRxTCAL:Hclip error" },
    { 0x0F01UL, "RxLODelay:RX is disabled" },
    { 0x0F02UL, "RxLODelay:Data Capture Error" },
    { 0x1001UL, "RxTCAL:RxQec3 obs image power error" },
    { 0x1002UL, "RxTCAL:RxQec3 obs insufficient power error" },
    { 0x1003UL, "RxTCAL:RxQec3 obs numerical error" },
    { 0x1004UL, "RxTCAL:RxQec3 obs no new data" },
    { 0x1005UL, "RxTCAL:Data capture error" },
    { 0x1006UL, "RxTCAL:Hclip error" },
    { 0x1101UL, "ORXLODelay:ORX is disabled" },
    { 0x1102UL, "ORXLODelay:Data Capture Error" },
    { 0x1201UL, "ORxTCAL:RxQec3 obs image power error" },
    { 0x1202UL, "ORxTCAL:RxQec3 obs insufficient power error" },
    { 0x1203UL, "ORxTCAL:RxQec3 obs numerical error" },
    { 0x1204UL, "ORxTCAL:RxQec3 obs no new data" },
    { 0x1205UL, "ORxTCAL:data capture error" },
    { 0x1206UL, "ORxTCAL:Hclip error" },
    { 0x1301UL, "TxDAC:DAC supply clock error" },
    { 0x1302UL, "TxDAC:DAC channel I not powered up" },
    { 0x1303UL, "TxDAC:DAC channel Q not powered up" },
    { 0x1304UL, "TxDAC:DAC channel I calibration didn't finish" },
    { 0x1305UL, "TxDAC:DAC channel Q calibration didn't finish" },
    { 0x1306UL, "TxDAC:DAC channel I saturated" },
    { 0x1307UL, "TxDAC:DAC channel Q saturated" },
    { 0x1308UL, "TxDAC:DAC channel I clock not powered down" },
    { 0x1309UL, "TxDAC:DAC channel Q clock not powered down" },
    { 0x1401UL, "DPDExt:DPD hardware is being used by other cals" },
    { 0x1402UL, "DPDExt:Stream Error" },
    { 0x1403UL, "DPDExt:Tx transition occurs during capture" },
    { 0x1404UL, "DPDExt:Global peak copy didn't complete in time" },
    { 0x1405UL, "DPDExt:Failed to create external DPD task" },
    { 0x1406UL, "DPDExt:Failed to create the event group" },
    { 0x1407UL, "DPDExt:The given model number is beyond number of models supported" },
    { 0x1408UL, "DPDExt:Recieved a new model update command while one is in progress" },
    { 0x1801UL, "TxAttenDelay:Invalid value" },
    { 0x1802UL, "TxAttenDelay:Invalid NCO power level" },
    { 0x1803UL, "TxAttenDelay:Calibration failed to start" },
    { 0x1804UL, "TxAttenDelay:Calibration value too low" },
    { 0x1805UL, "TxAttenDelay:Calibration value too high" },
    { 0x1806UL, "TxAttenDelay:Max deviation in cal results reached" },
    { 0x1807UL, "TxAttenDelay:Calibration timed-out" },
    { 0x1901UL, "TxAtten:Log timeout error" },
    { 0x1902UL, "TxAtten:Log read error" },
    { 0x1903UL, "TxAtten:Gain table error" },
    { 0x1904UL, "TxAtten:Rxqec hw log error" },
    { 0x1905UL, "TxAtten:Rxqec hw log error" },
    { 0x1906UL, "TxAtten:Phase measurement tone is OOB, not NCO shiftable for Phase measurement" },
    { 0x1907UL, "TxAtten:Phase measurement curve fit error" },
    { 0x1908UL, "TxAtten:Tx LO and Aux LO are not synchronized" },
    { 0x1A01UL, "RxGainDelay:Tone power too low" },
    { 0x1A02UL, "RxGainDelay:Calibration failed to start" },
    { 0x1A03UL, "RxGainDelay:Calibration value too low" },
    { 0x1A04UL, "RxGainDelay:Calibration value too high" },
    { 0x1A05UL, "RxGainDelay:Max deviation in cal results reached" },
    { 0x1A06UL, "RxGainDelay:Calibration timed-out" },
    { 0x1B01UL, "RxPhaseInit:log timeout error" },
    { 0x1B02UL, "RxPhaseInit:log read error" },
    { 0x1B03UL, "RxPhaseInit:gain table error" },
    { 0x1B04UL, "RxPhaseInit:rxqec hw log error" },
    { 0x1B05UL, "RxPhaseInit:rxqec hw log error" },
    { 0x1E01UL, "SERDES:Lane is powered down" },
    { 0x1E02UL, "SERDES:Control command not supported" },
    { 0x1E03UL, "SERDES:Best rset value not found" },
    { 0x1E04UL, "SERDES:Set Cal args Error" },
    { 0x1E05UL, "SERDES:Invalid temperature" },
    { 0x1E06UL, "SERDES:ALC calibration timeout" },
    { 0x1E07UL, "SERDES: Failed to create serdes semaphore" },
    { 0x1E08UL, "SERDES: Failed to take serdes semaphore" },
    { 0x1D01UL, "TxCFR:configuration error" },
    { 0x1D02UL, "TxCFR:unknown programming pulse mode" },
    { 0x1D03UL, "TxCFR:input rate exceeds max supported" },
    { 0x1D04UL, "TxCFR:control command not supported" },
    { 0x3001UL, "RxQECTrack:data capture error" },
    { 0x3002UL, "RxQECTrack:observation clipping, indicating setup error" },
    { 0x3003UL, "RxQECTrack:correction update semaphore error" },
    { 0x3004UL, "RxQECTrack:model has diverged and has been reset" },
    { 0x3201UL, "TxLOLTrack:Capture error" },
    { 0x3202UL, "TxLOLTrack:Capture abort error" },
    { 0x3203UL, "TxLOLTrack:Overflow warning" },
    { 0x3204UL, "TxLOLTrack:Pathdelay invalid" },
    { 0x3205UL, "TxLOLTrack:LOL Internal init calibration not done" },
    { 0x3206UL, "TxLOLTrack:No data was captured" },
    { 0x3207UL, "TxLOLTrack:No Orx assigned to the TX channel" },
    { 0x3208UL, "TxLOLTrack:Not all batches were run" },
    { 0x3209UL, "TxLOLTrack:Orx assigned to the TX channel, is not configured" },
    { 0x320AUL, "TxLOLTrack:Capture timed-out" },
    { 0x320BUL, "TxLOLTrack:Dummy capture failed" },
    { 0x320CUL, "TxLOLTrack:LOL External init calibration not done" },
    { 0x320DUL, "TxLOLTrack:Performed channel reset due to PLL changes" },
    { 0x320EUL, "TxLOLTrack:Wrong baseband is active" },
    { 0x3301UL, "TxQECTrack:Correlation capture error" },
    { 0x3302UL, "TxQECTrack:Correlation capture error" },
    { 0x3303UL, "TxQECTrack:Initial calibration not done" },
    { 0x3304UL, "TxQECTrack:No signal present" },
    { 0x3305UL, "TxQECTrack:Channel variance is invalid" },
    { 0x3306UL, "TxQECTrack:Correlation output buffer is null" },
    { 0x3307UL, "TxQECTrack:Correlation output buffer is not full" },
    { 0x3308UL, "TxQECTrack:Capture timed-out" },
    { 0x3309UL, "TxQECTrack:Capture ended with no solution" },
    { 0x320AUL, "TxQECTrack:Wrong baseband is active" },
    { 0x3401UL, "DPDTrack:reserved" },
    { 0x3402UL, "DPDTrack:reserved" },
    { 0x3403UL, "DPDTrack:Pathdelay not setup yet" },
    { 0x3404UL, "DPDTrack:reserved" },
    { 0x3405UL, "DPDTrack:ORx signal is too small" },
    { 0x3406UL, "DPDTrack:ORx signal is saturating" },
    { 0x3407UL, "DPDTrack:TX signal is too small" },
    { 0x3408UL, "DPDTrack:TX signal is saturating" },
    { 0x3409UL, "DPDTrack:reserved" },
    { 0x340AUL, "DPDTrack:Too many AM-AM outliers" },
    { 0x340BUL, "DPDTrack:DPD coefficients unavailable" },
    { 0x340CUL, "DPDTrack:DPD data capture loop time out" },
    { 0x340DUL, "DPDTrack:Unity model unavailable error" },
    { 0x340EUL, "DPDTrack:DPD LDL negative diagonal or INF detected" },
    { 0x340FUL, "DPDTrack:Maximum partial partitions reached" },
    { 0x3410UL, "DPDTrack:RPC send failed" },
    { 0x3411UL, "DPDTrack:Unknown RPC message received" },
    { 0x3412UL, "DPDTrack:Timed out waiting for RPC message" },
    { 0x3413UL, "DPDTrack:Could not create mutex" },
    { 0x3414UL, "DPDTrack:ACT I assignment conflict error" },
    { 0x3415UL, "DPDTrack:ACT K assignment exceed limit error" },
    { 0x3416UL, "DPDTrack:ACT multiplier row assignment conflict error" },
    { 0x3417UL, "DPDTrack:ACT LUT out of range error" },
    { 0x3418UL, "DPDTrack:ACT no free multiplier error" },
    { 0x3419UL, "DPDTrack:ACT write LUT error" },
    { 0x341AUL, "DPDTrack:DPD hardware is being used by other cals" },
    { 0x341BUL, "DPDTrack:DPD data capture error" },
    { 0x341CUL, "DPDTrack:DPD x-correlation error" },
    { 0x341DUL, "DPDTrack:DPD stability error occurs" },
    { 0x341EUL, "DPDTrack:DPD cholesky diagonal term too small" },
    { 0x341FUL, "DPDTrack:DPD-CLGC synchronization error" },
    { 0x3420UL, "DPDTrack:ACT LUT Entry Saturated" },
    { 0x3421UL, "DPDTrack:DPD data capture timeout error" },
    { 0x3422UL, "DPDTrack:Message Send RPC send failed" },
    { 0x3423UL, "DPDTrack:Do Reset RPC send failed" },
    { 0x3424UL, "DPDTrack:Message Get RPC send failed" },
    { 0x3501UL, "CLGCTrack:Correlation capture error" },
    { 0x3502UL, "CLGCTrack:Correlation capture abort error" },
    { 0x3503UL, "CLGCTrack:Pathdelay not found error" },
    { 0x3504UL, "CLGCTrack:Fail to apply tx atten error" },
    { 0x3505UL, "CLGCTrack:Tx atten limit error" },
    { 0x3506UL, "CLGCTrack:Convergence limit error" },
    { 0x3507UL, "CLGCTrack:PA protection error" },
    { 0x3508UL, "CLGCTrack:CLGC-DPD synchronization error" },
    { 0x3509UL, "CLGCTrack:Tx power level too low error" },
    { 0x350AUL, "CLGCTrack:ORx power level too low error" },
    { 0x350BUL, "CLGCTrack:Tx power measurement error" },
    { 0x350CUL, "CLGCTrack:ORx power measurement error" },
    { 0x350DUL, "CLGCTrack:Data capture timeout caused by invalid tx-to-orx mapping" },
    { 0x3701UL, "HD2Track: HD2 correction filter mapping error" },
    { 0x3801UL, "Initial calibration not done" },
    { 0x3802UL, "Serdes lane powered down" },
    { 0x3803UL, "Capture error" },
    { 0x3804UL, "Cal exit requested" },
    { 0x3804UL, "Status request argument invalid" },
    { 0x6001UL, "GPIOCtrl:Given signal ID is invalid" },
    { 0x6002UL, "GPIOCtrl:The given GPIO number is invalid" },
    { 0x6B01UL, "Loopfilter:PLL Selected invalid" },
    { 0x6B02UL, "Loopfilter:Input Selected invalid" },
    { 0x7701UL, "SRL:Slew Rate Limiter detected overload" },
    { 0x7702UL, "SRL:Init cals can't run when SRL is enabled" },
    { 0x7703UL, "SRL:Operation failed because SRL violation is in active progress" },
    { 0x7E01UL, "CaptureORx:Capture timed-out" },
    { 0x7E02UL, "CaptureORx:Number of samples not a power of 2" },
    { 0x7E03UL, "CaptureORx:Invalid TX input channel mask" },
    { 0x7E04UL, "CaptureORx:Invalid ORX input channel mask" },
    { 0x7E05UL, "CaptureORx:Required TX stream is disabled" },
    { 0x7E06UL, "CaptureORx:Required ORX stream is disabled" },
    { 0x7E07UL, "CaptureORx:For playback" },
    { 0x8001UL, "DeviceProfile:Checksum error" },
    { 0x8002UL, "DeviceProfile:Missing data for enabled channel" },
    { 0x8003UL, "DeviceProfile:ADC tuner profile checksum error" },
    { 0x8301UL, "Scheduler:A cal timed out while waiting for Scheduler to abort a data capture" },
    { 0x8302UL, "Scheduler:An invalid cal ID is passed to the Scheduler" },
    { 0x8303UL, "Scheduler:Scheduler received a PAUSED event that it was not expecting" },
    { 0x8101UL, "RadioEvent:TXCAL_ENADIS command cannot be issued as a pin is mapped to control it" },
    { 0xB001UL, "NCO:Invalid input parameters" },
    { 0xB101UL, "Stream:Invalid input parameters" },
    { 0xB102UL, "Stream:Timer expired waiting for stream completion" },
    { 0xB103UL, "Stream:Triggered stream reported an error" },
    { 0xB104UL, "Stream:Failed checksum verification" },
    { 0xB105UL, "Stream:Reported a FIFO error" },
    { 0xB106UL, "Stream:Reported an external timer error" },
    { 0xB107UL, "Stream:Reported an invalid instruction" },
    { 0xB108UL, "Stream:Reported an invalid AHB address" },
    { 0xB109UL, "Stream:Reported an invalid stream number" },
    { 0xB10AUL, "Stream:Reported a stack overflow" },
    { 0xB10BUL, "Stream:Reported a timeout error" },
    { 0xB10CUL, "Stream:Reported a check instruction error" },
    { 0xB10DUL, "Stream:Reported an invalid SPI address" },
    { 0xB10EUL, "Stream:Previous Stream didn't finish" },
    { 0xB10FUL, "Stream:Undefined Error" },
    { 0xB201UL, "PFIR:Invalid configuration" },
    { 0xB301UL, "JESD:Framer lane overlap" },
    { 0xB302UL, "JESD:Deframer lane overlap" },
    { 0xB303UL, "JESD:Framer number too larger" },
    { 0xB304UL, "JESD:Deframer number too larger" },
    { 0xB305UL, "JESD:Framer S is not a power of 2" },
    { 0xB306UL, "JESD:Deframer M not a power of 2" },
    { 0xB307UL, "JESD:Number of framer lanes must be more than 0" },
    { 0xB308UL, "JESD:No enabled deframer lanes" },
    { 0xB309UL, "JESD:Framer number of converters (M) set to 0" },
    { 0xB30AUL, "JESD:Framer number of converters is not a power of 2" },
    { 0xB30BUL, "JESD:Framer sample rate divide ratio not power of 2" },
    { 0xB30CUL, "JESD:Deframer sample rate divide ratio not power of 2" },
    { 0xB30DUL, "JESD:Framer0 must be enabled" },
    { 0xB30EUL, "JESD:bitRepeatRatio is not a power of 2" },
    { 0xB30FUL, "JESD:bitSplitRatio is not a power of 2" },
    { 0xB310UL, "JESD:Framer pclk divide ratio not a power of 2" },
    { 0xB311UL, "JESD:Failed to configure line clock" },
    { 0xB312UL, "JESD:Serdes PLL invalid input parameters" },
    { 0xB313UL, "JESD:Serdes PLL failed to calibrate or lock" },
    { 0xB314UL, "JESD:Driver not initialized" },
    { 0xB315UL, "JESD:Framer lane clock invalid" },
    { 0xB316UL, "JESD:Deframer lane clock invalid" },
    { 0xB317UL, "JESD:Unsupported configuration" },
    { 0xB318UL, "JESD:Framer sample rate is zero" },
    { 0xB319UL, "JESD:Deframer sample rate is zero" },
    { 0xB31AUL, "JESD:Invalid TX config detected by Jesd h/w block" },
    { 0xB31BUL, "JESD:Invalid RX config detected by Jesd h/w block" },
    { 0xB31CUL, "JESD:Invalid Framer Sample Xbar entry" },
    { 0xB31DUL, "JESD:Framer fast pclk divide ratio not integer" },
    { 0xB31EUL, "JESD:Framer pclk divide ratio not integer" },
    { 0xB31FUL, "JESD:Invalid Framer Sync Pad configuration" },
    { 0xB320UL, "JESD:Invalid Deframer Sync Pad configuration" },
    { 0xB321UL, "JESD:Deframer S is not a power of 2" },
    { 0xB322UL, "JESD:Framer link sharing configuration invalid" },
    { 0xB323UL, "JESD:Serdes Master Reset active" },
    { 0xB324UL, "JESD:Invalid Deframer Sample Xbar entry" },
    { 0xB325UL, "JESD:Invalid Framer link layer mode of operation" },
    { 0xB326UL, "JESD:Invalid Deframer link layer mode of operation" },
    { 0xB327UL, "JESD:Framer link sharing number of converters (M) invalid" },
    { 0xB401UL, "RxQECHWDrv:Error configuring RxQEC core clocks" },
    { 0xB402UL, "RxQECHWDrv:Error configuring RxQEC channel clocks" },
    { 0xB403UL, "RxQECHWDrv:QFIR overflow error, unable to represent desired filter in hardware" },
    { 0xB404UL, "RxQECHWDrv:LOC overflor error, unable to represent desired phase coefficient in hardware" },
    { 0xB405UL, "RxQECHWDrv:CFIR overflor error, unable to represent desired filter in hardware" },
    { 0xB406UL, "RxQECHWDrv:Error while attempting to halt an OBS engine" },
    { 0xB407UL, "RxQECHWDrv:Attempted to use an observation engine that was already allocated to another cal" },
    { 0xB408UL, "RxQECHWDrv:Attempted to release an observation engine that was allocated to another cal" },
    { 0xB409UL, "RxQECHWDrv:Error configuring RxQEC observation profiles" },
    { 0xB40AUL, "RxQECHWDrv:Observation data FIFO full" },
    { 0xB501UL, "TxAttenDrv:Wrong SPI mode for operation" },
    { 0xB502UL, "TxAttenDrv:Invalid HP attenuation value" },
    { 0xB503UL, "TxAttenDrv:Invalid digital attenuation value" },
    { 0xB504UL, "TxAttenDrv:Set attenuation state using invalid structure" },
    { 0xB601UL, "TxQECDrv:NCO synchronization timed-out" },
    { 0xB602UL, "TxQECDrv:NCO Set frequency is invalid" },
    { 0xB603UL, "TxQECDrv:Txqec correlator didn't finish" },
    { 0xB604UL, "TxQECDrv:NCO Offset LO Sync is inactive" },
    { 0xB605UL, "TxQECDrv:NCO Offset LO is not synced" },
    { 0x7F01UL, "TestMode:Invalid test task requested" },
    { 0xF001UL, "TestModeClkPll:Not in CLKPLL_SWEEP Test Mode" },
    { 0xF002UL, "TestModeClkPll:Frequency is out of range" },
    { 0xF003UL, "TestModeClkPll:BW parameter is out of range" },
    { 0xF101UL, "TestModeTxBBF:Not in TXBBF_3DB_SWEEP Test Mode" },
    { 0xF201UL, "TestModeTIA:Not in TIA_3DB_SWEEP Test Mode" },
    { 0xF202UL, "TestModeTIA:Frequency is out of range" },
    { 0xF203UL, "TestModeTIA:Invalid Channel Type" },
    { 0xF301UL, "TestModeLBRx:Not in LOOPBACK Ctrl Test Mode" },
    { 0xF302UL, "TestModeLBRx:Invalid Channel Type" },
    { 0xF401UL, "TestModeCBus:Not in CBUS R/W Ctrl Test Mode" },
    { 0xF402UL, "TestModeCBus:Invalid address Type" },
    { 0xFA01UL, "TestModeSerdes:Mode not supported on this platform" },
    { 0xFA02UL, "TestModeSerdes:Not in Serdes Test Mode" },
    { 0xFC01UL, "TestModeSerdes:Mode not supported on this platform" },
    { 0xFC02UL, "TestModeSerdes:Not in Serdes BG Cals Test Mode" },
    { 0xFF01UL, "System:PLL Synth Lock Failed" },
    { 0xFF02UL, "System:PLL Charge Pump Calibration error" },
    { 0xFF03UL, "System:PLL Calculation error" },
    { 0xFF04UL, "System:PLL input freq out of range" },
    { 0xFF05UL, "System:PLL Invalid PLL type" },
    { 0xFF06UL, "System:SysClk parameter out of range" },
    { 0xFF07UL, "System:HSDig calculations did not match API settings" },
    { 0xFF08UL, "System:Rx Setup Error" },
    { 0xFF09UL, "System:Orx Setup Error" },
    { 0xFF0AUL, "System:Tx Setup Error" },
    { 0xFF0BUL, "System:SysPLL Flagged an error." },
    { 0xFF0CUL, "System:Logen range error." },
    { 0xFF0DUL, "System:Logen bad path error." },
    { 0xFF0EUL, "System:MCS did not complete" },
    { 0xFF0FUL, "System:SERDES PLL Synth Lock Failed" },
    { 0xFF10UL, "System:SERDES PLL Invalid Input Parameter" },
    { 0xFF11UL, "System:Init cal invalid sequenct length" },
    { 0xFF12UL, "System:RF PLL Frequency not set" },
    { 0xFF13UL, "System:Tone path not configured" },
    { 0xFF14UL, "System:Init cal interrupted by ABORT command" },
    { 0xFF15UL, "System:Init cal warm boot checksum error" },
    { 0xFF16UL, "System:Init cal invalid channel mask error" },
    { 0xFF17UL, "System:Profile checksum failed or bad profile wrt to EFUSE" },
    { 0xFF18UL, "System:Clock generation error" },
    { 0xFF19UL, "System:JESD Error" },
    { 0xFF1AUL, "System:Stream checksum failed" },
    { 0xFF1BUL, "System:Could not create the task" },
    { 0xFF1CUL, "System:Could not create the event" },
    { 0xFF1DUL, "System:Could not create the Queue" },
    { 0xFF1EUL, "System:Could not create the timer" },
    { 0xFF1FUL, "System:Failed to post the message" },
    { 0xFF20UL, "System:Failed to receive the message" },
    { 0xFF21UL, "System:GP Timer driver error" },
    { 0xFF22UL, "System:Mailbox critical error" },
    { 0xFF23UL, "System:Health monitoring timer timedout" },
    { 0xFF24UL, "System:Commands sent to task that does not exist" },
    { 0xFF25UL, "System:Invalid message passed to ctrl task" },
    { 0xFF26UL, "System:Invalid mailbox command passed to ctrl task" },
    { 0xFF27UL, "System:The given cal does not support the control function" },
    { 0xFF28UL, "System:The given cal does not support the set config function" },
    { 0xFF29UL, "System:The given cal does not support the get config function" },
    { 0xFF2AUL, "System:The given cal does not support the get status function" },
    { 0xFF2BUL, "System:The given channel is not enabled in the profile" },
    { 0xFF2CUL, "System:The given target configuration object is invalid" },
    { 0xFF2DUL, "System:The given configuration size is invalid" },
    { 0xFF2EUL, "System:The given configuration offset is invalid" },
    { 0xFF2FUL, "System:The config cannot be updated in current state of module" },
    { 0xFF30UL, "System:AUX PLL NORMAL VCO failed to start" },
    { 0xFF31UL, "System:AUX PLL NORMAL VCO to complete" },
    { 0xFF32UL, "System:AUX PLL FAST VCO failed to start" },
    { 0xFF33UL, "System:AUX PLL FAST VCO failed to complete" },
    { 0xFF34UL, "System:PLL Temperature Time Out error" },
    { 0xFF35UL, "System:PLL Not Enabled" },
    { 0xFF36UL, "System:PLL Phase Sync Invalide Setting error" },
    { 0xFF37UL, "System:PLL Phase Sync cal timeout error" },
    { 0xFF38UL, "System:SERDES PLL Invalid divM value" },
    { 0xFF39UL, "System:SERDES PLL Invalid rxdivrate value" },
    { 0xFF3AUL, "System:JTAG Debug Build Error Code" },
    { 0xFF3BUL, "System:Internal MCS did not complete" },
    { 0xFF3CUL, "System:DDC calculations were out of bounds" },
    { 0xFF3DUL, "System:DDC Invalid band selected for Get_DCC parameters" },
    { 0xFF3EUL, "System:WDT config invalid (most likely in Debug mode = no WDT)" },
    { 0xFF3FUL, "System:AHB slice error" },
    { 0xFF40UL, "System:LDO Bypass not configured correctly" },
    { 0xFF41UL, "System:AUX Adc timed out" },
    { 0xFF42UL, "System:Semaphore take operation failure" },
    { 0xFF43UL, "System:RF1 PLL NORMAL VCO failed to start" },
    { 0xFF44UL, "System:RF1 PLL NORMAL VCO to complete" },
    { 0xFF45UL, "System:RF1 PLL FAST VCO failed to start" },
    { 0xFF46UL, "System:RF1 PLL FAST VCO failed to complete" },
    { 0xFF47UL, "System:RF2 PLL NORMAL VCO failed to start" },
    { 0xFF48UL, "System:RF2 PLL NORMAL VCO to complete" },
    { 0xFF49UL, "System:RF2 PLL FAST VCO failed to start" },
    { 0xFF4AUL, "System:RF2 PLL FAST VCO failed to complete" },
    { 0xFF4BUL, "System:SERDES PLL Invalid value of B parameter" },
    { 0xFF4CUL, "System:SERDES PLL Invalid value of refClkIn" },
    { 0xFF4DUL, "System:Pre init cal AUX:Synth Lock Failed" },
    { 0xFF4EUL, "System:Post init cal AUX Synth Lock Failed" },
    { 0xFF4FUL, "System:Pre Init cal TxQEC NCO lock failed" },
    { 0xFF50UL, "System:Post Init cal TxQEC NCO lock failed" },
    { 0xFF51UL, "System:DualBand Configuration Error" },
    { 0xFF52UL, "System:Semaphore create error" },
    { 0xFF53UL, "System:Semaphore give error" },
    { 0xFF54UL, "System:Tx Tracking cals cannot be scheduled" },
    { 0xFF55UL, "System:Core stream external timer error" },
    { 0xFF56UL, "System:Unable to read EFUSE" },
    { 0xFF57UL, "System:ARMD did not complete booting" },
    { 0xFF58UL, "System:pll and jesd gain ramp down event active" }
};

#ifdef __cplusplus
}
#endif

#endif
