// SPDX-FileCopyrightText: 2018 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

package bluetooth

const (
	GENERIC_AUDIO_UUID = "00001203-0000-1000-8000-00805f9b34fb"

	HSP_HS_UUID = "00001108-0000-1000-8000-00805f9b34fb"
	HSP_AG_UUID = "00001112-0000-1000-8000-00805f9b34fb"

	HFP_HS_UUID = "0000111e-0000-1000-8000-00805f9b34fb"
	HFP_AG_UUID = "0000111f-0000-1000-8000-00805f9b34fb"

	ADVANCED_AUDIO_UUID = "0000110d-0000-1000-8000-00805f9b34fb"

	A2DP_SOURCE_UUID = "0000110a-0000-1000-8000-00805f9b34fb"
	A2DP_SINK_UUID   = "0000110b-0000-1000-8000-00805f9b34fb"

	AVRCP_REMOTE_UUID = "0000110e-0000-1000-8000-00805f9b34fb"
	AVRCP_TARGET_UUID = "0000110c-0000-1000-8000-00805f9b34fb"

	PANU_UUID     = "00001115-0000-1000-8000-00805f9b34fb"
	NAP_UUID      = "00001116-0000-1000-8000-00805f9b34fb"
	GN_UUID       = "00001117-0000-1000-8000-00805f9b34fb"
	BNEP_SVC_UUID = "0000000f-0000-1000-8000-00805f9b34fb"

	PNPID_UUID              = "00002a50-0000-1000-8000-00805f9b34fb"
	DEVICE_INFORMATION_UUID = "0000180a-0000-1000-8000-00805f9b34fb"

	GATT_UUID            = "00001801-0000-1000-8000-00805f9b34fb"
	IMMEDIATE_ALERT_UUID = "00001802-0000-1000-8000-00805f9b34fb"
	LINK_LOSS_UUID       = "00001803-0000-1000-8000-00805f9b34fb"
	TX_POWER_UUID        = "00001804-0000-1000-8000-00805f9b34fb"

	SAP_UUID = "0000112D-0000-1000-8000-00805f9b34fb"

	HEART_RATE_UUID               = "0000180d-0000-1000-8000-00805f9b34fb"
	HEART_RATE_MEASUREMENT_UUID   = "00002a37-0000-1000-8000-00805f9b34fb"
	BODY_SENSOR_LOCATION_UUID     = "00002a38-0000-1000-8000-00805f9b34fb"
	HEART_RATE_CONTROL_POINT_UUID = "00002a39-0000-1000-8000-00805f9b34fb"

	HEALTH_THERMOMETER_UUID       = "00001809-0000-1000-8000-00805f9b34fb"
	TEMPERATURE_MEASUREMENT_UUID  = "00002a1c-0000-1000-8000-00805f9b34fb"
	TEMPERATURE_TYPE_UUID         = "00002a1d-0000-1000-8000-00805f9b34fb"
	INTERMEDIATE_TEMPERATURE_UUID = "00002a1e-0000-1000-8000-00805f9b34fb"
	MEASUREMENT_INTERVAL_UUID     = "00002a21-0000-1000-8000-00805f9b34fb"

	CYCLING_SC_UUID       = "00001816-0000-1000-8000-00805f9b34fb"
	CSC_MEASUREMENT_UUID  = "00002a5b-0000-1000-8000-00805f9b34fb"
	CSC_FEATURE_UUID      = "00002a5c-0000-1000-8000-00805f9b34fb"
	SENSOR_LOCATION_UUID  = "00002a5d-0000-1000-8000-00805f9b34fb"
	SC_CONTROL_POINT_UUID = "00002a55-0000-1000-8000-00805f9b34fb"

	RFCOMM_UUID_STR = "00000003-0000-1000-8000-00805f9b34fb"

	HDP_UUID        = "00001400-0000-1000-8000-00805f9b34fb"
	HDP_SOURCE_UUID = "00001401-0000-1000-8000-00805f9b34fb"
	HDP_SINK_UUID   = "00001402-0000-1000-8000-00805f9b34fb"

	HID_UUID = "00001124-0000-1000-8000-00805f9b34fb"

	DUN_GW_UUID = "00001103-0000-1000-8000-00805f9b34fb"

	GAP_UUID = "00001800-0000-1000-8000-00805f9b34fb"
	PNP_UUID = "00001200-0000-1000-8000-00805f9b34fb"

	SPP_UUID = "00001101-0000-1000-8000-00805f9b34fb"

	OBEX_SYNC_UUID = "00001104-0000-1000-8000-00805f9b34fb"
	OBEX_OPP_UUID  = "00001105-0000-1000-8000-00805f9b34fb"
	OBEX_FTP_UUID  = "00001106-0000-1000-8000-00805f9b34fb"
	OBEX_PCE_UUID  = "0000112e-0000-1000-8000-00805f9b34fb"
	OBEX_PSE_UUID  = "0000112f-0000-1000-8000-00805f9b34fb"
	OBEX_PBAP_UUID = "00001130-0000-1000-8000-00805f9b34fb"
	OBEX_MAS_UUID  = "00001132-0000-1000-8000-00805f9b34fb"
	OBEX_MNS_UUID  = "00001133-0000-1000-8000-00805f9b34fb"
	OBEX_MAP_UUID  = "00001134-0000-1000-8000-00805f9b34fb"

	/* GATT UUIDs section */
	GATT_PRIM_SVC_UUID = 0x2800
	GATT_SND_SVC_UUID  = 0x2801
	GATT_INCLUDE_UUID  = 0x2802
	GATT_CHARAC_UUID   = 0x2803

	/* GATT Characteristic Types */
	GATT_CHARAC_DEVICE_NAME          = 0x2A00
	GATT_CHARAC_APPEARANCE           = 0x2A01
	GATT_CHARAC_PERIPHERAL_PRIV_FLAG = 0x2A02
	GATT_CHARAC_RECONNECTION_ADDRESS = 0x2A03
	GATT_CHARAC_PERIPHERAL_PREF_CONN = 0x2A04
	GATT_CHARAC_SERVICE_CHANGED      = 0x2A05

	/* GATT Characteristic Descriptors */
	GATT_CHARAC_EXT_PROPER_UUID    = 0x2900
	GATT_CHARAC_USER_DESC_UUID     = 0x2901
	GATT_CLIENT_CHARAC_CFG_UUID    = 0x2902
	GATT_SERVER_CHARAC_CFG_UUID    = 0x2903
	GATT_CHARAC_FMT_UUID           = 0x2904
	GATT_CHARAC_AGREG_FMT_UUID     = 0x2905
	GATT_CHARAC_VALID_RANGE_UUID   = 0x2906
	GATT_EXTERNAL_REPORT_REFERENCE = 0x2907
	GATT_REPORT_REFERENCE          = 0x2908
)
