    # 系统登录认证接口

## 系统登录接口

系统在Session DBus上提供统一登录接口，应用程序调用登录接口完成deepinid用户的OAuth2登录流程。

### 应用注册接口

```c++
void Register(QString clientID, QString dest, QString path, QString interface);
```

| 参数 | 说明 |
| ---- | ---- |
| clientID | 申请的deepinid应用ID |
| dest | 本地应用的dbus服务的servicename |
| path | 本地应用的dbus服务的path |
| interface | 本地应用的dbus服务的interface |

程序在启动或者调用Authorize接口前，需要向系统注册应用的dbus信息。
在异步完成验证后，系统会调用应用的对应接口发送认证参数。

### 认证接口

```c++
void Authorize(QString clientID, QStringList scopes, QString redirectURI, QString state)
```

| 参数 | 说明 |
| ---- | ---- |
| clientID | 申请的deepinid应用ID |
| scopes | 申请的权限，如`"base,user:read`或`["base","user:read"]`，留空表示使用应用默认权限 |
| redirectURI | 回调地址，用于验证 |
| state | state参数，请务必使用服务器来生成 |


## 应用接口

应用程序必须实现如下接口：

1. 


```c++
void OnAuthorized(code string, state string);
```

在认证成功时调用，应用程序获取code和state后去应用服务器验证，并交换token。

2. 

```c++
void OnCancel();
```

认证取消时调用，当用户放弃输入时会调用该接口。

3. 

```c++
void OnCancelCode(errCode int);//OnCancel()更新接口
```

认证取消时调用，当用户放弃输入时会调用该接口。参数errCode表示可能会导致认证终止的错误类型，错误类型定义具体如下：

```cpp
enum ErrCode
{
    Err_no,					//无错误
    Err_Authorize,			//授权错误
    Err_LoginPageLoad,		//登陆页面加载错误
    Err_CloseLoginWindow,	//登陆窗口关闭
    Err_CloseClient,		//应用程序关闭
};
```
注意： 新接口OnCancelCode(errCode int)实现后，旧的接口OnCancel()需要删除，否则在调用AuthTerm接口后会再次把应用程序拉起
4. 

```c++
void AuthTerm(clientID string);
```

应用程序已打开登陆窗口，当用户关闭应用程序，需要登陆窗口同步关闭时，通过调用此接口通知登陆客户端，传入应用本身clientID，告诉登陆客户端，应用程序准备关闭并同步关闭登陆客户端。

## 登录流程

1 应用调用 com.deepin.deepinid.Client.Register 注册应用

2 调用com.deepin.deepinid.Client.Authorize接口进行认证

3 系统自动调用系统级别的登录界面，完成登录功能

4 系统登录后向应用签发OAuth需要的code和state，并通过应用的dbus接口发送给应用

5 应用程序收到code和state后，将code和state发送到应用服务器，在服务器端发起发起OAuth2的token流程

### 参考实现

Qt开发请参考deepinidApp源码