// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef RUNTIMESTATE_H
#define RUNTIMESTATE_H

#include "global_header.h"

#include <QString>
#include <QVariantHash>

class QFile;
GLOBAL_BEGIN_NAMESPACE

inline constexpr char kRuntime_state_pid[]{"pid"};

class RuntimeState
{
public:
    explicit RuntimeState(const QString &model);
    int pid() const;
    QString stateFile() const;
    static QString stateDir();
    static void mkpath();
    static void writeSate(QFile *file, const QVariantHash &state);
    static QList<QVariantHash> listAll();
protected:
    QString model;
};

GLOBAL_END_NAMESPACE

#endif // RUNTIMESTATE_H
