// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef HTTPSERVER_H
#define HTTPSERVER_H

#include "global_header.h"

#include <QThread>

#include <functional>

GLOBAL_BEGIN_NAMESPACE
class HttpServerPrivate;
class HttpContext;

using chunckProvider = std::function<bool(QString &out, bool &stop)>;
using chunckComplete = std::function<void(bool success)>;

class HttpServer : public QThread
{
    Q_OBJECT
    friend class HttpServerPrivate;
public:
    enum ReqType {Get,Post};
    explicit HttpServer(QObject *parent = nullptr);
    ~HttpServer();
    bool initialize(QString host = "", int port = -1);
    bool registerAPI(ReqType type, const QString &api);
    static int randomPort();
    void setLastWorkTime(int seconds);

    static QString getPath(HttpContext *ctx);
    static QString getBody(HttpContext *ctx);
    static void setContent(HttpContext *ctx, const QString &content, const QString &type = "application/json; charset=utf-8");
    static void setStatus(HttpContext *ctx, int st = 200);
    static void setChunckProvider(HttpContext *ctx, chunckProvider cp, chunckComplete cc, const QString &type = "text/event-stream");
signals:
    void newRequset(void *ctx);
public slots:
protected:
    void run();
private:
    HttpServerPrivate *d;
};

GLOBAL_END_NAMESPACE

#endif // HTTPSERVER_H
