#include "EventData.h"
#include <DSysInfo>
#include <QStringList>
#include <QDebug>
#include <QDateTime>
#include "../environments.h"
#include "../Process.h"

ResultInfo::ResultInfo() : errCode(-1), result(""), errMsg("")
{}

ResultInfo::ResultInfo(int retCode, const QString &resultInfo, const QString &errMsgInfo) :
    errCode(retCode), result(resultInfo), errMsg(errMsgInfo)
{}

ResultInfo::ResultInfo(const ResultInfo &other)
{
    this->errCode = other.errCode;
    this->result = other.result;
    this->errMsg = other.errMsg;
}

ResultInfo& ResultInfo::operator=(const ResultInfo &other)
{
    if (this != &other) {
        this->errCode = other.errCode;
        this->result = other.result;
        this->errMsg = other.errMsg;
    }

    return *this;
}

QJsonObject ResultInfo::marshal()
{
    QJsonObject jsonObject;

    jsonObject.insert("result", result);
    jsonObject.insert("errMsg", errMsg);
    jsonObject.insert("errCode", QString::number(errCode));

    return jsonObject;
}

void ResultInfo::unmarshal(const QJsonObject &jsonObject)
{
    result = jsonObject.value("result").toString();
    errMsg = jsonObject.value("errMsg").toString();
    errCode = jsonObject.value("errCode").toInt(-1);
}

EventBaseData::EventBaseData() : tid(-1), version(VERSION)
{}

QJsonObject EventBaseData::marshal()
{
    QJsonObject jsonObject = resInfo.marshal();
    jsonObject.insert("tid", QString::number(tid));
    jsonObject.insert("version", version);

    return jsonObject;
}

void EventBaseData::unmarshal(const QJsonObject &jsonObject)
{
    resInfo.unmarshal(jsonObject);
    tid = jsonObject.value("tid").toInt(-1);
    version = jsonObject.value("version").toString();
}

BackupEventData::BackupEventData() : EventBaseData(),
    operateType(""),
    backupType("")
{
    QDateTime time = QDateTime::fromSecsSinceEpoch(QDateTime::currentSecsSinceEpoch()); //时间戳-秒级
    backupFinishedTime = time.toString("yyyy-MM-dd HH:mm:ss");
}

QJsonObject BackupEventData::marshal()
{
    QJsonObject jsonObject = EventBaseData::marshal();
    jsonObject.insert("operateType", operateType);
    jsonObject.insert("backupType", backupType);
    jsonObject.insert("backupFinishedTime", backupFinishedTime);

    return jsonObject;
}

void BackupEventData::unmarshal(const QJsonObject &jsonObject)
{
    EventBaseData::unmarshal(jsonObject);
    operateType = jsonObject.value("operateType").toString();
    backupType = jsonObject.value("backupType").toString();
    backupFinishedTime = jsonObject.value("backupFinishedTime").toString();
}

RestoreEventData::RestoreEventData() : EventBaseData(),
    operateType(""),
    restoreType("")
{}

QJsonObject RestoreEventData::marshal()
{
    QJsonObject jsonObject = EventBaseData::marshal();
    jsonObject.insert("operateType", operateType);
    jsonObject.insert("restoreType", restoreType);

    return jsonObject;
}

void RestoreEventData::unmarshal(const QJsonObject &jsonObject)
{
    EventBaseData::unmarshal(jsonObject);
    operateType = jsonObject.value("operateType").toString();
    restoreType = jsonObject.value("restoreType").toString();
}

GhostEventData::GhostEventData() : EventBaseData(), operateType("")
{}

QJsonObject GhostEventData::marshal()
{
    QJsonObject jsonObject = EventBaseData::marshal();
    jsonObject.insert("operateType", operateType);

    return jsonObject;
}

void GhostEventData::unmarshal(const QJsonObject &jsonObject)
{
    EventBaseData::unmarshal(jsonObject);
    operateType = jsonObject.value("operateType").toString();
}
