# 9 Is Medieval Iceland an example of "anarcho"-capitalism working in
practice?

Ironically, medieval Iceland is a good example of why "anarcho"-capitalism
will **not** work, degenerating into de facto rule by the rich. It should be
pointed out first that Iceland, nearly 1,000 years ago, was not a capitalistic
system. In fact, like most cultures claimed by "anarcho"-capitalists as
examples of their "utopia," it was a communal, not individualistic, society,
based on artisan production, with extensive communal institutions as well as
individual "ownership" (i.e. use) and a form of social self-administration,
the **thing** \-- both local and Iceland-wide -- which can be considered a
"primitive" form of the anarchist communal assembly.

As William Ian Miller points out _"[p]eople of a communitarian nature. . .
have reason to be attracted [to Medieval Iceland]. . . the limited role of
lordship, the active participation of large numbers of free people . . . in
decision making within and without the homestead. The economy barely knew the
existence of markets. Social relations preceded economic relations. The nexus
of household, kin, Thing, even enmity, more than the nexus of cash, bound
people to each other. The lack of extensive economic differentiation supported
a weakly differentiated class system . . . [and material] deprivations were
more evenly distributed than they would be once state institutions also had to
be maintained."_ [**Bloodtaking and Peacemaking: Feud, Law and Society in Saga
Iceland**, p. 306]

At this time Iceland _"remained entirely rural. There were no towns, not even
villages, and early Iceland participated only marginally in the active trade
of Viking Age Scandinavia."_ There was a _"diminished level of stratification,
which emerged from the first phase of social and economic development, lent an
appearance of egalitarianism - social stratification was restrained and
political hierarchy limited."_ [Jesse Byock, **Viking Age Iceland**, p. 2]
That such a society could be classed as "capitalist" or even considered a
model for an advanced industrial society is staggering.

Kropotkin in **Mutual Aid** indicates that Norse society, from which the
settlers in Iceland came, had various "mutual aid" institutions, including
communal land ownership (based around what he called the _"village
community"_) and the **thing** (see also Kropotkin's **The State: Its Historic
Role** for a discussion of the "village community"). It is reasonable to think
that the first settlers in Iceland would have brought such institutions with
them and Iceland did indeed have its equivalent of the commune or "village
community," the **Hreppar**, which developed early in the country's history.
Like the early local assemblies, it is not much discussed in the Sagas but is
mentioned in the law book, the Grágás, and was composed of a minimum of twenty
farms and had a five member commission. The Hreppar was self-governing and,
among other things, was responsible for seeing that orphans and the poor
within the area were fed and housed. The Hreppar also served as a property
insurance agency and assisted in case of fire and losses due to diseased
livestock.

In addition, as in most pre-capitalist societies, there were "commons", common
land available for use by all. During the summer, _"common lands and pastures
in the highlands, often called **almenning**, were used by the region's
farmers for grazing."_ This increased the independence of the population from
the wealthy as these _"public lands offered opportunities for enterprising
individuals to increase their store of provisions and to find saleable
merchandise."_ [Jesse Byock, **Op. Cit.**, p. 47 and p. 48]

Thus Icelandic society had a network of solidarity, based upon communal life:

> _ "The status of farmers as free agents was reinforced by the presence of
communal units called **hreppar** (sing. **hreppr**) . . . these [were]
geographically defined associations of landowners. . . the **hreppr** were
self-governing . . . .[and] guided by a five-member steering committee . . .
As early as the 900s, the whole country seems to have been divided into
**hreppar** . . . **Hreppar** provided a blanket of local security, allowing
the landowning farmers a measure of independence to participate in the choices
of political life . . . _

>

> _"Through copoperation among their members, **hreppar** organised and
controlled summer grazing lands, organised communal labour, and provided an
immediate local forum for settling disputes. Crucially, they provided fire and
livestock insurance for local farmers. . . [They also] saw to the feeding and
housing of local orphans, and administered poor relief to people who were
recognised as inhabitants of their area. People who could not provide for
themselves were assigned to member farms, which took turns in providing for
them."_ [Byock, **Op. Cit.**, pp. 137-8]

In practice this meant that _"each commune was a mutual insurance company, or
a miniature welfare state. And membership in the commune was not voluntary.
Each farmer had to belong to the commune in which his farm was located and to
contribute to its needs."_ [Gissurarson quoted by Birgit T. Runolfsson
Solvason, **Ordered Anarchy, State and Rent-Seeking: The Icelandic
Commonwealth, 930-1262**] The Icelandic Commonwealth did not allow farmers
**not** to join its communes and _"[o]nce attached to the local **hreppr**, a
farm's affliation could not be changed."_ However, they did play a key role in
keeping the society free as the **hreppr** _"was essentially non-political and
addressed subsistence and economic security needs. Its presence freed farmers
from depending on an overclass to provide comparable services or corresponding
security measures."_ [Byock, **Op. Cit.**, p. 138]

Therefore, the Icelandic Commonwealth can hardly be claimed in any significant
way as an example of "anarcho"-capitalism in practice. This can also be seen
from the early economy, where prices were subject to popular judgement at the
**skuldaping** (_"payment-thing"_) **not** supply and demand. [Kirsten
Hastrup, **Culture and History in Medieval Iceland**, p. 125] Indeed, with its
communal price setting system in local assemblies, the early Icelandic
commonwealth was more similar to Guild Socialism (which was based upon guild's
negotiating "just prices" for goods and services) than capitalism. Therefore
Miller correctly argues that it would be wrong to impose capitalist ideas and
assumptions onto Icelandic society:

> _"Inevitably the attempt was made to add early Iceland to the number of
regions that socialised people in nuclear families within simple households. .
. what the sources tell us about the shape of Icelandic householding must
compel a different conclusion."_ [**Op. Cit.**, p. 112]

In other words, Kropotkin's analysis of communal society is far closer to the
reality of Medieval Iceland than "anarcho"-capitalist attempts to turn it into
a some kind of capitalist utopia.

However, the communal nature of Icelandic society also co-existed (as in most
such cultures) with hierarchical institutions, including some with
capitalistic elements, namely private property and "private states" around the
local **godar.** The godar were local chiefs who also took the role of
religious leaders. As the **Encyclopaedia Britannica** explains, _"a kind of
local government was evolved [in Iceland] by which the people of a district
who had most dealings together formed groups under the leadership of the most
important or influential man in the district"_ (the godi). The godi _"acted as
judge and mediator"_ and _"took a lead in communal activities"_ such as
building places of worship. These _"local assemblies. . . are heard of before
the establishment of the althing"_ (the national thing). This althing led to
co-operation between the local assemblies.

Thus Icelandic society had different elements, one based on the local chiefs
and communal organisations. Society was marked by inequalities as _"[a]mong
the landed there were differences in wealth and prominence. Distinct cleavages
existed between landowners and landless people and between free men and
slaves."_ This meant it was _"marked by aspects of statelessness and
egalitarianism as well as elements of social hierarchy . . . Although Iceland
was not a democratic system, proto-democratic tendencies existed."_ [Byock,
**Op. Cit.**, p. 64 and p. 65] The Icelandic social system was designed to
reduce the power of the wealthy by enhancing communal institutions:

> _"The society . . . was based on a system of decentralised self-government .
. . The Viking Age settlers began by establishing local things, or assemblies,
which had been the major forum for meetings of freemen and aristocrats in the
old Scandinavian and Germanic social order. . . They [the Icelanders] excluded
overlords with coercive power and expended the mandate of the assembly to fill
the full spectrum of the interests of the landed free farmers. The changes
transformed a Scandinavian decision-making body that mediated between freemen
and overlords into an Icelandic self-contained governmental system without
overlords. At the core of Icelandic government was the Althing, a national
assembly of freemen."_ [Byock, **Op. Cit.**, p. 75]

Therefore we see communal self-management in a basic form, **plus** co-
operation between communities as well. These communistic, mutual-aid features
exist in many non-capitalist cultures and are often essential for ensuring the
people's continued freedom within those cultures ( [section
B.2.5](secB2.md#secb25) on why the wealthy undermine these popular _"folk-
motes"_ in favour of centralisation). Usually, the existence of private
property (and so inequality) soon led to the destruction of communal forms of
self-management (with participation by all male members of the community as in
Iceland), which are replaced by the rule of the rich.

While such developments are a commonplace in most "primitive" cultures, the
Icelandic case has an unusual feature which explains the interest it provokes
in "anarcho"-capitalist circles. This feature was that individuals could seek
protection from any godi. As the **Encyclopaedia Britannica** puts it, _"the
extent of the godord [chieftancy] was not fixed by territorial boundaries.
Those who were dissatisfied with their chief could attach themselves to
another godi. . . As a result rivalry arose between the godar [chiefs]; as may
be seen from the Icelandic Sagas."_ This was because, while there were _"a
central legislature and uniform, country-wide judicial and legal systems,"_
people would seek the protection of any godi, providing payment in return.
[Byock, **Op. Cit.**, p. 2] These godi, in effect, would be subject to "market
forces," as dissatisfied individuals could affiliate themselves to other godi.
This system, however, had an obvious (and fatal) flaw. As the **Encyclopaedia
Britannica** points out:

> _"The position of the godi could be bought and sold, as well as inherited;
consequently, with the passing of time, the godord for large areas of the
country became concentrated in the hands of one man or a few men. This was the
principal weakness of the old form of government: it led to a struggle of
power and was the chief reason for the ending of the commonwealth and for the
country's submission to the King of Norway."_

It was the existence of these hierarchical elements in Icelandic society that
explain its fall from anarchistic to statist society. As Kropotkin argued
_"from chieftainship sprang on the one hand the State and on the other
**private** property."_ [**Act for Yourselves**, p. 85] Kropotkin's insight
that chieftainship is a transitional system has been confirmed by
anthropologists studying "primitive" societies. They have come to the
conclusion that societies made up of chieftainships or chiefdoms are not
states: _"Chiefdoms are neither stateless nor state societies in the fullest
sense of either term: they are on the borderline between the two. Having
emerged out of stateless systems, they give the impression of being on their
way to centralised states and exhibit characteristics of both."_ [Y. Cohen
quoted by Birgit T. Runolfsson Solvason, **Op. Cit.**] Since the Commonwealth
was made up of chiefdoms, this explains the contradictory nature of the
society - it was in the process of transition, from anarchy to statism, from a
communal economy to one based on private property.

The **political** transition within Icelandic society went hand in hand with
an **economic** transition (both tendencies being mutually reinforcing).
Initially, when Iceland was settled, large-scale farming based on extended
households with kinsmen was the dominant economic mode. This semi-communal
mode of production changed as the land was divided up (mostly through
inheritance claims) between the 10th and 11th centuries. This new economic
system based upon individual **possession** and artisan production was then
slowly displaced by tenant farming, in which the farmer worked for a landlord,
starting in the late 11th century. This economic system (based on tenant
farming, i.e. capitalistic production) ensured that _"great variants of
property and power emerged."_ [Kirsten Hastrup, **Culture and History in
Medieval Iceland**, pp. 172-173]

So significant changes in society started to occur in the eleventh century, as
_"slavery all but ceased. Tenant farming . . . took [its] place."_ Iceland was
moving from an economy based on **possession** to one based on **private
property** and so _"the renting of land was a widely established practice by
the late eleventh century . . . the status of the **godar** must have been
connected with landownership and rents."_ This lead to increasing oligarchy
and so the mid- to late-twelfth century was _"characterised by the appearance
of a new elite, the big chieftains who are called storgodar . . . [who]
struggled from the 1220s to the 1260s to win what had earlier been
unobtainable for Icelandic leaders, the prize of overlordship or centralised
executive authority."_ [Byock, **Op. Cit.**, p. 269 and pp. 3-4]

During this evolution in ownership patterns and the concentration of wealth
and power into the hands of a few, we should note that the godi's and wealthy
landowners' attitude to profit making also changed, with market values
starting to replace those associated with honour, kin, and so on. Social
relations became replaced by economic relations and the nexus of household,
kin and Thing was replaced by the nexus of cash and profit. The rise of
capitalistic social relationships in production and values within society was
also reflected in exchange, with the local marketplace, with its pricing
_"subject to popular judgement"_ being _"subsumed under central markets."_
[Hastrup, **Op. Cit.**, p. 225]

With a form of wage labour (tenant farming) being dominant within society, it
is not surprising that great differences in wealth started to appear. Also, as
protection did not come free, it is not surprising that a godi tended to
become rich also (in Kropotkin's words, _"the individual accumulation of
wealth and power"_). Powerful godi would be useful for wealthy landowners when
disputes over land and rent appeared, and wealthy landowners would be useful
for a godi looking for income. Concentrations of wealth, in other words,
produce concentrations of social and political power (and vice versa) --
_"power always follows wealth."_ [Kropotkin, **Mutual Aid**, p. 131]

The transformation of **possession** into **property** and the resulting rise
of hired labour was a **key** element in the accumulation of wealth and power,
and the corresponding decline in liberty among the farmers. Moreover, with
hired labour springs dependency -- the worker is now dependent on good
relations with their landlord in order to have access to the land they need.
With such reductions in the independence of part of Icelandic society, the
undermining of self-management in the various Things was also likely as
labourers could not vote freely as they could be subject to sanctions from
their landlord for voting the "wrong" way (_"The courts were less likely to
base judgements on the evidence than to adjust decisions to satisfy the honour
and resources of powerful individuals."_ [Byock, **Op. Cit.**, p. 185]).. Thus
hierarchy within the economy would spread into the rest of society, and in
particular its social institutions, reinforcing the effects of the
accumulation of wealth and power.

The resulting classification of Icelandic society played a key role in its
move from relative equality and anarchy to a class society and statism. As
Millar points out:

> _"as long as the social organisation of the economy did not allow for people
to maintain retinues, the basic egalitarian assumptions of the honour system.
. . were reflected reasonably well in reality. . . the mentality of hierarchy
never fully extricated itself from the egalitarian ethos of a frontier society
created and recreated by juridically equal farmers. Much of the egalitarian
ethic maintained itself even though it accorded less and less with economic
realities. . . by the end of the commonwealth period certain assumptions about
class privilege and expectations of deference were already well enough
established to have become part of the lexicon of self-congratulation and
self-justification."_ [**Op. Cit.**, pp. 33-4]

This process in turn accelerated the destruction of communal life and the
emergence of statism, focused around the godord. In effect, the godi and
wealthy farmers became rulers of the country. Political changes simply
reflected economic changes from a communalistic, anarchistic society to a
statist, propertarian one. Ironically, this process was a natural aspect of
the system of competing chiefs recommended by "anarcho"-capitalists:

> _ "In the twelfth and thirteenth centuries Icelandic society experienced
changes in the balance of power. As part of the evolution to a more stratified
social order, the number of chieftains diminished and the power of the
remaining leaders grew. By the thirteenth century six large families had come
to monopolise the control and ownership of many of the original
chieftaincies."_ [Byock, **Op. Cit.**, p. 341]

These families were called **storgodar** and they _"gained control over whole
regions."_ This process was not imposed, as _"the rise in social complexity
was evolutionary rather than revolutionary . . . they simply moved up the
ladder."_ This political change reflected economic processes, for _"[a]t the
same time other social transformations were at work. In conjunction with the
development of the **storgadar** elite, the most successful among the
**baendr** [farmers] also moved up a rung on the social ladder, being 'big
farmers' or **Storbaendr**"_ [**Op. Cit.**, p. 342] Unsurprisingly, it was the
rich farmers who initiated the final step towards normal statism and by the
1250s the **storbaendr** and their followers had grown weary of the
**storgodar** and their quarrels. In the end they accepted the King of
Norway's offer to become part if his kingdom.

The obvious conclusion is that as long as Iceland was not capitalistic, it was
anarchic and as it became more capitalistic, it became more statist.

This process, wherein the concentration of wealth leads to the destruction of
communal life and so the anarchistic aspects of a given society, can be seen
elsewhere, for example, in the history of the United States after the
Revolution or in the degeneration of the free cities of Medieval Europe. Peter
Kropotkin, in his classic work **Mutual Aid**, documents this process in some
detail, in many cultures and time periods. However, that this process occurred
in a society which is used by "anarcho"-capitalists as an example of their
system in action reinforces the anarchist analysis of the statist nature of
"anarcho"-capitalism and the deep flaws in its theory, as discussed in
[section 6](append136.md).

As Miller argues, _"[i]t is not the have-nots, after all, who invented the
state. The first steps toward state formation in Iceland were made by
churchmen. . . and by the big men content with imitating Norwegian royal
style. Early state formation, I would guess, tended to involve
redistributions, not from rich to poor, but from poor to rich, from weak to
strong."_ [**Op. Cit.**, p. 306]

The "anarcho"-capitalist argument that Iceland was an example of their
ideology working in practice is derived from the work of David Friedman.
Friedman is less gun-ho than many of his followers, arguing in **The Machinery
of Freedom**, that Iceland only had some features of an "anarcho"-capitalist
society and these provide some evidence in support of his ideology. How a pre-
capitalist society can provide any evidence to support an ideology aimed at an
advanced industrial and urban economy is hard to say as the institutions of
that society cannot be artificially separated from its social base.
Ironically, though, it does present some evidence against "anarcho"-capitalism
precisely because of the rise of capitalistic elements within it.

Friedman is aware of how the Icelandic Republic degenerated and its causes. He
states in a footnote in his 1979 essay _"Private Creation and Enforcement of
Law: A Historical Case"_ that the _"question of why the system eventually
broke down is both interesting and difficult. I believe that two of the
proximate causes were increased concentration of wealth, and hence power, and
the introduction into Iceland of a foreign ideology -- kingship. The former
meant that in many areas all or most of the godord were held by one family and
the latter that by the end of the Sturlung period the chieftains were no
longer fighting over the traditional quarrels of who owed what to whom, but
over who should eventually rule Iceland. The ultimate reasons for those
changes are beyond the scope of this paper."_

However, from an anarchist point of view, the "foreign" ideology of kingship
would be the **product** of changing socio-economic conditions that were
expressed in the increasing concentration of wealth and not its cause. After
all, the settlers of Iceland were well aware of the "ideology" of kingship for
the 300 years during which the Republic existed. As Byock notes, Iceland
_"inherited the tradition and the vocabulary of statehood from its European
origins . . . On the mainland, kings were enlarging their authority at the
expense of the traditional rights of free farmers. The emigrants to Iceland
were well aware of this process . . . available evidence does suggest that the
early Icelanders knew quite well what they did not want. In particular they
were collectively opposed to the centralising aspects of a state."_ [**Op.
Cit.**, p. 64-6] Unless some kind of collective and cultural amnesia occurred,
the notion of a "foreign ideology" causing the degeneration is hard to accept.
Moreover, only the concentration of wealth allowed would-be Kings the
opportunity to develop and act and the creation of boss-worker social
relationships on the land made the poor subject to, and familiar with, the
concept of authority. Such familiarity would spread into all aspects of life
and, combined with the existence of "prosperous" (and so powerful) godi to
enforce the appropriate servile responses, ensured the end of the relative
equality that fostered Iceland's anarchistic tendencies in the first place.

In addition, as private property is a monopoly of rulership over a given area,
the conflict between chieftains for power was, at its most basic, a conflict
of who would **own** Iceland, and so rule it. The attempt to ignore the facts
that private property creates rulership (i.e. a monopoly of government over a
given area) and that monarchies are privately owned states does Friedman's
case no good. In other words, the system of private property has a built in
tendency to produce both the ideology and fact of Kingship - the power
structures implied by Kingship are reflected in the social relations which are
produced by private property.

Friedman is also aware that an _"objection [to his system] is that the rich
(or powerful) could commit crimes with impunity, since nobody would be able to
enforce judgement against them. Where power is sufficiently concentrated this
might be true; this was one of the problems which led to the eventual
breakdown of the Icelandic legal system in the thirteenth century. But so long
as power was reasonably dispersed, as it seem to have been for the first two
centuries after the system was established, this was a less serious problem."_
[**Op. Cit.**]

Which is quite ironic. Firstly, because the first two centuries of Icelandic
society was marked by **non-capitalist** economic relations (communal pricing
and family/individual possession of land). Only when capitalistic social
relationships developed (hired labour and property replacing possession and
market values replacing social ones) in the 12th century did power become
concentrated, leading to the breakdown of the system in the 13th century.
Secondly, because Friedman is claiming that "anarcho"-capitalism will only
work if there is an approximate equality within society! But this state of
affairs is one most "anarcho"-capitalists claim is impossible and undesirable!

They claim there will **always** be rich and poor. But inequality in wealth
will also become inequality of power. When "actually existing" capitalism has
become more free market the rich have got richer and the poor poorer.
Apparently, according to the "anarcho"-capitalists, in an even "purer"
capitalism this process will be reversed! It is ironic that an ideology that
denounces egalitarianism as a revolt against nature implicitly requires an
egalitarian society in order to work.

In reality, wealth concentration is a fact of life in **any** system based
upon hierarchy and private property. Friedman is aware of the reasons why
"anarcho"-capitalism will become rule by the rich but prefers to believe that
"pure" capitalism will produce an egalitarian society! In the case of the
commonwealth of Iceland this did not happen - the rise in private property was
accompanied by a rise in inequality and this lead to the breakdown of the
Republic into statism.

In short, Medieval Iceland nicely illustrates David Weick's comments (as
quoted in [section 6.3](append136.md#secf63)) that _"when private wealth is
uncontrolled, then a police-judicial complex enjoying a clientele of wealthy
corporations whose motto is self-interest is hardly an innocuous social force
controllable by the possibility of forming or affiliating with competing
'companies.'"_ This is to say that "free market" justice soon results in rule
by the rich, and being able to affiliate with "competing" "defence companies"
is insufficient to stop or change that process.

This is simply because any defence-judicial system does not exist in a social
vacuum. The concentration of wealth -- a natural process under the "free
market" (particularly one marked by private property and wage labour) -- has
an impact on the surrounding society. Private property, i.e. monopolisation of
the means of production, allows the monopolists to become a ruling elite by
exploiting, and so accumulating vastly more wealth than, the workers. This
elite then uses its wealth to control the coercive mechanisms of society
(military, police, "private security forces," etc.), which it employs to
protect its monopoly and thus its ability to accumulate ever more wealth and
power. Thus, private property, far from increasing the freedom of the
individual, has always been the necessary precondition for the rise of the
state and rule by the rich. Medieval Iceland is a classic example of this
process at work.

[‹ 8 What role did the state take in the creation of
capitalism?](append138.md "Go to previous page" ) [up](append13.md "Go to
parent page" ) [10 Would laissez-faire capitalism be stable?
›](append1310.md "Go to next page" )

