/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:17:00 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.KarlinSigAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class KarlinSigAlgorithm_ESTest extends KarlinSigAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Karlin Signature Difference");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      Integer integer0 = karlinSigAlgorithm0.getDefaultStepSize(10);
      assertNull(integer0);
      assertTrue(karlinSigAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Karlin Signature Difference");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      float[] floatArray0 = new float[5];
      // Undeclared exception!
      try { 
        karlinSigAlgorithm0.getValues(10, 2, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 10 > end: 3
         //
         verifyException("uk.ac.sanger.artemis.plot.KarlinSigAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Karlin Signature Difference");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      Integer integer0 = karlinSigAlgorithm0.getDefaultStepSize(1741);
      assertEquals(174, (int)integer0);
      assertTrue(karlinSigAlgorithm0.scalingFlag());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Karlin Signature Difference");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      float[] floatArray0 = new float[9];
      // Undeclared exception!
      try { 
        karlinSigAlgorithm0.getValues((-239), (-5), floatArray0);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      KarlinSigAlgorithm karlinSigAlgorithm0 = null;
      try {
        karlinSigAlgorithm0 = new KarlinSigAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Karlin Signature Difference");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      float[] floatArray0 = new float[4];
      karlinSigAlgorithm0.getValues(1, 5, floatArray0);
      karlinSigAlgorithm0.getValues(8, 912, floatArray0);
      assertArrayEquals(new float[] {Float.NaN, 0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("Karlin Signature Difference");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      Integer integer0 = karlinSigAlgorithm0.getDefaultStepSize(441);
      assertNotNull(integer0);
      assertEquals(44, (int)integer0);
      assertTrue(karlinSigAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      Integer integer0 = karlinSigAlgorithm0.getDefaultStepSize(1);
      assertNull(integer0);
      assertTrue(karlinSigAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      Integer integer0 = karlinSigAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer0);
      assertTrue(karlinSigAlgorithm0.scalingFlag());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      Integer integer0 = karlinSigAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(5000, (int)integer0);
      assertTrue(karlinSigAlgorithm0.scalingFlag());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      Integer integer0 = karlinSigAlgorithm0.getDefaultWindowSize();
      assertTrue(karlinSigAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertEquals(240, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      float[] floatArray0 = new float[9];
      // Undeclared exception!
      try { 
        karlinSigAlgorithm0.getValues((-2045), 0, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.KarlinSigAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      float[] floatArray0 = new float[5];
      // Undeclared exception!
      try { 
        karlinSigAlgorithm0.getValues(1, 5, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 1 > end: 0
         //
         verifyException("uk.ac.sanger.artemis.plot.KarlinSigAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      int int0 = karlinSigAlgorithm0.getValueCount();
      assertTrue(karlinSigAlgorithm0.scalingFlag());
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      karlinSigAlgorithm0.getAverage();
      assertTrue(karlinSigAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      Float float0 = karlinSigAlgorithm0.getMaximumInternal();
      assertTrue(karlinSigAlgorithm0.scalingFlag());
      assertEquals(2.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      KarlinSigAlgorithm karlinSigAlgorithm0 = new KarlinSigAlgorithm(strand0);
      karlinSigAlgorithm0.getMinimumInternal();
  }
}
