/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     chenhaifeng  <chenhaifeng@uniontech.com>
*
* Maintainer: chenhaifeng  <chenhaifeng@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef DHUANGLIDATABASE_H
#define DHUANGLIDATABASE_H

#include "ddatabase.h"
#include "huangliData/lunardatastruct.h"
#include "huangliData/dbusdatastruct.h"
#include "lunarandfestival.h"

class DHuangLiDataBase : public DDataBase
{
    Q_OBJECT
public:
    explicit DHuangLiDataBase(QObject *parent = nullptr);
    QString queryFestivalList(quint32 year, quint8 month);
    QList<stHuangLi> queryHuangLiByDays(const QList<stDay> &days);

    void initDBData() override;

protected:
    //创建数据库
    void createDB() override;
};

#endif // DHUANGLIDATABASE_H
