
# 关于
hooks 里面的任务, 是按照排序, 串行运行的. 如果某个hook里一个重要的步骤执行失败了,
之后的所有任务都不会被执行, 这时, 安装器会直接转到错误提醒界面. 所以, hook脚本内部
最好做好各自的清理工作.


## 文件名命名方式
* 以 `.job` 结尾
* 以两位数字开头, 比如 `01_print_info.job` , 因为hooks的执行顺序是根据文件名
 升序来排序的
* 以下划线来连接文件名中的各个段, 不要使用连字符.

## 环境
hook 脚本在被执行之前, 会先载入 hooks/basic_utils.sh 这个脚本, 它提供了一些基本的函数,
比如, 读写安装配置, 打印错误/警告信息, 判断系统架构等.

## 错误级别
hooks中, 有级错误是可以忽略的; 但是当错误会导致系统无法正常安装和使用时, 应该直接打印详细的错误
信息并退出, 通过调用 `error` 函数.

## oem
目录`oem/hooks` 用来存放自定义的 hooks, 其写法与目录结构需要与安装器
自带的hooks一致.

## hook_manager
hooks/hook_manager.sh 是所有hook脚本的入口点, 它里面处理一些环境变量, 加入一些常用的函数,
并负责处理chroot环境.

## HooksManager
service/hooks_manager.h 计算进度条时, 在 before_chroot 阶段, 使用 unsquashfs 的进度
作为当前的进度度; 在 in_chroot 和 after_chroot 阶段, 则把进度条平均分配给每个
hook 脚本.

## 架构相关的hook
比如, 只在申威平台上运行的脚本, 或者只在x86上运行的, 首先hook脚本的名称里面要说明, 比如
`49_xxxx_sw.job`, 而且在脚本里面先判断是否是需要的平台, 如果不是就打印提示并正常退出.

## 方法说明
* install_package `提供了统一的安装包的方式，因为安装器需要沉默安装`
