package org.eclipse.webdav.internal.kernel;

/*
 * (c) Copyright IBM Corp. 2000, 2001.
 * All Rights Reserved.
 */

import org.eclipse.webdav.internal.kernel.QualifiedNameImpl;

import org.eclipse.webdav.dom.QualifiedName;

public interface WebDAVPropertyNames extends WebDAVConstants {
	
	// From WebDAV (RFC2518).
	QualifiedName DAV_CREATION_DATE = new QualifiedNameImpl(DAV_URI, "creationdate");
	QualifiedName DAV_DISPLAY_NAME = new QualifiedNameImpl(DAV_URI, "displayname");
	QualifiedName DAV_GET_CONTENT_LANGUAGE = new QualifiedNameImpl(DAV_URI, "getcontentlanguage");
	QualifiedName DAV_GET_CONTENT_LENGTH = new QualifiedNameImpl(DAV_URI, "getcontentlength");
	QualifiedName DAV_GET_CONTENT_TYPE = new QualifiedNameImpl(DAV_URI, "getcontenttype");
	QualifiedName DAV_GET_E_TAG = new QualifiedNameImpl(DAV_URI, "getetag");
	QualifiedName DAV_GET_LAST_MODIFIED = new QualifiedNameImpl(DAV_URI, "getlastmodified");
	QualifiedName DAV_HREF = new QualifiedNameImpl(DAV_URI, "href");
	QualifiedName DAV_LOCK_DISCOVERY = new QualifiedNameImpl(DAV_URI, "lockdiscovery");
	QualifiedName DAV_RESOURCE_TYPE = new QualifiedNameImpl(DAV_URI, "resourcetype");
	QualifiedName DAV_SOURCE = new QualifiedNameImpl(DAV_URI, "source");
	QualifiedName DAV_SUPPORTED_LOCK = new QualifiedNameImpl(DAV_URI, "supportedlock");

	// From Delta-V.

	// Properties defined in core versioning.
	QualifiedName DAV_ACTIVITY_CHECKOUT_SET = new QualifiedNameImpl(DAV_URI, "activity-checkout-set");
	QualifiedName DAV_ACTIVITY_VERSION_SET = new QualifiedNameImpl(DAV_URI, "activity-version-set");
	QualifiedName DAV_AUTO_CHECKIN = new QualifiedNameImpl(DAV_URI, "auto-checkin");
	QualifiedName DAV_AUTO_CHECKOUT = new QualifiedNameImpl(DAV_URI, "auto-checkout");
	QualifiedName DAV_AUTO_MERGE_SET = new QualifiedNameImpl(DAV_URI, "auto-merge-set");
	QualifiedName DAV_BASELINE_CONTROLLED_COLLECTION = new QualifiedNameImpl(DAV_URI, "baseline-controlled-collection");
	QualifiedName DAV_BASELINE_COLLECTION = new QualifiedNameImpl(DAV_URI, "baseline-collection");
	QualifiedName DAV_BASELINE_CONTROLLED_COLLECTION_SET = new QualifiedNameImpl(DAV_URI, "baseline-controlled-collection-set");
	QualifiedName DAV_BASELINE_SELECTOR = new QualifiedNameImpl(DAV_URI, "baseline-selector");
	QualifiedName DAV_CHECKED_IN = new QualifiedNameImpl(DAV_URI, "checked-in");
	QualifiedName DAV_CHECKED_OUT = new QualifiedNameImpl(DAV_URI, "checked-out");
	QualifiedName DAV_CHECKIN_DATE = new QualifiedNameImpl(DAV_URI, "checkin-date");
	QualifiedName DAV_CHECKIN_FORK = new QualifiedNameImpl(DAV_URI, "checkin-fork");
	QualifiedName DAV_CHECKOUT_FORK = new QualifiedNameImpl(DAV_URI, "checkout-fork");
	QualifiedName DAV_CHECKOUT_SET = new QualifiedNameImpl(DAV_URI, "checkout-date");
	QualifiedName DAV_COMMENT = new QualifiedNameImpl(DAV_URI, "comment");
	QualifiedName DAV_CREATOR_DISPLAYNAME = new QualifiedNameImpl(DAV_URI, "creator-displayname");
	QualifiedName DAV_CURRENT_ACTIVITY_SET = new QualifiedNameImpl(DAV_URI, "current-activity-set");
	QualifiedName DAV_CURRENT_WORKSPACE_SET = new QualifiedNameImpl(DAV_URI, "current-workspace-set");
	QualifiedName DAV_LATEST_VERSION = new QualifiedNameImpl(DAV_URI, "latest-version");
	QualifiedName DAV_LABEL_NAME_SET = new QualifiedNameImpl(DAV_URI, "label-name-set");
	QualifiedName DAV_MERGE_SET = new QualifiedNameImpl(DAV_URI, "merge-set");
	QualifiedName DAV_MUTABLE = new QualifiedNameImpl(DAV_URI, "mutable");
	QualifiedName DAV_PRECURSOR_SET = new QualifiedNameImpl(DAV_URI, "precursor-set");
	QualifiedName DAV_PREDECESSOR_SET = new QualifiedNameImpl(DAV_URI, "predecessor-set");
	QualifiedName DAV_ROOT_VERSION = new QualifiedNameImpl(DAV_URI, "root-version");
	QualifiedName DAV_SUBACTIVITY_SET = new QualifiedNameImpl(DAV_URI, "subactivity-set");
	QualifiedName DAV_SUBBASELINE_SET = new QualifiedNameImpl(DAV_URI, "subbaseline-set");
	QualifiedName DAV_SUCCESSOR_SET = new QualifiedNameImpl(DAV_URI, "successor-set");
	QualifiedName DAV_SUPPORTED_LIVE_PROPERTY_SET = new QualifiedNameImpl(DAV_URI, "supported-live-property-set");
	QualifiedName DAV_SUPPORTED_METHOD_SET = new QualifiedNameImpl(DAV_URI, "supported-method-set");
	QualifiedName DAV_SUPPORTED_REPORT_SET = new QualifiedNameImpl(DAV_URI, "supported-report-set");
	QualifiedName DAV_UNRESERVED = new QualifiedNameImpl(DAV_URI, "unreserved");
	QualifiedName DAV_VERSION_CONTROLLED_CONFIGURATION = new QualifiedNameImpl(DAV_URI, "version-controlled-configuration");
	QualifiedName DAV_VERSION_HISTORY = new QualifiedNameImpl(DAV_URI, "version-history");
	QualifiedName DAV_VERSION_NAME = new QualifiedNameImpl(DAV_URI, "version-name");
	QualifiedName DAV_VERSION_SET = new QualifiedNameImpl(DAV_URI, "version-set");
	QualifiedName DAV_WORKSPACE = new QualifiedNameImpl(DAV_URI, "workspace");
	QualifiedName DAV_WORKSPACE_CHECKOUT_SET = new QualifiedNameImpl(DAV_URI, "workspace-checkout-set");
	QualifiedName DAV_WORKSPACE_COLLECTION_SET = new QualifiedNameImpl(DAV_URI, "workspace-collection-set");

	// From Bindings spec.
	QualifiedName DAV_RESOURCE_ID = new QualifiedNameImpl(DAV_URI, "resourceid");

	// Added by this server implementation.
	QualifiedName DAV_WORKING_RESOURCE = new QualifiedNameImpl(DAV_URI, "working-resource");
}