Version 0.10 has been released two and a half months after 0.9, bringing many new features and enhancements. The [second issue](newsletter-sep-2017.html) of Elvish Newsletter accompanies this release.

# Breaking changes

*   If you are upgrading from an earlier version, Elvish will complain that
    your database is not valid. This is because Elvish now uses BoltDB for
    storage. A [database migration
    tool](https://github.com/elves/upgrade-db-for-0.10) is available.

*   Breaking changes to the editor API:

    *   The `$edit:completer` map is now known as `$edit:arg-completer`.

    *   The keybinding API has been changed (again). Keybindings for different now
        live in their own subnamespaces. For instance, keybindings for insert mode
        used to be `edit:binding[insert]` but is now `edit:insert:binding`.

    *   Module names of some editor modes have also been changed for consistency.
        The completion mode now uses the `edit:completion` module (used to be
        `edit:compl`). Location mode: `edit:location`; navigation mode:
        `edit:navigation`.

    *   Byte output from prompts now preserve newlines. For instance, if you
        have `edit:prompt = { echo haha }`, you will now have a trailing
        newline in the prompt, making your command appear on the next line. To
        fix this, simple replace `echo` with `print`, which does not print a
        trailing newline. ([#354](https://github.com/elves/elvish/issues/354))

*   Breaking changes to the language core:

    *   Due to the switch to persistent data structures, assignments of maps
        now behave as if they copy the entire container. See the section in
        [some unique semantics](/learn/unique-semantics.html) for an
        explanation.

    *   The implicit `$args` variable is gone, as well as its friends:
        positional variables `$0`, `$1`, ..., and the special `$@` shorthand
        for `$@args`. Lambdas defined without argument list (`{ some code }`)
        now behave as if they have an empty argument list.
        ([#397](https://github.com/elves/elvish/issues/397))

        Old lambdas that rely on `$args` or its friends now must declare their
        arguments explicitly. For instance, `fn ls { e:ls --color=auto $@ }`
        needs to be rewritten to `fn ls [@a]{ e:ls --color=auto $@a }`.

    * Support for using backquotes for output capture (e.g. ``echo uname is
      `uname` ``) has been removed. Use parentheses instead (e.g. `echo uname
      is (uname)`).
      
    * Backquotes are repurposed for line continuation. A backquote followed by
      a newline is equivalent to a space.
      ([#417](https://github.com/elves/elvish/issues/417))

*   The signature of the `splits` builtin has been changed. The separator used
    to be an option `sep` but is now the first argument. For instance, `splits
    &sep=: a:b:c` should now be written as `splits : a:b:c`.


# Notable fixes and enhancements

*   Thanks to the BoltDB migration, Elvish is now a pure Go project! This
    allows for fully statically linked executables and easy cross compilation.
    ([#377](https://github.com/elves/elvish/issues/377))

*   Enhancements to the language core:

    *   It is now possible to define options when declaring functions
        ([#82](https://github.com/elves/elvish/issues/82)).

    * Interrupting Elvish code with Ctrl-C now works more reliably ([#388](https://github.com/elves/elvish/issues/388)).

    * Piping value outputs into a command that does not read the value input (e.g. `range 1000 | echo haha`) no longer hangs ([#389](https://github.com/elves/elvish/issues/389)).

*   New builtins functions and variables (documented in the [builtin module reference](/ref/builtin.html)):

    * New `assoc` and `dissoc` builtin that outputs modified versions of container types.

    * New `keys`, `has-keys` and `has-values` builtins ([#432](https://github.com/elves/elvish/issues/432), [#398](https://github.com/elves/elvish/issues/398), [#407](https://github.com/elves/elvish/issues/407)).

    * A new blackhole variable `$_` has been added. ([#401](https://github.com/elves/elvish/issues/401))

    * New `replaces` builtin for replacing strings. ([#463](https://github.com/elves/elvish/issues/463))

    * New `not-eq` builtin for inequality.

    * New `drop` builtin, mirroring `take`.

*   Enhancements to the editor:

    *   Matching algorithm used in completion is now programmable with
        `$edit:-matcher` ([#430](https://github.com/elves/elvish/issues/430));
        see [documentation](/ref/edit.html).

    *   Elvish can now able to complete arguments with variables. For instance,
        if you have a directory with `a.mp4` and `a.txt`, and variable `$foo`
        containing `a`, `echo $foo.<Tab>` now works
        ([#446](https://github.com/elves/elvish/issues/446)). However, the
        completion will expand `$foo` into `a`, which is not intended
        ([#474](https://github.com/elves/elvish/issues/474)).

    *   It is now possible to manipulate the cursor position using the
        experimental `$edit:-dot` variable
        ([415](https://github.com/elves/elvish/issues/415)).

    *   The default prompt now replaces `>` with a red `#` when uid = 0.

*   An experimental custom listing mode (known as "narrow mode" for now) has
    been introduced and can be started with `edit:-narrow-read`. This means
    that it is now to implement listing modes entirely in Elvish script.

    Experimental re-implementations of the several standard listing modes
    (location mode, history lising mode and lastcmd mode) are provided as the
    bundled `narrow` module. Read [its source in
    eval/narrow.elv](https://github.com/elves/elvish/blob/e7a8b96d7d4fccb7bafe01f27db9c0fe06c568b4/eval/narrow.elv)
    for more details.

*   Improvements to the daemon:

    *   The daemon now quits automatically when all Elvish sessions are closed.
        ([#419](https://github.com/elves/elvish/issues/419))

    *   The daemon can now spawned be correctly when Elvish is not installed in
        `PATH`.

*   Elvish no longer quits on SIGQUIT (usually triggered by `Ctrl-\`), matching
    the behavior of other shells. It still prints a stack trace though, which
    can be useful for debugging.
    ([#411](https://github.com/elves/elvish/issues/411))

*   A `-compileonly` flag for the Elvish binary is added. It makes Elvish
    compiles a script (in memory) but does not execute it. It can be used for
    checking the well-formedness of programs and is useful in editor plugins.
    ([#458](https://github.com/elves/elvish/issues/458))
