/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-button.h"

#include "glue.h"

#include "button_up_gui_gtk.h"

#define SCOMP		"button_up"
#define COMP_(x)	button_up_ ## x

struct cpssp {
	GtkWidget *button;

	struct sig_boolean *port_mech_button;
};

/*
 * GUI Callbacks
 */
static void
COMP_(button_press_event)(GtkWidget *w, void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	sig_boolean_set(cpssp->port_mech_button, cpssp, 1);
}

static void
COMP_(button_release_event)(GtkWidget *w, void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	sig_boolean_set(cpssp->port_mech_button, cpssp, 0);
}

void *
COMP_(gui_gtk_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_mech_button,
	struct sig_std_logic *port_button
)
{
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->port_mech_button = port_mech_button;
	sig_boolean_connect_out(port_mech_button, cpssp, 0);

	cpssp->button = gui_gtk_button_new("Press");
	g_signal_connect(G_OBJECT(cpssp->button), "button-pressed",
			G_CALLBACK(COMP_(button_press_event)), cpssp);
	g_signal_connect(G_OBJECT(cpssp->button), "button-released",
			G_CALLBACK(COMP_(button_release_event)), cpssp);

	gui_gtk_comp_add(page, SCOMP, name, cpssp->button, FALSE, FALSE, NULL);

	return cpssp;
}

void
COMP_(gui_gtk_destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(gui_gtk_suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
COMP_(gui_gtk_resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	GtkWidget *save_button = cpssp->button;

	generic_resume(cpssp, sizeof(*cpssp), fp);

	cpssp->button = save_button;
}
