/**
 * Copyright (c) 2013-2016 Jens Deters http://www.jensd.de
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package de.jensd.fx.glyphs.emojione;

import de.jensd.fx.glyphs.GlyphIcons;

/**
 *
 * Icon Enum based on Weather Icons v2.0
 *
 * @author Jens Deters (mail@jensd.de)
 * @version 2.0 (222 Icons)
 */
public enum EmojiOne implements GlyphIcons {

    _100("U+1f4af"),
    _1234("U+1f522"),
    GRINNING("U+1f600"),
    GRIN("U+1f601"),
    JOY("U+1f602"),
    ROFL("U+1f923"),
    SMILEY("U+1f603"),
    SMILE("U+1f604"),
    SWEAT_SMILE("U+1f605"),
    LAUGHING("U+1f606"),
    WINK("U+1f609"),
    BLUSH("U+1f60a"),
    YUM("U+1f60b"),
    SUNGLASSES("U+1f60e"),
    HEART_EYES("U+1f60d"),
    KISSING_HEART("U+1f618"),
    KISSING("U+1f617"),
    KISSING_SMILING_EYES("U+1f619"),
    KISSING_CLOSED_EYES("U+1f61a"),
    RELAXED("U+263a"),
    SLIGHT_SMILE("U+1f642"),
    HUGGING("U+1f917"),
    THINKING("U+1f914"),
    NEUTRAL_FACE("U+1f610"),
    EXPRESSIONLESS("U+1f611"),
    NO_MOUTH("U+1f636"),
    ROLLING_EYES("U+1f644"),
    SMIRK("U+1f60f"),
    PERSEVERE("U+1f623"),
    DISAPPOINTED_RELIEVED("U+1f625"),
    OPEN_MOUTH("U+1f62e"),
    ZIPPER_MOUTH("U+1f910"),
    HUSHED("U+1f62f"),
    SLEEPY("U+1f62a"),
    TIRED_FACE("U+1f62b"),
    SLEEPING("U+1f634"),
    RELIEVED("U+1f60c"),
    NERD("U+1f913"),
    STUCK_OUT_TONGUE("U+1f61b"),
    STUCK_OUT_TONGUE_WINKING_EYE("U+1f61c"),
    STUCK_OUT_TONGUE_CLOSED_EYES("U+1f61d"),
    DROOLING_FACE("U+1f924"),
    UNAMUSED("U+1f612"),
    SWEAT("U+1f613"),
    PENSIVE("U+1f614"),
    CONFUSED("U+1f615"),
    UPSIDE_DOWN("U+1f643"),
    MONEY_MOUTH("U+1f911"),
    ASTONISHED("U+1f632"),
    FROWNING2("U+2639"),
    SLIGHT_FROWN("U+1f641"),
    CONFOUNDED("U+1f616"),
    DISAPPOINTED("U+1f61e"),
    WORRIED("U+1f61f"),
    TRIUMPH("U+1f624"),
    CRY("U+1f622"),
    SOB("U+1f62d"),
    FROWNING("U+1f626"),
    ANGUISHED("U+1f627"),
    FEARFUL("U+1f628"),
    WEARY("U+1f629"),
    GRIMACING("U+1f62c"),
    COLD_SWEAT("U+1f630"),
    SCREAM("U+1f631"),
    FLUSHED("U+1f633"),
    DIZZY_FACE("U+1f635"),
    RAGE("U+1f621"),
    ANGRY("U+1f620"),
    INNOCENT("U+1f607"),
    COWBOY("U+1f920"),
    CLOWN("U+1f921"),
    LYING_FACE("U+1f925"),
    MASK("U+1f637"),
    THERMOMETER_FACE("U+1f912"),
    HEAD_BANDAGE("U+1f915"),
    NAUSEATED_FACE("U+1f922"),
    SNEEZING_FACE("U+1f927"),
    SMILING_IMP("U+1f608"),
    IMP("U+1f47f"),
    JAPANESE_OGRE("U+1f479"),
    JAPANESE_GOBLIN("U+1f47a"),
    SKULL("U+1f480"),
    SKULL_CROSSBONES("U+2620"),
    GHOST("U+1f47b"),
    ALIEN("U+1f47d"),
    SPACE_INVADER("U+1f47e"),
    ROBOT("U+1f916"),
    POOP("U+1f4a9"),
    SMILEY_CAT("U+1f63a"),
    SMILE_CAT("U+1f638"),
    JOY_CAT("U+1f639"),
    HEART_EYES_CAT("U+1f63b"),
    SMIRK_CAT("U+1f63c"),
    KISSING_CAT("U+1f63d"),
    SCREAM_CAT("U+1f640"),
    CRYING_CAT_FACE("U+1f63f"),
    POUTING_CAT("U+1f63e"),
    SEE_NO_EVIL("U+1f648"),
    HEAR_NO_EVIL("U+1f649"),
    SPEAK_NO_EVIL("U+1f64a"),
    BOY("U+1f466"),
    GIRL("U+1f467"),
    MAN("U+1f468"),
    WOMAN("U+1f469"),
    OLDER_MAN("U+1f474"),
    OLDER_WOMAN("U+1f475"),
    BABY("U+1f476"),
    ANGEL("U+1f47c"),
    COP("U+1f46e"),
    SPY("U+1f575"),
    GUARDSMAN("U+1f482"),
    CONSTRUCTION_WORKER("U+1f477"),
    MAN_WITH_TURBAN("U+1f473"),
    PERSON_WITH_BLOND_HAIR("U+1f471"),
    SANTA("U+1f385"),
    MRS_CLAUS("U+1f936"),
    PRINCESS("U+1f478"),
    PRINCE("U+1f934"),
    BRIDE_WITH_VEIL("U+1f470"),
    MAN_IN_TUXEDO("U+1f935"),
    PREGNANT_WOMAN("U+1f930"),
    MAN_WITH_GUA_PI_MAO("U+1f472"),
    PERSON_FROWNING("U+1f64d"),
    PERSON_WITH_POUTING_FACE("U+1f64e"),
    NO_GOOD("U+1f645"),
    OK_WOMAN("U+1f646"),
    INFORMATION_DESK_PERSON("U+1f481"),
    RAISING_HAND("U+1f64b"),
    BOW("U+1f647"),
    FACE_PALM("U+1f926"),
    SHRUG("U+1f937"),
    MASSAGE("U+1f486"),
    HAIRCUT("U+1f487"),
    WALKING("U+1f6b6"),
    RUNNER("U+1f3c3"),
    DANCER("U+1f483"),
    MAN_DANCING("U+1f57a"),
    DANCERS("U+1f46f"),
    LEVITATE("U+1f574"),
    SPEAKING_HEAD("U+1f5e3"),
    BUST_IN_SILHOUETTE("U+1f464"),
    BUSTS_IN_SILHOUETTE("U+1f465"),
    FENCER("U+1f93a"),
    HORSE_RACING("U+1f3c7"),
    SKIER("U+26f7"),
    SNOWBOARDER("U+1f3c2"),
    GOLFER("U+1f3cc"),
    SURFER("U+1f3c4"),
    ROWBOAT("U+1f6a3"),
    SWIMMER("U+1f3ca"),
    BASKETBALL_PLAYER("U+26f9"),
    LIFTER("U+1f3cb"),
    BICYCLIST("U+1f6b4"),
    MOUNTAIN_BICYCLIST("U+1f6b5"),
    RACE_CAR("U+1f3ce"),
    MOTORCYCLE("U+1f3cd"),
    CARTWHEEL("U+1f938"),
    WRESTLERS("U+1f93c"),
    WATER_POLO("U+1f93d"),
    HANDBALL("U+1f93e"),
    JUGGLING("U+1f939"),
    COUPLE("U+1f46b"),
    TWO_MEN_HOLDING_HANDS("U+1f46c"),
    TWO_WOMEN_HOLDING_HANDS("U+1f46d"),
    COUPLEKISS("U+1f48f"),
    COUPLE_WITH_HEART("U+1f491"),
    FAMILY("U+1f46a"),
    TONE1("U+1f3fb"),
    TONE2("U+1f3fc"),
    TONE3("U+1f3fd"),
    TONE4("U+1f3fe"),
    TONE5("U+1f3ff"),
    MUSCLE("U+1f4aa"),
    SELFIE("U+1f933"),
    POINT_LEFT("U+1f448"),
    POINT_RIGHT("U+1f449"),
    POINT_UP("U+261d"),
    POINT_UP_2("U+1f446"),
    MIDDLE_FINGER("U+1f595"),
    POINT_DOWN("U+1f447"),
    V("U+270c"),
    FINGERS_CROSSED("U+1f91e"),
    VULCAN("U+1f596"),
    METAL("U+1f918"),
    CALL_ME("U+1f919"),
    HAND_SPLAYED("U+1f590"),
    RAISED_HAND("U+270b"),
    OK_HAND("U+1f44c"),
    THUMBSUP("U+1f44d"),
    THUMBSDOWN("U+1f44e"),
    FIST("U+270a"),
    PUNCH("U+1f44a"),
    LEFT_FACING_FIST("U+1f91b"),
    RIGHT_FACING_FIST("U+1f91c"),
    RAISED_BACK_OF_HAND("U+1f91a"),
    WAVE("U+1f44b"),
    CLAP("U+1f44f"),
    WRITING_HAND("U+270d"),
    OPEN_HANDS("U+1f450"),
    RAISED_HANDS("U+1f64c"),
    PRAY("U+1f64f"),
    HANDSHAKE("U+1f91d"),
    NAIL_CARE("U+1f485"),
    EAR("U+1f442"),
    NOSE("U+1f443"),
    FOOTPRINTS("U+1f463"),
    EYES("U+1f440"),
    EYE("U+1f441"),
    TONGUE("U+1f445"),
    LIPS("U+1f444"),
    KISS("U+1f48b"),
    CUPID("U+1f498"),
    HEART("U+2764"),
    HEARTBEAT("U+1f493"),
    BROKEN_HEART("U+1f494"),
    TWO_HEARTS("U+1f495"),
    SPARKLING_HEART("U+1f496"),
    HEARTPULSE("U+1f497"),
    BLUE_HEART("U+1f499"),
    GREEN_HEART("U+1f49a"),
    YELLOW_HEART("U+1f49b"),
    PURPLE_HEART("U+1f49c"),
    BLACK_HEART("U+1f5a4"),
    GIFT_HEART("U+1f49d"),
    REVOLVING_HEARTS("U+1f49e"),
    HEART_DECORATION("U+1f49f"),
    HEART_EXCLAMATION("U+2763"),
    LOVE_LETTER("U+1f48c"),
    ZZZ("U+1f4a4"),
    ANGER("U+1f4a2"),
    BOMB("U+1f4a3"),
    BOOM("U+1f4a5"),
    SWEAT_DROPS("U+1f4a6"),
    DASH("U+1f4a8"),
    DIZZY("U+1f4ab"),
    SPEECH_BALLOON("U+1f4ac"),
    SPEECH_LEFT("U+1f5e8"),
    ANGER_RIGHT("U+1f5ef"),
    THOUGHT_BALLOON("U+1f4ad"),
    HOLE("U+1f573"),
    EYEGLASSES("U+1f453"),
    DARK_SUNGLASSES("U+1f576"),
    NECKTIE("U+1f454"),
    SHIRT("U+1f455"),
    JEANS("U+1f456"),
    DRESS("U+1f457"),
    KIMONO("U+1f458"),
    BIKINI("U+1f459"),
    WOMANS_CLOTHES("U+1f45a"),
    PURSE("U+1f45b"),
    HANDBAG("U+1f45c"),
    POUCH("U+1f45d"),
    SHOPPING_BAGS("U+1f6cd"),
    SCHOOL_SATCHEL("U+1f392"),
    MANS_SHOE("U+1f45e"),
    ATHLETIC_SHOE("U+1f45f"),
    HIGH_HEEL("U+1f460"),
    SANDAL("U+1f461"),
    BOOT("U+1f462"),
    CROWN("U+1f451"),
    WOMANS_HAT("U+1f452"),
    TOPHAT("U+1f3a9"),
    MORTAR_BOARD("U+1f393"),
    HELMET_WITH_CROSS("U+26d1"),
    PRAYER_BEADS("U+1f4ff"),
    LIPSTICK("U+1f484"),
    RING("U+1f48d"),
    GEM("U+1f48e"),
    MONKEY_FACE("U+1f435"),
    MONKEY("U+1f412"),
    GORILLA("U+1f98d"),
    DOG("U+1f436"),
    DOG2("U+1f415"),
    POODLE("U+1f429"),
    WOLF("U+1f43a"),
    FOX("U+1f98a"),
    CAT("U+1f431"),
    CAT2("U+1f408"),
    LION_FACE("U+1f981"),
    TIGER("U+1f42f"),
    TIGER2("U+1f405"),
    LEOPARD("U+1f406"),
    HORSE("U+1f434"),
    RACEHORSE("U+1f40e"),
    DEER("U+1f98c"),
    UNICORN("U+1f984"),
    COW("U+1f42e"),
    OX("U+1f402"),
    WATER_BUFFALO("U+1f403"),
    COW2("U+1f404"),
    PIG("U+1f437"),
    PIG2("U+1f416"),
    BOAR("U+1f417"),
    PIG_NOSE("U+1f43d"),
    RAM("U+1f40f"),
    SHEEP("U+1f411"),
    GOAT("U+1f410"),
    DROMEDARY_CAMEL("U+1f42a"),
    CAMEL("U+1f42b"),
    ELEPHANT("U+1f418"),
    RHINO("U+1f98f"),
    MOUSE("U+1f42d"),
    MOUSE2("U+1f401"),
    RAT("U+1f400"),
    HAMSTER("U+1f439"),
    RABBIT("U+1f430"),
    RABBIT2("U+1f407"),
    CHIPMUNK("U+1f43f"),
    BAT("U+1f987"),
    BEAR("U+1f43b"),
    KOALA("U+1f428"),
    PANDA_FACE("U+1f43c"),
    FEET("U+1f43e"),
    TURKEY("U+1f983"),
    CHICKEN("U+1f414"),
    ROOSTER("U+1f413"),
    HATCHING_CHICK("U+1f423"),
    BABY_CHICK("U+1f424"),
    HATCHED_CHICK("U+1f425"),
    BIRD("U+1f426"),
    PENGUIN("U+1f427"),
    DOVE("U+1f54a"),
    EAGLE("U+1f985"),
    DUCK("U+1f986"),
    OWL("U+1f989"),
    FROG("U+1f438"),
    CROCODILE("U+1f40a"),
    TURTLE("U+1f422"),
    LIZARD("U+1f98e"),
    SNAKE("U+1f40d"),
    DRAGON_FACE("U+1f432"),
    DRAGON("U+1f409"),
    WHALE("U+1f433"),
    WHALE2("U+1f40b"),
    DOLPHIN("U+1f42c"),
    FISH("U+1f41f"),
    TROPICAL_FISH("U+1f420"),
    BLOWFISH("U+1f421"),
    SHARK("U+1f988"),
    OCTOPUS("U+1f419"),
    SHELL("U+1f41a"),
    CRAB("U+1f980"),
    SHRIMP("U+1f990"),
    SQUID("U+1f991"),
    BUTTERFLY("U+1f98b"),
    SNAIL("U+1f40c"),
    BUG("U+1f41b"),
    ANT("U+1f41c"),
    BEE("U+1f41d"),
    BEETLE("U+1f41e"),
    SPIDER("U+1f577"),
    SPIDER_WEB("U+1f578"),
    SCORPION("U+1f982"),
    BOUQUET("U+1f490"),
    CHERRY_BLOSSOM("U+1f338"),
    WHITE_FLOWER("U+1f4ae"),
    ROSETTE("U+1f3f5"),
    ROSE("U+1f339"),
    WILTED_ROSE("U+1f940"),
    HIBISCUS("U+1f33a"),
    SUNFLOWER("U+1f33b"),
    BLOSSOM("U+1f33c"),
    TULIP("U+1f337"),
    SEEDLING("U+1f331"),
    EVERGREEN_TREE("U+1f332"),
    DECIDUOUS_TREE("U+1f333"),
    PALM_TREE("U+1f334"),
    CACTUS("U+1f335"),
    EAR_OF_RICE("U+1f33e"),
    HERB("U+1f33f"),
    SHAMROCK("U+2618"),
    FOUR_LEAF_CLOVER("U+1f340"),
    MAPLE_LEAF("U+1f341"),
    FALLEN_LEAF("U+1f342"),
    LEAVES("U+1f343"),
    GRAPES("U+1f347"),
    MELON("U+1f348"),
    WATERMELON("U+1f349"),
    TANGERINE("U+1f34a"),
    LEMON("U+1f34b"),
    BANANA("U+1f34c"),
    PINEAPPLE("U+1f34d"),
    APPLE("U+1f34e"),
    GREEN_APPLE("U+1f34f"),
    PEAR("U+1f350"),
    PEACH("U+1f351"),
    CHERRIES("U+1f352"),
    STRAWBERRY("U+1f353"),
    KIWI("U+1f95d"),
    TOMATO("U+1f345"),
    AVOCADO("U+1f951"),
    EGGPLANT("U+1f346"),
    POTATO("U+1f954"),
    CARROT("U+1f955"),
    CORN("U+1f33d"),
    HOT_PEPPER("U+1f336"),
    CUCUMBER("U+1f952"),
    MUSHROOM("U+1f344"),
    PEANUTS("U+1f95c"),
    CHESTNUT("U+1f330"),
    BREAD("U+1f35e"),
    CROISSANT("U+1f950"),
    FRENCH_BREAD("U+1f956"),
    PANCAKES("U+1f95e"),
    CHEESE("U+1f9c0"),
    MEAT_ON_BONE("U+1f356"),
    POULTRY_LEG("U+1f357"),
    BACON("U+1f953"),
    HAMBURGER("U+1f354"),
    FRIES("U+1f35f"),
    PIZZA("U+1f355"),
    HOTDOG("U+1f32d"),
    TACO("U+1f32e"),
    BURRITO("U+1f32f"),
    STUFFED_FLATBREAD("U+1f959"),
    EGG("U+1f95a"),
    COOKING("U+1f373"),
    SHALLOW_PAN_OF_FOOD("U+1f958"),
    STEW("U+1f372"),
    SALAD("U+1f957"),
    POPCORN("U+1f37f"),
    BENTO("U+1f371"),
    RICE_CRACKER("U+1f358"),
    RICE_BALL("U+1f359"),
    RICE("U+1f35a"),
    CURRY("U+1f35b"),
    RAMEN("U+1f35c"),
    SPAGHETTI("U+1f35d"),
    SWEET_POTATO("U+1f360"),
    ODEN("U+1f362"),
    SUSHI("U+1f363"),
    FRIED_SHRIMP("U+1f364"),
    FISH_CAKE("U+1f365"),
    DANGO("U+1f361"),
    ICECREAM("U+1f366"),
    SHAVED_ICE("U+1f367"),
    ICE_CREAM("U+1f368"),
    DOUGHNUT("U+1f369"),
    COOKIE("U+1f36a"),
    BIRTHDAY("U+1f382"),
    CAKE("U+1f370"),
    CHOCOLATE_BAR("U+1f36b"),
    CANDY("U+1f36c"),
    LOLLIPOP("U+1f36d"),
    CUSTARD("U+1f36e"),
    HONEY_POT("U+1f36f"),
    BABY_BOTTLE("U+1f37c"),
    MILK("U+1f95b"),
    COFFEE("U+2615"),
    TEA("U+1f375"),
    SAKE("U+1f376"),
    CHAMPAGNE("U+1f37e"),
    WINE_GLASS("U+1f377"),
    COCKTAIL("U+1f378"),
    TROPICAL_DRINK("U+1f379"),
    BEER("U+1f37a"),
    BEERS("U+1f37b"),
    CHAMPAGNE_GLASS("U+1f942"),
    TUMBLER_GLASS("U+1f943"),
    FORK_KNIFE_PLATE("U+1f37d"),
    FORK_AND_KNIFE("U+1f374"),
    SPOON("U+1f944"),
    KNIFE("U+1f52a"),
    AMPHORA("U+1f3fa"),
    EARTH_AFRICA("U+1f30d"),
    EARTH_AMERICAS("U+1f30e"),
    EARTH_ASIA("U+1f30f"),
    GLOBE_WITH_MERIDIANS("U+1f310"),
    MAP("U+1f5fa"),
    JAPAN("U+1f5fe"),
    MOUNTAIN_SNOW("U+1f3d4"),
    MOUNTAIN("U+26f0"),
    VOLCANO("U+1f30b"),
    MOUNT_FUJI("U+1f5fb"),
    CAMPING("U+1f3d5"),
    BEACH("U+1f3d6"),
    DESERT("U+1f3dc"),
    ISLAND("U+1f3dd"),
    PARK("U+1f3de"),
    STADIUM("U+1f3df"),
    CLASSICAL_BUILDING("U+1f3db"),
    CONSTRUCTION_SITE("U+1f3d7"),
    HOMES("U+1f3d8"),
    CITYSCAPE("U+1f3d9"),
    HOUSE_ABANDONED("U+1f3da"),
    HOUSE("U+1f3e0"),
    HOUSE_WITH_GARDEN("U+1f3e1"),
    OFFICE("U+1f3e2"),
    POST_OFFICE("U+1f3e3"),
    EUROPEAN_POST_OFFICE("U+1f3e4"),
    HOSPITAL("U+1f3e5"),
    BANK("U+1f3e6"),
    HOTEL("U+1f3e8"),
    LOVE_HOTEL("U+1f3e9"),
    CONVENIENCE_STORE("U+1f3ea"),
    SCHOOL("U+1f3eb"),
    DEPARTMENT_STORE("U+1f3ec"),
    FACTORY("U+1f3ed"),
    JAPANESE_CASTLE("U+1f3ef"),
    EUROPEAN_CASTLE("U+1f3f0"),
    WEDDING("U+1f492"),
    TOKYO_TOWER("U+1f5fc"),
    STATUE_OF_LIBERTY("U+1f5fd"),
    CHURCH("U+26ea"),
    MOSQUE("U+1f54c"),
    SYNAGOGUE("U+1f54d"),
    SHINTO_SHRINE("U+26e9"),
    KAABA("U+1f54b"),
    FOUNTAIN("U+26f2"),
    TENT("U+26fa"),
    FOGGY("U+1f301"),
    NIGHT_WITH_STARS("U+1f303"),
    SUNRISE_OVER_MOUNTAINS("U+1f304"),
    SUNRISE("U+1f305"),
    CITY_DUSK("U+1f306"),
    CITY_SUNSET("U+1f307"),
    BRIDGE_AT_NIGHT("U+1f309"),
    HOTSPRINGS("U+2668"),
    MILKY_WAY("U+1f30c"),
    CAROUSEL_HORSE("U+1f3a0"),
    FERRIS_WHEEL("U+1f3a1"),
    ROLLER_COASTER("U+1f3a2"),
    BARBER("U+1f488"),
    CIRCUS_TENT("U+1f3aa"),
    PERFORMING_ARTS("U+1f3ad"),
    FRAME_PHOTO("U+1f5bc"),
    ART("U+1f3a8"),
    SLOT_MACHINE("U+1f3b0"),
    STEAM_LOCOMOTIVE("U+1f682"),
    RAILWAY_CAR("U+1f683"),
    BULLETTRAIN_SIDE("U+1f684"),
    BULLETTRAIN_FRONT("U+1f685"),
    TRAIN2("U+1f686"),
    METRO("U+1f687"),
    LIGHT_RAIL("U+1f688"),
    STATION("U+1f689"),
    TRAM("U+1f68a"),
    MONORAIL("U+1f69d"),
    MOUNTAIN_RAILWAY("U+1f69e"),
    TRAIN("U+1f68b"),
    BUS("U+1f68c"),
    ONCOMING_BUS("U+1f68d"),
    TROLLEYBUS("U+1f68e"),
    MINIBUS("U+1f690"),
    AMBULANCE("U+1f691"),
    FIRE_ENGINE("U+1f692"),
    POLICE_CAR("U+1f693"),
    ONCOMING_POLICE_CAR("U+1f694"),
    TAXI("U+1f695"),
    ONCOMING_TAXI("U+1f696"),
    RED_CAR("U+1f697"),
    ONCOMING_AUTOMOBILE("U+1f698"),
    BLUE_CAR("U+1f699"),
    TRUCK("U+1f69a"),
    ARTICULATED_LORRY("U+1f69b"),
    TRACTOR("U+1f69c"),
    BIKE("U+1f6b2"),
    SCOOTER("U+1f6f4"),
    MOTOR_SCOOTER("U+1f6f5"),
    BUSSTOP("U+1f68f"),
    MOTORWAY("U+1f6e3"),
    RAILWAY_TRACK("U+1f6e4"),
    FUELPUMP("U+26fd"),
    ROTATING_LIGHT("U+1f6a8"),
    TRAFFIC_LIGHT("U+1f6a5"),
    VERTICAL_TRAFFIC_LIGHT("U+1f6a6"),
    CONSTRUCTION("U+1f6a7"),
    OCTAGONAL_SIGN("U+1f6d1"),
    ANCHOR("U+2693"),
    SAILBOAT("U+26f5"),
    CANOE("U+1f6f6"),
    SPEEDBOAT("U+1f6a4"),
    CRUISE_SHIP("U+1f6f3"),
    FERRY("U+26f4"),
    MOTORBOAT("U+1f6e5"),
    SHIP("U+1f6a2"),
    AIRPLANE("U+2708"),
    AIRPLANE_SMALL("U+1f6e9"),
    AIRPLANE_DEPARTURE("U+1f6eb"),
    AIRPLANE_ARRIVING("U+1f6ec"),
    SEAT("U+1f4ba"),
    HELICOPTER("U+1f681"),
    SUSPENSION_RAILWAY("U+1f69f"),
    MOUNTAIN_CABLEWAY("U+1f6a0"),
    AERIAL_TRAMWAY("U+1f6a1"),
    ROCKET("U+1f680"),
    SATELLITE_ORBITAL("U+1f6f0"),
    BELLHOP("U+1f6ce"),
    DOOR("U+1f6aa"),
    SLEEPING_ACCOMMODATION("U+1f6cc"),
    BED("U+1f6cf"),
    COUCH("U+1f6cb"),
    TOILET("U+1f6bd"),
    SHOWER("U+1f6bf"),
    BATH("U+1f6c0"),
    BATHTUB("U+1f6c1"),
    HOURGLASS("U+231b"),
    HOURGLASS_FLOWING_SAND("U+23f3"),
    WATCH("U+231a"),
    ALARM_CLOCK("U+23f0"),
    STOPWATCH("U+23f1"),
    TIMER("U+23f2"),
    CLOCK("U+1f570"),
    CLOCK12("U+1f55b"),
    CLOCK1230("U+1f567"),
    CLOCK1("U+1f550"),
    CLOCK130("U+1f55c"),
    CLOCK2("U+1f551"),
    CLOCK230("U+1f55d"),
    CLOCK3("U+1f552"),
    CLOCK330("U+1f55e"),
    CLOCK4("U+1f553"),
    CLOCK430("U+1f55f"),
    CLOCK5("U+1f554"),
    CLOCK530("U+1f560"),
    CLOCK6("U+1f555"),
    CLOCK630("U+1f561"),
    CLOCK7("U+1f556"),
    CLOCK730("U+1f562"),
    CLOCK8("U+1f557"),
    CLOCK830("U+1f563"),
    CLOCK9("U+1f558"),
    CLOCK930("U+1f564"),
    CLOCK10("U+1f559"),
    CLOCK1030("U+1f565"),
    CLOCK11("U+1f55a"),
    CLOCK1130("U+1f566"),
    NEW_MOON("U+1f311"),
    WAXING_CRESCENT_MOON("U+1f312"),
    FIRST_QUARTER_MOON("U+1f313"),
    WAXING_GIBBOUS_MOON("U+1f314"),
    FULL_MOON("U+1f315"),
    WANING_GIBBOUS_MOON("U+1f316"),
    LAST_QUARTER_MOON("U+1f317"),
    WANING_CRESCENT_MOON("U+1f318"),
    CRESCENT_MOON("U+1f319"),
    NEW_MOON_WITH_FACE("U+1f31a"),
    FIRST_QUARTER_MOON_WITH_FACE("U+1f31b"),
    LAST_QUARTER_MOON_WITH_FACE("U+1f31c"),
    THERMOMETER("U+1f321"),
    SUNNY("U+2600"),
    FULL_MOON_WITH_FACE("U+1f31d"),
    SUN_WITH_FACE("U+1f31e"),
    STAR("U+2b50"),
    STAR2("U+1f31f"),
    STARS("U+1f320"),
    CLOUD("U+2601"),
    PARTLY_SUNNY("U+26c5"),
    THUNDER_CLOUD_RAIN("U+26c8"),
    WHITE_SUN_SMALL_CLOUD("U+1f324"),
    WHITE_SUN_CLOUD("U+1f325"),
    WHITE_SUN_RAIN_CLOUD("U+1f326"),
    CLOUD_RAIN("U+1f327"),
    CLOUD_SNOW("U+1f328"),
    CLOUD_LIGHTNING("U+1f329"),
    CLOUD_TORNADO("U+1f32a"),
    FOG("U+1f32b"),
    WIND_BLOWING_FACE("U+1f32c"),
    CYCLONE("U+1f300"),
    RAINBOW("U+1f308"),
    CLOSED_UMBRELLA("U+1f302"),
    UMBRELLA2("U+2602"),
    UMBRELLA("U+2614"),
    BEACH_UMBRELLA("U+26f1"),
    ZAP("U+26a1"),
    SNOWFLAKE("U+2744"),
    SNOWMAN2("U+2603"),
    SNOWMAN("U+26c4"),
    COMET("U+2604"),
    FIRE("U+1f525"),
    DROPLET("U+1f4a7"),
    OCEAN("U+1f30a"),
    JACK_O_LANTERN("U+1f383"),
    CHRISTMAS_TREE("U+1f384"),
    FIREWORKS("U+1f386"),
    SPARKLER("U+1f387"),
    SPARKLES("U+2728"),
    BALLOON("U+1f388"),
    TADA("U+1f389"),
    CONFETTI_BALL("U+1f38a"),
    TANABATA_TREE("U+1f38b"),
    BAMBOO("U+1f38d"),
    DOLLS("U+1f38e"),
    FLAGS("U+1f38f"),
    WIND_CHIME("U+1f390"),
    RICE_SCENE("U+1f391"),
    RIBBON("U+1f380"),
    GIFT("U+1f381"),
    REMINDER_RIBBON("U+1f397"),
    TICKETS("U+1f39f"),
    TICKET("U+1f3ab"),
    MILITARY_MEDAL("U+1f396"),
    TROPHY("U+1f3c6"),
    MEDAL("U+1f3c5"),
    FIRST_PLACE("U+1f947"),
    SECOND_PLACE("U+1f948"),
    THIRD_PLACE("U+1f949"),
    SOCCER("U+26bd"),
    BASEBALL("U+26be"),
    BASKETBALL("U+1f3c0"),
    VOLLEYBALL("U+1f3d0"),
    FOOTBALL("U+1f3c8"),
    RUGBY_FOOTBALL("U+1f3c9"),
    TENNIS("U+1f3be"),
    _8BALL("U+1f3b1"),
    BOWLING("U+1f3b3"),
    CRICKET("U+1f3cf"),
    FIELD_HOCKEY("U+1f3d1"),
    HOCKEY("U+1f3d2"),
    PING_PONG("U+1f3d3"),
    BADMINTON("U+1f3f8"),
    BOXING_GLOVE("U+1f94a"),
    MARTIAL_ARTS_UNIFORM("U+1f94b"),
    GOAL("U+1f945"),
    DART("U+1f3af"),
    GOLF("U+26f3"),
    ICE_SKATE("U+26f8"),
    FISHING_POLE_AND_FISH("U+1f3a3"),
    RUNNING_SHIRT_WITH_SASH("U+1f3bd"),
    SKI("U+1f3bf"),
    VIDEO_GAME("U+1f3ae"),
    JOYSTICK("U+1f579"),
    GAME_DIE("U+1f3b2"),
    SPADES("U+2660"),
    HEARTS("U+2665"),
    DIAMONDS("U+2666"),
    CLUBS("U+2663"),
    BLACK_JOKER("U+1f0cf"),
    MAHJONG("U+1f004"),
    FLOWER_PLAYING_CARDS("U+1f3b4"),
    MUTE("U+1f507"),
    SPEAKER("U+1f508"),
    SOUND("U+1f509"),
    LOUD_SOUND("U+1f50a"),
    LOUDSPEAKER("U+1f4e2"),
    MEGA("U+1f4e3"),
    POSTAL_HORN("U+1f4ef"),
    BELL("U+1f514"),
    NO_BELL("U+1f515"),
    MUSICAL_SCORE("U+1f3bc"),
    MUSICAL_NOTE("U+1f3b5"),
    NOTES("U+1f3b6"),
    MICROPHONE2("U+1f399"),
    LEVEL_SLIDER("U+1f39a"),
    CONTROL_KNOBS("U+1f39b"),
    MICROPHONE("U+1f3a4"),
    HEADPHONES("U+1f3a7"),
    RADIO("U+1f4fb"),
    SAXOPHONE("U+1f3b7"),
    GUITAR("U+1f3b8"),
    MUSICAL_KEYBOARD("U+1f3b9"),
    TRUMPET("U+1f3ba"),
    VIOLIN("U+1f3bb"),
    DRUM("U+1f941"),
    IPHONE("U+1f4f1"),
    CALLING("U+1f4f2"),
    TELEPHONE("U+260e"),
    TELEPHONE_RECEIVER("U+1f4de"),
    PAGER("U+1f4df"),
    FAX("U+1f4e0"),
    BATTERY("U+1f50b"),
    ELECTRIC_PLUG("U+1f50c"),
    COMPUTER("U+1f4bb"),
    DESKTOP("U+1f5a5"),
    PRINTER("U+1f5a8"),
    KEYBOARD("U+2328"),
    MOUSE_THREE_BUTTON("U+1f5b1"),
    TRACKBALL("U+1f5b2"),
    MINIDISC("U+1f4bd"),
    FLOPPY_DISK("U+1f4be"),
    CD("U+1f4bf"),
    DVD("U+1f4c0"),
    MOVIE_CAMERA("U+1f3a5"),
    FILM_FRAMES("U+1f39e"),
    PROJECTOR("U+1f4fd"),
    CLAPPER("U+1f3ac"),
    TV("U+1f4fa"),
    CAMERA("U+1f4f7"),
    CAMERA_WITH_FLASH("U+1f4f8"),
    VIDEO_CAMERA("U+1f4f9"),
    VHS("U+1f4fc"),
    MAG("U+1f50d"),
    MAG_RIGHT("U+1f50e"),
    MICROSCOPE("U+1f52c"),
    TELESCOPE("U+1f52d"),
    SATELLITE("U+1f4e1"),
    CANDLE("U+1f56f"),
    BULB("U+1f4a1"),
    FLASHLIGHT("U+1f526"),
    IZAKAYA_LANTERN("U+1f3ee"),
    NOTEBOOK_WITH_DECORATIVE_COVER("U+1f4d4"),
    CLOSED_BOOK("U+1f4d5"),
    BOOK("U+1f4d6"),
    GREEN_BOOK("U+1f4d7"),
    BLUE_BOOK("U+1f4d8"),
    ORANGE_BOOK("U+1f4d9"),
    BOOKS("U+1f4da"),
    NOTEBOOK("U+1f4d3"),
    LEDGER("U+1f4d2"),
    PAGE_WITH_CURL("U+1f4c3"),
    SCROLL("U+1f4dc"),
    PAGE_FACING_UP("U+1f4c4"),
    NEWSPAPER("U+1f4f0"),
    NEWSPAPER2("U+1f5de"),
    BOOKMARK_TABS("U+1f4d1"),
    BOOKMARK("U+1f516"),
    LABEL("U+1f3f7"),
    MONEYBAG("U+1f4b0"),
    YEN("U+1f4b4"),
    DOLLAR("U+1f4b5"),
    EURO("U+1f4b6"),
    POUND("U+1f4b7"),
    MONEY_WITH_WINGS("U+1f4b8"),
    CREDIT_CARD("U+1f4b3"),
    CHART("U+1f4b9"),
    CURRENCY_EXCHANGE("U+1f4b1"),
    HEAVY_DOLLAR_SIGN("U+1f4b2"),
    ENVELOPE("U+2709"),
    E_MAIL("U+1f4e7"),
    INCOMING_ENVELOPE("U+1f4e8"),
    ENVELOPE_WITH_ARROW("U+1f4e9"),
    OUTBOX_TRAY("U+1f4e4"),
    INBOX_TRAY("U+1f4e5"),
    PACKAGE("U+1f4e6"),
    MAILBOX("U+1f4eb"),
    MAILBOX_CLOSED("U+1f4ea"),
    MAILBOX_WITH_MAIL("U+1f4ec"),
    MAILBOX_WITH_NO_MAIL("U+1f4ed"),
    POSTBOX("U+1f4ee"),
    BALLOT_BOX("U+1f5f3"),
    PENCIL2("U+270f"),
    BLACK_NIB("U+2712"),
    PEN_FOUNTAIN("U+1f58b"),
    PEN_BALLPOINT("U+1f58a"),
    PAINTBRUSH("U+1f58c"),
    CRAYON("U+1f58d"),
    PENCIL("U+1f4dd"),
    BRIEFCASE("U+1f4bc"),
    FILE_FOLDER("U+1f4c1"),
    OPEN_FILE_FOLDER("U+1f4c2"),
    DIVIDERS("U+1f5c2"),
    DATE("U+1f4c5"),
    CALENDAR("U+1f4c6"),
    NOTEPAD_SPIRAL("U+1f5d2"),
    CALENDAR_SPIRAL("U+1f5d3"),
    CARD_INDEX("U+1f4c7"),
    CHART_WITH_UPWARDS_TREND("U+1f4c8"),
    CHART_WITH_DOWNWARDS_TREND("U+1f4c9"),
    BAR_CHART("U+1f4ca"),
    CLIPBOARD("U+1f4cb"),
    PUSHPIN("U+1f4cc"),
    ROUND_PUSHPIN("U+1f4cd"),
    PAPERCLIP("U+1f4ce"),
    PAPERCLIPS("U+1f587"),
    STRAIGHT_RULER("U+1f4cf"),
    TRIANGULAR_RULER("U+1f4d0"),
    SCISSORS("U+2702"),
    CARD_BOX("U+1f5c3"),
    FILE_CABINET("U+1f5c4"),
    WASTEBASKET("U+1f5d1"),
    LOCK("U+1f512"),
    UNLOCK("U+1f513"),
    LOCK_WITH_INK_PEN("U+1f50f"),
    CLOSED_LOCK_WITH_KEY("U+1f510"),
    KEY("U+1f511"),
    KEY2("U+1f5dd"),
    HAMMER("U+1f528"),
    PICK("U+26cf"),
    HAMMER_PICK("U+2692"),
    TOOLS("U+1f6e0"),
    DAGGER("U+1f5e1"),
    CROSSED_SWORDS("U+2694"),
    GUN("U+1f52b"),
    BOW_AND_ARROW("U+1f3f9"),
    SHIELD("U+1f6e1"),
    WRENCH("U+1f527"),
    NUT_AND_BOLT("U+1f529"),
    GEAR("U+2699"),
    COMPRESSION("U+1f5dc"),
    ALEMBIC("U+2697"),
    SCALES("U+2696"),
    LINK("U+1f517"),
    CHAINS("U+26d3"),
    SYRINGE("U+1f489"),
    PILL("U+1f48a"),
    SMOKING("U+1f6ac"),
    COFFIN("U+26b0"),
    URN("U+26b1"),
    MOYAI("U+1f5ff"),
    OIL("U+1f6e2"),
    CRYSTAL_BALL("U+1f52e"),
    SHOPPING_CART("U+1f6d2"),
    ATM("U+1f3e7"),
    PUT_LITTER_IN_ITS_PLACE("U+1f6ae"),
    POTABLE_WATER("U+1f6b0"),
    WHEELCHAIR("U+267f"),
    MENS("U+1f6b9"),
    WOMENS("U+1f6ba"),
    RESTROOM("U+1f6bb"),
    BABY_SYMBOL("U+1f6bc"),
    WC("U+1f6be"),
    PASSPORT_CONTROL("U+1f6c2"),
    CUSTOMS("U+1f6c3"),
    BAGGAGE_CLAIM("U+1f6c4"),
    LEFT_LUGGAGE("U+1f6c5"),
    WARNING("U+26a0"),
    CHILDREN_CROSSING("U+1f6b8"),
    NO_ENTRY("U+26d4"),
    NO_ENTRY_SIGN("U+1f6ab"),
    NO_BICYCLES("U+1f6b3"),
    NO_SMOKING("U+1f6ad"),
    DO_NOT_LITTER("U+1f6af"),
    NON_POTABLE_WATER("U+1f6b1"),
    NO_PEDESTRIANS("U+1f6b7"),
    NO_MOBILE_PHONES("U+1f4f5"),
    UNDERAGE("U+1f51e"),
    RADIOACTIVE("U+2622"),
    BIOHAZARD("U+2623"),
    ARROW_UP("U+2b06"),
    ARROW_UPPER_RIGHT("U+2197"),
    ARROW_RIGHT("U+27a1"),
    ARROW_LOWER_RIGHT("U+2198"),
    ARROW_DOWN("U+2b07"),
    ARROW_LOWER_LEFT("U+2199"),
    ARROW_LEFT("U+2b05"),
    ARROW_UPPER_LEFT("U+2196"),
    ARROW_UP_DOWN("U+2195"),
    LEFT_RIGHT_ARROW("U+2194"),
    LEFTWARDS_ARROW_WITH_HOOK("U+21a9"),
    ARROW_RIGHT_HOOK("U+21aa"),
    ARROW_HEADING_UP("U+2934"),
    ARROW_HEADING_DOWN("U+2935"),
    ARROWS_CLOCKWISE("U+1f503"),
    ARROWS_COUNTERCLOCKWISE("U+1f504"),
    BACK("U+1f519"),
    END("U+1f51a"),
    ON("U+1f51b"),
    SOON("U+1f51c"),
    TOP("U+1f51d"),
    PLACE_OF_WORSHIP("U+1f6d0"),
    ATOM("U+269b"),
    OM_SYMBOL("U+1f549"),
    STAR_OF_DAVID("U+2721"),
    WHEEL_OF_DHARMA("U+2638"),
    YIN_YANG("U+262f"),
    CROSS("U+271d"),
    ORTHODOX_CROSS("U+2626"),
    STAR_AND_CRESCENT("U+262a"),
    PEACE("U+262e"),
    MENORAH("U+1f54e"),
    SIX_POINTED_STAR("U+1f52f"),
    ARIES("U+2648"),
    TAURUS("U+2649"),
    GEMINI("U+264a"),
    CANCER("U+264b"),
    LEO("U+264c"),
    VIRGO("U+264d"),
    LIBRA("U+264e"),
    SCORPIUS("U+264f"),
    SAGITTARIUS("U+2650"),
    CAPRICORN("U+2651"),
    AQUARIUS("U+2652"),
    PISCES("U+2653"),
    OPHIUCHUS("U+26ce"),
    TWISTED_RIGHTWARDS_ARROWS("U+1f500"),
    REPEAT("U+1f501"),
    REPEAT_ONE("U+1f502"),
    ARROW_FORWARD("U+25b6"),
    FAST_FORWARD("U+23e9"),
    TRACK_NEXT("U+23ed"),
    PLAY_PAUSE("U+23ef"),
    ARROW_BACKWARD("U+25c0"),
    REWIND("U+23ea"),
    TRACK_PREVIOUS("U+23ee"),
    ARROW_UP_SMALL("U+1f53c"),
    ARROW_DOUBLE_UP("U+23eb"),
    ARROW_DOWN_SMALL("U+1f53d"),
    ARROW_DOUBLE_DOWN("U+23ec"),
    PAUSE_BUTTON("U+23f8"),
    STOP_BUTTON("U+23f9"),
    RECORD_BUTTON("U+23fa"),
    EJECT("U+23cf"),
    CINEMA("U+1f3a6"),
    LOW_BRIGHTNESS("U+1f505"),
    HIGH_BRIGHTNESS("U+1f506"),
    SIGNAL_STRENGTH("U+1f4f6"),
    VIBRATION_MODE("U+1f4f3"),
    MOBILE_PHONE_OFF("U+1f4f4"),
    RECYCLE("U+267b"),
    NAME_BADGE("U+1f4db"),
    FLEUR_DE_LIS("U+269c"),
    BEGINNER("U+1f530"),
    TRIDENT("U+1f531"),
    O("U+2b55"),
    WHITE_CHECK_MARK("U+2705"),
    BALLOT_BOX_WITH_CHECK("U+2611"),
    HEAVY_CHECK_MARK("U+2714"),
    HEAVY_MULTIPLICATION_X("U+2716"),
    X("U+274c"),
    NEGATIVE_SQUARED_CROSS_MARK("U+274e"),
    HEAVY_PLUS_SIGN("U+2795"),
    HEAVY_MINUS_SIGN("U+2796"),
    HEAVY_DIVISION_SIGN("U+2797"),
    CURLY_LOOP("U+27b0"),
    LOOP("U+27bf"),
    PART_ALTERNATION_MARK("U+303d"),
    EIGHT_SPOKED_ASTERISK("U+2733"),
    EIGHT_POINTED_BLACK_STAR("U+2734"),
    SPARKLE("U+2747"),
    BANGBANG("U+203c"),
    INTERROBANG("U+2049"),
    QUESTION("U+2753"),
    GREY_QUESTION("U+2754"),
    GREY_EXCLAMATION("U+2755"),
    EXCLAMATION("U+2757"),
    WAVY_DASH("U+3030"),
    COPYRIGHT("U+00a9"),
    REGISTERED("U+00ae"),
    TM("U+2122"),
    KEYCAP_TEN("U+1f51f"),
    CAPITAL_ABCD("U+1f520"),
    ABCD("U+1f521"),
    SYMBOLS("U+1f523"),
    ABC("U+1f524"),
    A("U+1f170"),
    AB("U+1f18e"),
    B("U+1f171"),
    CL("U+1f191"),
    COOL("U+1f192"),
    FREE("U+1f193"),
    INFORMATION_SOURCE("U+2139"),
    ID("U+1f194"),
    M("U+24c2"),
    NEW("U+1f195"),
    NG("U+1f196"),
    O2("U+1f17e"),
    OK("U+1f197"),
    PARKING("U+1f17f"),
    SOS("U+1f198"),
    UP("U+1f199"),
    VS("U+1f19a"),
    KOKO("U+1f201"),
    SA("U+1f202"),
    U6708("U+1f237"),
    U6709("U+1f236"),
    U6307("U+1f22f"),
    IDEOGRAPH_ADVANTAGE("U+1f250"),
    U5272("U+1f239"),
    U7121("U+1f21a"),
    U7981("U+1f232"),
    ACCEPT("U+1f251"),
    U7533("U+1f238"),
    U5408("U+1f234"),
    U7A7A("U+1f233"),
    CONGRATULATIONS("U+3297"),
    SECRET("U+3299"),
    U55B6("U+1f23a"),
    U6E80("U+1f235"),
    BLACK_SMALL_SQUARE("U+25aa"),
    WHITE_SMALL_SQUARE("U+25ab"),
    WHITE_MEDIUM_SQUARE("U+25fb"),
    BLACK_MEDIUM_SQUARE("U+25fc"),
    WHITE_MEDIUM_SMALL_SQUARE("U+25fd"),
    BLACK_MEDIUM_SMALL_SQUARE("U+25fe"),
    BLACK_LARGE_SQUARE("U+2b1b"),
    WHITE_LARGE_SQUARE("U+2b1c"),
    LARGE_ORANGE_DIAMOND("U+1f536"),
    LARGE_BLUE_DIAMOND("U+1f537"),
    SMALL_ORANGE_DIAMOND("U+1f538"),
    SMALL_BLUE_DIAMOND("U+1f539"),
    SMALL_RED_TRIANGLE("U+1f53a"),
    SMALL_RED_TRIANGLE_DOWN("U+1f53b"),
    DIAMOND_SHAPE_WITH_A_DOT_INSIDE("U+1f4a0"),
    RADIO_BUTTON("U+1f518"),
    BLACK_SQUARE_BUTTON("U+1f532"),
    WHITE_SQUARE_BUTTON("U+1f533"),
    WHITE_CIRCLE("U+26aa"),
    BLACK_CIRCLE("U+26ab"),
    RED_CIRCLE("U+1f534"),
    BLUE_CIRCLE("U+1f535"),
    CHECKERED_FLAG("U+1f3c1"),
    TRIANGULAR_FLAG_ON_POST("U+1f6a9"),
    CROSSED_FLAGS("U+1f38c"),
    FLAG_BLACK("U+1f3f4"),
    FLAG_WHITE("U+1f3f3"),
    REGIONAL_INDICATOR_Z("U+1f1ff"),
    REGIONAL_INDICATOR_Y("U+1f1fe"),
    REGIONAL_INDICATOR_X("U+1f1fd"),
    REGIONAL_INDICATOR_W("U+1f1fc"),
    REGIONAL_INDICATOR_V("U+1f1fb"),
    REGIONAL_INDICATOR_U("U+1f1fa"),
    REGIONAL_INDICATOR_T("U+1f1f9"),
    REGIONAL_INDICATOR_S("U+1f1f8"),
    REGIONAL_INDICATOR_R("U+1f1f7"),
    REGIONAL_INDICATOR_Q("U+1f1f6"),
    REGIONAL_INDICATOR_P("U+1f1f5"),
    REGIONAL_INDICATOR_O("U+1f1f4"),
    REGIONAL_INDICATOR_N("U+1f1f3"),
    REGIONAL_INDICATOR_M("U+1f1f2"),
    REGIONAL_INDICATOR_L("U+1f1f1"),
    REGIONAL_INDICATOR_K("U+1f1f0"),
    REGIONAL_INDICATOR_J("U+1f1ef"),
    REGIONAL_INDICATOR_I("U+1f1ee"),
    REGIONAL_INDICATOR_H("U+1f1ed"),
    REGIONAL_INDICATOR_G("U+1f1ec"),
    REGIONAL_INDICATOR_F("U+1f1eb"),
    REGIONAL_INDICATOR_E("U+1f1ea"),
    REGIONAL_INDICATOR_D("U+1f1e9"),
    REGIONAL_INDICATOR_C("U+1f1e8"),
    REGIONAL_INDICATOR_B("U+1f1e7"),
    REGIONAL_INDICATOR_A("U+1f1e6");

    private final String unicode;

    private EmojiOne(String codeposition) {
        this.unicode = convert(codeposition);
    }

    private String convert(String codeposition) {
        int code = Integer.parseInt(codeposition.substring(2), 16);
        return new String(Character.toChars(code));
    }

    @Override
    public String unicode() {
        return unicode;
    }

    @Override
    public String fontFamily() {
        return "emojione";
    }

}
