#ifndef _HERMES_RID_H
#define _HERMES_RID_H

/*
 * Configuration RIDs
 */
#define HERMES_RID_CNFPORTTYPE			0xFC00	/* used */
#define HERMES_RID_CNFOWNMACADDR		0xFC01	/* used */
#define HERMES_RID_CNFDESIREDSSID		0xFC02	/* used */
#define HERMES_RID_CNFOWNCHANNEL		0xFC03	/* used */
#define HERMES_RID_CNFOWNSSID			0xFC04	/* used */
#define HERMES_RID_CNFOWNATIMWINDOW		0xFC05
#define HERMES_RID_CNFSYSTEMSCALE		0xFC06	/* used */
#define HERMES_RID_CNFMAXDATALEN		0xFC07
#define HERMES_RID_CNFWDSADDRESS		0xFC08
#define HERMES_RID_CNFPMENABLED			0xFC09	/* used */
#define HERMES_RID_CNFPMEPS			0xFC0A
#define HERMES_RID_CNFMULTICASTRECEIVE		0xFC0B	/* used */
#define HERMES_RID_CNFMAXSLEEPDURATION		0xFC0C	/* used */
#define HERMES_RID_CNFPMHOLDOVERDURATION	0xFC0D	/* used */
#define HERMES_RID_CNFOWNNAME			0xFC0E	/* used */
#define HERMES_RID_CNFOWNDTIMPERIOD		0xFC10
#define HERMES_RID_CNFWDSADDRESS1		0xFC11
#define HERMES_RID_CNFWDSADDRESS2		0xFC12
#define HERMES_RID_CNFWDSADDRESS3		0xFC13
#define HERMES_RID_CNFWDSADDRESS4		0xFC14
#define HERMES_RID_CNFWDSADDRESS5		0xFC15
#define HERMES_RID_CNFWDSADDRESS6		0xFC16
#define HERMES_RID_CNFMULTICASTPMBUFFERING	0xFC17
#define HERMES_RID_CNFWEPENABLED_AGERE		0xFC20	/* used */
#define HERMES_RID_CNFMANDATORYBSSID_SYMBOL	0xFC21
#define HERMES_RID_CNFWEPDEFAULTKEYID		0xFC23	/* used */
#define HERMES_RID_CNFDEFAULTKEY0		0xFC24	/* used */
#define HERMES_RID_CNFDEFAULTKEY1		0xFC25	/* used */
#define HERMES_RID_CNFMWOROBUST_AGERE		0xFC25	/* used */
#define HERMES_RID_CNFDEFAULTKEY2		0xFC26	/* used */
#define HERMES_RID_CNFDEFAULTKEY3		0xFC27	/* used */
#define HERMES_RID_CNFWEPFLAGS_INTERSIL		0xFC28	/* used */
#define HERMES_RID_CNFWEPKEYMAPPINGTABLE	0xFC29
#define HERMES_RID_CNFAUTHENTICATION		0xFC2A	/* used */
#define HERMES_RID_CNFMAXASSOCSTA		0xFC2B
#define	HERMES_RID_CNFKEYLENGTH_SYMBOL		0xFC2B
#define HERMES_RID_CNFTXCONTROL			0xFC2C
#define HERMES_RID_CNFROAMINGMODE		0xFC2D
#define HERMES_RID_CNFHOSTAUTHENTICATION	0xFC2E
#define HERMES_RID_CNFRCVCRCERROR		0xFC30
#define HERMES_RID_CNFMMLIFE			0xFC31
#define HERMES_RID_CNFALTRETRYCOUNT		0xFC32
#define HERMES_RID_CNFBEACONINT			0xFC33
#define HERMES_RID_CNFAPPCFINFO			0xFC34
#define HERMES_RID_CNFSTAPCFINFO		0xFC35
#define HERMES_RID_CNFPRIORITYQUSAGE		0xFC37
#define HERMES_RID_CNFTIMCTRL			0xFC40
#define HERMES_RID_CNFTHIRTY2TALLY		0xFC42
#define HERMES_RID_CNFENHSECURITY		0xFC43
#define HERMES_RID_CNFGROUPADDRESSES		0xFC80	/* used */
#define HERMES_RID_CNFCREATEIBSS		0xFC81	/* used */
#define HERMES_RID_CNFFRAGMENTATIONTHRESHOLD	0xFC82	/* used */
#define HERMES_RID_CNFRTSTHRESHOLD		0xFC83	/* used */
#define HERMES_RID_CNFTXRATECONTROL		0xFC84	/* used */
#define HERMES_RID_CNFPROMISCUOUSMODE		0xFC85	/* used */
#define HERMES_RID_CNFBASICRATES_SYMBOL		0xFC8A
#define HERMES_RID_CNFPREAMBLE_SYMBOL		0xFC8C	/* used */
#define HERMES_RID_CNFFRAGMENTATIONTHRESHOLD0	0xFC90
#define HERMES_RID_CNFFRAGMENTATIONTHRESHOLD1	0xFC91
#define HERMES_RID_CNFFRAGMENTATIONTHRESHOLD2	0xFC92
#define HERMES_RID_CNFFRAGMENTATIONTHRESHOLD3	0xFC93
#define HERMES_RID_CNFFRAGMENTATIONTHRESHOLD4	0xFC94
#define HERMES_RID_CNFFRAGMENTATIONTHRESHOLD5	0xFC95
#define HERMES_RID_CNFFRAGMENTATIONTHRESHOLD6	0xFC96
#define HERMES_RID_CNFRTSTHRESHOLD0		0xFC97
#define HERMES_RID_CNFRTSTHRESHOLD1		0xFC98
#define HERMES_RID_CNFRTSTHRESHOLD2		0xFC99
#define HERMES_RID_CNFRTSTHRESHOLD3		0xFC9A
#define HERMES_RID_CNFRTSTHRESHOLD4		0xFC9B
#define HERMES_RID_CNFRTSTHRESHOLD5		0xFC9C
#define HERMES_RID_CNFRTSTHRESHOLD6		0xFC9D
#define HERMES_RID_CNFSHORTPREAMBLE		0xFCB0
#define HERMES_RID_CNFWEPKEYS_AGERE		0xFCB0	/* used */
#define HERMES_RID_CNFEXCLUDELONGPREAMBLE	0xFCB1
#define HERMES_RID_CNFTXKEY_AGERE		0xFCB1	/* used */
#define HERMES_RID_CNFAUTHENTICATIONRSPTO	0xFCB2
#define HERMES_RID_CNFBASICRATES		0xFCB3
#define HERMES_RID_CNFSUPPORTEDRATES		0xFCB4
#define HERMES_RID_CNFTICKTIME			0xFCE0	/* used */
#define HERMES_RID_CNFSCANREQUEST		0xFCE1
#define HERMES_RID_CNFJOINREQUEST		0xFCE2
#define HERMES_RID_CNFAUTHENTICATESTATION	0xFCE3
#define HERMES_RID_CNFCHANNELINFOREQUEST	0xFCE4

/*
 * Information RIDs
 */
#define HERMES_RID_MAXLOADTIME			0xFD00
#define HERMES_RID_DOWNLOADBUFFER		0xFD01
#define HERMES_RID_PRIID			0xFD02
#define HERMES_RID_PRISUPRANGE			0xFD03
#define HERMES_RID_CFIACTRANGES			0xFD04
#define HERMES_RID_NICSERNUM			0xFD0A
#define HERMES_RID_NICID			0xFD0B
#define HERMES_RID_MFISUPRANGE			0xFD0C
#define HERMES_RID_CFISUPRANGE			0xFD0D
#define HERMES_RID_CHANNELLIST			0xFD10	/* used */
#define HERMES_RID_REGULATORYDOMAINS		0xFD11
#define HERMES_RID_TEMPTYPE			0xFD12
#define HERMES_RID_CIS				0xFD13
#define HERMES_RID_STAID			0xFD20	/* used */
#define HERMES_RID_STASUPRANGE			0xFD21
#define HERMES_RID_MFIACTRANGES			0xFD22
#define HERMES_RID_CFIACTRANGES2		0xFD23
#define HERMES_RID_SECONDARYVERSION_SYMBOL	0xFD24	/* used */
#define HERMES_RID_PORTSTATUS			0xFD40
#define HERMES_RID_CURRENTSSID			0xFD41	/* used */
#define HERMES_RID_CURRENTBSSID			0xFD42	/* used */
#define HERMES_RID_COMMSQUALITY			0xFD43	/* used */
#define HERMES_RID_CURRENTTXRATE		0xFD44	/* used */
#define HERMES_RID_CURRENTBEACONINTERVAL	0xFD45
#define HERMES_RID_CURRENTSCALETHRESHOLDS	0xFD46
#define HERMES_RID_PROTOCOLRSPTIME		0xFD47
#define HERMES_RID_SHORTRETRYLIMIT		0xFD48	/* used */
#define HERMES_RID_LONGRETRYLIMIT		0xFD49	/* used */
#define HERMES_RID_MAXTRANSMITLIFETIME		0xFD4A	/* used */
#define HERMES_RID_MAXRECEIVELIFETIME		0xFD4B
#define HERMES_RID_CFPOLLABLE			0xFD4C
#define HERMES_RID_AUTHENTICATIONALGORITHMS	0xFD4D
#define HERMES_RID_PRIVACYOPTIONIMPLEMENTED	0xFD4F
#define HERMES_RID_CURRENTTXRATE1		0xFD80
#define HERMES_RID_CURRENTTXRATE2		0xFD81
#define HERMES_RID_CURRENTTXRATE3		0xFD82
#define HERMES_RID_CURRENTTXRATE4		0xFD83
#define HERMES_RID_CURRENTTXRATE5		0xFD84
#define HERMES_RID_CURRENTTXRATE6		0xFD85
#define HERMES_RID_OWNMACADDR			0xFD86
#define HERMES_RID_SCANRESULTSTABLE		0xFD88
#define HERMES_RID_PHYTYPE			0xFDC0
#define HERMES_RID_CURRENTCHANNEL		0xFDC1	/* used */
#define HERMES_RID_CURRENTPOWERSTATE		0xFDC2
#define HERMES_RID_CCAMODE			0xFDC3
#define HERMES_RID_SUPPORTEDDATARATES		0xFDC6	/* used */
#define HERMES_RID_BUILDSEQ			0xFFFE
#define HERMES_RID_FWID				0xFFFF

/* "ID" structure - used for ESSID and station nickname */
struct hermes_idstring {
	u16 len;
	u16 val[16];
} __attribute__ ((packed));

typedef struct hermes_multicast {
	u8 addr[HERMES_MAX_MULTICAST][ETH_ALEN];
} __attribute__ ((packed)) hermes_multicast_t;

#endif
