{- This module was generated from data in the Kate syntax
   highlighting file tcsh.xml, version 1, by Matthew Woehlke (mw_triad@users.sourceforge.net) -}

module Text.Highlighting.Kate.Syntax.Tcsh
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Tcsh"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.csh;*.tcsh;csh.cshrc;csh.login;.tcshrc;.cshrc;.login"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Tcsh","Start")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Tcsh","Start") -> return ()
      ("Tcsh","FindAll") -> return ()
      ("Tcsh","FindMost") -> return ()
      ("Tcsh","FindComments") -> (popContext) >> pEndLine
      ("Tcsh","Comment") -> (popContext) >> pEndLine
      ("Tcsh","FindCommentsParen") -> (popContext) >> pEndLine
      ("Tcsh","CommentParen") -> (popContext) >> pEndLine
      ("Tcsh","FindCommentsBackq") -> (popContext) >> pEndLine
      ("Tcsh","CommentBackq") -> (popContext) >> pEndLine
      ("Tcsh","FindCommands") -> return ()
      ("Tcsh","FindOthers") -> return ()
      ("Tcsh","FindStrings") -> return ()
      ("Tcsh","FindSubstitutions") -> return ()
      ("Tcsh","FindTests") -> return ()
      ("Tcsh","ExprDblParen") -> return ()
      ("Tcsh","ExprDblParenSubst") -> return ()
      ("Tcsh","ExprSubParen") -> return ()
      ("Tcsh","ExprBracket") -> return ()
      ("Tcsh","ExprDblBracket") -> return ()
      ("Tcsh","Group") -> return ()
      ("Tcsh","SubShell") -> return ()
      ("Tcsh","Assign") -> (popContext) >> pEndLine
      ("Tcsh","AssignArray") -> (popContext) >> pEndLine
      ("Tcsh","AssignSubscr") -> (popContext) >> pEndLine
      ("Tcsh","Subscript") -> return ()
      ("Tcsh","FunctionDef") -> (popContext) >> pEndLine
      ("Tcsh","CmdSetEnv") -> (popContext) >> pEndLine
      ("Tcsh","VarName") -> (popContext) >> pEndLine
      ("Tcsh","ProcessSubst") -> return ()
      ("Tcsh","StringSQ") -> return ()
      ("Tcsh","StringDQ") -> return ()
      ("Tcsh","StringEsc") -> return ()
      ("Tcsh","VarBrace") -> return ()
      ("Tcsh","SubstFile") -> return ()
      ("Tcsh","SubstCommand") -> return ()
      ("Tcsh","SubstBackq") -> return ()
      ("Tcsh","Switch") -> return ()
      ("Tcsh","SwitchCase") -> return ()
      ("Tcsh","SwitchDefault") -> return ()
      ("Tcsh","SwitchExpr") -> return ()
      ("Tcsh","HereDoc") -> return ()
      ("Tcsh","HereDocRemainder") -> (popContext) >> pEndLine
      ("Tcsh","HereDocQ") -> return ()
      ("Tcsh","HereDocNQ") -> return ()
      ("Tcsh","HereDocIQ") -> return ()
      ("Tcsh","HereDocINQ") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "else for function in select until while . then"
list_builtins = Set.fromList $ words $ ": alias alloc bg bindkey break builtins bye cd chdir complete continue dirs echo echotc eval exec exit fg filetest glob hashstat history hup inlib jobs kill limit log login logout ls-F migrate newgrp nice nohup notify onintr popd printenv pushd rehash repeat sched settc setty shift source stop suspend telltc time umask unalias uncomplete unhash unlimit ver wait watchlog where which"
list_builtins'5fvar = Set.fromList $ words $ "unset unsetenv"
list_unixcommands = Set.fromList $ words $ "arch awk bash bunzip2 bzcat bzcmp bzdiff bzegrep bzfgrep bzgrep bzip2 bzip2recover bzless bzmore cat chattr chgrp chmod chown chvt cp date dd deallocvt df dir dircolors dmesg dnsdomainname domainname du dumpkeys echo ed egrep false fgconsole fgrep fuser gawk getkeycodes gocr grep groff groups gunzip gzexe gzip hostname igawk install kbd_mode kbdrate killall last lastb link ln loadkeys loadunimap login ls lsattr lsmod lsmod.old mapscrn mesg mkdir mkfifo mknod mktemp more mount mv nano netstat nisdomainname nroff openvt pgawk pidof ping ps pstree pwd rbash readlink red resizecons rm rmdir run-parts sash sed setfont setkeycodes setleds setmetamode setserial sh showkey shred sleep ssed stat stty su sync tar tempfile touch troff true umount uname unicode_start unicode_stop unlink utmpdump uuidgen vdir wall wc ypdomainname zcat zcmp zdiff zegrep zfgrep zforce zgrep zless zmore znew zsh aclocal aconnect aplay apm apmsleep apropos ar arecord as as86 autoconf autoheader automake awk basename bc bison c++ cal cat cc cdda2wav cdparanoia cdrdao cd-read cdrecord chfn chgrp chmod chown chroot chsh clear cmp co col comm cp cpio cpp cut dc dd df diff diff3 dir dircolors directomatic dirname du env expr fbset file find flex flex++ fmt free ftp funzip fuser g++ gawk gc gcc gdb getent getopt gettext gettextize gimp gimp-remote gimptool gmake gs head hexdump id install join kill killall ld ld86 ldd less lex ln locate lockfile logname lp lpr ls lynx m4 make man mkdir mknod msgfmt mv namei nasm nawk nice nl nm nm86 nmap nohup nop od passwd patch pcregrep pcretest perl perror pidof pr printf procmail prune ps2ascii ps2epsi ps2frag ps2pdf ps2ps psbook psmerge psnup psresize psselect pstops rcs rev rm scp sed seq setterm shred size size86 skill slogin snice sort sox split ssh ssh-add ssh-agent ssh-keygen ssh-keyscan stat strings strip sudo suidperl sum tac tail tee test tr uniq unlink unzip updatedb updmap uptime users vmstat w wc wget whatis whereis which who whoami write xargs yacc yes zip zsoelim dcop kdialog kfile xhost xmodmap xset"

regex_'5b'5cs'3b'5d'28'3f'3d'23'29 = compileRegex True "[\\s;](?=#)"
regex_'5b'5e'29'5d'28'3f'3d'5c'29'29 = compileRegex True "[^)](?=\\))"
regex_'5b'5e'60'5d'28'3f'3d'60'29 = compileRegex True "[^`](?=`)"
regex_'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\[\\[(?=($|\\s))"
regex_'5cs'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\s\\[\\[(?=($|\\s))"
regex_'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\[(?=($|\\s))"
regex_'5cs'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\s\\[(?=($|\\s))"
regex_'5c'7b'28'3f'3d'28'24'7c'5cs'29'29 = compileRegex True "\\{(?=($|\\s))"
regex_'5cbdo'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bdo(?![\\w$+-])"
regex_'5cbdone'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bdone(?![\\w$+-])"
regex_'5cbelse'5cs'2bif'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\belse\\s+if(?![\\w$+-])"
regex_'5cbif'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bif(?![\\w$+-])"
regex_'5cbendif'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bendif(?![\\w$+-])"
regex_'5cbswitch'28'3f'21'5b'5cw'24'2b'2d'5d'29 = compileRegex True "\\bswitch(?![\\w$+-])"
regex_'2d'5bA'2dZa'2dz0'2d9'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "-[A-Za-z0-9][A-Za-z0-9_]*"
regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a = compileRegex True "--[a-z][A-Za-z0-9_-]*"
regex_'5cb'40'5cs = compileRegex True "\\b@\\s"
regex_'5cbset'5cs = compileRegex True "\\bset\\s"
regex_'5cbsetenv'5cs = compileRegex True "\\bsetenv\\s"
regex_'5cbfunction'5cb = compileRegex True "\\bfunction\\b"
regex_'28'3c'3c'3f'7c'3e'3e'3f'26'3f'21'3f'29 = compileRegex True "(<<?|>>?&?!?)"
regex_'28'5b'7c'26'5d'29'5c1'3f = compileRegex True "([|&])\\1?"
regex_'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'5cs'2a'5c'28'5c'29 = compileRegex True "[A-Za-z_:][A-Za-z0-9_:#%@-]*\\s*\\(\\)"
regex_'5c'5c'5b'3b'22'5c'5c'27'24'60'7b'7d'28'29'7c'26'3c'3e'2a_'5d = compileRegex True "\\\\[;\"\\\\'$`{}()|&<>* ]"
regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'2f'29 = compileRegex True "([\\w_@.%*?+-]|\\\\ )*(?=/)"
regex_'7e'5cw'2a = compileRegex True "~\\w*"
regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'2f'29'3a'3b'24'60'27'22'5d'7c'24'29'29 = compileRegex True "/([\\w_@.%*?+-]|\\\\ )*(?=([\\s/):;$`'\"]|$))"
regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'5b = compileRegex True "\\$[A-Za-z_][A-Za-z0-9_]*\\["
regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "\\$[A-Za-z_][A-Za-z0-9_]*"
regex_'5c'24'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d = compileRegex True "\\$[*@#?$!_0-9-]"
regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'5c'7d = compileRegex True "\\$\\{[*@#?$!_0-9-]\\}"
regex_'5c'24'5c'7b'23'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'7d = compileRegex True "\\$\\{#[A-Za-z_][A-Za-z0-9_]*\\}"
regex_'5c'24'5c'7b'21'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'2a'3f'5c'7d = compileRegex True "\\$\\{![A-Za-z_][A-Za-z0-9_]*\\*?\\}"
regex_'5c'24'5c'7b'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "\\$\\{[A-Za-z_][A-Za-z0-9_]*"
regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'28'3f'3d'5b'3a'23'25'2f'5d'29 = compileRegex True "\\$\\{[*@#?$!_0-9-](?=[:#%/])"
regex_'5c'5c'5b'60'24'5c'5c'5d = compileRegex True "\\\\[`$\\\\]"
regex_'2d'5brwxXeozsfdlbcpSugktRLDIFNZ'5d'28'3f'3d'5cs'29 = compileRegex True "-[rwxXeozsfdlbcpSugktRLDIFNZ](?=\\s)"
regex_'2d'5bAMCUG'5d'3a'3f'28'3f'3d'5cs'29 = compileRegex True "-[AMCUG]:?(?=\\s)"
regex_'2dP'5b0'2d7'5d'7b'2c3'7d'3a'3f'28'3f'3d'5cs'29 = compileRegex True "-P[0-7]{,3}:?(?=\\s)"
regex_'28'5b'7c'26'3d'3e'3c'5d'29'5c1 = compileRegex True "([|&=><])\\1"
regex_'5b'7c'5e'26'3e'3c'2b'5c'2d'2a'2f'25'21'7e'5d = compileRegex True "[|^&><+\\-*/%!~]"
regex_'28'5b'21'3d'5d'7e'7c'5b'21'3e'3c'5d'3d'29 = compileRegex True "([!=]~|[!><]=)"
regex_'5cs'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex True "\\s\\](?=($|[\\s;|&]))"
regex_'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex True "\\](?=($|[\\s;|&]))"
regex_'5cs'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex True "\\s\\]\\](?=($|[\\s;|&]))"
regex_'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 = compileRegex True "\\]\\](?=($|[\\s;|&]))"
regex_'5b'5cw'3a'2c'2b'5f'2e'2f'2d'5d'2b = compileRegex True "[\\w:,+_./-]+"
regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'28'5cs'2a'5c'28'5c'29'29'3f = compileRegex True "\\s+[A-Za-z_:][A-Za-z0-9_:#%@-]*(\\s*\\(\\))?"
regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex True "\\b[A-Za-z_][A-Za-z0-9_]*"
regex_'2d'5bA'2dZa'2dz0'2d9'5d'2b = compileRegex True "-[A-Za-z0-9]+"
regex_'5b'5e'5d'7d'29'7c'3b'60'26'3e'3c'5d = compileRegex True "[^]})|;`&><]"
regex_'5c'5c'5b'60'22'5c'5c'24'5cn'5d = compileRegex True "\\\\[`\"\\\\$\\n]"
regex_'5c'5c'5babefnrtv'5c'5c'27'5d = compileRegex True "\\\\[abefnrtv\\\\']"
regex_'5c'5c'28'5b0'2d7'5d'7b1'2c3'7d'7cx'5bA'2dFa'2df0'2d9'5d'7b1'2c2'7d'7cc'2e'29 = compileRegex True "\\\\([0-7]{1,3}|x[A-Fa-f0-9]{1,2}|c.)"
regex_'5cscase'5cb = compileRegex True "\\scase\\b"
regex_'5csdefault'5cb = compileRegex True "\\sdefault\\b"
regex_'5cbendsw'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 = compileRegex True "\\bendsw(?=$|[\\s;)])"
regex_'5csbreaksw'5cb = compileRegex True "\\sbreaksw\\b"
regex_'28'3c'3c'2d'5cs'2a'22'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29 = compileRegex True "(<<-\\s*\"([|&;()<>\\s]+)\")"
regex_'28'3c'3c'2d'5cs'2a'27'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29 = compileRegex True "(<<-\\s*'([|&;()<>\\s]+)')"
regex_'28'3c'3c'2d'5cs'2a'5c'5c'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex True "(<<-\\s*\\\\([|&;()<>\\s]+))"
regex_'28'3c'3c'2d'5cs'2a'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex True "(<<-\\s*([|&;()<>\\s]+))"
regex_'28'3c'3c'5cs'2a'22'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29 = compileRegex True "(<<\\s*\"([|&;()<>\\s]+)\")"
regex_'28'3c'3c'5cs'2a'27'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29 = compileRegex True "(<<\\s*'([|&;()<>\\s]+)')"
regex_'28'3c'3c'5cs'2a'5c'5c'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex True "(<<\\s*\\\\([|&;()<>\\s]+))"
regex_'28'3c'3c'5cs'2a'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29 = compileRegex True "(<<\\s*([|&;()<>\\s]+))"

parseRules ("Tcsh","Start") =
  (((parseRules ("Tcsh","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","Start")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","FindAll") =
  (((parseRules ("Tcsh","FindComments")))
   <|>
   ((parseRules ("Tcsh","FindCommands")))
   <|>
   ((parseRules ("Tcsh","FindStrings")))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   ((parseRules ("Tcsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","FindAll")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","FindMost") =
  (((parseRules ("Tcsh","FindComments")))
   <|>
   ((parseRules ("Tcsh","FindStrings")))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   ((parseRules ("Tcsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","FindMost")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","FindComments") =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Tcsh","Comment"))
   <|>
   ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute NormalTok) >>~ pushContext ("Tcsh","Comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","FindComments")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","Comment") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Tcsh","FindCommentsParen") =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Tcsh","CommentParen"))
   <|>
   ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute NormalTok) >>~ pushContext ("Tcsh","CommentParen"))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","FindCommentsParen")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","CommentParen") =
  (((pRegExpr regex_'5b'5e'29'5d'28'3f'3d'5c'29'29 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","CommentParen")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Tcsh","FindCommentsBackq") =
  (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute CommentTok) >>~ pushContext ("Tcsh","CommentBackq"))
   <|>
   ((pRegExpr regex_'5b'5cs'3b'5d'28'3f'3d'23'29 >>= withAttribute NormalTok) >>~ pushContext ("Tcsh","CommentBackq"))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","FindCommentsBackq")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","CommentBackq") =
  (((pRegExpr regex_'5b'5e'60'5d'28'3f'3d'60'29 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","CommentBackq")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Tcsh","FindCommands") =
  (((pDetect2Chars False '(' '(' >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","ExprDblParen"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","ExprDblBracket"))
   <|>
   ((pRegExpr regex_'5cs'5c'5b'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","ExprDblBracket"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","ExprBracket"))
   <|>
   ((pRegExpr regex_'5cs'5c'5b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","ExprBracket"))
   <|>
   ((pRegExpr regex_'5c'7b'28'3f'3d'28'24'7c'5cs'29'29 >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","Group"))
   <|>
   ((pDetectChar False '(' >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","SubShell"))
   <|>
   ((pRegExpr regex_'5cbdo'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbdone'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbelse'5cs'2bif'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbif'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbendif'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbswitch'28'3f'21'5b'5cw'24'2b'2d'5d'29 >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","Switch"))
   <|>
   ((pRegExpr regex_'2d'5bA'2dZa'2dz0'2d9'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cb'40'5cs >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbset'5cs >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cbsetenv'5cs >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","CmdSetEnv"))
   <|>
   ((pString False ":()" >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5cbfunction'5cb >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","FunctionDef"))
   <|>
   ((pKeyword " \n\t()!+,<=>&*/;?|~\\`" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t()!+,<=>&*/;?|~\\`" list_builtins >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t()!+,<=>&*/;?|~\\`" list_unixcommands >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t()!+,<=>&*/;?|~\\`" list_builtins'5fvar >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","VarName"))
   <|>
   ((pRegExpr regex_'28'3c'3c'3f'7c'3e'3e'3f'26'3f'21'3f'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5b'7c'26'5d'29'5c1'3f >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'5cs'2a'5c'28'5c'29 >>= withAttribute FunctionTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","FindCommands")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","FindOthers") =
  (((pRegExpr regex_'5c'5c'5b'3b'22'5c'5c'27'24'60'7b'7d'28'29'7c'26'3c'3e'2a_'5d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'2f'29 >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'7e'5cw'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2f'28'5b'5cw'5f'40'2e'25'2a'3f'2b'2d'5d'7c'5c'5c_'29'2a'28'3f'3d'28'5b'5cs'2f'29'3a'3b'24'60'27'22'5d'7c'24'29'29 >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","FindOthers")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","FindStrings") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("Tcsh","StringSQ"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Tcsh","StringDQ"))
   <|>
   ((pDetect2Chars False '$' '\'' >>= withAttribute StringTok) >>~ pushContext ("Tcsh","StringEsc"))
   <|>
   ((pDetect2Chars False '$' '"' >>= withAttribute StringTok) >>~ pushContext ("Tcsh","StringDQ"))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","FindStrings")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","FindSubstitutions") =
  (((pRegExpr regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'5b >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","Subscript"))
   <|>
   ((pRegExpr regex_'5c'24'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'5c'7d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'23'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'7d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'21'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'5c'2a'3f'5c'7d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","VarBrace"))
   <|>
   ((pRegExpr regex_'5c'24'5c'7b'5b'2a'40'23'3f'24'21'5f0'2d9'2d'5d'28'3f'3d'5b'3a'23'25'2f'5d'29 >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","VarBrace"))
   <|>
   ((pString False "$((" >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","ExprDblParenSubst"))
   <|>
   ((pDetectChar False '`' >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","SubstBackq"))
   <|>
   ((pRegExpr regex_'5c'5c'5b'60'24'5c'5c'5d >>= withAttribute DataTypeTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","FindSubstitutions")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","FindTests") =
  (((pRegExpr regex_'2d'5brwxXeozsfdlbcpSugktRLDIFNZ'5d'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'2d'5bAMCUG'5d'3a'3f'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'2dP'5b0'2d7'5d'7b'2c3'7d'3a'3f'28'3f'3d'5cs'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'28'5b'7c'26'3d'3e'3c'5d'29'5c1 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5b'7c'5e'26'3e'3c'2b'5c'2d'2a'2f'25'21'7e'5d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'28'5b'21'3d'5d'7e'7c'5b'21'3e'3c'5d'3d'29 >>= withAttribute OtherTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","FindTests")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","ExprDblParen") =
  (((pDetect2Chars False ')' ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Tcsh","ExprSubParen"))
   <|>
   ((parseRules ("Tcsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","ExprDblParen")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","ExprDblParenSubst") =
  (((pDetect2Chars False ')' ')' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Tcsh","ExprSubParen"))
   <|>
   ((parseRules ("Tcsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","ExprDblParenSubst")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","ExprSubParen") =
  (((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Tcsh","ExprSubParen"))
   <|>
   ((parseRules ("Tcsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","ExprSubParen")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","ExprBracket") =
  (((pRegExpr regex_'5cs'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Tcsh","ExprSubParen"))
   <|>
   ((parseRules ("Tcsh","FindTests")))
   <|>
   ((parseRules ("Tcsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","ExprBracket")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","ExprDblBracket") =
  (((pRegExpr regex_'5cs'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5c'5d'5c'5d'28'3f'3d'28'24'7c'5b'5cs'3b'7c'26'5d'29'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Tcsh","ExprSubParen"))
   <|>
   ((parseRules ("Tcsh","FindTests")))
   <|>
   ((parseRules ("Tcsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","ExprDblBracket")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","Group") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Tcsh","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","Group")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","SubShell") =
  (((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Tcsh","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","SubShell")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","Assign") =
  (((pDetectChar False '(' >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","AssignArray"))
   <|>
   ((parseRules ("Tcsh","FindStrings")))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   ((parseRules ("Tcsh","FindOthers")))
   <|>
   ((pRegExpr regex_'5b'5cw'3a'2c'2b'5f'2e'2f'2d'5d'2b >>= withAttribute NormalTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Tcsh","AssignArray") =
  (((pDetectChar False ')' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","Subscript"))
   <|>
   ((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","Assign"))
   <|>
   ((parseRules ("Tcsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","AssignArray")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","AssignSubscr") =
  (((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","Subscript"))
   <|>
   ((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","Assign"))
   <|>
   ((parseRules ("Tcsh","FindStrings")))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   ((parseRules ("Tcsh","FindOthers")))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Tcsh","Subscript") =
  (((pDetectChar False ']' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((parseRules ("Tcsh","FindStrings")))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   ((parseRules ("Tcsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","Subscript")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Tcsh","FunctionDef") =
  (((pRegExpr regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5bA'2dZa'2dz0'2d9'5f'3a'23'25'40'2d'5d'2a'28'5cs'2a'5c'28'5c'29'29'3f >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Tcsh","CmdSetEnv") =
  (((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetectChar False ' ' >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","Assign"))
   <|>
   ((parseRules ("Tcsh","FindMost")))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Tcsh","VarName") =
  (((pRegExpr regex_'2d'5bA'2dZa'2dz0'2d9'5d'2b >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2d'2d'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'2d'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5cb'5bA'2dZa'2dz'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","Subscript"))
   <|>
   ((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","Assign"))
   <|>
   ((parseRules ("Tcsh","FindMost")))
   <|>
   ((pRegExpr regex_'5b'5e'5d'7d'29'7c'3b'60'26'3e'3c'5d >>= withAttribute NormalTok))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("Tcsh","ProcessSubst") =
  (((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Tcsh","FindCommentsParen")))
   <|>
   ((parseRules ("Tcsh","FindCommands")))
   <|>
   ((parseRules ("Tcsh","FindStrings")))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   ((parseRules ("Tcsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","ProcessSubst")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","StringSQ") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","StringSQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("Tcsh","StringDQ") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'5b'60'22'5c'5c'24'5cn'5d >>= withAttribute DataTypeTok))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","StringDQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("Tcsh","StringEsc") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'5babefnrtv'5c'5c'27'5d >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5c'5c'28'5b0'2d7'5d'7b1'2c3'7d'7cx'5bA'2dFa'2df0'2d9'5d'7b1'2c2'7d'7cc'2e'29 >>= withAttribute DataTypeTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","StringEsc")) >> pDefault >>= withAttribute StringTok))

parseRules ("Tcsh","VarBrace") =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext ("Tcsh","Subscript"))
   <|>
   ((parseRules ("Tcsh","FindStrings")))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","VarBrace")) >> pDefault >>= withAttribute OtherTok))

parseRules ("Tcsh","SubstFile") =
  (((pDetectChar False ')' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Tcsh","FindCommentsParen")))
   <|>
   ((parseRules ("Tcsh","FindStrings")))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   ((parseRules ("Tcsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","SubstFile")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","SubstCommand") =
  (((pDetectChar False ')' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((parseRules ("Tcsh","FindCommentsParen")))
   <|>
   ((parseRules ("Tcsh","FindCommands")))
   <|>
   ((parseRules ("Tcsh","FindStrings")))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   ((parseRules ("Tcsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","SubstCommand")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","SubstBackq") =
  (((pDetectChar False '`' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Tcsh","FindCommentsBackq")))
   <|>
   ((parseRules ("Tcsh","FindCommands")))
   <|>
   ((parseRules ("Tcsh","FindStrings")))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   ((parseRules ("Tcsh","FindOthers")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","SubstBackq")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","Switch") =
  (((pRegExpr regex_'5cscase'5cb >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","SwitchCase"))
   <|>
   ((pRegExpr regex_'5csdefault'5cb >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","SwitchDefault"))
   <|>
   ((pRegExpr regex_'5cbendsw'28'3f'3d'24'7c'5b'5cs'3b'29'5d'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules ("Tcsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","Switch")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","SwitchCase") =
  (((pDetectChar False ':' >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","SwitchExpr"))
   <|>
   ((parseRules ("Tcsh","FindMost")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","SwitchCase")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","SwitchDefault") =
  (((pDetectChar False ':' >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","SwitchExpr"))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","SwitchDefault")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","SwitchExpr") =
  (((pRegExpr regex_'5csbreaksw'5cb >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((lookAhead (pRegExpr regex_'5cscase'5cb) >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules ("Tcsh","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","SwitchExpr")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","HereDoc") =
  (((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'22'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29) >> pushContext ("Tcsh","HereDocIQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'27'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29) >> pushContext ("Tcsh","HereDocIQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'5c'5c'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext ("Tcsh","HereDocIQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'2d'5cs'2a'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext ("Tcsh","HereDocINQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'22'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'22'29) >> pushContext ("Tcsh","HereDocQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'27'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'27'29) >> pushContext ("Tcsh","HereDocQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'5c'5c'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext ("Tcsh","HereDocQ") >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'28'3c'3c'5cs'2a'28'5b'7c'26'3b'28'29'3c'3e'5cs'5d'2b'29'29) >> pushContext ("Tcsh","HereDocNQ") >> currentContext >>= parseRules))
   <|>
   ((pString False "<<" >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","HereDoc")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","HereDocRemainder") =
  (((parseRules ("Tcsh","FindAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","HereDocRemainder")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","HereDocQ") =
  (((pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","HereDocRemainder"))
   <|>
   ((pColumn 0 >> pRegExprDynamic "%2[\\s;]*$" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","HereDocQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","HereDocNQ") =
  (((pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","HereDocRemainder"))
   <|>
   ((pColumn 0 >> pRegExprDynamic "%2[\\s;]*$" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","HereDocNQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","HereDocIQ") =
  (((pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","HereDocRemainder"))
   <|>
   ((pColumn 0 >> pRegExprDynamic "\\s*%2[\\s;]*$" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","HereDocIQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Tcsh","HereDocINQ") =
  (((pRegExprDynamic "%1" >>= withAttribute KeywordTok) >>~ pushContext ("Tcsh","HereDocRemainder"))
   <|>
   ((pColumn 0 >> pRegExprDynamic "\\s*%2[\\s;]*$" >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("Tcsh","FindSubstitutions")))
   <|>
   (currentContext >>= \x -> guard (x == ("Tcsh","HereDocINQ")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("Tcsh","Start") <|> fail ("Unknown context" ++ show x)
