/*
 * jaZip for Linux  (c) 1996  Jarrod A. Smith
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#include <forms.h>
#include	<mntent.h>
#include <unistd.h>
#include "pixmaps.h"
#include "jazip.h"

extern	int	execv();

int main(int argc, char *argv[])
{
	FD_jazip		*fd_jazip;
	FILE	*jazipconf;
	struct	mntent	*mp;
	int	found;
	char	*display;

	if (geteuid()) {
		printf ("jaZip permission error:");
		printf ("Make sure the suid bit is set, and root owns the executable.\n");
		printf ("You must be root when you install the program.\n");
		exit( -1 );
	}

	seteuid(getuid());

	/* Attempt to dodge possible buffer overflow in xforms */
	display = getenv("DISPLAY");
	if (strlen(display) > 256){
		display[256] = '\0';
		setenv("DISPLAY", display,1);
	}

	fl_initialize (&argc, argv, 0, 0, 0);
	fl_set_goodies_font(FL_NORMAL_STYLE, FL_NORMAL_SIZE);
	fd_jazip = create_form_jazip();
	found = 0;
	conf = 1;

	if (!(jazipconf = setmntent (IOMEGA_FSTAB, "r"))) {
		printf ("Can't read configuration file %s.\n", IOMEGA_FSTAB);
		exit( -1 );
	}

	if (argv[1] && (strncmp (argv[1], "-", 1))) {
		strcpy (dev, argv[1]);
		while(  mp = getmntent (jazipconf) ){
			if( !strcmp( mp->mnt_fsname, dev ) ) {
				found = 1; 
				break;
			}
			conf++;
		}
		endmntent (jazipconf);
		if( !found ){
			printf( "Couldn't locate raw scsi device %s in %s\n", dev, IOMEGA_FSTAB );
			exit( -1 );
		}
	} else {
		mp = getmntent (jazipconf);
		strcpy (dev, mp->mnt_fsname);
		endmntent (jazipconf);
	}

	if (!check_scsi_dev(dev, fd_jazip)) exit( -1 );

	fd_jazip->info->u_vdata = fd_jazip;
	fd_jazip->mount_z->u_vdata = fd_jazip;
	fd_jazip->umount_z->u_vdata = fd_jazip;
	fd_jazip->eject_z->u_vdata = fd_jazip;
	fd_jazip->ro_z->u_vdata = fd_jazip;
	fd_jazip->rw_z->u_vdata = fd_jazip;
	fd_jazip->file_menu->u_vdata = fd_jazip;
	fd_jazip->tools_menu->u_vdata = fd_jazip;
	fd_jazip->help_menu->u_vdata = fd_jazip;

	fl_show_form (fd_jazip->jazip,FL_PLACE_CENTER,FL_FULLBORDER,"jaZip");
	fl_do_forms();
	
	return (0);
}
