.. -*- rst -*-

Register an identity provider
=============================

.. rest_method::  PUT /v3/OS-FEDERATION/identity_providers/{id}

Register an identity provider to be used to authenticate federated users.

Relationship: ``https://docs.openstack.org/api/openstack-identity/3/ext/OS-FEDERATION/1.0/rel/identity_provider``

Request
-------

Parameters
~~~~~~~~~~
.. rest_parameters:: federation/identity-provider/parameters.yaml

    - domain_id: domain_id
    - description: description
    - enabled: enabled
    - id: id_path
    - remote_ids: remote_ids

As a domain may only be associated to a single identity provider, a 409 response code will be
returned if the specified ``domain_id`` already maps an existing identity provider.

Example
~~~~~~~

.. literalinclude:: federation/identity-provider/samples/register-request.json
   :language: javascript

Response
--------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - domain_id: domain_id
    - description: description
    - enabled: enabled
    - id: id_body
    - links: links
    - remote_ids: remote_ids

Status Codes
~~~~~~~~~~~~

.. rest_status_code:: success ../v3/status.yaml

   - 201

Example
~~~~~~~

.. literalinclude:: federation/identity-provider/samples/register-response.json
   :language: javascript


List identity providers
=======================

.. rest_method::  GET /v3/OS-FEDERATION/identity_providers

List registered identity providers.

Relationship: ``https://docs.openstack.org/api/openstack-identity/3/ext/OS-FEDERATION/1.0/rel/identity_providers``

Request
-------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - id: id_query
    - enabled: enabled_query

Response
--------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - identity_providers: identity_providers

Status Codes
~~~~~~~~~~~~

.. rest_status_code:: success ../v3/status.yaml

   - 200

Example
~~~~~~~~

.. literalinclude:: federation/identity-provider/samples/list-response.json
   :language: javascript


Get identity provider
=====================

.. rest_method::  GET /v3/OS-FEDERATION/identity_providers/{id}

Get registered identity providers.

Relationship: ``https://docs.openstack.org/api/openstack-identity/3/ext/OS-FEDERATION/1.0/rel/identity_provider``

Request
-------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - id: id_path

Response
--------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - domain_id: domain_id
    - description: description
    - enabled: enabled
    - id: id_body
    - links: links
    - remote_ids: remote_ids

Status Codes
~~~~~~~~~~~~

.. rest_status_code:: success ../v3/status.yaml

   - 200

Example
~~~~~~~

.. literalinclude:: federation/identity-provider/samples/get-response.json
   :language: javascript


Delete identity provider
========================

.. rest_method::  DELETE /v3/OS-FEDERATION/identity_providers/{id}

When an identity provider is deleted, any tokens generated by that identity
provider will be revoked.

Relationship: ``https://docs.openstack.org/api/openstack-identity/3/ext/OS-FEDERATION/1.0/rel/identity_provider``

Request
-------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - id: id_path

Response
--------

Status Codes
~~~~~~~~~~~~

.. rest_status_code:: success ../v3/status.yaml

   - 204

Update identity provider
========================

.. rest_method::  PATCH /v3/OS-FEDERATION/identity_providers/{id}

When an identity provider is disabled, any tokens generated by that identity
provider will be revoked.

Relationship: ``https://docs.openstack.org/api/openstack-identity/3/ext/OS-FEDERATION/1.0/rel/identity_provider``

Request
-------

Except ``domain_id``, any attribute of an Identity Provider may be passed in
the request body. To update the ``domain_id``, you will need to delete and
recreate the Identity Provider. If ``domain_id`` is included in the request, a
400 response code will be returned.

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - id: id_path

Example
~~~~~~~

.. literalinclude:: federation/identity-provider/samples/update-request.json
   :language: javascript

Response
--------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - domain_id: domain_id
    - description: description
    - enabled: enabled
    - id: id_body
    - links: links
    - remote_ids: remote_ids

Status Codes
~~~~~~~~~~~~

.. rest_status_code:: success ../v3/status.yaml

   - 200

Example
~~~~~~~

.. literalinclude:: federation/identity-provider/samples/update-response.json
   :language: javascript


Add protocol to identity provider
=================================

.. rest_method::  PUT /v3/OS-FEDERATION/identity_providers/{idp_id}/protocols/{protocol_id}

Add a protocol and attribute mapping to an identity provider.

Relationship: ``https://docs.openstack.org/api/openstack-identity/3/ext/OS-FEDERATION/1.0/rel/identity_provider_protocol``

Request
-------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - idp_id: id_path
    - protocol_id: protocol_id
    - protocol: protocol

Example
~~~~~~~

.. literalinclude:: federation/identity-provider/samples/add-protocol-request.json
   :language: javascript

Response
--------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - protocol: protocol

Status Codes
~~~~~~~~~~~~

.. rest_status_code:: success ../v3/status.yaml

   - 201

Example
~~~~~~~

.. literalinclude:: federation/identity-provider/samples/add-protocol-response.json
   :language: javascript


List protocols of identity provider
===================================

.. rest_method::  GET /v3/OS-FEDERATION/identity_providers/{id}/protocols

List all protocol and attribute mappings of an identity provider.

Relationship: ``https://docs.openstack.org/api/openstack-identity/3/ext/OS-FEDERATION/1.0/rel/identity_provider_protocols``

Request
-------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - id: id_path

Response
--------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - protocols: protocols
    - links: protocols_links

Status Codes
~~~~~~~~~~~~

.. rest_status_code:: success ../v3/status.yaml

   - 200

Example
~~~~~~~

.. literalinclude:: federation/identity-provider/samples/list-protocol-response.json
   :language: javascript


Get protocol for identity provider
==================================

.. rest_method::  GET /v3/OS-FEDERATION/identity_providers/{idp_id}/protocols/{protocol_id}

Get a protocol and attribute mapping for an identity provider.

Relationship: ``https://docs.openstack.org/api/openstack-identity/3/ext/OS-FEDERATION/1.0/rel/identity_provider_protocol``

Request
-------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - idp_id: id_path
    - protocol_id: protocol_id

Response
--------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - protocol: protocol

Status Codes
~~~~~~~~~~~~

.. rest_status_code:: success ../v3/status.yaml

   - 200

Example
~~~~~~~

.. literalinclude:: federation/identity-provider/samples/get-protocol-response.json
   :language: javascript


Update attribute mapping for identity provider
==============================================

.. rest_method::  PATCH /v3/OS-FEDERATION/identity_providers/{idp_id}/protocols/{protocol_id}

Update the attribute mapping for an identity provider and protocol.

Relationship: ``https://docs.openstack.org/api/openstack-identity/3/ext/OS-FEDERATION/1.0/rel/identity_provider_protocol``

Request
-------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - idp_id: id_path
    - protocol_id: protocol_id
    - protocol: protocol

Example
~~~~~~~

.. literalinclude:: federation/identity-provider/samples/update-protocol-request.json
   :language: javascript

Response
--------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - protocol: protocol

Status Codes
~~~~~~~~~~~~

.. rest_status_code:: success ../v3/status.yaml

   - 200

Example
~~~~~~~

.. literalinclude:: federation/identity-provider/samples/update-protocol-response.json
   :language: javascript


Delete a protocol from identity provider
========================================

.. rest_method::  DELETE /v3/OS-FEDERATION/identity_providers/{idp_id}/protocols/{protocol_id}

Delete a protocol and attribute mapping from an identity provider.

Relationship: ``https://docs.openstack.org/api/openstack-identity/3/ext/OS-FEDERATION/1.0/rel/identity_provider_protocol``

Request
-------

Parameters
~~~~~~~~~~

.. rest_parameters:: federation/identity-provider/parameters.yaml

    - idp_id: id_path
    - protocol_id: protocol_id

Response
--------

Status Codes
~~~~~~~~~~~~

.. rest_status_code:: success ../v3/status.yaml

   - 204