/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "profilenetworkgeneraloptions.h"

#include <QtGui/QCheckBox>
#include <QtGui/QGroupBox>
#include <QtGui/QLabel>
#include <QtGui/QSpinBox>

#include <klineedit.h>
#include <knuminput.h>

#include "widgetnotifyhelper.h"

ProfileNetworkGeneralOptions::ProfileNetworkGeneralOptions(QWidget *parent) : QWidget(parent)
{
    setupUi(this);
    useConnectionStatusCheckToggled(UseConnectionStatusCheckCheckBox->isChecked());
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;
	
	
	connect(UseRemoteNetworkCheckBox, SIGNAL(stateChanged(int)), this, SLOT(useNetworkToggled(int)));
}


ProfileNetworkGeneralOptions::~ProfileNetworkGeneralOptions()
{}


void ProfileNetworkGeneralOptions::mtuToggled(bool)
{
    if (MtuCheckbox->isChecked())
        MtuSpinbox->setEnabled(true);
    else
        MtuSpinbox->setEnabled(false);
}

void ProfileNetworkGeneralOptions::mruToggled(bool)
{
    if (MruCheckbox->isChecked())
        MruSpinbox->setEnabled(true);
    else
        MruSpinbox->setEnabled(false);
}


void ProfileNetworkGeneralOptions::useConnectionStatusCheckToggled(bool)
{
    if (UseConnectionStatusCheckCheckBox->isChecked()) {
        ConnectionStatusCheckIntervalNumInput->setEnabled(true);
        ConnectionStatusSuccessCountNumInput->setEnabled(true);
        PingIntervalLabel->setEnabled(true);
        PingSuccessCountLabel->setEnabled(true);
    } else {
        ConnectionStatusCheckIntervalNumInput->setEnabled(false);
        ConnectionStatusSuccessCountNumInput->setEnabled(false);
        PingIntervalLabel->setEnabled(false);
        PingSuccessCountLabel->setEnabled(false);
    }
}

void ProfileNetworkGeneralOptions::pingIpAfterConnectToggled(bool)
{
    if (PingCheckBox->isChecked())
        PingIPLineEdit->setEnabled(true);
    else
        PingIPLineEdit->setEnabled(false);
}

void ProfileNetworkGeneralOptions::useReconnectDelayToggled(bool)
{
    if (UseReconnectDelayCheckBox->isChecked())
        ReconnectDelayNumInput->setEnabled(true);
    else
        ReconnectDelayNumInput->setEnabled(false);
}

void ProfileNetworkGeneralOptions::useReconnectAfterDisconnectToggled(bool)
{
    if (DoReconnectAfterConnectionLostCheckBox->isChecked()) {
        if (UseReconnectDelayCheckBox->isChecked())
            ReconnectDelayNumInput->setEnabled(true);
        else
            ReconnectDelayNumInput->setEnabled(false);

        UseReconnectDelayCheckBox->setEnabled(true);
    } else {
        ReconnectDelayNumInput->setEnabled(false);
        UseReconnectDelayCheckBox->setEnabled(false);
    }
}

void ProfileNetworkGeneralOptions::UseDnsUpdateToggled(bool)
{
//   UseDnsUpdate->setEnabled(UseDnsUpdateCheckBox->isChecked());
}


void ProfileNetworkGeneralOptions::dialogChanged()
{
    dialogModified = true;
}


void ProfileNetworkGeneralOptions::useNetworkToggled(int)
{
    if (UseRemoteNetworkCheckBox->isChecked())
        UseRemoteNetworkGroupBox->setEnabled(true);
    else
        UseRemoteNetworkGroupBox->setEnabled(false);
}


