/* dialog.c generated by valac 0.42.3, the Vala compiler
 * generated from dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define GAMES_SCORES_TYPE_DIALOG (games_scores_dialog_get_type ())
#define GAMES_SCORES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog))
#define GAMES_SCORES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))
#define GAMES_SCORES_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))

typedef struct _GamesScoresDialog GamesScoresDialog;
typedef struct _GamesScoresDialogClass GamesScoresDialogClass;
typedef struct _GamesScoresDialogPrivate GamesScoresDialogPrivate;

#define GAMES_SCORES_TYPE_CONTEXT (games_scores_context_get_type ())
#define GAMES_SCORES_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext))
#define GAMES_SCORES_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_CONTEXT, GamesScoresContextClass))
#define GAMES_SCORES_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_CONTEXT))
#define GAMES_SCORES_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_CONTEXT))
#define GAMES_SCORES_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_CONTEXT, GamesScoresContextClass))

typedef struct _GamesScoresContext GamesScoresContext;
typedef struct _GamesScoresContextClass GamesScoresContextClass;

#define GAMES_SCORES_TYPE_CATEGORY (games_scores_category_get_type ())
#define GAMES_SCORES_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategory))
#define GAMES_SCORES_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategoryClass))
#define GAMES_SCORES_IS_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_CATEGORY))
#define GAMES_SCORES_IS_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_CATEGORY))
#define GAMES_SCORES_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategoryClass))

typedef struct _GamesScoresCategory GamesScoresCategory;
typedef struct _GamesScoresCategoryClass GamesScoresCategoryClass;

#define GAMES_SCORES_TYPE_STYLE (games_scores_style_get_type ())

#define GAMES_SCORES_TYPE_SCORE (games_scores_score_get_type ())
#define GAMES_SCORES_SCORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_SCORE, GamesScoresScore))
#define GAMES_SCORES_SCORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_SCORE, GamesScoresScoreClass))
#define GAMES_SCORES_IS_SCORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_SCORE))
#define GAMES_SCORES_IS_SCORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_SCORE))
#define GAMES_SCORES_SCORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_SCORE, GamesScoresScoreClass))

typedef struct _GamesScoresScore GamesScoresScore;
typedef struct _GamesScoresScoreClass GamesScoresScoreClass;
enum  {
	GAMES_SCORES_DIALOG_0_PROPERTY,
	GAMES_SCORES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* games_scores_dialog_properties[GAMES_SCORES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;

struct _GamesScoresDialog {
	GtkDialog parent_instance;
	GamesScoresDialogPrivate * priv;
};

struct _GamesScoresDialogClass {
	GtkDialogClass parent_class;
};

typedef enum  {
	GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER,
	GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER,
	GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER,
	GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER
} GamesScoresStyle;

struct _GamesScoresDialogPrivate {
	GamesScoresContext* context;
	GamesScoresCategory* active_category;
	gint rows_to_display;
	GtkComboBoxText* combo;
	GtkLabel* category_label;
	GtkHeaderBar* headerbar;
	GtkGrid* grid;
	GamesScoresStyle scores_style;
	GamesScoresScore* new_high_score;
	GamesScoresCategory* scores_active_category;
};

struct _Block4Data {
	int _ref_count_;
	GamesScoresDialog* self;
	GamesScoresScore* score;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	GtkEntry* entry;
};


static gint GamesScoresDialog_private_offset;
static gpointer games_scores_dialog_parent_class = NULL;

GType games_scores_dialog_get_type (void) G_GNUC_CONST;
GType games_scores_context_get_type (void) G_GNUC_CONST;
GType games_scores_category_get_type (void) G_GNUC_CONST;
GType games_scores_style_get_type (void) G_GNUC_CONST;
GType games_scores_score_get_type (void) G_GNUC_CONST;
GamesScoresDialog* games_scores_dialog_new (GamesScoresContext* context,
                                            const gchar* category_type,
                                            GamesScoresStyle style,
                                            GamesScoresScore* new_high_score,
                                            GamesScoresCategory* current_cat,
                                            GtkWindow* window,
                                            const gchar* app_name);
GamesScoresDialog* games_scores_dialog_construct (GType object_type,
                                                  GamesScoresContext* context,
                                                  const gchar* category_type,
                                                  GamesScoresStyle style,
                                                  GamesScoresScore* new_high_score,
                                                  GamesScoresCategory* current_cat,
                                                  GtkWindow* window,
                                                  const gchar* app_name);
gboolean games_scores_context_has_scores (GamesScoresContext* self);
GList* games_scores_context_get_categories (GamesScoresContext* self);
const gchar* games_scores_category_get_name (GamesScoresCategory* self);
static void games_scores_dialog_load_scores (GamesScoresDialog* self);
static void _games_scores_dialog_load_scores_gtk_combo_box_changed (GtkComboBox* _sender,
                                                             gpointer self);
static void games_scores_dialog_fill_grid_with_labels (GamesScoresDialog* self);
static void games_scores_dialog_load_categories (GamesScoresDialog* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda10_ (GamesScoresDialog* self,
                  GamesScoresCategory* x);
const gchar* games_scores_category_get_key (GamesScoresCategory* self);
static void ___lambda10__gfunc (gconstpointer data,
                         gpointer self);
GamesScoresCategory* games_scores_category_new (const gchar* key,
                                                const gchar* name);
GamesScoresCategory* games_scores_category_construct (GType object_type,
                                                      const gchar* key,
                                                      const gchar* name);
void games_scores_category_set_key (GamesScoresCategory* self,
                                    const gchar* value);
void games_scores_category_set_name (GamesScoresCategory* self,
                                     const gchar* value);
GeeList* games_scores_context_get_high_scores (GamesScoresContext* self,
                                               GamesScoresCategory* category,
                                               gint n);
static void games_scores_dialog_display_single_score (GamesScoresDialog* self,
                                               GamesScoresScore* score,
                                               gint row_count,
                                               guint no_scores);
static void games_scores_dialog_make_remaining_labels_empty (GamesScoresDialog* self,
                                                      gint row_count);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
glong games_scores_score_get_score (GamesScoresScore* self);
gboolean games_scores_score_equals (GamesScoresScore* a,
                                    GamesScoresScore* b);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
const gchar* games_scores_score_get_user (GamesScoresScore* self);
static void ___lambda9_ (Block5Data* _data5_);
void games_scores_context_update_score_name (GamesScoresContext* self,
                                             GamesScoresScore* old_score,
                                             GamesScoresCategory* category,
                                             const gchar* new_name);
void games_scores_score_set_user (GamesScoresScore* self,
                                  const gchar* value);
static void ____lambda9__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void games_scores_dialog_finalize (GObject * obj);


static inline gpointer
games_scores_dialog_get_instance_private (GamesScoresDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresDialog_private_offset);
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 45 "scores/dialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 218 "dialog.c"
}


static void
_games_scores_dialog_load_scores_gtk_combo_box_changed (GtkComboBox* _sender,
                                                        gpointer self)
{
#line 128 "scores/dialog.vala"
	games_scores_dialog_load_scores ((GamesScoresDialog*) self);
#line 228 "dialog.c"
}


static void
_g_object_unref0_ (gpointer var)
{
#line 39 "scores/dialog.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 237 "dialog.c"
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 39 "scores/dialog.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 246 "dialog.c"
}


GamesScoresDialog*
games_scores_dialog_construct (GType object_type,
                               GamesScoresContext* context,
                               const gchar* category_type,
                               GamesScoresStyle style,
                               GamesScoresScore* new_high_score,
                               GamesScoresCategory* current_cat,
                               GtkWindow* window,
                               const gchar* app_name)
{
	GamesScoresDialog * self = NULL;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GtkWidget* _tmp3_;
	GtkHeaderBar* _tmp4_;
	GtkHeaderBar* _tmp5_;
	gboolean _tmp12_ = FALSE;
	GtkBox* vbox = NULL;
	GtkBox* _tmp41_;
	GtkBox* _tmp42_;
	GtkBox* _tmp43_;
	GtkBox* catbar = NULL;
	GtkBox* _tmp44_;
	GtkBox* _tmp45_;
	GtkBox* _tmp46_;
	GList* categories = NULL;
	GList* _tmp47_;
	GList* _tmp48_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp54_;
	GtkLabel* _tmp55_;
	GtkLabel* _tmp56_;
	GtkBox* _tmp57_;
	GtkLabel* _tmp58_;
	GtkGrid* _tmp73_;
	GtkBox* _tmp74_;
	GtkGrid* _tmp75_;
	GtkGrid* _tmp76_;
	GtkGrid* _tmp77_;
	GtkGrid* _tmp78_;
	GtkGrid* _tmp79_;
	gchar* string_rank = NULL;
	gchar* _tmp80_;
	GtkLabel* label_column_1 = NULL;
	const gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	GtkLabel* _tmp86_;
	GtkLabel* _tmp87_;
	GtkLabel* _tmp88_;
	GtkGrid* _tmp89_;
	GtkLabel* _tmp90_;
	gchar* score_or_time = NULL;
	gchar* _tmp91_;
	gboolean _tmp92_ = FALSE;
	GamesScoresStyle _tmp93_;
	GtkLabel* label_column_2 = NULL;
	const gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	GtkLabel* _tmp102_;
	GtkLabel* _tmp103_;
	GtkLabel* _tmp104_;
	GtkGrid* _tmp105_;
	GtkLabel* _tmp106_;
	gchar* string_player = NULL;
	gchar* _tmp107_;
	GtkLabel* label_column_3 = NULL;
	const gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	GtkLabel* _tmp113_;
	GtkLabel* _tmp114_;
	GtkLabel* _tmp115_;
	GtkGrid* _tmp116_;
	GtkLabel* _tmp117_;
	GtkGrid* _tmp118_;
	GtkBox* _tmp121_;
#line 39 "scores/dialog.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 39 "scores/dialog.vala"
	g_return_val_if_fail (category_type != NULL, NULL);
#line 39 "scores/dialog.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 39 "scores/dialog.vala"
	g_return_val_if_fail (app_name != NULL, NULL);
#line 41 "scores/dialog.vala"
	self = (GamesScoresDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
#line 43 "scores/dialog.vala"
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
#line 45 "scores/dialog.vala"
	_tmp0_ = _g_object_ref0 (context);
#line 45 "scores/dialog.vala"
	_g_object_unref0 (self->priv->context);
#line 45 "scores/dialog.vala"
	self->priv->context = _tmp0_;
#line 46 "scores/dialog.vala"
	gtk_window_set_transient_for ((GtkWindow*) self, window);
#line 47 "scores/dialog.vala"
	_tmp1_ = _g_object_ref0 (new_high_score);
#line 47 "scores/dialog.vala"
	_g_object_unref0 (self->priv->new_high_score);
#line 47 "scores/dialog.vala"
	self->priv->new_high_score = _tmp1_;
#line 49 "scores/dialog.vala"
	self->priv->scores_style = style;
#line 50 "scores/dialog.vala"
	_tmp2_ = _g_object_ref0 (current_cat);
#line 50 "scores/dialog.vala"
	_g_object_unref0 (self->priv->scores_active_category);
#line 50 "scores/dialog.vala"
	self->priv->scores_active_category = _tmp2_;
#line 52 "scores/dialog.vala"
	_tmp3_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
#line 52 "scores/dialog.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 52 "scores/dialog.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 52 "scores/dialog.vala"
	self->priv->headerbar = _tmp4_;
#line 54 "scores/dialog.vala"
	_tmp5_ = self->priv->headerbar;
#line 54 "scores/dialog.vala"
	gtk_header_bar_set_show_close_button (_tmp5_, new_high_score == NULL);
#line 56 "scores/dialog.vala"
	if (new_high_score != NULL) {
#line 383 "dialog.c"
		GtkHeaderBar* _tmp6_;
#line 58 "scores/dialog.vala"
		_tmp6_ = self->priv->headerbar;
#line 58 "scores/dialog.vala"
		gtk_header_bar_set_title (_tmp6_, _ ("Congratulations!"));
#line 389 "dialog.c"
	} else {
		gboolean _tmp7_ = FALSE;
		GamesScoresStyle _tmp8_;
#line 59 "scores/dialog.vala"
		_tmp8_ = self->priv->scores_style;
#line 59 "scores/dialog.vala"
		if (_tmp8_ == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
#line 59 "scores/dialog.vala"
			_tmp7_ = TRUE;
#line 399 "dialog.c"
		} else {
			GamesScoresStyle _tmp9_;
#line 59 "scores/dialog.vala"
			_tmp9_ = self->priv->scores_style;
#line 59 "scores/dialog.vala"
			_tmp7_ = _tmp9_ == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
#line 406 "dialog.c"
		}
#line 59 "scores/dialog.vala"
		if (_tmp7_) {
#line 410 "dialog.c"
			GtkHeaderBar* _tmp10_;
#line 60 "scores/dialog.vala"
			_tmp10_ = self->priv->headerbar;
#line 60 "scores/dialog.vala"
			gtk_header_bar_set_title (_tmp10_, _ ("High Scores"));
#line 416 "dialog.c"
		} else {
			GtkHeaderBar* _tmp11_;
#line 62 "scores/dialog.vala"
			_tmp11_ = self->priv->headerbar;
#line 62 "scores/dialog.vala"
			gtk_header_bar_set_title (_tmp11_, _ ("Best Times"));
#line 423 "dialog.c"
		}
	}
#line 64 "scores/dialog.vala"
	if (!games_scores_context_has_scores (context)) {
#line 64 "scores/dialog.vala"
		_tmp12_ = new_high_score == NULL;
#line 430 "dialog.c"
	} else {
#line 64 "scores/dialog.vala"
		_tmp12_ = FALSE;
#line 434 "dialog.c"
	}
#line 64 "scores/dialog.vala"
	if (_tmp12_) {
#line 438 "dialog.c"
		GtkBox* vbox = NULL;
		GtkBox* _tmp13_;
		GtkBox* _tmp14_;
		GtkBox* _tmp15_;
		GtkBox* _tmp16_;
		GtkBox* _tmp17_;
		GtkBox* _tmp18_;
		GtkStyleContext* _tmp19_;
		GtkImage* image = NULL;
		GtkImage* _tmp20_;
		GtkImage* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GtkImage* _tmp24_;
		GtkImage* _tmp25_;
		GtkBox* _tmp26_;
		GtkImage* _tmp27_;
		GtkLabel* title_label = NULL;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		GtkLabel* _tmp32_;
		GtkLabel* _tmp33_;
		GtkLabel* _tmp34_;
		GtkBox* _tmp35_;
		GtkLabel* _tmp36_;
		GtkLabel* description_label = NULL;
		GtkLabel* _tmp37_;
		GtkBox* _tmp38_;
		GtkLabel* _tmp39_;
		GtkBox* _tmp40_;
#line 66 "scores/dialog.vala"
		_tmp13_ = gtk_dialog_get_content_area ((GtkDialog*) self);
#line 66 "scores/dialog.vala"
		_tmp14_ = _g_object_ref0 (_tmp13_);
#line 66 "scores/dialog.vala"
		vbox = _tmp14_;
#line 67 "scores/dialog.vala"
		_tmp15_ = vbox;
#line 67 "scores/dialog.vala"
		gtk_box_set_spacing (_tmp15_, 4);
#line 68 "scores/dialog.vala"
		_tmp16_ = vbox;
#line 68 "scores/dialog.vala"
		gtk_container_set_border_width ((GtkContainer*) _tmp16_, (guint) 10);
#line 69 "scores/dialog.vala"
		_tmp17_ = vbox;
#line 69 "scores/dialog.vala"
		gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
#line 70 "scores/dialog.vala"
		_tmp18_ = vbox;
#line 70 "scores/dialog.vala"
		_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
#line 70 "scores/dialog.vala"
		gtk_style_context_add_class (_tmp19_, "dim-label");
#line 72 "scores/dialog.vala"
		_tmp20_ = (GtkImage*) gtk_image_new ();
#line 72 "scores/dialog.vala"
		g_object_ref_sink (_tmp20_);
#line 72 "scores/dialog.vala"
		image = _tmp20_;
#line 73 "scores/dialog.vala"
		_tmp21_ = image;
#line 73 "scores/dialog.vala"
		_tmp22_ = g_strconcat (app_name, "-symbolic", NULL);
#line 73 "scores/dialog.vala"
		_tmp23_ = _tmp22_;
#line 73 "scores/dialog.vala"
		g_object_set (_tmp21_, "icon-name", _tmp23_, NULL);
#line 73 "scores/dialog.vala"
		_g_free0 (_tmp23_);
#line 74 "scores/dialog.vala"
		_tmp24_ = image;
#line 74 "scores/dialog.vala"
		gtk_image_set_pixel_size (_tmp24_, 64);
#line 75 "scores/dialog.vala"
		_tmp25_ = image;
#line 75 "scores/dialog.vala"
		gtk_widget_set_opacity ((GtkWidget*) _tmp25_, 0.2);
#line 76 "scores/dialog.vala"
		_tmp26_ = vbox;
#line 76 "scores/dialog.vala"
		_tmp27_ = image;
#line 76 "scores/dialog.vala"
		gtk_box_pack_start (_tmp26_, (GtkWidget*) _tmp27_, FALSE, FALSE, (guint) 0);
#line 78 "scores/dialog.vala"
		_tmp28_ = g_strconcat ("<b><span size=\"large\">", _ ("No scores yet"), NULL);
#line 78 "scores/dialog.vala"
		_tmp29_ = _tmp28_;
#line 78 "scores/dialog.vala"
		_tmp30_ = g_strconcat (_tmp29_, "</span></b>", NULL);
#line 78 "scores/dialog.vala"
		_tmp31_ = _tmp30_;
#line 78 "scores/dialog.vala"
		_tmp32_ = (GtkLabel*) gtk_label_new (_tmp31_);
#line 78 "scores/dialog.vala"
		g_object_ref_sink (_tmp32_);
#line 78 "scores/dialog.vala"
		_tmp33_ = _tmp32_;
#line 78 "scores/dialog.vala"
		_g_free0 (_tmp31_);
#line 78 "scores/dialog.vala"
		_g_free0 (_tmp29_);
#line 78 "scores/dialog.vala"
		title_label = _tmp33_;
#line 79 "scores/dialog.vala"
		_tmp34_ = title_label;
#line 79 "scores/dialog.vala"
		gtk_label_set_use_markup (_tmp34_, TRUE);
#line 80 "scores/dialog.vala"
		_tmp35_ = vbox;
#line 80 "scores/dialog.vala"
		_tmp36_ = title_label;
#line 80 "scores/dialog.vala"
		gtk_box_pack_start (_tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 0);
#line 82 "scores/dialog.vala"
		_tmp37_ = (GtkLabel*) gtk_label_new (_ ("Play some games and your scores will show up here."));
#line 82 "scores/dialog.vala"
		g_object_ref_sink (_tmp37_);
#line 82 "scores/dialog.vala"
		description_label = _tmp37_;
#line 83 "scores/dialog.vala"
		_tmp38_ = vbox;
#line 83 "scores/dialog.vala"
		_tmp39_ = description_label;
#line 83 "scores/dialog.vala"
		gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 0);
#line 85 "scores/dialog.vala"
		_tmp40_ = vbox;
#line 85 "scores/dialog.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp40_);
#line 87 "scores/dialog.vala"
		g_object_set ((GtkWidget*) self, "width-request", 450, NULL);
#line 88 "scores/dialog.vala"
		g_object_set ((GtkWidget*) self, "height-request", 500, NULL);
#line 90 "scores/dialog.vala"
		_g_object_unref0 (description_label);
#line 90 "scores/dialog.vala"
		_g_object_unref0 (title_label);
#line 90 "scores/dialog.vala"
		_g_object_unref0 (image);
#line 90 "scores/dialog.vala"
		_g_object_unref0 (vbox);
#line 90 "scores/dialog.vala"
		return self;
#line 585 "dialog.c"
	}
#line 93 "scores/dialog.vala"
	_tmp41_ = gtk_dialog_get_content_area ((GtkDialog*) self);
#line 93 "scores/dialog.vala"
	_tmp42_ = _g_object_ref0 (_tmp41_);
#line 93 "scores/dialog.vala"
	vbox = _tmp42_;
#line 94 "scores/dialog.vala"
	_tmp43_ = vbox;
#line 94 "scores/dialog.vala"
	gtk_box_set_spacing (_tmp43_, 20);
#line 95 "scores/dialog.vala"
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 10);
#line 97 "scores/dialog.vala"
	_tmp44_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
#line 97 "scores/dialog.vala"
	g_object_ref_sink (_tmp44_);
#line 97 "scores/dialog.vala"
	catbar = _tmp44_;
#line 98 "scores/dialog.vala"
	_tmp45_ = catbar;
#line 98 "scores/dialog.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp45_, 10);
#line 99 "scores/dialog.vala"
	_tmp46_ = catbar;
#line 99 "scores/dialog.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp46_, GTK_ALIGN_CENTER);
#line 101 "scores/dialog.vala"
	_tmp47_ = games_scores_context_get_categories (context);
#line 101 "scores/dialog.vala"
	categories = _tmp47_;
#line 102 "scores/dialog.vala"
	_tmp48_ = categories;
#line 102 "scores/dialog.vala"
	if (g_list_length (_tmp48_) > ((guint) 1)) {
#line 621 "dialog.c"
		GtkBox* _tmp49_;
		GtkBox* _tmp50_;
		GtkSeparator* hdiv = NULL;
		GtkSeparator* _tmp51_;
		GtkBox* _tmp52_;
		GtkSeparator* _tmp53_;
#line 104 "scores/dialog.vala"
		_tmp49_ = vbox;
#line 104 "scores/dialog.vala"
		_tmp50_ = catbar;
#line 104 "scores/dialog.vala"
		gtk_box_pack_start (_tmp49_, (GtkWidget*) _tmp50_, TRUE, FALSE, (guint) 0);
#line 106 "scores/dialog.vala"
		_tmp51_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 106 "scores/dialog.vala"
		g_object_ref_sink (_tmp51_);
#line 106 "scores/dialog.vala"
		hdiv = _tmp51_;
#line 107 "scores/dialog.vala"
		_tmp52_ = vbox;
#line 107 "scores/dialog.vala"
		_tmp53_ = hdiv;
#line 107 "scores/dialog.vala"
		gtk_box_pack_start (_tmp52_, (GtkWidget*) _tmp53_, FALSE, FALSE, (guint) 0);
#line 102 "scores/dialog.vala"
		_g_object_unref0 (hdiv);
#line 648 "dialog.c"
	}
#line 110 "scores/dialog.vala"
	_tmp54_ = (GtkLabel*) gtk_label_new (category_type);
#line 110 "scores/dialog.vala"
	g_object_ref_sink (_tmp54_);
#line 110 "scores/dialog.vala"
	label = _tmp54_;
#line 111 "scores/dialog.vala"
	_tmp55_ = label;
#line 111 "scores/dialog.vala"
	gtk_label_set_use_markup (_tmp55_, TRUE);
#line 112 "scores/dialog.vala"
	_tmp56_ = label;
#line 112 "scores/dialog.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp56_, GTK_ALIGN_CENTER);
#line 113 "scores/dialog.vala"
	_tmp57_ = catbar;
#line 113 "scores/dialog.vala"
	_tmp58_ = label;
#line 113 "scores/dialog.vala"
	gtk_box_pack_start (_tmp57_, (GtkWidget*) _tmp58_, FALSE, FALSE, (guint) 0);
#line 115 "scores/dialog.vala"
	if (new_high_score != NULL) {
#line 672 "dialog.c"
		GamesScoresCategory* _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		GtkLabel* _tmp62_;
		GtkLabel* _tmp63_;
		GtkLabel* _tmp64_;
		GtkLabel* _tmp65_;
		GtkBox* _tmp66_;
		GtkLabel* _tmp67_;
#line 117 "scores/dialog.vala"
		_tmp59_ = self->priv->scores_active_category;
#line 117 "scores/dialog.vala"
		_tmp60_ = games_scores_category_get_name (_tmp59_);
#line 117 "scores/dialog.vala"
		_tmp61_ = _tmp60_;
#line 117 "scores/dialog.vala"
		_tmp62_ = (GtkLabel*) gtk_label_new (_tmp61_);
#line 117 "scores/dialog.vala"
		g_object_ref_sink (_tmp62_);
#line 117 "scores/dialog.vala"
		_g_object_unref0 (self->priv->category_label);
#line 117 "scores/dialog.vala"
		self->priv->category_label = _tmp62_;
#line 118 "scores/dialog.vala"
		_tmp63_ = self->priv->category_label;
#line 118 "scores/dialog.vala"
		gtk_label_set_use_markup (_tmp63_, TRUE);
#line 119 "scores/dialog.vala"
		_tmp64_ = self->priv->category_label;
#line 119 "scores/dialog.vala"
		gtk_widget_set_halign ((GtkWidget*) _tmp64_, GTK_ALIGN_CENTER);
#line 120 "scores/dialog.vala"
		_tmp65_ = self->priv->category_label;
#line 120 "scores/dialog.vala"
		gtk_widget_set_valign ((GtkWidget*) _tmp65_, GTK_ALIGN_CENTER);
#line 121 "scores/dialog.vala"
		_tmp66_ = catbar;
#line 121 "scores/dialog.vala"
		_tmp67_ = self->priv->category_label;
#line 121 "scores/dialog.vala"
		gtk_box_pack_start (_tmp66_, (GtkWidget*) _tmp67_, FALSE, FALSE, (guint) 0);
#line 714 "dialog.c"
	} else {
		GtkComboBoxText* _tmp68_;
		GtkComboBoxText* _tmp69_;
		GtkBox* _tmp70_;
		GtkComboBoxText* _tmp71_;
		GtkComboBoxText* _tmp72_;
#line 125 "scores/dialog.vala"
		_tmp68_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
#line 125 "scores/dialog.vala"
		g_object_ref_sink (_tmp68_);
#line 125 "scores/dialog.vala"
		_g_object_unref0 (self->priv->combo);
#line 125 "scores/dialog.vala"
		self->priv->combo = _tmp68_;
#line 126 "scores/dialog.vala"
		_tmp69_ = self->priv->combo;
#line 126 "scores/dialog.vala"
		gtk_widget_set_focus_on_click ((GtkWidget*) _tmp69_, FALSE);
#line 127 "scores/dialog.vala"
		_tmp70_ = catbar;
#line 127 "scores/dialog.vala"
		_tmp71_ = self->priv->combo;
#line 127 "scores/dialog.vala"
		gtk_box_pack_start (_tmp70_, (GtkWidget*) _tmp71_, TRUE, TRUE, (guint) 0);
#line 128 "scores/dialog.vala"
		_tmp72_ = self->priv->combo;
#line 128 "scores/dialog.vala"
		g_signal_connect_object ((GtkComboBox*) _tmp72_, "changed", (GCallback) _games_scores_dialog_load_scores_gtk_combo_box_changed, self, 0);
#line 743 "dialog.c"
	}
#line 131 "scores/dialog.vala"
	_tmp73_ = (GtkGrid*) gtk_grid_new ();
#line 131 "scores/dialog.vala"
	g_object_ref_sink (_tmp73_);
#line 131 "scores/dialog.vala"
	_g_object_unref0 (self->priv->grid);
#line 131 "scores/dialog.vala"
	self->priv->grid = _tmp73_;
#line 132 "scores/dialog.vala"
	_tmp74_ = vbox;
#line 132 "scores/dialog.vala"
	_tmp75_ = self->priv->grid;
#line 132 "scores/dialog.vala"
	gtk_box_pack_start (_tmp74_, (GtkWidget*) _tmp75_, FALSE, FALSE, (guint) 0);
#line 134 "scores/dialog.vala"
	_tmp76_ = self->priv->grid;
#line 134 "scores/dialog.vala"
	gtk_grid_set_row_homogeneous (_tmp76_, TRUE);
#line 135 "scores/dialog.vala"
	_tmp77_ = self->priv->grid;
#line 135 "scores/dialog.vala"
	gtk_grid_set_column_spacing (_tmp77_, 40);
#line 136 "scores/dialog.vala"
	_tmp78_ = self->priv->grid;
#line 136 "scores/dialog.vala"
	g_object_set ((GtkWidget*) _tmp78_, "margin", 20, NULL);
#line 137 "scores/dialog.vala"
	_tmp79_ = self->priv->grid;
#line 137 "scores/dialog.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp79_, GTK_ALIGN_CENTER);
#line 140 "scores/dialog.vala"
	_tmp80_ = g_strdup (_ ("Rank"));
#line 140 "scores/dialog.vala"
	string_rank = _tmp80_;
#line 141 "scores/dialog.vala"
	_tmp81_ = string_rank;
#line 141 "scores/dialog.vala"
	_tmp82_ = g_strconcat ("<span weight='bold'>", _tmp81_, NULL);
#line 141 "scores/dialog.vala"
	_tmp83_ = _tmp82_;
#line 141 "scores/dialog.vala"
	_tmp84_ = g_strconcat (_tmp83_, "</span>", NULL);
#line 141 "scores/dialog.vala"
	_tmp85_ = _tmp84_;
#line 141 "scores/dialog.vala"
	_tmp86_ = (GtkLabel*) gtk_label_new (_tmp85_);
#line 141 "scores/dialog.vala"
	g_object_ref_sink (_tmp86_);
#line 141 "scores/dialog.vala"
	_tmp87_ = _tmp86_;
#line 141 "scores/dialog.vala"
	_g_free0 (_tmp85_);
#line 141 "scores/dialog.vala"
	_g_free0 (_tmp83_);
#line 141 "scores/dialog.vala"
	label_column_1 = _tmp87_;
#line 142 "scores/dialog.vala"
	_tmp88_ = label_column_1;
#line 142 "scores/dialog.vala"
	gtk_label_set_use_markup (_tmp88_, TRUE);
#line 143 "scores/dialog.vala"
	_tmp89_ = self->priv->grid;
#line 143 "scores/dialog.vala"
	_tmp90_ = label_column_1;
#line 143 "scores/dialog.vala"
	gtk_grid_attach (_tmp89_, (GtkWidget*) _tmp90_, 0, 0, 1, 1);
#line 145 "scores/dialog.vala"
	_tmp91_ = g_strdup ("");
#line 145 "scores/dialog.vala"
	score_or_time = _tmp91_;
#line 147 "scores/dialog.vala"
	_tmp93_ = self->priv->scores_style;
#line 147 "scores/dialog.vala"
	if (_tmp93_ == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
#line 147 "scores/dialog.vala"
		_tmp92_ = TRUE;
#line 821 "dialog.c"
	} else {
		GamesScoresStyle _tmp94_;
#line 147 "scores/dialog.vala"
		_tmp94_ = self->priv->scores_style;
#line 147 "scores/dialog.vala"
		_tmp92_ = _tmp94_ == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
#line 828 "dialog.c"
	}
#line 147 "scores/dialog.vala"
	if (_tmp92_) {
#line 832 "dialog.c"
		gchar* _tmp95_;
#line 149 "scores/dialog.vala"
		_tmp95_ = g_strdup (_ ("Score"));
#line 149 "scores/dialog.vala"
		_g_free0 (score_or_time);
#line 149 "scores/dialog.vala"
		score_or_time = _tmp95_;
#line 840 "dialog.c"
	} else {
		gchar* _tmp96_;
#line 151 "scores/dialog.vala"
		_tmp96_ = g_strdup (_ ("Time"));
#line 151 "scores/dialog.vala"
		_g_free0 (score_or_time);
#line 151 "scores/dialog.vala"
		score_or_time = _tmp96_;
#line 849 "dialog.c"
	}
#line 153 "scores/dialog.vala"
	_tmp97_ = score_or_time;
#line 153 "scores/dialog.vala"
	_tmp98_ = g_strconcat ("<span weight='bold'>", _tmp97_, NULL);
#line 153 "scores/dialog.vala"
	_tmp99_ = _tmp98_;
#line 153 "scores/dialog.vala"
	_tmp100_ = g_strconcat (_tmp99_, "</span>", NULL);
#line 153 "scores/dialog.vala"
	_tmp101_ = _tmp100_;
#line 153 "scores/dialog.vala"
	_tmp102_ = (GtkLabel*) gtk_label_new (_tmp101_);
#line 153 "scores/dialog.vala"
	g_object_ref_sink (_tmp102_);
#line 153 "scores/dialog.vala"
	_tmp103_ = _tmp102_;
#line 153 "scores/dialog.vala"
	_g_free0 (_tmp101_);
#line 153 "scores/dialog.vala"
	_g_free0 (_tmp99_);
#line 153 "scores/dialog.vala"
	label_column_2 = _tmp103_;
#line 154 "scores/dialog.vala"
	_tmp104_ = label_column_2;
#line 154 "scores/dialog.vala"
	gtk_label_set_use_markup (_tmp104_, TRUE);
#line 155 "scores/dialog.vala"
	_tmp105_ = self->priv->grid;
#line 155 "scores/dialog.vala"
	_tmp106_ = label_column_2;
#line 155 "scores/dialog.vala"
	gtk_grid_attach (_tmp105_, (GtkWidget*) _tmp106_, 1, 0, 1, 1);
#line 158 "scores/dialog.vala"
	_tmp107_ = g_strdup (_ ("Player"));
#line 158 "scores/dialog.vala"
	string_player = _tmp107_;
#line 159 "scores/dialog.vala"
	_tmp108_ = string_player;
#line 159 "scores/dialog.vala"
	_tmp109_ = g_strconcat ("<span weight='bold'>", _tmp108_, NULL);
#line 159 "scores/dialog.vala"
	_tmp110_ = _tmp109_;
#line 159 "scores/dialog.vala"
	_tmp111_ = g_strconcat (_tmp110_, "</span>", NULL);
#line 159 "scores/dialog.vala"
	_tmp112_ = _tmp111_;
#line 159 "scores/dialog.vala"
	_tmp113_ = (GtkLabel*) gtk_label_new (_tmp112_);
#line 159 "scores/dialog.vala"
	g_object_ref_sink (_tmp113_);
#line 159 "scores/dialog.vala"
	_tmp114_ = _tmp113_;
#line 159 "scores/dialog.vala"
	_g_free0 (_tmp112_);
#line 159 "scores/dialog.vala"
	_g_free0 (_tmp110_);
#line 159 "scores/dialog.vala"
	label_column_3 = _tmp114_;
#line 160 "scores/dialog.vala"
	_tmp115_ = label_column_3;
#line 160 "scores/dialog.vala"
	gtk_label_set_use_markup (_tmp115_, TRUE);
#line 161 "scores/dialog.vala"
	_tmp116_ = self->priv->grid;
#line 161 "scores/dialog.vala"
	_tmp117_ = label_column_3;
#line 161 "scores/dialog.vala"
	gtk_grid_attach (_tmp116_, (GtkWidget*) _tmp117_, 2, 0, 1, 1);
#line 163 "scores/dialog.vala"
	_tmp118_ = self->priv->grid;
#line 163 "scores/dialog.vala"
	gtk_grid_set_baseline_row (_tmp118_, 0);
#line 164 "scores/dialog.vala"
	games_scores_dialog_fill_grid_with_labels (self);
#line 166 "scores/dialog.vala"
	if (new_high_score != NULL) {
#line 927 "dialog.c"
		GtkWidget* _tmp119_;
		GtkStyleContext* _tmp120_;
#line 168 "scores/dialog.vala"
		_tmp119_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("_Done"), (gint) GTK_RESPONSE_OK);
#line 168 "scores/dialog.vala"
		_tmp120_ = gtk_widget_get_style_context (_tmp119_);
#line 168 "scores/dialog.vala"
		gtk_style_context_add_class (_tmp120_, "suggested-action");
#line 936 "dialog.c"
	}
#line 170 "scores/dialog.vala"
	games_scores_dialog_load_categories (self);
#line 172 "scores/dialog.vala"
	_tmp121_ = vbox;
#line 172 "scores/dialog.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp121_);
#line 39 "scores/dialog.vala"
	_g_object_unref0 (label_column_3);
#line 39 "scores/dialog.vala"
	_g_free0 (string_player);
#line 39 "scores/dialog.vala"
	_g_object_unref0 (label_column_2);
#line 39 "scores/dialog.vala"
	_g_free0 (score_or_time);
#line 39 "scores/dialog.vala"
	_g_object_unref0 (label_column_1);
#line 39 "scores/dialog.vala"
	_g_free0 (string_rank);
#line 39 "scores/dialog.vala"
	_g_object_unref0 (label);
#line 39 "scores/dialog.vala"
	(categories == NULL) ? NULL : (categories = (_g_list_free__g_object_unref0_ (categories), NULL));
#line 39 "scores/dialog.vala"
	_g_object_unref0 (catbar);
#line 39 "scores/dialog.vala"
	_g_object_unref0 (vbox);
#line 39 "scores/dialog.vala"
	return self;
#line 966 "dialog.c"
}


GamesScoresDialog*
games_scores_dialog_new (GamesScoresContext* context,
                         const gchar* category_type,
                         GamesScoresStyle style,
                         GamesScoresScore* new_high_score,
                         GamesScoresCategory* current_cat,
                         GtkWindow* window,
                         const gchar* app_name)
{
#line 39 "scores/dialog.vala"
	return games_scores_dialog_construct (GAMES_SCORES_TYPE_DIALOG, context, category_type, style, new_high_score, current_cat, window, app_name);
#line 981 "dialog.c"
}


static void
games_scores_dialog_fill_grid_with_labels (GamesScoresDialog* self)
{
#line 175 "scores/dialog.vala"
	g_return_if_fail (self != NULL);
#line 990 "dialog.c"
	{
		gint row = 0;
#line 177 "scores/dialog.vala"
		row = 1;
#line 995 "dialog.c"
		{
			gboolean _tmp0_ = FALSE;
#line 177 "scores/dialog.vala"
			_tmp0_ = TRUE;
#line 177 "scores/dialog.vala"
			while (TRUE) {
#line 1002 "dialog.c"
				gint _tmp2_;
				gint _tmp3_;
				GtkStack* stack = NULL;
				GtkStack* _tmp15_;
				GtkStack* _tmp16_;
				GtkStack* _tmp17_;
				GtkStack* _tmp18_;
				GtkStack* _tmp19_;
				GtkLabel* label = NULL;
				GtkLabel* _tmp20_;
				GtkLabel* _tmp21_;
				GtkLabel* _tmp22_;
				GtkLabel* _tmp23_;
				GtkStack* _tmp24_;
				GtkLabel* _tmp25_;
				GtkEntry* entry = NULL;
				GtkEntry* _tmp26_;
				GtkEntry* _tmp27_;
				GtkEntry* _tmp28_;
				GtkEntry* _tmp29_;
				GtkStack* _tmp30_;
				GtkEntry* _tmp31_;
				GtkStack* _tmp32_;
				GtkGrid* _tmp33_;
				GtkStack* _tmp34_;
				gint _tmp35_;
#line 177 "scores/dialog.vala"
				if (!_tmp0_) {
#line 1031 "dialog.c"
					gint _tmp1_;
#line 177 "scores/dialog.vala"
					_tmp1_ = row;
#line 177 "scores/dialog.vala"
					row = _tmp1_ + 1;
#line 1037 "dialog.c"
				}
#line 177 "scores/dialog.vala"
				_tmp0_ = FALSE;
#line 177 "scores/dialog.vala"
				_tmp2_ = row;
#line 177 "scores/dialog.vala"
				_tmp3_ = self->priv->rows_to_display;
#line 177 "scores/dialog.vala"
				if (!(_tmp2_ <= _tmp3_)) {
#line 177 "scores/dialog.vala"
					break;
#line 1049 "dialog.c"
				}
				{
					gint column = 0;
#line 179 "scores/dialog.vala"
					column = 0;
#line 1055 "dialog.c"
					{
						gboolean _tmp4_ = FALSE;
#line 179 "scores/dialog.vala"
						_tmp4_ = TRUE;
#line 179 "scores/dialog.vala"
						while (TRUE) {
#line 1062 "dialog.c"
							gint _tmp6_;
							GtkLabel* label = NULL;
							GtkLabel* _tmp7_;
							GtkLabel* _tmp8_;
							GtkLabel* _tmp9_;
							GtkLabel* _tmp10_;
							GtkGrid* _tmp11_;
							GtkLabel* _tmp12_;
							gint _tmp13_;
							gint _tmp14_;
#line 179 "scores/dialog.vala"
							if (!_tmp4_) {
#line 1075 "dialog.c"
								gint _tmp5_;
#line 179 "scores/dialog.vala"
								_tmp5_ = column;
#line 179 "scores/dialog.vala"
								column = _tmp5_ + 1;
#line 1081 "dialog.c"
							}
#line 179 "scores/dialog.vala"
							_tmp4_ = FALSE;
#line 179 "scores/dialog.vala"
							_tmp6_ = column;
#line 179 "scores/dialog.vala"
							if (!(_tmp6_ <= 1)) {
#line 179 "scores/dialog.vala"
								break;
#line 1091 "dialog.c"
							}
#line 181 "scores/dialog.vala"
							_tmp7_ = (GtkLabel*) gtk_label_new ("");
#line 181 "scores/dialog.vala"
							g_object_ref_sink (_tmp7_);
#line 181 "scores/dialog.vala"
							label = _tmp7_;
#line 182 "scores/dialog.vala"
							_tmp8_ = label;
#line 182 "scores/dialog.vala"
							gtk_widget_set_visible ((GtkWidget*) _tmp8_, TRUE);
#line 183 "scores/dialog.vala"
							_tmp9_ = label;
#line 183 "scores/dialog.vala"
							gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_CENTER);
#line 184 "scores/dialog.vala"
							_tmp10_ = label;
#line 184 "scores/dialog.vala"
							gtk_widget_set_valign ((GtkWidget*) _tmp10_, GTK_ALIGN_CENTER);
#line 186 "scores/dialog.vala"
							_tmp11_ = self->priv->grid;
#line 186 "scores/dialog.vala"
							_tmp12_ = label;
#line 186 "scores/dialog.vala"
							_tmp13_ = column;
#line 186 "scores/dialog.vala"
							_tmp14_ = row;
#line 186 "scores/dialog.vala"
							gtk_grid_attach (_tmp11_, (GtkWidget*) _tmp12_, _tmp13_, _tmp14_, 1, 1);
#line 179 "scores/dialog.vala"
							_g_object_unref0 (label);
#line 1123 "dialog.c"
						}
					}
				}
#line 189 "scores/dialog.vala"
				_tmp15_ = (GtkStack*) gtk_stack_new ();
#line 189 "scores/dialog.vala"
				g_object_ref_sink (_tmp15_);
#line 189 "scores/dialog.vala"
				stack = _tmp15_;
#line 190 "scores/dialog.vala"
				_tmp16_ = stack;
#line 190 "scores/dialog.vala"
				gtk_widget_set_visible ((GtkWidget*) _tmp16_, TRUE);
#line 191 "scores/dialog.vala"
				_tmp17_ = stack;
#line 191 "scores/dialog.vala"
				gtk_stack_set_homogeneous (_tmp17_, FALSE);
#line 192 "scores/dialog.vala"
				_tmp18_ = stack;
#line 192 "scores/dialog.vala"
				gtk_stack_set_vhomogeneous (_tmp18_, TRUE);
#line 193 "scores/dialog.vala"
				_tmp19_ = stack;
#line 193 "scores/dialog.vala"
				gtk_stack_set_transition_type (_tmp19_, GTK_STACK_TRANSITION_TYPE_NONE);
#line 195 "scores/dialog.vala"
				_tmp20_ = (GtkLabel*) gtk_label_new ("");
#line 195 "scores/dialog.vala"
				g_object_ref_sink (_tmp20_);
#line 195 "scores/dialog.vala"
				label = _tmp20_;
#line 196 "scores/dialog.vala"
				_tmp21_ = label;
#line 196 "scores/dialog.vala"
				gtk_widget_set_visible ((GtkWidget*) _tmp21_, TRUE);
#line 197 "scores/dialog.vala"
				_tmp22_ = label;
#line 197 "scores/dialog.vala"
				gtk_label_set_justify (_tmp22_, GTK_JUSTIFY_CENTER);
#line 198 "scores/dialog.vala"
				_tmp23_ = label;
#line 198 "scores/dialog.vala"
				gtk_widget_set_valign ((GtkWidget*) _tmp23_, GTK_ALIGN_CENTER);
#line 199 "scores/dialog.vala"
				_tmp24_ = stack;
#line 199 "scores/dialog.vala"
				_tmp25_ = label;
#line 199 "scores/dialog.vala"
				gtk_stack_add_named (_tmp24_, (GtkWidget*) _tmp25_, "label");
#line 201 "scores/dialog.vala"
				_tmp26_ = (GtkEntry*) gtk_entry_new ();
#line 201 "scores/dialog.vala"
				g_object_ref_sink (_tmp26_);
#line 201 "scores/dialog.vala"
				entry = _tmp26_;
#line 202 "scores/dialog.vala"
				_tmp27_ = entry;
#line 202 "scores/dialog.vala"
				gtk_widget_set_visible ((GtkWidget*) _tmp27_, TRUE);
#line 203 "scores/dialog.vala"
				_tmp28_ = entry;
#line 203 "scores/dialog.vala"
				gtk_widget_set_size_request ((GtkWidget*) _tmp28_, 20, 20);
#line 204 "scores/dialog.vala"
				_tmp29_ = entry;
#line 204 "scores/dialog.vala"
				g_object_set ((GtkWidget*) _tmp29_, "expand", FALSE, NULL);
#line 205 "scores/dialog.vala"
				_tmp30_ = stack;
#line 205 "scores/dialog.vala"
				_tmp31_ = entry;
#line 205 "scores/dialog.vala"
				gtk_stack_add_named (_tmp30_, (GtkWidget*) _tmp31_, "entry");
#line 207 "scores/dialog.vala"
				_tmp32_ = stack;
#line 207 "scores/dialog.vala"
				gtk_stack_set_visible_child_name (_tmp32_, "label");
#line 208 "scores/dialog.vala"
				_tmp33_ = self->priv->grid;
#line 208 "scores/dialog.vala"
				_tmp34_ = stack;
#line 208 "scores/dialog.vala"
				_tmp35_ = row;
#line 208 "scores/dialog.vala"
				gtk_grid_attach (_tmp33_, (GtkWidget*) _tmp34_, 2, _tmp35_, 1, 1);
#line 177 "scores/dialog.vala"
				_g_object_unref0 (entry);
#line 177 "scores/dialog.vala"
				_g_object_unref0 (label);
#line 177 "scores/dialog.vala"
				_g_object_unref0 (stack);
#line 1215 "dialog.c"
			}
		}
	}
}


static void
__lambda10_ (GamesScoresDialog* self,
             GamesScoresCategory* x)
{
	GtkComboBoxText* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 225 "scores/dialog.vala"
	_tmp0_ = self->priv->combo;
#line 225 "scores/dialog.vala"
	_tmp1_ = games_scores_category_get_key (x);
#line 225 "scores/dialog.vala"
	_tmp2_ = _tmp1_;
#line 225 "scores/dialog.vala"
	_tmp3_ = games_scores_category_get_name (x);
#line 225 "scores/dialog.vala"
	_tmp4_ = _tmp3_;
#line 225 "scores/dialog.vala"
	gtk_combo_box_text_append (_tmp0_, _tmp2_, _tmp4_);
#line 1243 "dialog.c"
}


static void
___lambda10__gfunc (gconstpointer data,
                    gpointer self)
{
#line 225 "scores/dialog.vala"
	__lambda10_ ((GamesScoresDialog*) self, (GamesScoresCategory*) data);
#line 1253 "dialog.c"
}


static void
games_scores_dialog_load_categories (GamesScoresDialog* self)
{
	GamesScoresScore* _tmp0_;
	GtkComboBoxText* _tmp1_;
	GList* categories = NULL;
	GamesScoresContext* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GamesScoresCategory* _tmp5_;
	GamesScoresCategory* _tmp15_;
#line 213 "scores/dialog.vala"
	g_return_if_fail (self != NULL);
#line 216 "scores/dialog.vala"
	_tmp0_ = self->priv->new_high_score;
#line 216 "scores/dialog.vala"
	if (_tmp0_ != NULL) {
#line 218 "scores/dialog.vala"
		games_scores_dialog_load_scores (self);
#line 1276 "dialog.c"
	}
#line 221 "scores/dialog.vala"
	_tmp1_ = self->priv->combo;
#line 221 "scores/dialog.vala"
	if (_tmp1_ == NULL) {
#line 222 "scores/dialog.vala"
		return;
#line 1284 "dialog.c"
	}
#line 224 "scores/dialog.vala"
	_tmp2_ = self->priv->context;
#line 224 "scores/dialog.vala"
	_tmp3_ = games_scores_context_get_categories (_tmp2_);
#line 224 "scores/dialog.vala"
	categories = _tmp3_;
#line 225 "scores/dialog.vala"
	_tmp4_ = categories;
#line 225 "scores/dialog.vala"
	g_list_foreach (_tmp4_, ___lambda10__gfunc, self);
#line 227 "scores/dialog.vala"
	_tmp5_ = self->priv->scores_active_category;
#line 227 "scores/dialog.vala"
	if (_tmp5_ == NULL) {
#line 1300 "dialog.c"
		GtkComboBoxText* _tmp6_;
		GList* _tmp7_;
		gconstpointer _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 228 "scores/dialog.vala"
		_tmp6_ = self->priv->combo;
#line 228 "scores/dialog.vala"
		_tmp7_ = categories;
#line 228 "scores/dialog.vala"
		_tmp8_ = g_list_nth_data (_tmp7_, (guint) 0);
#line 228 "scores/dialog.vala"
		_tmp9_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp8_);
#line 228 "scores/dialog.vala"
		_tmp10_ = _tmp9_;
#line 228 "scores/dialog.vala"
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp6_, _tmp10_);
#line 1318 "dialog.c"
	} else {
		GtkComboBoxText* _tmp11_;
		GamesScoresCategory* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
#line 230 "scores/dialog.vala"
		_tmp11_ = self->priv->combo;
#line 230 "scores/dialog.vala"
		_tmp12_ = self->priv->scores_active_category;
#line 230 "scores/dialog.vala"
		_tmp13_ = games_scores_category_get_key (_tmp12_);
#line 230 "scores/dialog.vala"
		_tmp14_ = _tmp13_;
#line 230 "scores/dialog.vala"
		gtk_combo_box_set_active_id ((GtkComboBox*) _tmp11_, _tmp14_);
#line 1334 "dialog.c"
	}
#line 232 "scores/dialog.vala"
	_tmp15_ = self->priv->active_category;
#line 232 "scores/dialog.vala"
	if (_tmp15_ == NULL) {
#line 1340 "dialog.c"
		GList* _tmp16_;
		gconstpointer _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		GList* _tmp20_;
		gconstpointer _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		GamesScoresCategory* _tmp24_;
#line 234 "scores/dialog.vala"
		_tmp16_ = categories;
#line 234 "scores/dialog.vala"
		_tmp17_ = g_list_nth_data (_tmp16_, (guint) 0);
#line 234 "scores/dialog.vala"
		_tmp18_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp17_);
#line 234 "scores/dialog.vala"
		_tmp19_ = _tmp18_;
#line 234 "scores/dialog.vala"
		_tmp20_ = categories;
#line 234 "scores/dialog.vala"
		_tmp21_ = g_list_nth_data (_tmp20_, (guint) 0);
#line 234 "scores/dialog.vala"
		_tmp22_ = games_scores_category_get_name ((GamesScoresCategory*) _tmp21_);
#line 234 "scores/dialog.vala"
		_tmp23_ = _tmp22_;
#line 234 "scores/dialog.vala"
		_tmp24_ = games_scores_category_new (_tmp19_, _tmp23_);
#line 234 "scores/dialog.vala"
		_g_object_unref0 (self->priv->active_category);
#line 234 "scores/dialog.vala"
		self->priv->active_category = _tmp24_;
#line 1372 "dialog.c"
	} else {
		GamesScoresCategory* _tmp25_;
		GList* _tmp26_;
		gconstpointer _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		GamesScoresCategory* _tmp30_;
		GList* _tmp31_;
		gconstpointer _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
#line 238 "scores/dialog.vala"
		_tmp25_ = self->priv->active_category;
#line 238 "scores/dialog.vala"
		_tmp26_ = categories;
#line 238 "scores/dialog.vala"
		_tmp27_ = g_list_nth_data (_tmp26_, (guint) 0);
#line 238 "scores/dialog.vala"
		_tmp28_ = games_scores_category_get_key ((GamesScoresCategory*) _tmp27_);
#line 238 "scores/dialog.vala"
		_tmp29_ = _tmp28_;
#line 238 "scores/dialog.vala"
		games_scores_category_set_key (_tmp25_, _tmp29_);
#line 239 "scores/dialog.vala"
		_tmp30_ = self->priv->active_category;
#line 239 "scores/dialog.vala"
		_tmp31_ = categories;
#line 239 "scores/dialog.vala"
		_tmp32_ = g_list_nth_data (_tmp31_, (guint) 0);
#line 239 "scores/dialog.vala"
		_tmp33_ = games_scores_category_get_name ((GamesScoresCategory*) _tmp32_);
#line 239 "scores/dialog.vala"
		_tmp34_ = _tmp33_;
#line 239 "scores/dialog.vala"
		games_scores_category_set_name (_tmp30_, _tmp34_);
#line 1408 "dialog.c"
	}
#line 213 "scores/dialog.vala"
	(categories == NULL) ? NULL : (categories = (_g_list_free__g_object_unref0_ (categories), NULL));
#line 1412 "dialog.c"
}


static void
games_scores_dialog_load_scores (GamesScoresDialog* self)
{
	GamesScoresScore* _tmp0_;
	GeeList* best_n_scores = NULL;
	GamesScoresContext* _tmp14_;
	GamesScoresCategory* _tmp15_;
	gint _tmp16_;
	GeeList* _tmp17_;
	gint row_count = 0;
	gint _tmp35_;
	gint _tmp36_;
#line 244 "scores/dialog.vala"
	g_return_if_fail (self != NULL);
#line 246 "scores/dialog.vala"
	_tmp0_ = self->priv->new_high_score;
#line 246 "scores/dialog.vala"
	if (_tmp0_ != NULL) {
#line 1434 "dialog.c"
		GamesScoresCategory* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		GamesScoresCategory* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GamesScoresCategory* _tmp7_;
#line 247 "scores/dialog.vala"
		_tmp1_ = self->priv->scores_active_category;
#line 247 "scores/dialog.vala"
		_tmp2_ = games_scores_category_get_key (_tmp1_);
#line 247 "scores/dialog.vala"
		_tmp3_ = _tmp2_;
#line 247 "scores/dialog.vala"
		_tmp4_ = self->priv->scores_active_category;
#line 247 "scores/dialog.vala"
		_tmp5_ = games_scores_category_get_name (_tmp4_);
#line 247 "scores/dialog.vala"
		_tmp6_ = _tmp5_;
#line 247 "scores/dialog.vala"
		_tmp7_ = games_scores_category_new (_tmp3_, _tmp6_);
#line 247 "scores/dialog.vala"
		_g_object_unref0 (self->priv->active_category);
#line 247 "scores/dialog.vala"
		self->priv->active_category = _tmp7_;
#line 1460 "dialog.c"
	} else {
		GtkComboBoxText* _tmp8_;
		const gchar* _tmp9_;
		GtkComboBoxText* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GamesScoresCategory* _tmp13_;
#line 249 "scores/dialog.vala"
		_tmp8_ = self->priv->combo;
#line 249 "scores/dialog.vala"
		_tmp9_ = gtk_combo_box_get_active_id ((GtkComboBox*) _tmp8_);
#line 249 "scores/dialog.vala"
		_tmp10_ = self->priv->combo;
#line 249 "scores/dialog.vala"
		_tmp11_ = gtk_combo_box_text_get_active_text (_tmp10_);
#line 249 "scores/dialog.vala"
		_tmp12_ = _tmp11_;
#line 249 "scores/dialog.vala"
		_tmp13_ = games_scores_category_new (_tmp9_, _tmp12_);
#line 249 "scores/dialog.vala"
		_g_object_unref0 (self->priv->active_category);
#line 249 "scores/dialog.vala"
		self->priv->active_category = _tmp13_;
#line 249 "scores/dialog.vala"
		_g_free0 (_tmp12_);
#line 1486 "dialog.c"
	}
#line 251 "scores/dialog.vala"
	_tmp14_ = self->priv->context;
#line 251 "scores/dialog.vala"
	_tmp15_ = self->priv->active_category;
#line 251 "scores/dialog.vala"
	_tmp16_ = self->priv->rows_to_display;
#line 251 "scores/dialog.vala"
	_tmp17_ = games_scores_context_get_high_scores (_tmp14_, _tmp15_, _tmp16_);
#line 251 "scores/dialog.vala"
	best_n_scores = _tmp17_;
#line 253 "scores/dialog.vala"
	row_count = 1;
#line 1500 "dialog.c"
	{
		GeeList* _score_list = NULL;
		GeeList* _tmp18_;
		GeeList* _tmp19_;
		gint _score_size = 0;
		GeeList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _score_index = 0;
#line 255 "scores/dialog.vala"
		_tmp18_ = best_n_scores;
#line 255 "scores/dialog.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 255 "scores/dialog.vala"
		_score_list = _tmp19_;
#line 255 "scores/dialog.vala"
		_tmp20_ = _score_list;
#line 255 "scores/dialog.vala"
		_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
#line 255 "scores/dialog.vala"
		_tmp22_ = _tmp21_;
#line 255 "scores/dialog.vala"
		_score_size = _tmp22_;
#line 255 "scores/dialog.vala"
		_score_index = -1;
#line 255 "scores/dialog.vala"
		while (TRUE) {
#line 1528 "dialog.c"
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			GamesScoresScore* score = NULL;
			GeeList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_;
			GamesScoresScore* _tmp29_;
			gint _tmp30_;
			GeeList* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
#line 255 "scores/dialog.vala"
			_tmp23_ = _score_index;
#line 255 "scores/dialog.vala"
			_score_index = _tmp23_ + 1;
#line 255 "scores/dialog.vala"
			_tmp24_ = _score_index;
#line 255 "scores/dialog.vala"
			_tmp25_ = _score_size;
#line 255 "scores/dialog.vala"
			if (!(_tmp24_ < _tmp25_)) {
#line 255 "scores/dialog.vala"
				break;
#line 1554 "dialog.c"
			}
#line 255 "scores/dialog.vala"
			_tmp26_ = _score_list;
#line 255 "scores/dialog.vala"
			_tmp27_ = _score_index;
#line 255 "scores/dialog.vala"
			_tmp28_ = gee_list_get (_tmp26_, _tmp27_);
#line 255 "scores/dialog.vala"
			score = (GamesScoresScore*) _tmp28_;
#line 257 "scores/dialog.vala"
			_tmp29_ = score;
#line 257 "scores/dialog.vala"
			_tmp30_ = row_count;
#line 257 "scores/dialog.vala"
			_tmp31_ = best_n_scores;
#line 257 "scores/dialog.vala"
			_tmp32_ = gee_collection_get_size ((GeeCollection*) _tmp31_);
#line 257 "scores/dialog.vala"
			_tmp33_ = _tmp32_;
#line 257 "scores/dialog.vala"
			games_scores_dialog_display_single_score (self, _tmp29_, _tmp30_, (guint) _tmp33_);
#line 258 "scores/dialog.vala"
			_tmp34_ = row_count;
#line 258 "scores/dialog.vala"
			row_count = _tmp34_ + 1;
#line 255 "scores/dialog.vala"
			_g_object_unref0 (score);
#line 1582 "dialog.c"
		}
#line 255 "scores/dialog.vala"
		_g_object_unref0 (_score_list);
#line 1586 "dialog.c"
	}
#line 261 "scores/dialog.vala"
	_tmp35_ = row_count;
#line 261 "scores/dialog.vala"
	_tmp36_ = self->priv->rows_to_display;
#line 261 "scores/dialog.vala"
	if (_tmp35_ < (_tmp36_ + 1)) {
#line 1594 "dialog.c"
		gint _tmp37_;
#line 262 "scores/dialog.vala"
		_tmp37_ = row_count;
#line 262 "scores/dialog.vala"
		games_scores_dialog_make_remaining_labels_empty (self, _tmp37_);
#line 1600 "dialog.c"
	}
#line 244 "scores/dialog.vala"
	_g_object_unref0 (best_n_scores);
#line 1604 "dialog.c"
}


static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 267 "scores/dialog.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 267 "scores/dialog.vala"
	return _data4_;
#line 1615 "dialog.c"
}


static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 267 "scores/dialog.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 1626 "dialog.c"
		GamesScoresDialog* self;
#line 267 "scores/dialog.vala"
		self = _data4_->self;
#line 267 "scores/dialog.vala"
		_g_object_unref0 (_data4_->score);
#line 267 "scores/dialog.vala"
		_g_object_unref0 (self);
#line 267 "scores/dialog.vala"
		g_slice_free (Block4Data, _data4_);
#line 1636 "dialog.c"
	}
}


static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
#line 288 "scores/dialog.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 288 "scores/dialog.vala"
	return _data5_;
#line 1648 "dialog.c"
}


static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 288 "scores/dialog.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 1659 "dialog.c"
		GamesScoresDialog* self;
#line 288 "scores/dialog.vala"
		self = _data5_->_data4_->self;
#line 288 "scores/dialog.vala"
		_g_object_unref0 (_data5_->entry);
#line 288 "scores/dialog.vala"
		block4_data_unref (_data5_->_data4_);
#line 288 "scores/dialog.vala"
		_data5_->_data4_ = NULL;
#line 288 "scores/dialog.vala"
		g_slice_free (Block5Data, _data5_);
#line 1671 "dialog.c"
	}
}


static void
___lambda9_ (Block5Data* _data5_)
{
	Block4Data* _data4_;
	GamesScoresDialog* self;
	GamesScoresContext* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
#line 300 "scores/dialog.vala"
	_data4_ = _data5_->_data4_;
#line 300 "scores/dialog.vala"
	self = _data4_->self;
#line 301 "scores/dialog.vala"
	_tmp0_ = self->priv->context;
#line 301 "scores/dialog.vala"
	_tmp1_ = self->priv->active_category;
#line 301 "scores/dialog.vala"
	_tmp2_ = _data5_->entry;
#line 301 "scores/dialog.vala"
	_tmp3_ = gtk_entry_get_text (_tmp2_);
#line 301 "scores/dialog.vala"
	games_scores_context_update_score_name (_tmp0_, _data4_->score, _tmp1_, _tmp3_);
#line 302 "scores/dialog.vala"
	_tmp4_ = _data5_->entry;
#line 302 "scores/dialog.vala"
	_tmp5_ = gtk_entry_get_text (_tmp4_);
#line 302 "scores/dialog.vala"
	games_scores_score_set_user (_data4_->score, _tmp5_);
#line 1707 "dialog.c"
}


static void
____lambda9__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 300 "scores/dialog.vala"
	___lambda9_ (self);
#line 1718 "dialog.c"
}


static void
games_scores_dialog_display_single_score (GamesScoresDialog* self,
                                          GamesScoresScore* score,
                                          gint row_count,
                                          guint no_scores)
{
	Block4Data* _data4_;
	GamesScoresScore* _tmp0_;
	GtkLabel* rank_label = NULL;
	GtkGrid* _tmp1_;
	GtkWidget* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkLabel* score_label = NULL;
	GtkGrid* _tmp7_;
	GtkWidget* _tmp8_;
	GtkLabel* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GamesScoresStyle _tmp11_;
	gboolean _tmp33_ = FALSE;
	GamesScoresScore* _tmp34_;
	GtkStack* name_stack = NULL;
	GtkGrid* _tmp50_;
	GtkWidget* _tmp51_;
	GtkStack* _tmp52_;
	GtkWidget* widget = NULL;
	GtkStack* _tmp53_;
	GtkWidget* _tmp54_;
	GtkWidget* _tmp55_;
	GtkStack* _tmp56_;
	const gchar* _tmp57_;
#line 267 "scores/dialog.vala"
	g_return_if_fail (self != NULL);
#line 267 "scores/dialog.vala"
	g_return_if_fail (score != NULL);
#line 267 "scores/dialog.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 267 "scores/dialog.vala"
	_data4_->_ref_count_ = 1;
#line 267 "scores/dialog.vala"
	_data4_->self = g_object_ref (self);
#line 267 "scores/dialog.vala"
	_tmp0_ = _g_object_ref0 (score);
#line 267 "scores/dialog.vala"
	_g_object_unref0 (_data4_->score);
#line 267 "scores/dialog.vala"
	_data4_->score = _tmp0_;
#line 269 "scores/dialog.vala"
	_tmp1_ = self->priv->grid;
#line 269 "scores/dialog.vala"
	_tmp2_ = gtk_grid_get_child_at (_tmp1_, 0, row_count);
#line 269 "scores/dialog.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_label_get_type (), GtkLabel));
#line 269 "scores/dialog.vala"
	rank_label = _tmp3_;
#line 270 "scores/dialog.vala"
	_tmp4_ = rank_label;
#line 270 "scores/dialog.vala"
	_tmp5_ = g_strdup_printf ("%i", row_count);
#line 270 "scores/dialog.vala"
	_tmp6_ = _tmp5_;
#line 270 "scores/dialog.vala"
	gtk_label_set_text (_tmp4_, _tmp6_);
#line 270 "scores/dialog.vala"
	_g_free0 (_tmp6_);
#line 272 "scores/dialog.vala"
	_tmp7_ = self->priv->grid;
#line 272 "scores/dialog.vala"
	_tmp8_ = gtk_grid_get_child_at (_tmp7_, 1, row_count);
#line 272 "scores/dialog.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_label_get_type (), GtkLabel));
#line 272 "scores/dialog.vala"
	score_label = _tmp9_;
#line 273 "scores/dialog.vala"
	_tmp11_ = self->priv->scores_style;
#line 273 "scores/dialog.vala"
	if (_tmp11_ == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
#line 273 "scores/dialog.vala"
		_tmp10_ = TRUE;
#line 1803 "dialog.c"
	} else {
		GamesScoresStyle _tmp12_;
#line 273 "scores/dialog.vala"
		_tmp12_ = self->priv->scores_style;
#line 273 "scores/dialog.vala"
		_tmp10_ = _tmp12_ == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER;
#line 1810 "dialog.c"
	}
#line 273 "scores/dialog.vala"
	if (_tmp10_) {
#line 1814 "dialog.c"
		GtkLabel* _tmp13_;
		glong _tmp14_;
		glong _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 275 "scores/dialog.vala"
		_tmp13_ = score_label;
#line 275 "scores/dialog.vala"
		_tmp14_ = games_scores_score_get_score (_data4_->score);
#line 275 "scores/dialog.vala"
		_tmp15_ = _tmp14_;
#line 275 "scores/dialog.vala"
		_tmp16_ = g_strdup_printf ("%li", _tmp15_);
#line 275 "scores/dialog.vala"
		_tmp17_ = _tmp16_;
#line 275 "scores/dialog.vala"
		gtk_label_set_text (_tmp13_, _tmp17_);
#line 275 "scores/dialog.vala"
		_g_free0 (_tmp17_);
#line 1834 "dialog.c"
	} else {
		glong minutes = 0L;
		glong _tmp18_;
		glong _tmp19_;
		glong seconds = 0L;
		glong _tmp20_;
		glong _tmp21_;
		GtkLabel* _tmp22_;
		glong _tmp23_;
		glong _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		glong _tmp27_;
		glong _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
#line 279 "scores/dialog.vala"
		_tmp18_ = games_scores_score_get_score (_data4_->score);
#line 279 "scores/dialog.vala"
		_tmp19_ = _tmp18_;
#line 279 "scores/dialog.vala"
		minutes = _tmp19_ / 60;
#line 280 "scores/dialog.vala"
		_tmp20_ = games_scores_score_get_score (_data4_->score);
#line 280 "scores/dialog.vala"
		_tmp21_ = _tmp20_;
#line 280 "scores/dialog.vala"
		seconds = _tmp21_ % 60;
#line 281 "scores/dialog.vala"
		_tmp22_ = score_label;
#line 281 "scores/dialog.vala"
		_tmp23_ = minutes;
#line 281 "scores/dialog.vala"
		_tmp24_ = minutes;
#line 281 "scores/dialog.vala"
		_tmp25_ = g_strdup_printf (ngettext ("%ld minute", "%ld minutes", (gulong) _tmp23_), _tmp24_);
#line 281 "scores/dialog.vala"
		_tmp26_ = _tmp25_;
#line 281 "scores/dialog.vala"
		_tmp27_ = seconds;
#line 281 "scores/dialog.vala"
		_tmp28_ = seconds;
#line 281 "scores/dialog.vala"
		_tmp29_ = g_strdup_printf (ngettext ("%ld second", "%ld seconds", (gulong) _tmp27_), _tmp28_);
#line 281 "scores/dialog.vala"
		_tmp30_ = _tmp29_;
#line 281 "scores/dialog.vala"
		_tmp31_ = g_strdup_printf ("%s %s", _tmp26_, _tmp30_);
#line 281 "scores/dialog.vala"
		_tmp32_ = _tmp31_;
#line 281 "scores/dialog.vala"
		gtk_label_set_text (_tmp22_, _tmp32_);
#line 281 "scores/dialog.vala"
		_g_free0 (_tmp32_);
#line 281 "scores/dialog.vala"
		_g_free0 (_tmp30_);
#line 281 "scores/dialog.vala"
		_g_free0 (_tmp26_);
#line 1895 "dialog.c"
	}
#line 288 "scores/dialog.vala"
	_tmp34_ = self->priv->new_high_score;
#line 288 "scores/dialog.vala"
	if (_tmp34_ != NULL) {
#line 1901 "dialog.c"
		GamesScoresScore* _tmp35_;
#line 288 "scores/dialog.vala"
		_tmp35_ = self->priv->new_high_score;
#line 288 "scores/dialog.vala"
		_tmp33_ = games_scores_score_equals (_data4_->score, _tmp35_);
#line 1907 "dialog.c"
	} else {
#line 288 "scores/dialog.vala"
		_tmp33_ = FALSE;
#line 1911 "dialog.c"
	}
#line 288 "scores/dialog.vala"
	if (_tmp33_) {
#line 1915 "dialog.c"
		Block5Data* _data5_;
		gboolean _tmp36_ = FALSE;
		GtkStack* temp_stack = NULL;
		GtkGrid* _tmp39_;
		GtkWidget* _tmp40_;
		GtkStack* _tmp41_;
		GtkStack* _tmp42_;
		GtkStack* _tmp43_;
		GtkWidget* _tmp44_;
		GtkEntry* _tmp45_;
		GtkEntry* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		GtkEntry* _tmp49_;
#line 288 "scores/dialog.vala"
		_data5_ = g_slice_new0 (Block5Data);
#line 288 "scores/dialog.vala"
		_data5_->_ref_count_ = 1;
#line 288 "scores/dialog.vala"
		_data5_->_data4_ = block4_data_ref (_data4_);
#line 290 "scores/dialog.vala"
		if (no_scores > ((guint) 1)) {
#line 290 "scores/dialog.vala"
			_tmp36_ = row_count == 1;
#line 1940 "dialog.c"
		} else {
#line 290 "scores/dialog.vala"
			_tmp36_ = FALSE;
#line 1944 "dialog.c"
		}
#line 290 "scores/dialog.vala"
		if (_tmp36_) {
#line 1948 "dialog.c"
			GtkHeaderBar* _tmp37_;
#line 291 "scores/dialog.vala"
			_tmp37_ = self->priv->headerbar;
#line 291 "scores/dialog.vala"
			gtk_header_bar_set_subtitle (_tmp37_, _ ("Your score is the best!"));
#line 1954 "dialog.c"
		} else {
			GtkHeaderBar* _tmp38_;
#line 293 "scores/dialog.vala"
			_tmp38_ = self->priv->headerbar;
#line 293 "scores/dialog.vala"
			gtk_header_bar_set_subtitle (_tmp38_, _ ("Your score has made the top ten."));
#line 1961 "dialog.c"
		}
#line 295 "scores/dialog.vala"
		_tmp39_ = self->priv->grid;
#line 295 "scores/dialog.vala"
		_tmp40_ = gtk_grid_get_child_at (_tmp39_, 2, row_count);
#line 295 "scores/dialog.vala"
		_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_stack_get_type (), GtkStack));
#line 295 "scores/dialog.vala"
		temp_stack = _tmp41_;
#line 296 "scores/dialog.vala"
		_tmp42_ = temp_stack;
#line 296 "scores/dialog.vala"
		gtk_stack_set_visible_child_name (_tmp42_, "entry");
#line 298 "scores/dialog.vala"
		_tmp43_ = temp_stack;
#line 298 "scores/dialog.vala"
		_tmp44_ = gtk_stack_get_visible_child (_tmp43_);
#line 298 "scores/dialog.vala"
		_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_entry_get_type (), GtkEntry));
#line 298 "scores/dialog.vala"
		_data5_->entry = _tmp45_;
#line 299 "scores/dialog.vala"
		_tmp46_ = _data5_->entry;
#line 299 "scores/dialog.vala"
		_tmp47_ = games_scores_score_get_user (_data4_->score);
#line 299 "scores/dialog.vala"
		_tmp48_ = _tmp47_;
#line 299 "scores/dialog.vala"
		gtk_entry_set_text (_tmp46_, _tmp48_);
#line 300 "scores/dialog.vala"
		_tmp49_ = _data5_->entry;
#line 300 "scores/dialog.vala"
		g_signal_connect_data ((GObject*) _tmp49_, "notify::text", (GCallback) ____lambda9__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 288 "scores/dialog.vala"
		_g_object_unref0 (temp_stack);
#line 288 "scores/dialog.vala"
		block5_data_unref (_data5_);
#line 288 "scores/dialog.vala"
		_data5_ = NULL;
#line 2001 "dialog.c"
	}
#line 306 "scores/dialog.vala"
	_tmp50_ = self->priv->grid;
#line 306 "scores/dialog.vala"
	_tmp51_ = gtk_grid_get_child_at (_tmp50_, 2, row_count);
#line 306 "scores/dialog.vala"
	_tmp52_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_stack_get_type (), GtkStack));
#line 306 "scores/dialog.vala"
	name_stack = _tmp52_;
#line 307 "scores/dialog.vala"
	_tmp53_ = name_stack;
#line 307 "scores/dialog.vala"
	_tmp54_ = gtk_stack_get_visible_child (_tmp53_);
#line 307 "scores/dialog.vala"
	_tmp55_ = _g_object_ref0 (_tmp54_);
#line 307 "scores/dialog.vala"
	widget = _tmp55_;
#line 309 "scores/dialog.vala"
	_tmp56_ = name_stack;
#line 309 "scores/dialog.vala"
	_tmp57_ = gtk_stack_get_visible_child_name (_tmp56_);
#line 309 "scores/dialog.vala"
	if (g_strcmp0 (_tmp57_, "label") == 0) {
#line 2025 "dialog.c"
		GtkLabel* user_label = NULL;
		GtkWidget* _tmp58_;
		GtkLabel* _tmp59_;
		GtkLabel* _tmp60_;
		const gchar* _tmp61_;
		const gchar* _tmp62_;
#line 311 "scores/dialog.vala"
		_tmp58_ = widget;
#line 311 "scores/dialog.vala"
		_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_label_get_type (), GtkLabel));
#line 311 "scores/dialog.vala"
		user_label = _tmp59_;
#line 312 "scores/dialog.vala"
		_tmp60_ = user_label;
#line 312 "scores/dialog.vala"
		_tmp61_ = games_scores_score_get_user (_data4_->score);
#line 312 "scores/dialog.vala"
		_tmp62_ = _tmp61_;
#line 312 "scores/dialog.vala"
		gtk_label_set_text (_tmp60_, _tmp62_);
#line 309 "scores/dialog.vala"
		_g_object_unref0 (user_label);
#line 2048 "dialog.c"
	} else {
		GtkEntry* entry = NULL;
		GtkWidget* _tmp63_;
		GtkEntry* _tmp64_;
		GtkEntry* _tmp65_;
		const gchar* _tmp66_;
		const gchar* _tmp67_;
#line 316 "scores/dialog.vala"
		_tmp63_ = widget;
#line 316 "scores/dialog.vala"
		_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_entry_get_type (), GtkEntry));
#line 316 "scores/dialog.vala"
		entry = _tmp64_;
#line 317 "scores/dialog.vala"
		_tmp65_ = entry;
#line 317 "scores/dialog.vala"
		_tmp66_ = games_scores_score_get_user (_data4_->score);
#line 317 "scores/dialog.vala"
		_tmp67_ = _tmp66_;
#line 317 "scores/dialog.vala"
		gtk_entry_set_text (_tmp65_, _tmp67_);
#line 309 "scores/dialog.vala"
		_g_object_unref0 (entry);
#line 2072 "dialog.c"
	}
#line 267 "scores/dialog.vala"
	_g_object_unref0 (widget);
#line 267 "scores/dialog.vala"
	_g_object_unref0 (name_stack);
#line 267 "scores/dialog.vala"
	_g_object_unref0 (score_label);
#line 267 "scores/dialog.vala"
	_g_object_unref0 (rank_label);
#line 267 "scores/dialog.vala"
	block4_data_unref (_data4_);
#line 267 "scores/dialog.vala"
	_data4_ = NULL;
#line 2086 "dialog.c"
}


static void
games_scores_dialog_make_remaining_labels_empty (GamesScoresDialog* self,
                                                 gint row_count)
{
#line 322 "scores/dialog.vala"
	g_return_if_fail (self != NULL);
#line 2096 "dialog.c"
	{
		gint i = 0;
#line 324 "scores/dialog.vala"
		i = row_count;
#line 2101 "dialog.c"
		{
			gboolean _tmp0_ = FALSE;
#line 324 "scores/dialog.vala"
			_tmp0_ = TRUE;
#line 324 "scores/dialog.vala"
			while (TRUE) {
#line 2108 "dialog.c"
				gint _tmp2_;
				gint _tmp3_;
				GtkStack* stack = NULL;
				GtkGrid* _tmp13_;
				gint _tmp14_;
				GtkWidget* _tmp15_;
				GtkStack* _tmp16_;
				GtkLabel* label = NULL;
				GtkStack* _tmp17_;
				GtkWidget* _tmp18_;
				GtkLabel* _tmp19_;
				GtkLabel* _tmp20_;
#line 324 "scores/dialog.vala"
				if (!_tmp0_) {
#line 2123 "dialog.c"
					gint _tmp1_;
#line 324 "scores/dialog.vala"
					_tmp1_ = i;
#line 324 "scores/dialog.vala"
					i = _tmp1_ + 1;
#line 2129 "dialog.c"
				}
#line 324 "scores/dialog.vala"
				_tmp0_ = FALSE;
#line 324 "scores/dialog.vala"
				_tmp2_ = i;
#line 324 "scores/dialog.vala"
				_tmp3_ = self->priv->rows_to_display;
#line 324 "scores/dialog.vala"
				if (!(_tmp2_ <= _tmp3_)) {
#line 324 "scores/dialog.vala"
					break;
#line 2141 "dialog.c"
				}
				{
					gint j = 0;
#line 326 "scores/dialog.vala"
					j = 0;
#line 2147 "dialog.c"
					{
						gboolean _tmp4_ = FALSE;
#line 326 "scores/dialog.vala"
						_tmp4_ = TRUE;
#line 326 "scores/dialog.vala"
						while (TRUE) {
#line 2154 "dialog.c"
							gint _tmp6_;
							GtkLabel* label = NULL;
							GtkGrid* _tmp7_;
							gint _tmp8_;
							gint _tmp9_;
							GtkWidget* _tmp10_;
							GtkLabel* _tmp11_;
							GtkLabel* _tmp12_;
#line 326 "scores/dialog.vala"
							if (!_tmp4_) {
#line 2165 "dialog.c"
								gint _tmp5_;
#line 326 "scores/dialog.vala"
								_tmp5_ = j;
#line 326 "scores/dialog.vala"
								j = _tmp5_ + 1;
#line 2171 "dialog.c"
							}
#line 326 "scores/dialog.vala"
							_tmp4_ = FALSE;
#line 326 "scores/dialog.vala"
							_tmp6_ = j;
#line 326 "scores/dialog.vala"
							if (!(_tmp6_ <= 1)) {
#line 326 "scores/dialog.vala"
								break;
#line 2181 "dialog.c"
							}
#line 328 "scores/dialog.vala"
							_tmp7_ = self->priv->grid;
#line 328 "scores/dialog.vala"
							_tmp8_ = j;
#line 328 "scores/dialog.vala"
							_tmp9_ = i;
#line 328 "scores/dialog.vala"
							_tmp10_ = gtk_grid_get_child_at (_tmp7_, _tmp8_, _tmp9_);
#line 328 "scores/dialog.vala"
							_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_label_get_type (), GtkLabel));
#line 328 "scores/dialog.vala"
							label = _tmp11_;
#line 329 "scores/dialog.vala"
							_tmp12_ = label;
#line 329 "scores/dialog.vala"
							gtk_label_set_text (_tmp12_, "");
#line 326 "scores/dialog.vala"
							_g_object_unref0 (label);
#line 2201 "dialog.c"
						}
					}
				}
#line 332 "scores/dialog.vala"
				_tmp13_ = self->priv->grid;
#line 332 "scores/dialog.vala"
				_tmp14_ = i;
#line 332 "scores/dialog.vala"
				_tmp15_ = gtk_grid_get_child_at (_tmp13_, 2, _tmp14_);
#line 332 "scores/dialog.vala"
				_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_stack_get_type (), GtkStack));
#line 332 "scores/dialog.vala"
				stack = _tmp16_;
#line 333 "scores/dialog.vala"
				_tmp17_ = stack;
#line 333 "scores/dialog.vala"
				_tmp18_ = gtk_stack_get_visible_child (_tmp17_);
#line 333 "scores/dialog.vala"
				_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_label_get_type (), GtkLabel));
#line 333 "scores/dialog.vala"
				label = _tmp19_;
#line 334 "scores/dialog.vala"
				_tmp20_ = label;
#line 334 "scores/dialog.vala"
				gtk_label_set_text (_tmp20_, "");
#line 324 "scores/dialog.vala"
				_g_object_unref0 (label);
#line 324 "scores/dialog.vala"
				_g_object_unref0 (stack);
#line 2231 "dialog.c"
			}
		}
	}
}


static void
games_scores_dialog_class_init (GamesScoresDialogClass * klass)
{
#line 24 "scores/dialog.vala"
	games_scores_dialog_parent_class = g_type_class_peek_parent (klass);
#line 24 "scores/dialog.vala"
	g_type_class_adjust_private_offset (klass, &GamesScoresDialog_private_offset);
#line 24 "scores/dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = games_scores_dialog_finalize;
#line 2247 "dialog.c"
}


static void
games_scores_dialog_instance_init (GamesScoresDialog * self)
{
#line 24 "scores/dialog.vala"
	self->priv = games_scores_dialog_get_instance_private (self);
#line 27 "scores/dialog.vala"
	self->priv->active_category = NULL;
#line 28 "scores/dialog.vala"
	self->priv->rows_to_display = 10;
#line 30 "scores/dialog.vala"
	self->priv->combo = NULL;
#line 31 "scores/dialog.vala"
	self->priv->category_label = NULL;
#line 32 "scores/dialog.vala"
	self->priv->headerbar = NULL;
#line 2266 "dialog.c"
}


static void
games_scores_dialog_finalize (GObject * obj)
{
	GamesScoresDialog * self;
#line 24 "scores/dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog);
#line 26 "scores/dialog.vala"
	_g_object_unref0 (self->priv->context);
#line 27 "scores/dialog.vala"
	_g_object_unref0 (self->priv->active_category);
#line 30 "scores/dialog.vala"
	_g_object_unref0 (self->priv->combo);
#line 31 "scores/dialog.vala"
	_g_object_unref0 (self->priv->category_label);
#line 32 "scores/dialog.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 33 "scores/dialog.vala"
	_g_object_unref0 (self->priv->grid);
#line 36 "scores/dialog.vala"
	_g_object_unref0 (self->priv->new_high_score);
#line 37 "scores/dialog.vala"
	_g_object_unref0 (self->priv->scores_active_category);
#line 24 "scores/dialog.vala"
	G_OBJECT_CLASS (games_scores_dialog_parent_class)->finalize (obj);
#line 2294 "dialog.c"
}


GType
games_scores_dialog_get_type (void)
{
	static volatile gsize games_scores_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&games_scores_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesScoresDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresDialog), 0, (GInstanceInitFunc) games_scores_dialog_instance_init, NULL };
		GType games_scores_dialog_type_id;
		games_scores_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "GamesScoresDialog", &g_define_type_info, 0);
		GamesScoresDialog_private_offset = g_type_add_instance_private (games_scores_dialog_type_id, sizeof (GamesScoresDialogPrivate));
		g_once_init_leave (&games_scores_dialog_type_id__volatile, games_scores_dialog_type_id);
	}
	return games_scores_dialog_type_id__volatile;
}



