/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.DockDropReceiver;
import com.vldocking.swing.docking.Dockable;
import com.vldocking.swing.docking.DockableDragSource;
import com.vldocking.swing.docking.DockingUtilities;
import com.vldocking.swing.docking.event.DockDragEvent;
import com.vldocking.swing.docking.event.DockDropEvent;
import java.awt.Container;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JButton;

public class DockableStoreButton
extends JButton
implements DockDropReceiver,
DockableDragSource {
    private static final long serialVersionUID = 1L;
    private Dockable dockable;
    private String emptyText = "Nothing stored";
    private String emptyTooltip = "<html>Move and drop a view of your application above this button to store it";
    private Icon emptyIcon = null;
    private String fullText = "View &1 stored";
    private String fullTooltip = "<html>Drag this button to move the view <b>&1</b> to a new position";

    public DockableStoreButton(String emptyText) {
        super(emptyText);
        this.emptyText = emptyText;
        this.updateButtonText();
    }

    public DockableStoreButton() {
        this.updateButtonText();
    }

    @Override
    public void processDockableDrag(DockDragEvent event) {
        event.rejectDrag();
    }

    @Override
    public void processDockableDrop(DockDropEvent event) {
        this.setDockable(event.getDragSource().getDockable());
        event.rejectDrop();
    }

    public void setDockable(Dockable dockable) {
        this.dockable = dockable;
        this.updateButtonText();
    }

    public void updateButtonText() {
        if (this.dockable == null) {
            this.setText(this.emptyText);
            this.setToolTipText(this.emptyTooltip);
            this.setIcon(null);
        } else {
            String text = this.fullText.replaceAll("&1", this.dockable.getDockKey().getName());
            this.setText(text);
            String tttext = this.fullTooltip.replaceAll("&1", this.dockable.getDockKey().getName());
            this.setToolTipText(tttext);
            this.setIcon(this.dockable.getDockKey().getIcon());
        }
    }

    @Override
    public boolean startDragComponent(Point p) {
        return this.dockable != null;
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public Container getDockableContainer() {
        return (Container)((Object)DockingUtilities.findDockableContainer(this.dockable));
    }

    @Override
    public void endDragComponent(boolean dropped) {
        if (dropped) {
            this.dockable = null;
            this.updateButtonText();
        }
    }

    public String getEmptyText() {
        return this.emptyText;
    }

    public void setEmptyText(String emptyText) {
        this.emptyText = emptyText;
    }

    public String getEmptyTooltip() {
        return this.emptyTooltip;
    }

    public void setEmptyTooltip(String emptyTooltip) {
        this.emptyTooltip = emptyTooltip;
    }

    public Icon getEmptyIcon() {
        return this.emptyIcon;
    }

    public void setEmptyIcon(Icon emptyIcon) {
        this.emptyIcon = emptyIcon;
    }

    public String getFullText() {
        return this.fullText;
    }

    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    public String getFullTooltip() {
        return this.fullTooltip;
    }

    public void setFullTooltip(String fullTooltip) {
        this.fullTooltip = fullTooltip;
    }
}

