#include "masks.h"

/* Map a command line given name to a Mac name.  If LATIN1 is not defined
   the translation is direct, except that \ is handled special.  \\ is
   translated to \, \ddd (three digits) is translated to the octal code.
   If LATIN1 is defined, special care has been taken with the 8 bit chars
   to get a proper mapping, if possible.  Note: colon is translated to _. */
static char char_mapping[] = {
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 ' ',  '!',  '"',  '#',  '$',  '%',  '&', '\'',
	 '(',  ')',  '*',  '+',  ',',  '-',  '.',  '/',
	 '0',  '1',  '2',  '3',  '4',  '5',  '6',  '7',
	 '8',  '9',  '_',  ';',  '<',  '=',  '>',  '?',
	 '@',  'A',  'B',  'C',  'D',  'E',  'F',  'G',
	 'H',  'I',  'J',  'K',  'L',  'M',  'N',  'O',
	 'P',  'Q',  'R',  'S',  'T',  'U',  'V',  'W',
	 'X',  'Y',  'Z',  '[', '\\',  ']',  '^',  '_',
	 '`',  'a',  'b',  'c',  'd',  'e',  'f',  'g',
	 'h',  'i',  'j',  'k',  'l',  'm',  'n',  'o',
	 'p',  'q',  'r',  's',  't',  'u',  'v',  'w',
	 'x',  'y',  'z',  '{',  '|',  '}',  '~', 0177,
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
#ifndef LATIN1
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_',
	 '_',  '_',  '_',  '_',  '_',  '_',  '_',  '_'};
#else /* LATIN1 */
	 '_', 0301, 0242, 0243, 0327, 0265,  '_', 0244,
	0254, 0251,  '_', 0307, 0302,  '_', 0250,  '_',
	0241, 0261,  '_',  '_', 0253,  '_', 0246, 0245,
	 '_',  '_',  '_', 0310,  '_',  '_',  '_', 0300,
	0313, 0207, 0211, 0313, 0200, 0201, 0256, 0202,
	0217, 0203, 0220, 0221, 0223, 0314, 0224, 0225,
	 '_', 0204, 0230, 0227, 0231, 0233, 0205,  '_',
	0257, 0235, 0234, 0236, 0206,  '_',  '_', 0247,
	0210, 0207, 0211, 0213, 0212, 0214, 0276, 0215,
	0217, 0216, 0220, 0221, 0223, 0222, 0224, 0225,
	 '_', 0226, 0230, 0227, 0231, 0233, 0232, 0326,
	0277, 0235, 0234, 0236, 0237,  '_',  '_', 0330};
#endif /* LATIN1 */

void backtrans(macname, name)
char *macname, *name;
{
    char *in, *out;
    int c, count = 0;

    out = macname;
    for (in = name; *in; in++){
	if(count == 31) {
	    break;
	}
	if(*in != '\\') {
	    *out++ = char_mapping[*in & BYTEMASK];
	    count++;
	    continue;
	}
	in++;
	if(*in == 0) {
	    break;;
	}
	if(*in < '0' || *in > '9') {
	    *out++ = char_mapping[*in & BYTEMASK];
	    count++;
	    continue;
	}
	c = *in - '0';
	in++;
	if(*in < '0' || *in > '9') {
	    *out++ = c;
	    count++;
	    in--;
	    continue;
	}
	c = (c << 3) + *in - '0';
	in++;
	if(*in < '0' || *in > '9') {
	    *out++ = c;
	    count++;
	    in--;
	    continue;
	}
	c = (c << 3) + *in - '0';
	*out++ = c;
	count++;
    }
    *out++ = 0;
}

