/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef EditTransaction_H
#define EditTransaction_H

#include "Transaction.h"
#include "EditorObserver.h"
#include "TaskObserver.h"
#include "IconObject.h"

class EditTransaction : 
	public Transaction, 
	public EditorObserver,
	public TaskObserver
{
	IconObjectH current_;

	virtual MvTransaction *cloneSelf();
	virtual void callback(MvRequest&);
	virtual void apply(IconObject*);
	virtual void close(IconObject*);

public:
        EditTransaction(); 
	EditTransaction(MvTransaction* t);
	~EditTransaction();
	
private:
	// No copy allowed
	EditTransaction(const EditTransaction&);
	EditTransaction& operator=(const EditTransaction&);

	IconClass* subClass_;

	virtual void success(Task*,const Request&);
	virtual void failure(Task*,const Request&);


};

inline void destroy(EditTransaction**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(EditTransaction);
//#endif

#endif
