/*
 *  This file is part of the WebKit open source project.
 *  This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "WebKitDOMTestActiveDOMObject.h"

#include "CSSImportRule.h"
#include "DOMObjectCache.h"
#include "Document.h"
#include "ExceptionCode.h"
#include "ExceptionCodeDescription.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMTestActiveDOMObjectPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_TEST_ACTIVE_DOM_OBJECT_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_DOM_TYPE_TEST_ACTIVE_DOM_OBJECT, WebKitDOMTestActiveDOMObjectPrivate)

typedef struct _WebKitDOMTestActiveDOMObjectPrivate {
    RefPtr<WebCore::TestActiveDOMObject> coreObject;
} WebKitDOMTestActiveDOMObjectPrivate;

namespace WebKit {

WebKitDOMTestActiveDOMObject* kit(WebCore::TestActiveDOMObject* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_TEST_ACTIVE_DOM_OBJECT(ret);

    return wrapTestActiveDOMObject(obj);
}

WebCore::TestActiveDOMObject* core(WebKitDOMTestActiveDOMObject* request)
{
    return request ? static_cast<WebCore::TestActiveDOMObject*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMTestActiveDOMObject* wrapTestActiveDOMObject(WebCore::TestActiveDOMObject* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_TEST_ACTIVE_DOM_OBJECT(g_object_new(WEBKIT_DOM_TYPE_TEST_ACTIVE_DOM_OBJECT, "core-object", coreObject, nullptr));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMTestActiveDOMObject, webkit_dom_test_active_dom_object, WEBKIT_DOM_TYPE_OBJECT)

enum {
    PROP_0,
    PROP_EXCITING_ATTR,
};

static void webkit_dom_test_active_dom_object_finalize(GObject* object)
{
    WebKitDOMTestActiveDOMObjectPrivate* priv = WEBKIT_DOM_TEST_ACTIVE_DOM_OBJECT_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMTestActiveDOMObjectPrivate();
    G_OBJECT_CLASS(webkit_dom_test_active_dom_object_parent_class)->finalize(object);
}

static void webkit_dom_test_active_dom_object_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebKitDOMTestActiveDOMObject* self = WEBKIT_DOM_TEST_ACTIVE_DOM_OBJECT(object);

    switch (propertyId) {
    case PROP_EXCITING_ATTR:
        g_value_set_long(value, webkit_dom_test_active_dom_object_get_exciting_attr(self));
        break;
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_test_active_dom_object_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_test_active_dom_object_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMTestActiveDOMObjectPrivate* priv = WEBKIT_DOM_TEST_ACTIVE_DOM_OBJECT_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::TestActiveDOMObject*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_test_active_dom_object_class_init(WebKitDOMTestActiveDOMObjectClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMTestActiveDOMObjectPrivate));
    gobjectClass->constructor = webkit_dom_test_active_dom_object_constructor;
    gobjectClass->finalize = webkit_dom_test_active_dom_object_finalize;
    gobjectClass->get_property = webkit_dom_test_active_dom_object_get_property;

    g_object_class_install_property(
        gobjectClass,
        PROP_EXCITING_ATTR,
        g_param_spec_long(
            "exciting-attr",
            "TestActiveDOMObject:exciting-attr",
            "read-only glong TestActiveDOMObject:exciting-attr",
            G_MINLONG, G_MAXLONG, 0,
            WEBKIT_PARAM_READABLE));

}

static void webkit_dom_test_active_dom_object_init(WebKitDOMTestActiveDOMObject* request)
{
    WebKitDOMTestActiveDOMObjectPrivate* priv = WEBKIT_DOM_TEST_ACTIVE_DOM_OBJECT_GET_PRIVATE(request);
    new (priv) WebKitDOMTestActiveDOMObjectPrivate();
}

void webkit_dom_test_active_dom_object_exciting_function(WebKitDOMTestActiveDOMObject* self, WebKitDOMNode* nextChild)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_ACTIVE_DOM_OBJECT(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(nextChild));
    WebCore::TestActiveDOMObject* item = WebKit::core(self);
    WebCore::Node* convertedNextChild = WebKit::core(nextChild);
    item->excitingFunction(convertedNextChild);
}

void webkit_dom_test_active_dom_object_post_message(WebKitDOMTestActiveDOMObject* self, const gchar* message)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_TEST_ACTIVE_DOM_OBJECT(self));
    g_return_if_fail(message);
    WebCore::TestActiveDOMObject* item = WebKit::core(self);
    WTF::String convertedMessage = WTF::String::fromUTF8(message);
    item->postMessage(convertedMessage);
}

glong webkit_dom_test_active_dom_object_get_exciting_attr(WebKitDOMTestActiveDOMObject* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_ACTIVE_DOM_OBJECT(self), 0);
    WebCore::TestActiveDOMObject* item = WebKit::core(self);
    glong result = item->excitingAttr();
    return result;
}

