% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_group_sequential.R
\name{getDesignInverseNormal}
\alias{getDesignInverseNormal}
\title{Get Design Inverse Normal}
\usage{
getDesignInverseNormal(..., kMax = NA_integer_, alpha = NA_real_,
  beta = NA_real_, sided = 1, informationRates = NA_real_,
  futilityBounds = NA_real_, typeOfDesign = C_DEFAULT_TYPE_OF_DESIGN,
  deltaWT = 0, optimizationCriterion = C_OPTIMIZATION_CRITERION_DEFAULT,
  gammaA = 1, typeBetaSpending = C_TYPE_OF_DESIGN_BS_NONE,
  userAlphaSpending = NA_real_, userBetaSpending = NA_real_, gammaB = 1,
  bindingFutility = C_BINDING_FUTILITY_DEFAULT,
  constantBoundsHP = C_CONST_BOUND_HP_DEFAULT,
  twoSidedPower = C_TWO_SIDED_POWER_DEFAULT,
  tolerance = C_DESIGN_TOLERANCE_DEFAULT)
}
\arguments{
\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{kMax}{The maximum number of stages K. K = 1, 2, ..., 10, default is 3.}

\item{alpha}{The significance level alpha, default is 0.025.}

\item{beta}{Type II error rate, necessary for providing sample size calculations \cr
(e.g., \code{\link{getSampleSizeMeans}}), beta spending function designs, 
or optimum designs, default is 0.20.}

\item{sided}{One-sided or two-sided, default is 1.}

\item{informationRates}{The information rates, default is \code{(1 : kMax)/kMax}.}

\item{futilityBounds}{The futility bounds (vector of length K - 1).}

\item{typeOfDesign}{The type of design. Type of design is one of the following: 
O'Brien & Fleming ("OF"), Pocock ("P"), Wang & Tsiatis Delta class ("WT"), 
Haybittle & Peto ("HP"), Optimum design within Wang & Tsiatis class ("WToptimum"), 
O'Brien & Fleming type alpha spending ("asOF"), Pocock type alpha spending ("asP"), 
Kim & DeMets alpha spending ("asKD"), Hwang, Shi & DeCani alpha spending ("asHSD"), 
user defined alpha spending ("asUser"), default is "OF".}

\item{deltaWT}{Delta for Wang & Tsiatis Delta class.}

\item{optimizationCriterion}{Optimization criterion for optimum design within 
Wang & Tsiatis class ("ASNH1", "ASNIFH1", "ASNsum"), default is "ASNH1".}

\item{gammaA}{Parameter for alpha spending function, default is 1.}

\item{typeBetaSpending}{Type of beta spending. Type of of beta spending is one of the following: 
O'Brien & Fleming type beta spending, Pocock type beta spending, 
Kim & DeMets beta spending, Hwang, Shi & DeCani beta spending, user defined 
beta spending ("bsOF", "bsP",...).}

\item{userAlphaSpending}{The user defined alpha spending.}

\item{userBetaSpending}{The user defined beta spending.}

\item{gammaB}{Parameter for beta spending function, default is 1.}

\item{bindingFutility}{If \code{bindingFutility = TRUE} is specified the calculation of 
the critical values is affected by the futility bounds (default is FALSE).}

\item{constantBoundsHP}{The constant bounds up to stage K - 1 for the 
Haybittle & Peto design (default is 3).}

\item{twoSidedPower}{For two-sided testing, if \code{twoSidedPower = TRUE} is specified 
the sample size calculation is performed by considering both tails of the distribution. 
Default is FALSE, i.e., it is assumed that one tail probability is equal to 0 or the power
should be directed to one part.}

\item{tolerance}{The tolerance, default is 1e-08.}
}
\value{
Returns a \code{\link{TrialDesignInverseNormal}} object.
}
\description{
Provides adjusted boundaries and defines a group sequential design for its use in 
the inverse normal combination test.
}
\details{
Depending on \code{typeOfDesign} some parameters are specified, others not. 
For example, only if \code{typeOfDesign} "asHSD" is selected, \code{gammaA} needs to be specified.

If an alpha spending approach was specified ("asOF", "asP", "asKD", "asHSD", or "asUser") 
additionally a beta spending function can be specified to produce futility bounds.
}
\examples{

# Run with default values
getDesignInverseNormal() 

# The output is
# 
# Design parameters and output of inverse normal design:
# 
# User defined parameters: not available
# 
# Derived from user defined parameters: not available
# 
# Default parameters:
#   Type of design                        : OF 
#   Maximum number of stages              : 3 
#   Stages                                : 1, 2, 3 
#   Information rates                     : 0.333, 0.667, 1.000 
#   Significance level                    : 0.0250 
#   Type II error rate                    : 0.2 
#   Two-sided power                       : FALSE 
#   Delta for Wang & Tsiatis Delta class  : 0 
#   Futility bounds (non-binding)         : -Inf, -Inf 
#   Binding futility                      : FALSE 
#   Haybittle Peto constants              : 3.000 
#   Parameter for alpha spending function : 1 
#   Parameter for beta spending function  : 1 
#   Optimization criterion for optimum design within Wang & Tsiatis class : ASNH1 
#   Test                                  : one-sided 
#   Tolerance                             : 1e-08 
#   Type of beta spending                 : none 
#                                       
# Output:                               
#   Cumulative alpha spending             : 0.0002592, 0.0071601, 0.0250000 
#   Critical values                       : 3.471, 2.454, 2.004 
#   Stage levels                          : 0.0002592, 0.0070554, 0.0225331 
# 

# Calculate the Pocock type alpha spending critical values if the second 
# interim analysis was performed after 70\% of information was observed
getDesignInverseNormal(informationRates = c(0.4, 0.7), 
    typeOfDesign = "asP") 

# The output is
#
# Design parameters and output of inverse normal design: 
#
# User defined parameters: 
#   Type of design                        : asP 
#   Stages                                : 1, 2 
#   Information rates                     : 0.400, 0.700 
# 
# Derived from user defined parameters : 
#   Maximum number of stages              : 2 
#   Futility bounds (non-binding)         : -Inf 
# 
# Default parameters: 
#   Significance level                    : 0.0250 
#   Type II error rate                    : 0.2 
#   Delta for Wang & Tsiatis Delta class  : 0 
#   Parameter for alpha spending function : 1 
#   Parameter for beta spending function  : 1 
#   Optimization criterion for Optimum design within Wang & Tsiatis class : ASNH1 
#   Test                                  : one-sided 
#   Tolerance                             : 1e-08 
#   Type of beta                          : none 
# Output: 
#   Cumulative alpha spending             : 0.01308, 0.01974 
#   Critical values                       : 2.224, 2.305 
#   Stage levels                          : 0.01308, 0.01058 

}
\seealso{
\code{\link{getDesignSet}} for creating a set of designs to compare.
}
