/*
  neg.hh, copyright (c) 2006 by Vincent Fourmond: 
  The class definition for negation.
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/

namespace SCalc {
  class Neg : public Expression {
  protected:
    Expression * neg;
  public:
    Neg(Session * s, Expression * su) : Expression(s) { neg = su;};
    virtual ~Neg() { delete neg;};
    
    virtual double evaluate(const double * d, const double *e) { 
      return - neg->evaluate(d,e);
    };
    virtual Expression * copy() {
      return new Neg(session(), neg->copy());
    };
    virtual Expression * derive(int id) {
      return new Neg(session(), neg->derive(id));
    };
    virtual Expression * simplify();

    virtual std::set<int> used_variables() { 
      return neg->used_variables();
    };


    virtual std::string pretty_print();
  };
};
