/*
  syntax.cc, copyright (c) 2006 by Vincent Fourmond: 
  The class for describing syntax errors
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/

#include <calc_internals.hh>

namespace SCalc {
  
  SyntaxError::SyntaxError(Session * s, const char * str, 
			   const char *error, int st, int en) : ParserResult(s)
  {
    original = str;
    message = error;
    start = st;
    end = en;
  }

  /// This tries to pretty_print the error message, assuming that all chars
  /// take exactly one space...
  std::string SyntaxError::pretty_print()
  {
    std::string s = original;
    s += "\n";

    for(int i = 0; i < start; i++)
      s += " ";
    for(int i = start; i < end; i++)
      s += "^";

    s += " error : ";
    s += message;
    return s;
  }

};
