/* ====================================================================
 * Copyright (c) 2009  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "subcommander/wcview/ItemModel.h"
#include "subcommander-test/WcViewItemTest.h"
#include "sublib/OStreamQt.h"
#include "util-test/Link.h"
EXPORT_TESTCASE (AnEmptyModel);

// gmock
#include <gmock/gmock.h>


namespace wcview
{


class AnEmptyModel : public ::testing::Test
{
protected:
  AnEmptyModel () 
    : _model(sc::String("invisible/root"), &_data)
  {
  }

protected:
  WcViewItemDataTest _data;
  ItemModel          _model;
};


TEST_F (AnEmptyModel,shouldContainNoRows)
{
  EXPECT_EQ (0, _model.rowCount(QModelIndex()));
}

TEST_F (AnEmptyModel,shouldReturnAnInvalidIndex)
{
  EXPECT_EQ (QModelIndex(), _model.index(0,0,QModelIndex()));
  EXPECT_EQ (QModelIndex(), _model.index(0,1,QModelIndex()));
  EXPECT_EQ (QModelIndex(), _model.index(1,0,QModelIndex()));
  EXPECT_EQ (QModelIndex(), _model.index(1,1,QModelIndex()));
}

TEST_F (AnEmptyModel,shouldReturnAnInvalidParentIndex)
{
  EXPECT_EQ (QModelIndex(), _model.parent(QModelIndex()));
}

TEST_F (AnEmptyModel,shouldReturnNoData)
{
  EXPECT_EQ (QVariant(), _model.data(QModelIndex(),Qt::DisplayRole) );
  EXPECT_EQ (QVariant(), _model.data(QModelIndex(),Qt::ToolTipRole) );
}

TEST_F (AnEmptyModel,shouldReturnNoFlags)
{
  EXPECT_TRUE (Qt::NoItemFlags==_model.flags(QModelIndex()));
}

} // namespace
