/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "SwitchCmd.h"
#include "SwitchParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"
#include "util/Error.h"


SwitchCmd::SwitchCmd( SwitchParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

SwitchCmd::~SwitchCmd()
{
  delete _cb;
}

void SwitchCmd::run()
{
  sc::Error* err;

  _prgscb->started( _param, getCancel() );

  err = _client->switchx( &_param->getRevnumber(), _param->getPath(), _param->getUrl(),
    *_param->getRevision(), _param->getRecurse() );

  _param->setError( err );
  _prgscb->finished( _param );

  _cb->handleResult( _param, err );
}
