/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "uosrecv.h"

gchar *uos_recv_bytes		(UosSockInfo	*sock,
                             glong		 size){
    return recv_bytes		(sock,size);
}

gint uos_recv_write_to_file		(UosSockInfo	*sock,
                 const gchar	*filename){
    return recv_write_to_file		(sock,filename);
}

gint uos_recv_bytes_write_to_file	(UosSockInfo	*sock,
                 glong		 size,
                 const gchar	*filename){
    return recv_bytes_write_to_file	(sock,size,filename);
}

gint uos_recv_write			(UosSockInfo	*sock,
                 FILE		*fp){
    return recv_write			(sock,fp);
}

gint uos_recv_bytes_write		(UosSockInfo	*sock,
                 glong		 size,
                 FILE		*fp){
    return recv_bytes_write		(sock,size,fp);
}

void uos_recv_set_ui_func		(UosRecvUIFunc	 func,
                 gpointer	 data){
    recv_set_ui_func		(func,data);
}


gboolean uos_if_recv_needexit(){
    return Recv_NeedExit;
}


void uos_set_recv_needexit(gboolean gb){
    Recv_NeedExit=gb;
}
