/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uosssl.h"

#if USE_SSL

void uos_ssl_init				(void){
    ssl_init				();
}

void uos_ssl_done				(void){
    ssl_done				();
}

gboolean uos_ssl_init_socket		(UosSockInfo	*sockinfo, gchar **errorchar){
    return ssl_init_socket		(sockinfo, errorchar);
}

gboolean uos_ssl_init_socket_with_method	(UosSockInfo	*sockinfo,
                     UosSSLMethod	 method, char **errorchar){
    return ssl_init_socket_with_method	(sockinfo,method, errorchar);
}

void uos_ssl_done_socket			(UosSockInfo	*sockinfo){
    ssl_done_socket			(sockinfo);
}

void uos_ssl_set_verify_func		(UosSSLVerifyFunc	 func){
    ssl_set_verify_func		(func);
}


#endif /* USE_SSL */
