/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uosnews.h"

UosFolderClass *uos_news_get_class		(void){
     return news_get_class		();
}

GSList *uos_news_get_group_list		(UosFolder		*folder){
    return news_get_group_list		(folder);
}

void uos_news_group_list_free		(GSList		*group_list){
    news_group_list_free		(group_list);
}

void uos_news_remove_group_list_cache	(UosFolder		*folder){
    news_remove_group_list_cache	(folder);
}


gint uos_news_post				(UosFolder		*folder,
                     const gchar	*file){
    return news_post	(folder,file);
}

gint uos_news_post_stream			(UosFolder		*folder,
                     FILE		*fp){
    return news_post_stream	(folder,fp);
}

