/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSPREFS_ACCOUNT_H__
#define __UOSPREFS_ACCOUNT_H__

#include "libsylph/prefs_account.h"

typedef PrefsAccount UosPrefsAccount;

#include "uosprefs.h"
#include "uosfolder.h"
#include "uossmtp.h"

typedef RecvProtocol UosRecvProtocol;
#define UosA_POP3 A_POP3
#define UosA_APOP A_APOP
#define UosA_RPOP A_RPOP
#define UosA_IMAP4 A_IMAP4
#define UosA_NNTP A_NNTP
#define UosA_LOCAL A_LOCAL
typedef SigType UosSigType;
#define UosSIG_FILE SIG_FILE
#define UosSIG_COMMAND SIG_COMMAND
#define UosSIG_DIRECT SIG_DIRECT
typedef SignKeyType UosSignKeyType;
#define UosSIGN_KEY_DEFAULT SIGN_KEY_DEFAULT
#define UosSIGN_KEY_BY_FROM SIGN_KEY_BY_FROM
#define UosSIGN_KEY_CUSTOM SIGN_KEY_CUSTOM

UosPrefsAccount *uos_prefs_account_new(void);

UosPrefsAccount *uos_prefs_account_get_tmp_prefs(void);
void uos_prefs_account_set_tmp_prefs(UosPrefsAccount *ac_prefs);
void uos_prefs_account_apply_tmp_prefs(UosPrefsAccount *ac_prefs);
UosPrefParam *uos_prefs_account_get_params(void);

void uos_prefs_account_read_config(UosPrefsAccount *ac_prefs,
                               const gchar *label);
void uos_prefs_account_write_config_all(GList *account_list);

void uos_account_free(UosPrefsAccount *ap);
void uos_prefs_account_free(UosPrefsAccount *ac_prefs);

#endif /* __UOSPREFS_ACCOUNT_H__ */
