/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSPROCHEADER_H__
#define __UOSPROCHEADER_H__

#include "libsylph/procheader.h"

#include "uosprocmsg.h"

typedef HeaderEntry UosHeaderEntry;
typedef Header UosHeader;

gint uos_procheader_get_one_field		(gchar		*buf,
					 size_t		 len,
					 FILE		*fp,
                     UosHeaderEntry	 hentry[]);
gchar *uos_procheader_get_unfolded_line	(gchar		*buf,
					 size_t		 len,
					 FILE		*fp);

GSList *uos_procheader_get_header_list_from_file	(const gchar	*file);
GSList *uos_procheader_get_header_list		(FILE		*fp);
GSList *uos_procheader_get_header_list_from_msginfo	(UosMsgInfo	*msginfo);
GSList *uos_procheader_add_header_list		(GSList		*hlist,
						 const gchar	*header_name,
						 const gchar	*body);
GSList *uos_procheader_copy_header_list		(GSList		*hlist);
GSList *uos_procheader_merge_header_list		(GSList		*hlist1,
						 GSList		*hlist2);
GSList *uos_procheader_merge_header_list_dup	(GSList		*hlist1,
						 GSList		*hlist2);
gint uos_procheader_find_header_list		(GSList		*hlist,
						 const gchar	*header_name);
void uos_procheader_header_list_destroy		(GSList		*hlist);

GPtrArray *uos_procheader_get_header_array		(FILE		*fp,
						 const gchar	*encoding);
GPtrArray *uos_procheader_get_header_array_asis	(FILE		*fp,
						 const gchar	*encoding);
GPtrArray *uos_procheader_get_header_array_for_display
						(FILE		*fp,
						 const gchar	*encoding);
void uos_procheader_header_array_destroy		(GPtrArray	*harray);

void uos_procheader_header_free			(UosHeader		*header);

void uos_procheader_get_header_fields	(FILE		*fp,
                     UosHeaderEntry	 hentry[]);
UosMsgInfo *uos_procheader_parse_file		(const gchar	*file,
                     UosMsgFlags	 flags,
					 gboolean	 full);
UosMsgInfo *uos_procheader_parse_str		(const gchar	*str,
                     UosMsgFlags	 flags,
					 gboolean	 full);
UosMsgInfo *uos_procheader_parse_stream	(FILE		*fp,
                     UosMsgFlags	 flags,
					 gboolean	 full);

gchar *uos_procheader_get_fromname		(const gchar	*str);
gchar *uos_procheader_get_toname		(const gchar	*str);

stime_t uos_procheader_date_parse		(gchar		*dest,
					 const gchar	*src,
					 gint		 len);
void uos_procheader_date_get_localtime	(gchar		*dest,
					 gint		 len,
					 const stime_t	 timer);

#endif /* __UOSPROCHEADER_H__ */
