/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSSMTP_H__
#define __UOSSMTP_H__

#include "libsylph/smtp.h"

#include "uossession.h"

typedef SMTPSession UosSMTPSession;

#define UOSSMTP_SESSION(obj) SMTP_SESSION(obj)

#define UOSSMTPBUFSIZE SMTPBUFSIZE


typedef SMTPErrorValue UosSMTPErrorValue;
#define UosSM_OK SM_OK
#define UosSM_ERROR	 SM_ERROR
#define UosSM_UNRECOVERABLE SM_UNRECOVERABLE
#define UosSM_AUTHFAIL SM_AUTHFAIL

typedef ESMTPFlag UosESMTPFlag;
#define UosESMTP_8BITMIME ESMTP_8BITMIME
#define UosESMTP_SIZE	 ESMTP_SIZE
#define UosESMTP_ETRN ESMTP_ETRN

typedef SMTPAuthType UosSMTPAuthType;
#define UosSMTPAUTH_LOGIN  SMTPAUTH_LOGIN
#define UosSMTPAUTH_CRAM_MD5	 SMTPAUTH_CRAM_MD5
#define UosSMTPAUTH_DIGEST_MD5 SMTPAUTH_DIGEST_MD5
#define UosSMTPAUTH_PLAIN  SMTPAUTH_PLAIN

typedef SMTPState UosSMTPState;
#define UosSMTP_READY  SMTP_READY
#define UosSMTP_CONNECTED	 SMTP_CONNECTED
#define UosSMTP_HELO SMTP_HELO
#define UosSMTP_EHLO  SMTP_EHLO
#define UosSMTP_STARTTLS SMTP_STARTTLS
#define UosSMTP_FROM SMTP_FROM
#define UosSMTP_AUTH SMTP_AUTH
#define UosSMTP_AUTH_PLAIN SMTP_AUTH_PLAIN
#define UosSMTP_AUTH_LOGIN_USER SMTP_AUTH_LOGIN_USER
#define UosSMTP_AUTH_LOGIN_PASS SMTP_AUTH_LOGIN_PASS
#define UosSMTP_AUTH_CRAM_MD5 SMTP_AUTH_CRAM_MD5
#define UosSMTP_RCPT SMTP_RCPT
#define UosSMTP_DATA SMTP_DATA
#define UosSMTP_SEND_DATA SMTP_SEND_DATA
#define UosSMTP_EOM SMTP_EOM
#define UosSMTP_RSET SMTP_RSET
#define UosSMTP_QUIT SMTP_QUIT
#define UosSMTP_ERROR SMTP_ERROR
#define UosSMTP_DISCONNECTED SMTP_DISCONNECTED
#define UosN_SMTP_PHASE N_SMTP_PHASE

UosSession *uos_smtp_session_new	(void);

#endif /* __UOSSMTP_H__ */
