/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uosutils.h"

#define BUFFSIZE	8192

void uos_list_free_strings(GList *list){
    list_free_strings(list);
}

void uos_slist_free_strings(GSList *list){
    slist_free_strings(list);
}

void uos_hash_free_strings(GHashTable *table){
    hash_free_strings(table);
}

void uos_hash_free_value_mem(GHashTable *table){
    hash_free_value_mem(table);
}

gint uos_str_case_equal(gconstpointer v, gconstpointer v2){
    return str_case_equal(v, v2);
}

guint uos_str_case_hash(gconstpointer key){
    return str_case_hash(key);
}

void uos_ptr_array_free_strings(GPtrArray *array){
    ptr_array_free_strings(array);
}

gboolean uos_str_find(const gchar *haystack, const gchar *needle){
    return str_find(haystack, needle);
}

gboolean uos_str_case_find(const gchar *haystack, const gchar *needle){
    return str_case_find(haystack, needle);
}

gboolean uos_str_find_equal(const gchar *haystack, const gchar *needle){
    return str_find_equal(haystack, needle);
}

gboolean uos_str_case_find_equal(const gchar *haystack, const gchar *needle){
    return str_case_find_equal(haystack, needle);
}

gint uos_to_number(const gchar *nstr){
    return to_number(nstr);
}

guint uos_to_unumber(const gchar *nstr){
    return to_unumber(nstr);
}

gchar *uos_itos_buf(gchar *nstr, gint n){
    return itos_buf(nstr, n);
}

gchar *uos_itos(gint n){
    return itos(n);
}

gchar *uos_utos_buf(gchar *nstr, guint n){
    return utos_buf(nstr, n);
}

gchar *uos_to_human_readable_buf(gchar *buf, size_t bufsize, gint64 size){
    return to_human_readable_buf(buf, bufsize, size);
}

gchar *uos_to_human_readable(gint64 size){
    return to_human_readable(size);
}

gint uos_strcmp2(const gchar *s1, const gchar *s2){
    return strcmp2(s1, s2);
}

gint uos_path_cmp(const gchar *s1, const gchar *s2){
    return path_cmp(s1, s2);
}

gboolean uos_is_path_parent(const gchar *parent, const gchar *child){
    return is_path_parent(parent, child);
}

gchar *uos_strretchomp(gchar *str){
    return strretchomp(str);
}

gchar *uos_strtailchomp(gchar *str, gchar tail_char){
    return strtailchomp(str, tail_char);
}

gchar *uos_strcrchomp(gchar *str){
    return strcrchomp(str);
}

const gchar *uos_strcasestr(const gchar *haystack,
                            const gchar *needle){
    return strcasestr(haystack,needle);
}

gpointer uos_my_memmem(gconstpointer haystack, size_t haystacklen, gconstpointer needle,
                       size_t needlelen){
    return my_memmem(haystack, haystacklen, needle,needlelen);
}

gchar *uos_strncpy2(gchar *dest, const gchar *src, size_t n){
    return strncpy2(dest, src, n);
}

gboolean uos_str_has_suffix_case(const gchar *str, const gchar *suffix){
    return str_has_suffix_case(str, suffix);
}

gint uos_str_find_format_times(const gchar *haystack, gchar ch){
    return str_find_format_times(haystack, ch);
}

gboolean uos_is_next_nonascii(const gchar *s){
    return is_next_nonascii(s);
}

gint uos_get_next_word_len(const gchar *s){
    return get_next_word_len(s);
}

gint uos_subject_compare(const gchar *s1, const gchar *s2){
    return subject_compare(s1, s2);
}

gint uos_subject_compare_for_sort(const gchar *s1, const gchar *s2){
    return subject_compare_for_sort(s1, s2);
}

void uos_trim_subject_for_compare(gchar *str){
    trim_subject_for_compare(str);
}

void uos_trim_subject_for_sort(gchar *str){
    trim_subject_for_sort(str);
}

void uos_trim_subject(gchar *str){
    trim_subject(str);
}

void uos_eliminate_parenthesis(gchar *str, gchar op, gchar cl){
    eliminate_parenthesis(str, op, cl);
}

void uos_extract_parenthesis(gchar *str, gchar op, gchar cl){
    extract_parenthesis(str, op, cl);
}

void uos_extract_parenthesis_with_escape(gchar *str, gchar op, gchar cl){
    extract_parenthesis_with_escape(str, op, cl);
}

void uos_extract_parenthesis_with_skip_quote(gchar *str, gchar quote_chr, gchar op, gchar cl){
    extract_parenthesis_with_skip_quote(str, quote_chr, op, cl);
}

void uos_eliminate_quote(gchar *str, gchar quote_chr){
    eliminate_quote(str, quote_chr);
}

void uos_extract_quote(gchar *str, gchar quote_chr){
    extract_quote(str, quote_chr);
}

void uos_extract_quote_with_escape(gchar *str, gchar quote_chr){
    extract_quote_with_escape(str, quote_chr);
}

void uos_eliminate_address_comment(gchar *str){
    eliminate_address_comment(str);
}

gchar *uos_strchr_with_skip_quote(const gchar *str, gint quote_chr, gint c){
    return strchr_with_skip_quote(str, quote_chr, c);
}

gchar *uos_strrchr_with_skip_quote(const gchar *str, gint quote_chr, gint c){
    return strrchr_with_skip_quote(str, quote_chr, c);
}

void uos_extract_address(gchar *str){
    extract_address(str);
}

void uos_extract_list_id_str(gchar *str){
    extract_list_id_str(str);
}

gchar *uos_extract_addresses(const gchar *str){
    return extract_addresses(str);
}

gchar *uos_normalize_address_field(const gchar *str){
    return normalize_address_field(str);
}

gboolean uos_address_equal(const gchar *addr1, const gchar *addr2){
    return address_equal(addr1, addr2);
}

GSList *uos_address_list_append_orig(GSList *addr_list, const gchar *str){
    return address_list_append_orig(addr_list, str);
}

GSList *uos_address_list_append(GSList *addr_list, const gchar *str){
    return address_list_append(addr_list, str);
}

GSList *uos_references_list_prepend(GSList *msgid_list, const gchar *str){
    return references_list_prepend(msgid_list, str);
}

GSList *uos_references_list_append(GSList *msgid_list, const gchar *str){
    return references_list_append(msgid_list, str);
}

GSList *uos_newsgroup_list_append(GSList *group_list, const gchar *str){
    return newsgroup_list_append(group_list, str);
}

GList *uos_add_history(GList *list, const gchar *str){
    return add_history(list, str);
}

/* modify string */
void uos_remove_return(gchar *str){
    remove_return(str);
}

void uos_remove_space(gchar *str){
    remove_space(str);
}

void uos_unfold_line(gchar *str){
    unfold_line(str);
}

void uos_subst_char(gchar *str, gchar orig, gchar subst){
    subst_char(str, orig, subst);
}

void uos_subst_chars(gchar *str, gchar *orig, gchar subst){
    subst_chars(str, orig, subst);
}

void uos_subst_null(gchar *str, gint len, gchar subst){
    subst_null(str, len, subst);
}

void uos_subst_control(gchar *str, gchar subst){
    subst_control(str, subst);
}

void uos_subst_for_filename(gchar *str){
    subst_for_filename(str);
}

gchar *uos_get_alt_filename(const gchar *filename, gint count){
    return get_alt_filename(filename, count);
}

gboolean uos_is_header_line(const gchar *str){
    return is_header_line(str);
}

gboolean uos_is_ascii_str(const gchar *str){
    return is_ascii_str(str);
}

gint uos_get_quote_level(const gchar *str){
    return get_quote_level(str);
}

gint uos_check_line_length(const gchar *str, gint max_chars, gint *line){
    return check_line_length(str, max_chars, line);
}

gchar *uos_strstr_with_skip_quote(const gchar *haystack, const gchar *needle){
    return strstr_with_skip_quote(haystack, needle);
}

gchar *uos_strcasestr_with_skip_quote(const gchar *haystack, const gchar *needle){
    return strcasestr_with_skip_quote(haystack, needle);
}

gchar *uos_strchr_parenthesis_close(const gchar *str, gchar op, gchar cl){
    return strchr_parenthesis_close(str, op, cl);
}

gchar **uos_strsplit_parenthesis(const gchar *str, gchar op, gchar cl, gint max_tokens){
    return strsplit_parenthesis(str, op, cl, max_tokens);
}

gchar **uos_strsplit_with_quote(const gchar *str, const gchar *delim, gint max_tokens){
    return strsplit_with_quote(str, delim, max_tokens);
}

gchar **uos_strsplit_csv(const gchar *str, gchar delim, gint max_tokens){
    return strsplit_csv(str, delim, max_tokens);
}


gchar *uos_strconcat_csv(gchar delim, const gchar *field1, ...){
    va_list args;
    va_start(args, field1);
    gchar *re=strconcat_csv_arg(delim, field1, args);
    va_end(args);

    return re;
}

gchar *uos_get_abbrev_newsgroup_name(const gchar *group, gint len){
    return get_abbrev_newsgroup_name(group, len);
}

gchar *uos_trim_string(const gchar *str, gint len){
    return trim_string(str, len);
}

gchar *uos_trim_string_before(const gchar *str, gint len){
    return trim_string_before(str, len);
}


GList *uos_uri_list_extract_filenames(const gchar *uri_list){
    return uri_list_extract_filenames(uri_list);
}

gboolean uos_is_uri_string(const gchar *str){
    return is_uri_string(str);
}

gchar *uos_get_uri_path(const gchar *uri){
    return get_uri_path(uri);
}

gint uos_get_uri_len(const gchar *str){
    return get_uri_len(str);
}

void uos_decode_uri(gchar *decoded_uri, const gchar *encoded_uri){
    decode_uri(decoded_uri, encoded_uri);
}

void uos_decode_xdigit_encoded_str(gchar *decoded, const gchar *encoded){
    decode_xdigit_encoded_str(decoded, encoded);
}

gchar *uos_encode_uri(const gchar *filename){
    return encode_uri(filename);
}

gchar *uos_uriencode_for_filename(const gchar *filename){
    return uriencode_for_filename(filename);
}

gchar *uos_uriencode_for_mailto(const gchar *mailto){
    return uriencode_for_mailto(mailto);
}

gint uos_scan_mailto_url(const gchar *mailto, gchar **to, gchar **cc, gchar **bcc, gchar **subject,
                         gchar **inreplyto, gchar **body){
    return scan_mailto_url(mailto, to, cc, bcc, subject,inreplyto, body);
}


void uos_set_startup_dir(void){
    set_startup_dir();
}

void uos_set_rc_dir(const gchar *dir){
    set_rc_dir(dir);
}


/* return static strings */
const gchar *uos_get_startup_dir(void){
    return get_startup_dir();
}

const gchar *uos_get_home_dir(void){
    return get_home_dir();
}

const gchar *uos_get_document_dir(void){
    return get_document_dir();
}

const gchar *uos_get_rc_dir(void){
    return get_rc_dir();
}

const gchar *uos_get_old_rc_dir(void){
    return get_old_rc_dir();
}

const gchar *uos_get_mail_base_dir(void){
    return get_mail_base_dir();
}

gchar *uos_get_news_cache_dir(void){
    return get_news_cache_dir();
}

gchar *uos_get_imap_cache_dir(void){
    return get_imap_cache_dir();
}

gchar *uos_get_pop_cache_dir(void){
    return get_pop_cache_dir();
}

gchar *uos_get_mime_tmp_dir(void){
    return get_mime_tmp_dir();
}

const gchar *uos_get_template_dir(void){
    return get_template_dir();
}

gchar *uos_get_tmp_dir(void){
    return get_tmp_dir();
}

gchar *uos_get_tmp_file(void){
    return get_tmp_file();
}

const gchar *uos_get_domain_name(void){
    return get_domain_name();
}


off_t uos_get_file_size(const gchar *file){
    return get_file_size(file);
}

off_t uos_get_file_size_as_crlf(const gchar *file){
    return get_file_size_as_crlf(file);
}

off_t uos_get_left_file_size(FILE *fp){
    return get_left_file_size(fp);
}


gint uos_get_last_empty_line_size(FILE *fp, off_t size){
    return get_last_empty_line_size(fp, size);
}


gboolean uos_file_exist(const gchar *file, gboolean allow_fifo){
    return file_exist(file, allow_fifo);
}

gboolean uos_is_dir_exist(const gchar *dir){
    return is_dir_exist(dir);
}

gboolean uos_is_file_entry_exist(const gchar *file){
    return is_file_entry_exist(file);
}

gboolean uos_dirent_is_regular_file(struct dirent *d){
    return dirent_is_regular_file(d);
}

gboolean uos_dirent_is_directory(struct dirent *d){
    return dirent_is_directory(d);
}

gint uos_change_dir(const gchar *dir){
    return change_dir(dir);
}

gint uos_make_dir(const gchar *dir){
    return make_dir(dir);
}

gint uos_make_dir_hier(const gchar *dir){
    return make_dir_hier(dir);
}

gint uos_remove_all_files(const gchar *dir){
    return remove_all_files(dir);
}

gint uos_remove_numbered_files(const gchar *dir, guint first, guint last){
    return remove_numbered_files(dir, first, last);
}

gint uos_remove_all_numbered_files(const gchar *dir){
    return remove_all_numbered_files(dir);
}

gint uos_remove_expired_files(const gchar *dir, guint hours){
    return remove_expired_files(dir, hours);
}

gint uos_remove_dir_recursive(const gchar *dir){
    return remove_dir_recursive(dir);
}

gint uos_rename_force(const gchar *oldpath, const gchar *newpath){
    return rename_force(oldpath, newpath);
}

gint uos_copy_file(const gchar *src, const gchar *dest, gboolean keep_backup){
    return copy_file(src, dest, keep_backup);
}

gint uos_copy_file_import(const gchar *src, const gchar *dest, const gchar *uosmessageid, gboolean keep_backup){
    return copy_file_import(src, dest, uosmessageid, keep_backup);
}

gint uos_copy_dir(const gchar *src, const gchar *dest){
    return copy_dir(src, dest);
}

gint uos_move_file(const gchar *src, const gchar *dest, gboolean overwrite){
    return move_file(src, dest, overwrite);
}


gint uos_append_file_part(FILE *fp, off_t offset, size_t length, FILE *dest_fp){
    return append_file_part(fp, offset, length, dest_fp);
}

gint uos_copy_file_part(FILE *fp, off_t offset, size_t length, const gchar *dest){
    return copy_file_part(fp, offset, length, dest);
}


gint uos_copy_file_stream(FILE *fp, FILE *dest_fp){
    return copy_file_stream(fp, dest_fp);
}


gchar *uos_canonicalize_str(const gchar *str){
    return canonicalize_str(str);
}

gint uos_canonicalize_file(const gchar *src, const gchar *dest){
    return canonicalize_file(src, dest);
}

gint uos_canonicalize_file_replace(const gchar *file){
    return canonicalize_file_replace(file);
}

FILE *uos_canonicalize_file_stream(FILE *fp, gint *length){
    return canonicalize_file_stream(fp, length);
}

gint uos_uncanonicalize_file(const gchar *src, const gchar *dest){
    return uncanonicalize_file(src, dest);
}

gint uos_uncanonicalize_file_replace(const gchar *file){
    return uncanonicalize_file_replace(file);
}


gchar *uos_normalize_newlines(const gchar *str){
    return normalize_newlines(str);
}

gchar *uos_strchomp_all(const gchar *str){
    return strchomp_all(str);
}

FILE *uos_get_outgoing_rfc2822_file(FILE *fp){
    return get_outgoing_rfc2822_file(fp);
}

gchar *uos_get_outgoing_rfc2822_str(FILE *fp){
    return get_outgoing_rfc2822_str(fp);
}

gchar *uos_generate_mime_boundary(const gchar *prefix){
    return generate_mime_boundary(prefix);
}

gint uos_change_file_mode_rw(FILE *fp, const gchar *file){
    return change_file_mode_rw(fp, file);
}

FILE *uos_my_tmpfile(void){
    return my_tmpfile();
}

FILE *uos_str_open_as_stream(const gchar *str){
    return str_open_as_stream(str);
}

gint uos_str_write_to_file(const gchar *str, const gchar *file){
    return str_write_to_file(str, file);
}

gchar *uos_file_read_to_str(const gchar *file){
    return file_read_to_str(file);
}

gchar *uos_file_read_stream_to_str(FILE *fp){
    return file_read_stream_to_str(fp);
}


/* process execution */
gint uos_execute_async(gchar *const argv[]){
    return execute_async(argv);
}

gint uos_execute_sync(gchar *const argv[]){
    return execute_sync(argv);
}

gint uos_execute_command_line(const gchar *cmdline, gboolean async){
    return execute_command_line(cmdline, async);
}

gint uos_execute_command_line_async_wait(const gchar *cmdline){
    return execute_command_line_async_wait(cmdline);
}

gint uos_execute_open_file(const gchar *file, const gchar *content_type){
    return execute_open_file(file, content_type);
}

gint uos_execute_print_file(const gchar *file){
    return execute_print_file(file);
}

gchar *uos_get_command_output(const gchar *cmdline){
    return get_command_output(cmdline);
}


/* open URI with external browser */
gint uos_open_uri(const gchar *uri, const gchar *cmdline){
    return open_uri(uri, cmdline);
}

/* play sound */
gint uos_play_sound(const gchar *file, gboolean async){
    return play_sound(file, async);
}

/* time functions */
stime_t uos_remote_tzoffset_sec(const gchar *zone){
    return remote_tzoffset_sec(zone);
}

stime_t uos_tzoffset_sec(stime_t *now){
    return tzoffset_sec(now);
}

gchar *uos_tzoffset_buf(gchar *buf, stime_t *now){
    return tzoffset_buf(buf, now);
}

gchar *uos_tzoffset(stime_t *now){
    return tzoffset(now);
}

void uos_get_rfc822_date(gchar *buf, gint len){
    get_rfc822_date(buf, len);
}


size_t uos_my_strftime(gchar *s, size_t max, const gchar *format, const struct tm *tm){
    return my_strftime(s, max, format, tm);
}


/* UI hints */
void uos_set_ui_update_func(UIUpdateFunc func){
    set_ui_update_func(func);
}

void uos_ui_update(void){
    ui_update();
}


void uos_set_event_loop_func(EventLoopFunc func){
    set_event_loop_func(func);
}

void uos_event_loop_iterate(void){
    event_loop_iterate();
}


void uos_set_progress_func(ProgressFunc func){
    set_progress_func(func);
}

void uos_progress_show(gint cur, gint total){
    progress_show(cur, total);
}


/* user input */
void uos_set_input_query_password_func(QueryPasswordFunc func){
    set_input_query_password_func(func);
}


gchar *uos_input_query_password(const gchar *server, const gchar *user){
    return input_query_password(server, user);
}


/* logging */
void uos_set_log_file(const gchar *filename){
    set_log_file(filename);
}

void uos_close_log_file(void){
    close_log_file();
}

void uos_set_log_verbosity(gboolean verbose){
    set_log_verbosity(verbose);
}

gboolean uos_get_debug_mode(void){
    return get_debug_mode();
}

void uos_set_debug_mode(gboolean enable){
    set_debug_mode(enable);
}


void uos_set_log_ui_func(LogFunc print_func, LogFunc message_func, LogFunc warning_func,
                         LogFunc error_func){
    set_log_ui_func(print_func, message_func, warning_func,error_func);
}


void uos_set_log_ui_func_full(LogFunc print_func, LogFunc message_func, LogFunc warning_func,
                              LogFunc error_func, LogFlushFunc flush_func){
    set_log_ui_func_full(print_func, message_func, warning_func,error_func, flush_func);
}


void uos_set_log_show_status_func(LogFunc status_func){
    set_log_show_status_func(status_func);
}


void uos_debug_print(const gchar *format, ...){
    va_list args;
    gchar *buf = g_malloc0(BUFFSIZE * sizeof(gchar));
    va_start(args, format);
    g_vsnprintf(buf, BUFFSIZE * sizeof(gchar), format, args);
    va_end(args);
    debug_print("%s", buf);
    g_free(buf);
}

void uos_status_print(const gchar *format, ...){
    va_list args;
    gchar *buf = g_malloc0(BUFFSIZE * sizeof(gchar));
    va_start(args, format);
    g_vsnprintf(buf, BUFFSIZE * sizeof(gchar), format, args);
    va_end(args);
    status_print("%s", buf);
    g_free(buf);
}


void uos_log_write(const gchar *str, const gchar *prefix)
{
    log_write(str, prefix);
}

void uos_log_print(const gchar *format, ...)
{
    va_list args;
    gchar *buf = g_malloc0(BUFFSIZE * sizeof(gchar));
    va_start(args, format);
    g_vsnprintf(buf, BUFFSIZE * sizeof(gchar), format, args);
    va_end(args);
    log_print("%s", buf);
    g_free(buf);
}

void uos_log_message(const gchar *format, ...)
{
    va_list args;
    gchar *buf = g_malloc0(BUFFSIZE * sizeof(gchar));
    va_start(args, format);
    g_vsnprintf(buf, BUFFSIZE * sizeof(gchar), format, args);
    va_end(args);
    log_message("%s", buf);
    g_free(buf);
}

void uos_log_warning(const gchar *format, ...)
{
    va_list args;
    gchar *buf = g_malloc0(BUFFSIZE * sizeof(gchar));
    va_start(args, format);
    g_vsnprintf(buf, BUFFSIZE * sizeof(gchar), format, args);
    va_end(args);
    log_warning("%s", buf);
    g_free(buf);
}

void uos_log_error(const gchar *format, ...){
    va_list args;
    gchar *buf = g_malloc0(BUFFSIZE * sizeof(gchar));
    va_start(args, format);
    g_vsnprintf(buf, BUFFSIZE * sizeof(gchar), format, args);
    va_end(args);

    log_error("%s", buf);
    g_free(buf);
}

void uos_log_flush(void){
    log_flush();
}

unsigned long uos_max_strlen(const char *buf, unsigned long max_size){
    return max_strlen(buf,max_size);
}


void uos_set_log_print_qt_func(UosLogFunc func){
    set_log_print_qt_func(func);
}

void uos_set_aesdecrypt_func(UosAesDecryptFunc func){
    set_aesdecrypt_func(func);
}

void uos_set_base64decrypt_func(UosBase64DecryptFunc func){
    set_base64decrypt_func(func);
}

void uos_set_is_network_online(int (*func)(void))
{
    is_network_online = func;
}

void uos_set_debugprint(gboolean trigger)
{
    b_debugPrint = trigger;
}
