/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <vdk/forms.h>
#include <vdk/vdkobj.h>
#include <vdk/rawobj.h>
#ifndef COLORS_H
#define COLORS_H
/*!
  \class VDKColor
  \brief provides a raw color object
 */
class VDKColor: public VDKRawObject
{
  GdkColor *color;
  GdkColormap	 *colormap;

public:
  /*!
    Constructor
    \param obj color owner
    \param red component (0-255)
    \param green component
    \param blue component
   */
  VDKColor(VDKObject* obj, int red, int green, int blue);
  /*!
    Constructor
    \param obj color owner
    \param rgb a VDKRgb reference
  */
  VDKColor(VDKObject* obj, VDKRgb rgb);
    /*!
    Constructor
    \param obj color owner
    \param name names are those provided
    in rgb X database (normally on /usr/lib/X11/rgb.txt )
  */  
  VDKColor(VDKObject* obj, char* name);
  /*!
    Destructor
  */
  virtual ~VDKColor();
  /*!
    GdkColor* conversion
   */
  GdkColor* Color() { return color; }
  /*!
    GdkColor* conversion
   */
  operator GdkColor*() { return color; }
};
#endif

