/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/


#include "vdk/rawpixmap.h"
#include "vdk/forms.h"
#include "gdk/gdkprivate.h"
#include <cstring>
static gint
pixmap_read_string (FILE  *infile,
		    gchar **buffer,
		    guint *buffer_size);
static gint
pixmap_seek_string (FILE  *infile,
		    const gchar *str,
		    gint   skip_comments);
static gint
pixmap_seek_char (FILE  *infile,
		  gchar  c);

void PixSize(int* width, int* height, char* filename);
/*
constructor
*/
VDKRawPixmap::VDKRawPixmap(VDKObject* owner, char* pixfile):
  VDKRawObject(owner)
{
  GtkWidget* widget = owner->Widget();
  GdkWindow* window = widget->window;
#if HAVE_GNOME
  if(! window)
    {
      gtk_widget_realize(widget);
      window = widget->window;
    }
#endif
  if(! window)
    {
      pixmap = NULL;
      style = NULL;
    }
  else
    {
      style = gtk_widget_get_style(widget);
      pixmap = gdk_pixmap_create_from_xpm(window,
					  &mask,
					  &style->bg[GTK_STATE_NORMAL],
					  pixfile);
      PixSize(&w,&h,pixfile);
    }
}
/*
 */
VDKRawPixmap::VDKRawPixmap(VDKObject* owner,char** pixdata):
  VDKRawObject(owner)
{
  GtkWidget* widget = owner->Widget();
  GdkWindow* window = widget->window;
  if(! window)
    {
      pixmap = NULL;
      style = NULL;
    }
  else
    {
      style = gtk_widget_get_style(widget);
      pixmap = gdk_pixmap_create_from_xpm_d(window,
					  &mask,
					  &style->bg[GTK_STATE_NORMAL],
					  pixdata);
      sscanf(pixdata[0],"%d %d", &w, &h);
    }
}

/*
destructor
*/
VDKRawPixmap::~VDKRawPixmap()
{
if(pixmap)
  {
    /* STUB
    GdkWindowPrivate *p = (GdkWindowPrivate *) pixmap;
    if(p->ref_count > 0)
    gdk_pixmap_unref(pixmap);
    */
  }
}

/*
 */ 
void VDKRawPixmap::Paint(int x, int y)
{
  //  if(x != 0 && y != 0)
    lastDraw = VDKPoint(x,y);
  GtkWidget* widget = owner->Widget();
  if(!pixmap)
    return;
  GdkWindow* window = widget->window;
  gdk_draw_pixmap(window,
		  widget->style->bg_gc[GTK_WIDGET_STATE(widget)],
		  pixmap,
		  0,
		  0,
		  x ? x : lastDraw.X(),  
		  y ? y : lastDraw.Y(),
		  w,
		  h);
}

void VDKRawPixmap::Paint(bool lastdraw, GdkWindow* window, int x, int y)
{
  if(!lastdraw)
    lastDraw = VDKPoint(x,y);
  if(!pixmap)
    return;
  GtkWidget* widget = owner->Widget();
  if (!window) 
    window = widget->window;
  gdk_draw_pixmap(window,
		  widget->style->bg_gc[GTK_WIDGET_STATE(widget)],
		  pixmap,
		  0,
		  0,
		  x ? x : lastDraw.X(),  
		  y ? y : lastDraw.Y(),
		  w,
		  h);
}

//=================================
gint
pixmap_read_string (FILE  *infile,
		    gchar **buffer,
		    guint *buffer_size)
{
  gint c;
  guint cnt = 0;
  
  if ((*buffer) == NULL)
    {
      (*buffer_size) = 10 * sizeof (gchar);
      (*buffer) = g_new(gchar, *buffer_size);
    }
  
  do
    c = getc (infile);
  while (c != EOF && c != '"');
  
  if (c != '"')
    return FALSE;
  
  while ((c = getc(infile)) != EOF)
    {
      if (cnt == (*buffer_size))
	{
	  guint new_size = (*buffer_size) * 2;
	  if (new_size > (*buffer_size))
	    *buffer_size = new_size;
	  else
	    return FALSE;
	  
	  (*buffer) = (gchar *) g_realloc ((*buffer), *buffer_size);	
	}
      
      if (c != '"')
	(*buffer)[cnt++] = c;
      else
	{
	  (*buffer)[cnt++] = 0;
	  return TRUE;
	}
    }
  
  return FALSE;
}

gint
pixmap_seek_string (FILE  *infile,
		    const gchar *str,
		    gint   skip_comments)
{
  char instr[1024];
  
  while (!feof (infile))
    {
      fscanf (infile, "%1023s", instr);
      if (skip_comments == TRUE && std::strcmp (instr, "/*") == 0)
	{
	  fscanf (infile, "%1023s", instr);
	  while (!feof (infile) && std::strcmp (instr, "*/") != 0)
	    fscanf (infile, "%1023s", instr);
	  fscanf(infile, "%1023s", instr);
	}
      if (std::strcmp (instr, str)==0)
	return TRUE;
    }
  
  return FALSE;
}


gint
pixmap_seek_char (FILE  *infile,
gchar  c)
{
  gint b, oldb;

  while ((b = getc(infile)) != EOF)
    {
      if (c != b && b == '/')
	{
	  b = getc (infile);
	  if (b == EOF)
	    return FALSE;
	  else if (b == '*')	/* we have a comment */
 	    {
	      b = -1;
	      do
 		{
 		  oldb = b;
		  b = getc (infile);
 		  if (b == EOF)
 		    return FALSE;
 		}
 	      while (!(oldb == '*' && b == '/'));
 	    }
        }
      else if (c == b)
 	return TRUE;
    }
  return FALSE;
}


void PixSize(int* width, int* height, char* filename)
{
  FILE *infile = NULL;
  char *buffer = NULL;
  guint  buffer_size = 0;
  infile = fopen (filename, "rb");
  if ( (infile) && (pixmap_seek_string (infile, "XPM", FALSE) == TRUE))
    {
      if (pixmap_seek_char (infile,'{') == TRUE)
	{
	  pixmap_seek_char (infile, '"');
	  fseek (infile, -1, SEEK_CUR);
	  pixmap_read_string (infile, &buffer, &buffer_size);  
	  sscanf (buffer,"%d %d", width, height);
	}
      else
	*width = *height = 0;
      fclose(infile);
    }
  else
    *width = *height = 0;
}
